/*
 * Decompiled with CFR 0.152.
 */
package android.content.om;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class OverlayInfo
implements Parcelable {
    public static final int STATE_UNKNOWN = -1;
    public static final int STATE_MISSING_TARGET = 0;
    public static final int STATE_NO_IDMAP = 1;
    public static final int STATE_DISABLED = 2;
    public static final int STATE_ENABLED = 3;
    public static final int STATE_TARGET_UPGRADING = 4;
    public static final int STATE_OVERLAY_UPGRADING = 5;
    public final String packageName;
    public final String targetPackageName;
    public final String baseCodePath;
    public final int state;
    public final int userId;
    public static final Parcelable.Creator<OverlayInfo> CREATOR = new Parcelable.Creator<OverlayInfo>(){

        @Override
        public OverlayInfo createFromParcel(Parcel source) {
            return new OverlayInfo(source);
        }

        public OverlayInfo[] newArray(int size) {
            return new OverlayInfo[size];
        }
    };

    public OverlayInfo(OverlayInfo source, int state) {
        this(source.packageName, source.targetPackageName, source.baseCodePath, state, source.userId);
    }

    public OverlayInfo(String packageName, String targetPackageName, String baseCodePath, int state, int userId) {
        this.packageName = packageName;
        this.targetPackageName = targetPackageName;
        this.baseCodePath = baseCodePath;
        this.state = state;
        this.userId = userId;
        this.ensureValidState();
    }

    public OverlayInfo(Parcel source) {
        this.packageName = source.readString();
        this.targetPackageName = source.readString();
        this.baseCodePath = source.readString();
        this.state = source.readInt();
        this.userId = source.readInt();
        this.ensureValidState();
    }

    private void ensureValidState() {
        if (this.packageName == null) {
            throw new IllegalArgumentException("packageName must not be null");
        }
        if (this.targetPackageName == null) {
            throw new IllegalArgumentException("targetPackageName must not be null");
        }
        if (this.baseCodePath == null) {
            throw new IllegalArgumentException("baseCodePath must not be null");
        }
        switch (this.state) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("State " + this.state + " is not a valid state");
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.packageName);
        dest.writeString(this.targetPackageName);
        dest.writeString(this.baseCodePath);
        dest.writeInt(this.state);
        dest.writeInt(this.userId);
    }

    public boolean isEnabled() {
        switch (this.state) {
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static String stateToString(int state) {
        switch (state) {
            case -1: {
                return "STATE_UNKNOWN";
            }
            case 0: {
                return "STATE_MISSING_TARGET";
            }
            case 1: {
                return "STATE_NO_IDMAP";
            }
            case 2: {
                return "STATE_DISABLED";
            }
            case 3: {
                return "STATE_ENABLED";
            }
            case 4: {
                return "STATE_TARGET_UPGRADING";
            }
            case 5: {
                return "STATE_OVERLAY_UPGRADING";
            }
        }
        return "<unknown state>";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.userId;
        result = 31 * result + this.state;
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        result = 31 * result + (this.targetPackageName == null ? 0 : this.targetPackageName.hashCode());
        result = 31 * result + (this.baseCodePath == null ? 0 : this.baseCodePath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OverlayInfo other = (OverlayInfo)obj;
        if (this.userId != other.userId) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        if (!this.packageName.equals(other.packageName)) {
            return false;
        }
        if (!this.targetPackageName.equals(other.targetPackageName)) {
            return false;
        }
        return this.baseCodePath.equals(other.baseCodePath);
    }

    public String toString() {
        return "OverlayInfo { overlay=" + this.packageName + ", target=" + this.targetPackageName + ", state=" + this.state + " (" + OverlayInfo.stateToString(this.state) + "), userId=" + this.userId + " }";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

