/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.split;

import android.content.pm.PackageParser;
import android.content.pm.split.SplitAssetLoader;
import android.content.res.AssetManager;
import android.os.Build;
import com.android.internal.util.ArrayUtils;
import libcore.io.IoUtils;

public class DefaultSplitAssetLoader
implements SplitAssetLoader {
    private final String mBaseCodePath;
    private final String[] mSplitCodePaths;
    private final int mFlags;
    private AssetManager mCachedAssetManager;

    public DefaultSplitAssetLoader(PackageParser.PackageLite pkg, int flags) {
        this.mBaseCodePath = pkg.baseCodePath;
        this.mSplitCodePaths = pkg.splitCodePaths;
        this.mFlags = flags;
    }

    private static void loadApkIntoAssetManager(AssetManager assets, String apkPath, int flags) throws PackageParser.PackageParserException {
        if ((flags & 1) != 0 && !PackageParser.isApkPath(apkPath)) {
            throw new PackageParser.PackageParserException(-100, "Invalid package file: " + apkPath);
        }
        if (assets.addAssetPath(apkPath) == 0) {
            throw new PackageParser.PackageParserException(-101, "Failed adding asset path: " + apkPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssetManager getBaseAssetManager() throws PackageParser.PackageParserException {
        if (this.mCachedAssetManager != null) {
            return this.mCachedAssetManager;
        }
        AssetManager assets = new AssetManager();
        try {
            assets.setConfiguration(0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Build.VERSION.RESOURCES_SDK_INT);
            DefaultSplitAssetLoader.loadApkIntoAssetManager(assets, this.mBaseCodePath, this.mFlags);
            if (!ArrayUtils.isEmpty(this.mSplitCodePaths)) {
                for (String apkPath : this.mSplitCodePaths) {
                    DefaultSplitAssetLoader.loadApkIntoAssetManager(assets, apkPath, this.mFlags);
                }
            }
            this.mCachedAssetManager = assets;
            assets = null;
            AssetManager assetManager = this.mCachedAssetManager;
            return assetManager;
        }
        finally {
            if (assets != null) {
                IoUtils.closeQuietly(assets);
            }
        }
    }

    @Override
    public AssetManager getSplitAssetManager(int splitIdx) throws PackageParser.PackageParserException {
        return this.getBaseAssetManager();
    }

    @Override
    public void close() throws Exception {
        if (this.mCachedAssetManager != null) {
            IoUtils.closeQuietly(this.mCachedAssetManager);
        }
    }
}

