/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.app.ActivityThread;
import android.app.Application;
import android.database.sqlite.SQLiteGlobal;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.KeyValueListParser;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;

public class SQLiteCompatibilityWalFlags {
    private static final String TAG = "SQLiteCompatibilityWalFlags";
    private static volatile boolean sInitialized;
    private static volatile boolean sFlagsSet;
    private static volatile boolean sCompatibilityWalSupported;
    private static volatile String sWALSyncMode;
    private static volatile boolean sCallingGlobalSettings;

    @VisibleForTesting
    public static boolean areFlagsSet() {
        SQLiteCompatibilityWalFlags.initIfNeeded();
        return sFlagsSet;
    }

    @VisibleForTesting
    public static boolean isCompatibilityWalSupported() {
        SQLiteCompatibilityWalFlags.initIfNeeded();
        return sCompatibilityWalSupported;
    }

    @VisibleForTesting
    public static String getWALSyncMode() {
        SQLiteCompatibilityWalFlags.initIfNeeded();
        return sWALSyncMode;
    }

    private static void initIfNeeded() {
        if (sInitialized || sCallingGlobalSettings) {
            return;
        }
        ActivityThread activityThread = ActivityThread.currentActivityThread();
        Application app = activityThread == null ? null : activityThread.getApplication();
        String flags = null;
        if (app == null) {
            Log.w(TAG, "Cannot read global setting sqlite_compatibility_wal_flags - Application state not available");
        } else {
            try {
                sCallingGlobalSettings = true;
                flags = Settings.Global.getString(app.getContentResolver(), "sqlite_compatibility_wal_flags");
            }
            finally {
                sCallingGlobalSettings = false;
            }
        }
        SQLiteCompatibilityWalFlags.init(flags);
    }

    @VisibleForTesting
    public static void init(String flags) {
        if (TextUtils.isEmpty(flags)) {
            sInitialized = true;
            return;
        }
        KeyValueListParser parser = new KeyValueListParser(',');
        try {
            parser.setString(flags);
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Setting has invalid format: " + flags, e);
            sInitialized = true;
            return;
        }
        sCompatibilityWalSupported = parser.getBoolean("compatibility_wal_supported", SQLiteGlobal.isCompatibilityWalSupported());
        sWALSyncMode = parser.getString("wal_syncmode", SQLiteGlobal.getWALSyncMode());
        Log.i(TAG, "Read compatibility WAL flags: compatibility_wal_supported=" + sCompatibilityWalSupported + ", wal_syncmode=" + sWALSyncMode);
        sFlagsSet = true;
        sInitialized = true;
    }

    @VisibleForTesting
    public static void reset() {
        sInitialized = false;
        sFlagsSet = false;
        sCompatibilityWalSupported = false;
        sWALSyncMode = null;
    }
}

