/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.CursorWindow;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteBindOrColumnIndexOutOfRangeException;
import android.database.sqlite.SQLiteCompatibilityWalFlags;
import android.database.sqlite.SQLiteConnectionPool;
import android.database.sqlite.SQLiteCustomFunction;
import android.database.sqlite.SQLiteDatabaseConfiguration;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteDebug;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteGlobal;
import android.database.sqlite.SQLiteStatementInfo;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.os.SystemClock;
import android.os.Trace;
import android.util.Log;
import android.util.LruCache;
import android.util.Printer;
import dalvik.system.BlockGuard;
import dalvik.system.CloseGuard;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public final class SQLiteConnection
implements CancellationSignal.OnCancelListener {
    private static final String TAG = "SQLiteConnection";
    private static final boolean DEBUG = false;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final SQLiteConnectionPool mPool;
    private final SQLiteDatabaseConfiguration mConfiguration;
    private final int mConnectionId;
    private final boolean mIsPrimaryConnection;
    private final boolean mIsReadOnlyConnection;
    private final PreparedStatementCache mPreparedStatementCache;
    private PreparedStatement mPreparedStatementPool;
    private final OperationLog mRecentOperations;
    private long mConnectionPtr;
    private boolean mOnlyAllowReadOnlyOperations;
    private int mCancellationSignalAttachCount;

    private static native long nativeOpen(String var0, int var1, String var2, boolean var3, boolean var4, int var5, int var6);

    private static native void nativeClose(long var0);

    private static native void nativeRegisterCustomFunction(long var0, SQLiteCustomFunction var2);

    private static native void nativeRegisterLocalizedCollators(long var0, String var2);

    private static native long nativePrepareStatement(long var0, String var2);

    private static native void nativeFinalizeStatement(long var0, long var2);

    private static native int nativeGetParameterCount(long var0, long var2);

    private static native boolean nativeIsReadOnly(long var0, long var2);

    private static native int nativeGetColumnCount(long var0, long var2);

    private static native String nativeGetColumnName(long var0, long var2, int var4);

    private static native void nativeBindNull(long var0, long var2, int var4);

    private static native void nativeBindLong(long var0, long var2, int var4, long var5);

    private static native void nativeBindDouble(long var0, long var2, int var4, double var5);

    private static native void nativeBindString(long var0, long var2, int var4, String var5);

    private static native void nativeBindBlob(long var0, long var2, int var4, byte[] var5);

    private static native void nativeResetStatementAndClearBindings(long var0, long var2);

    private static native void nativeExecute(long var0, long var2);

    private static native long nativeExecuteForLong(long var0, long var2);

    private static native String nativeExecuteForString(long var0, long var2);

    private static native int nativeExecuteForBlobFileDescriptor(long var0, long var2);

    private static native int nativeExecuteForChangedRowCount(long var0, long var2);

    private static native long nativeExecuteForLastInsertedRowId(long var0, long var2);

    private static native long nativeExecuteForCursorWindow(long var0, long var2, long var4, int var6, int var7, boolean var8);

    private static native int nativeGetDbLookaside(long var0);

    private static native void nativeCancel(long var0);

    private static native void nativeResetCancel(long var0, boolean var2);

    private SQLiteConnection(SQLiteConnectionPool pool, SQLiteDatabaseConfiguration configuration, int connectionId, boolean primaryConnection) {
        this.mPool = pool;
        this.mRecentOperations = new OperationLog(this.mPool);
        this.mConfiguration = new SQLiteDatabaseConfiguration(configuration);
        this.mConnectionId = connectionId;
        this.mIsPrimaryConnection = primaryConnection;
        this.mIsReadOnlyConnection = (configuration.openFlags & 1) != 0;
        this.mPreparedStatementCache = new PreparedStatementCache(this.mConfiguration.maxSqlCacheSize);
        this.mCloseGuard.open("close");
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mPool != null && this.mConnectionPtr != 0L) {
                this.mPool.onConnectionLeaked();
            }
            this.dispose(true);
        }
        finally {
            super.finalize();
        }
    }

    static SQLiteConnection open(SQLiteConnectionPool pool, SQLiteDatabaseConfiguration configuration, int connectionId, boolean primaryConnection) {
        SQLiteConnection connection = new SQLiteConnection(pool, configuration, connectionId, primaryConnection);
        try {
            connection.open();
            return connection;
        }
        catch (SQLiteException ex) {
            connection.dispose(false);
            throw ex;
        }
    }

    void close() {
        this.dispose(false);
    }

    private void open() {
        this.mConnectionPtr = SQLiteConnection.nativeOpen(this.mConfiguration.path, this.mConfiguration.openFlags, this.mConfiguration.label, SQLiteDebug.DEBUG_SQL_STATEMENTS, SQLiteDebug.DEBUG_SQL_TIME, this.mConfiguration.lookasideSlotSize, this.mConfiguration.lookasideSlotCount);
        this.setPageSize();
        this.setForeignKeyModeFromConfiguration();
        this.setWalModeFromConfiguration();
        this.setJournalSizeLimit();
        this.setAutoCheckpointInterval();
        this.setLocaleFromConfiguration();
        int functionCount = this.mConfiguration.customFunctions.size();
        for (int i = 0; i < functionCount; ++i) {
            SQLiteCustomFunction function = this.mConfiguration.customFunctions.get(i);
            SQLiteConnection.nativeRegisterCustomFunction(this.mConnectionPtr, function);
        }
    }

    private void dispose(boolean finalized) {
        if (this.mCloseGuard != null) {
            if (finalized) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mCloseGuard.close();
        }
        if (this.mConnectionPtr != 0L) {
            int cookie = this.mRecentOperations.beginOperation("close", null, null);
            try {
                this.mPreparedStatementCache.evictAll();
                SQLiteConnection.nativeClose(this.mConnectionPtr);
                this.mConnectionPtr = 0L;
            }
            finally {
                this.mRecentOperations.endOperation(cookie);
            }
        }
    }

    private void setPageSize() {
        if (!this.mConfiguration.isInMemoryDb() && !this.mIsReadOnlyConnection) {
            long newValue = SQLiteGlobal.getDefaultPageSize();
            long value = this.executeForLong("PRAGMA page_size", null, null);
            if (value != newValue) {
                this.execute("PRAGMA page_size=" + newValue, null, null);
            }
        }
    }

    private void setAutoCheckpointInterval() {
        if (!this.mConfiguration.isInMemoryDb() && !this.mIsReadOnlyConnection) {
            long newValue = SQLiteGlobal.getWALAutoCheckpoint();
            long value = this.executeForLong("PRAGMA wal_autocheckpoint", null, null);
            if (value != newValue) {
                this.executeForLong("PRAGMA wal_autocheckpoint=" + newValue, null, null);
            }
        }
    }

    private void setJournalSizeLimit() {
        if (!this.mConfiguration.isInMemoryDb() && !this.mIsReadOnlyConnection) {
            long newValue = SQLiteGlobal.getJournalSizeLimit();
            long value = this.executeForLong("PRAGMA journal_size_limit", null, null);
            if (value != newValue) {
                this.executeForLong("PRAGMA journal_size_limit=" + newValue, null, null);
            }
        }
    }

    private void setForeignKeyModeFromConfiguration() {
        if (!this.mIsReadOnlyConnection) {
            long newValue = this.mConfiguration.foreignKeyConstraintsEnabled ? 1L : 0L;
            long value = this.executeForLong("PRAGMA foreign_keys", null, null);
            if (value != newValue) {
                this.execute("PRAGMA foreign_keys=" + newValue, null, null);
            }
        }
    }

    private void setWalModeFromConfiguration() {
        if (!this.mConfiguration.isInMemoryDb() && !this.mIsReadOnlyConnection) {
            boolean useCompatibilityWal;
            boolean walEnabled = (this.mConfiguration.openFlags & 0x20000000) != 0;
            boolean bl = useCompatibilityWal = this.mConfiguration.journalMode == null && this.mConfiguration.syncMode == null && this.mConfiguration.useCompatibilityWal;
            if (walEnabled || useCompatibilityWal) {
                this.setJournalMode("WAL");
                if (useCompatibilityWal && SQLiteCompatibilityWalFlags.areFlagsSet()) {
                    this.setSyncMode(SQLiteCompatibilityWalFlags.getWALSyncMode());
                } else {
                    this.setSyncMode(SQLiteGlobal.getWALSyncMode());
                }
            } else {
                this.setJournalMode(this.mConfiguration.journalMode == null ? SQLiteGlobal.getDefaultJournalMode() : this.mConfiguration.journalMode);
                this.setSyncMode(this.mConfiguration.syncMode == null ? SQLiteGlobal.getDefaultSyncMode() : this.mConfiguration.syncMode);
            }
        }
    }

    private void setSyncMode(String newValue) {
        String value = this.executeForString("PRAGMA synchronous", null, null);
        if (!SQLiteConnection.canonicalizeSyncMode(value).equalsIgnoreCase(SQLiteConnection.canonicalizeSyncMode(newValue))) {
            this.execute("PRAGMA synchronous=" + newValue, null, null);
        }
    }

    private static String canonicalizeSyncMode(String value) {
        switch (value) {
            case "0": {
                return "OFF";
            }
            case "1": {
                return "NORMAL";
            }
            case "2": {
                return "FULL";
            }
        }
        return value;
    }

    private void setJournalMode(String newValue) {
        String value = this.executeForString("PRAGMA journal_mode", null, null);
        if (!value.equalsIgnoreCase(newValue)) {
            try {
                String result = this.executeForString("PRAGMA journal_mode=" + newValue, null, null);
                if (result.equalsIgnoreCase(newValue)) {
                    return;
                }
            }
            catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
                // empty catch block
            }
            Log.w(TAG, "Could not change the database journal mode of '" + this.mConfiguration.label + "' from '" + value + "' to '" + newValue + "' because the database is locked.  This usually means that there are other open connections to the database which prevents the database from enabling or disabling write-ahead logging mode.  Proceeding without changing the journal mode.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLocaleFromConfiguration() {
        if ((this.mConfiguration.openFlags & 0x10) != 0) {
            return;
        }
        String newLocale = this.mConfiguration.locale.toString();
        SQLiteConnection.nativeRegisterLocalizedCollators(this.mConnectionPtr, newLocale);
        if (this.mIsReadOnlyConnection) {
            return;
        }
        try {
            this.execute("CREATE TABLE IF NOT EXISTS android_metadata (locale TEXT)", null, null);
            String oldLocale = this.executeForString("SELECT locale FROM android_metadata UNION SELECT NULL ORDER BY locale DESC LIMIT 1", null, null);
            if (oldLocale != null && oldLocale.equals(newLocale)) {
                return;
            }
            this.execute("BEGIN", null, null);
            boolean success = false;
            try {
                this.execute("DELETE FROM android_metadata", null, null);
                this.execute("INSERT INTO android_metadata (locale) VALUES(?)", new Object[]{newLocale}, null);
                this.execute("REINDEX LOCALIZED", null, null);
                success = true;
                this.execute(success ? "COMMIT" : "ROLLBACK", null, null);
            }
            catch (Throwable throwable) {
                this.execute(success ? "COMMIT" : "ROLLBACK", null, null);
                throw throwable;
            }
        }
        catch (RuntimeException ex) {
            throw new SQLiteException("Failed to change locale for db '" + this.mConfiguration.label + "' to '" + newLocale + "'.", ex);
        }
    }

    void reconfigure(SQLiteDatabaseConfiguration configuration) {
        this.mOnlyAllowReadOnlyOperations = false;
        int functionCount = configuration.customFunctions.size();
        for (int i = 0; i < functionCount; ++i) {
            SQLiteCustomFunction function = configuration.customFunctions.get(i);
            if (this.mConfiguration.customFunctions.contains(function)) continue;
            SQLiteConnection.nativeRegisterCustomFunction(this.mConnectionPtr, function);
        }
        boolean foreignKeyModeChanged = configuration.foreignKeyConstraintsEnabled != this.mConfiguration.foreignKeyConstraintsEnabled;
        boolean walModeChanged = ((configuration.openFlags ^ this.mConfiguration.openFlags) & 0x20000000) != 0 || configuration.useCompatibilityWal != this.mConfiguration.useCompatibilityWal;
        boolean localeChanged = !configuration.locale.equals(this.mConfiguration.locale);
        this.mConfiguration.updateParametersFrom(configuration);
        this.mPreparedStatementCache.resize(configuration.maxSqlCacheSize);
        if (foreignKeyModeChanged) {
            this.setForeignKeyModeFromConfiguration();
        }
        if (walModeChanged) {
            this.setWalModeFromConfiguration();
        }
        if (localeChanged) {
            this.setLocaleFromConfiguration();
        }
    }

    void setOnlyAllowReadOnlyOperations(boolean readOnly) {
        this.mOnlyAllowReadOnlyOperations = readOnly;
    }

    boolean isPreparedStatementInCache(String sql) {
        return this.mPreparedStatementCache.get(sql) != null;
    }

    public int getConnectionId() {
        return this.mConnectionId;
    }

    public boolean isPrimaryConnection() {
        return this.mIsPrimaryConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(String sql, SQLiteStatementInfo outStatementInfo) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        int cookie = this.mRecentOperations.beginOperation("prepare", sql, null);
        try {
            PreparedStatement statement = this.acquirePreparedStatement(sql);
            try {
                if (outStatementInfo != null) {
                    outStatementInfo.numParameters = statement.mNumParameters;
                    outStatementInfo.readOnly = statement.mReadOnly;
                    int columnCount = SQLiteConnection.nativeGetColumnCount(this.mConnectionPtr, statement.mStatementPtr);
                    if (columnCount == 0) {
                        outStatementInfo.columnNames = EMPTY_STRING_ARRAY;
                    } else {
                        outStatementInfo.columnNames = new String[columnCount];
                        for (int i = 0; i < columnCount; ++i) {
                            outStatementInfo.columnNames[i] = SQLiteConnection.nativeGetColumnName(this.mConnectionPtr, statement.mStatementPtr, i);
                        }
                    }
                }
            }
            finally {
                this.releasePreparedStatement(statement);
            }
        }
        catch (RuntimeException ex) {
            this.mRecentOperations.failOperation(cookie, ex);
            throw ex;
        }
        finally {
            this.mRecentOperations.endOperation(cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String sql, Object[] bindArgs, CancellationSignal cancellationSignal) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        int cookie = this.mRecentOperations.beginOperation("execute", sql, bindArgs);
        try {
            PreparedStatement statement = this.acquirePreparedStatement(sql);
            try {
                this.throwIfStatementForbidden(statement);
                this.bindArguments(statement, bindArgs);
                this.applyBlockGuardPolicy(statement);
                this.attachCancellationSignal(cancellationSignal);
                try {
                    SQLiteConnection.nativeExecute(this.mConnectionPtr, statement.mStatementPtr);
                }
                finally {
                    this.detachCancellationSignal(cancellationSignal);
                }
            }
            finally {
                this.releasePreparedStatement(statement);
            }
        }
        catch (RuntimeException ex) {
            this.mRecentOperations.failOperation(cookie, ex);
            throw ex;
        }
        finally {
            this.mRecentOperations.endOperation(cookie);
        }
    }

    /*
     * Exception decompiling
     */
    public long executeForLong(String sql, Object[] bindArgs, CancellationSignal cancellationSignal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String executeForString(String sql, Object[] bindArgs, CancellationSignal cancellationSignal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public ParcelFileDescriptor executeForBlobFileDescriptor(String sql, Object[] bindArgs, CancellationSignal cancellationSignal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int executeForChangedRowCount(String sql, Object[] bindArgs, CancellationSignal cancellationSignal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public long executeForLastInsertedRowId(String sql, Object[] bindArgs, CancellationSignal cancellationSignal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int executeForCursorWindow(String sql, Object[] bindArgs, CursorWindow window, int startPos, int requiredPos, boolean countAllRows, CancellationSignal cancellationSignal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PreparedStatement acquirePreparedStatement(String sql) {
        PreparedStatement statement = (PreparedStatement)this.mPreparedStatementCache.get(sql);
        boolean skipCache = false;
        if (statement != null) {
            if (!statement.mInUse) {
                return statement;
            }
            skipCache = true;
        }
        long statementPtr = SQLiteConnection.nativePrepareStatement(this.mConnectionPtr, sql);
        try {
            int numParameters = SQLiteConnection.nativeGetParameterCount(this.mConnectionPtr, statementPtr);
            int type = DatabaseUtils.getSqlStatementType(sql);
            boolean readOnly = SQLiteConnection.nativeIsReadOnly(this.mConnectionPtr, statementPtr);
            statement = this.obtainPreparedStatement(sql, statementPtr, numParameters, type, readOnly);
            if (!skipCache && SQLiteConnection.isCacheable(type)) {
                this.mPreparedStatementCache.put(sql, statement);
                statement.mInCache = true;
            }
        }
        catch (RuntimeException ex) {
            if (statement == null || !statement.mInCache) {
                SQLiteConnection.nativeFinalizeStatement(this.mConnectionPtr, statementPtr);
            }
            throw ex;
        }
        statement.mInUse = true;
        return statement;
    }

    private void releasePreparedStatement(PreparedStatement statement) {
        statement.mInUse = false;
        if (statement.mInCache) {
            try {
                SQLiteConnection.nativeResetStatementAndClearBindings(this.mConnectionPtr, statement.mStatementPtr);
            }
            catch (SQLiteException ex) {
                this.mPreparedStatementCache.remove(statement.mSql);
            }
        } else {
            this.finalizePreparedStatement(statement);
        }
    }

    private void finalizePreparedStatement(PreparedStatement statement) {
        SQLiteConnection.nativeFinalizeStatement(this.mConnectionPtr, statement.mStatementPtr);
        this.recyclePreparedStatement(statement);
    }

    private void attachCancellationSignal(CancellationSignal cancellationSignal) {
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
            ++this.mCancellationSignalAttachCount;
            if (this.mCancellationSignalAttachCount == 1) {
                SQLiteConnection.nativeResetCancel(this.mConnectionPtr, true);
                cancellationSignal.setOnCancelListener(this);
            }
        }
    }

    private void detachCancellationSignal(CancellationSignal cancellationSignal) {
        if (cancellationSignal != null) {
            assert (this.mCancellationSignalAttachCount > 0);
            --this.mCancellationSignalAttachCount;
            if (this.mCancellationSignalAttachCount == 0) {
                cancellationSignal.setOnCancelListener(null);
                SQLiteConnection.nativeResetCancel(this.mConnectionPtr, false);
            }
        }
    }

    @Override
    public void onCancel() {
        SQLiteConnection.nativeCancel(this.mConnectionPtr);
    }

    private void bindArguments(PreparedStatement statement, Object[] bindArgs) {
        int count;
        int n = count = bindArgs != null ? bindArgs.length : 0;
        if (count != statement.mNumParameters) {
            throw new SQLiteBindOrColumnIndexOutOfRangeException("Expected " + statement.mNumParameters + " bind arguments but " + count + " were provided.");
        }
        if (count == 0) {
            return;
        }
        long statementPtr = statement.mStatementPtr;
        block6: for (int i = 0; i < count; ++i) {
            Object arg = bindArgs[i];
            switch (DatabaseUtils.getTypeOfObject(arg)) {
                case 0: {
                    SQLiteConnection.nativeBindNull(this.mConnectionPtr, statementPtr, i + 1);
                    continue block6;
                }
                case 1: {
                    SQLiteConnection.nativeBindLong(this.mConnectionPtr, statementPtr, i + 1, ((Number)arg).longValue());
                    continue block6;
                }
                case 2: {
                    SQLiteConnection.nativeBindDouble(this.mConnectionPtr, statementPtr, i + 1, ((Number)arg).doubleValue());
                    continue block6;
                }
                case 4: {
                    SQLiteConnection.nativeBindBlob(this.mConnectionPtr, statementPtr, i + 1, (byte[])arg);
                    continue block6;
                }
                default: {
                    if (arg instanceof Boolean) {
                        SQLiteConnection.nativeBindLong(this.mConnectionPtr, statementPtr, i + 1, (Boolean)arg != false ? 1L : 0L);
                        continue block6;
                    }
                    SQLiteConnection.nativeBindString(this.mConnectionPtr, statementPtr, i + 1, arg.toString());
                }
            }
        }
    }

    private void throwIfStatementForbidden(PreparedStatement statement) {
        if (this.mOnlyAllowReadOnlyOperations && !statement.mReadOnly) {
            throw new SQLiteException("Cannot execute this statement because it might modify the database but the connection is read-only.");
        }
    }

    private static boolean isCacheable(int statementType) {
        return statementType == 2 || statementType == 1;
    }

    private void applyBlockGuardPolicy(PreparedStatement statement) {
        if (!this.mConfiguration.isInMemoryDb()) {
            if (statement.mReadOnly) {
                BlockGuard.getThreadPolicy().onReadFromDisk();
            } else {
                BlockGuard.getThreadPolicy().onWriteToDisk();
            }
        }
    }

    public void dump(Printer printer, boolean verbose) {
        this.dumpUnsafe(printer, verbose);
    }

    void dumpUnsafe(Printer printer, boolean verbose) {
        printer.println("Connection #" + this.mConnectionId + ":");
        if (verbose) {
            printer.println("  connectionPtr: 0x" + Long.toHexString(this.mConnectionPtr));
        }
        printer.println("  isPrimaryConnection: " + this.mIsPrimaryConnection);
        printer.println("  onlyAllowReadOnlyOperations: " + this.mOnlyAllowReadOnlyOperations);
        this.mRecentOperations.dump(printer, verbose);
        if (verbose) {
            this.mPreparedStatementCache.dump(printer);
        }
    }

    String describeCurrentOperationUnsafe() {
        return this.mRecentOperations.describeCurrentOperation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void collectDbStats(ArrayList<SQLiteDebug.DbStats> dbStatsList) {
        int lookaside = SQLiteConnection.nativeGetDbLookaside(this.mConnectionPtr);
        long pageCount = 0L;
        long pageSize = 0L;
        try {
            pageCount = this.executeForLong("PRAGMA page_count;", null, null);
            pageSize = this.executeForLong("PRAGMA page_size;", null, null);
        }
        catch (SQLiteException sQLiteException) {
            // empty catch block
        }
        dbStatsList.add(this.getMainDbStatsUnsafe(lookaside, pageCount, pageSize));
        try (CursorWindow window = new CursorWindow("collectDbStats");){
            this.executeForCursorWindow("PRAGMA database_list;", null, window, 0, 0, false, null);
            for (int i = 1; i < window.getNumRows(); ++i) {
                String name = window.getString(i, 1);
                String path = window.getString(i, 2);
                pageCount = 0L;
                pageSize = 0L;
                try {
                    pageCount = this.executeForLong("PRAGMA " + name + ".page_count;", null, null);
                    pageSize = this.executeForLong("PRAGMA " + name + ".page_size;", null, null);
                }
                catch (SQLiteException sQLiteException) {
                    // empty catch block
                }
                String label = "  (attached) " + name;
                if (!path.isEmpty()) {
                    label = label + ": " + path;
                }
                dbStatsList.add(new SQLiteDebug.DbStats(label, pageCount, pageSize, 0, 0, 0, 0));
            }
        }
    }

    void collectDbStatsUnsafe(ArrayList<SQLiteDebug.DbStats> dbStatsList) {
        dbStatsList.add(this.getMainDbStatsUnsafe(0, 0L, 0L));
    }

    private SQLiteDebug.DbStats getMainDbStatsUnsafe(int lookaside, long pageCount, long pageSize) {
        String label = this.mConfiguration.path;
        if (!this.mIsPrimaryConnection) {
            label = label + " (" + this.mConnectionId + ")";
        }
        return new SQLiteDebug.DbStats(label, pageCount, pageSize, lookaside, this.mPreparedStatementCache.hitCount(), this.mPreparedStatementCache.missCount(), this.mPreparedStatementCache.size());
    }

    public String toString() {
        return "SQLiteConnection: " + this.mConfiguration.path + " (" + this.mConnectionId + ")";
    }

    private PreparedStatement obtainPreparedStatement(String sql, long statementPtr, int numParameters, int type, boolean readOnly) {
        PreparedStatement statement = this.mPreparedStatementPool;
        if (statement != null) {
            this.mPreparedStatementPool = statement.mPoolNext;
            statement.mPoolNext = null;
            statement.mInCache = false;
        } else {
            statement = new PreparedStatement();
        }
        statement.mSql = sql;
        statement.mStatementPtr = statementPtr;
        statement.mNumParameters = numParameters;
        statement.mType = type;
        statement.mReadOnly = readOnly;
        return statement;
    }

    private void recyclePreparedStatement(PreparedStatement statement) {
        statement.mSql = null;
        statement.mPoolNext = this.mPreparedStatementPool;
        this.mPreparedStatementPool = statement;
    }

    private static String trimSqlForDisplay(String sql) {
        return sql.replaceAll("[\\s]*\\n+[\\s]*", " ");
    }

    private static final class Operation {
        private static final int MAX_TRACE_METHOD_NAME_LEN = 256;
        public long mStartWallTime;
        public long mStartTime;
        public long mEndTime;
        public String mKind;
        public String mSql;
        public ArrayList<Object> mBindArgs;
        public boolean mFinished;
        public Exception mException;
        public int mCookie;

        private Operation() {
        }

        public void describe(StringBuilder msg, boolean verbose) {
            msg.append(this.mKind);
            if (this.mFinished) {
                msg.append(" took ").append(this.mEndTime - this.mStartTime).append("ms");
            } else {
                msg.append(" started ").append(System.currentTimeMillis() - this.mStartWallTime).append("ms ago");
            }
            msg.append(" - ").append(this.getStatus());
            if (this.mSql != null) {
                msg.append(", sql=\"").append(SQLiteConnection.trimSqlForDisplay(this.mSql)).append("\"");
            }
            if (verbose && this.mBindArgs != null && this.mBindArgs.size() != 0) {
                msg.append(", bindArgs=[");
                int count = this.mBindArgs.size();
                for (int i = 0; i < count; ++i) {
                    Object arg = this.mBindArgs.get(i);
                    if (i != 0) {
                        msg.append(", ");
                    }
                    if (arg == null) {
                        msg.append("null");
                        continue;
                    }
                    if (arg instanceof byte[]) {
                        msg.append("<byte[]>");
                        continue;
                    }
                    if (arg instanceof String) {
                        msg.append("\"").append((String)arg).append("\"");
                        continue;
                    }
                    msg.append(arg);
                }
                msg.append("]");
            }
            if (this.mException != null) {
                msg.append(", exception=\"").append(this.mException.getMessage()).append("\"");
            }
        }

        private String getStatus() {
            if (!this.mFinished) {
                return "running";
            }
            return this.mException != null ? "failed" : "succeeded";
        }

        private String getTraceMethodName() {
            String methodName = this.mKind + " " + this.mSql;
            if (methodName.length() > 256) {
                return methodName.substring(0, 256);
            }
            return methodName;
        }
    }

    private static final class OperationLog {
        private static final int MAX_RECENT_OPERATIONS = 20;
        private static final int COOKIE_GENERATION_SHIFT = 8;
        private static final int COOKIE_INDEX_MASK = 255;
        private final Operation[] mOperations = new Operation[20];
        private int mIndex;
        private int mGeneration;
        private final SQLiteConnectionPool mPool;

        OperationLog(SQLiteConnectionPool pool) {
            this.mPool = pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int beginOperation(String kind, String sql, Object[] bindArgs) {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                int index = (this.mIndex + 1) % 20;
                Operation operation = this.mOperations[index];
                if (operation == null) {
                    this.mOperations[index] = operation = new Operation();
                } else {
                    operation.mFinished = false;
                    operation.mException = null;
                    if (operation.mBindArgs != null) {
                        operation.mBindArgs.clear();
                    }
                }
                operation.mStartWallTime = System.currentTimeMillis();
                operation.mStartTime = SystemClock.uptimeMillis();
                operation.mKind = kind;
                operation.mSql = sql;
                if (bindArgs != null) {
                    if (operation.mBindArgs == null) {
                        operation.mBindArgs = new ArrayList();
                    } else {
                        operation.mBindArgs.clear();
                    }
                    for (int i = 0; i < bindArgs.length; ++i) {
                        Object arg = bindArgs[i];
                        if (arg != null && arg instanceof byte[]) {
                            operation.mBindArgs.add(EMPTY_BYTE_ARRAY);
                            continue;
                        }
                        operation.mBindArgs.add(arg);
                    }
                }
                operation.mCookie = this.newOperationCookieLocked(index);
                if (Trace.isTagEnabled(0x100000L)) {
                    Trace.asyncTraceBegin(0x100000L, operation.getTraceMethodName(), operation.mCookie);
                }
                this.mIndex = index;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return operation.mCookie;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failOperation(int cookie, Exception ex) {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                Operation operation = this.getOperationLocked(cookie);
                if (operation != null) {
                    operation.mException = ex;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endOperation(int cookie) {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                if (this.endOperationDeferLogLocked(cookie)) {
                    this.logOperationLocked(cookie, null);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean endOperationDeferLog(int cookie) {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.endOperationDeferLogLocked(cookie);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void logOperation(int cookie, String detail) {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                this.logOperationLocked(cookie, detail);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        private boolean endOperationDeferLogLocked(int cookie) {
            Operation operation = this.getOperationLocked(cookie);
            if (operation != null) {
                if (Trace.isTagEnabled(0x100000L)) {
                    Trace.asyncTraceEnd(0x100000L, operation.getTraceMethodName(), operation.mCookie);
                }
                operation.mEndTime = SystemClock.uptimeMillis();
                operation.mFinished = true;
                long execTime = operation.mEndTime - operation.mStartTime;
                this.mPool.onStatementExecuted(execTime);
                return SQLiteDebug.DEBUG_LOG_SLOW_QUERIES && SQLiteDebug.shouldLogSlowQuery(execTime);
            }
            return false;
        }

        private void logOperationLocked(int cookie, String detail) {
            Operation operation = this.getOperationLocked(cookie);
            StringBuilder msg = new StringBuilder();
            operation.describe(msg, false);
            if (detail != null) {
                msg.append(", ").append(detail);
            }
            Log.d(SQLiteConnection.TAG, msg.toString());
        }

        private int newOperationCookieLocked(int index) {
            int generation = this.mGeneration++;
            return generation << 8 | index;
        }

        private Operation getOperationLocked(int cookie) {
            int index = cookie & 0xFF;
            Operation operation = this.mOperations[index];
            return operation.mCookie == cookie ? operation : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String describeCurrentOperation() {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                Operation operation = this.mOperations[this.mIndex];
                if (operation != null && !operation.mFinished) {
                    StringBuilder msg = new StringBuilder();
                    operation.describe(msg, false);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return msg.toString();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(Printer printer, boolean verbose) {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                printer.println("  Most recently executed operations:");
                int index = this.mIndex;
                Operation operation = this.mOperations[index];
                if (operation != null) {
                    SimpleDateFormat opDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                    int n = 0;
                    do {
                        StringBuilder msg = new StringBuilder();
                        msg.append("    ").append(n).append(": [");
                        String formattedStartTime = opDF.format(new Date(operation.mStartWallTime));
                        msg.append(formattedStartTime);
                        msg.append("] ");
                        operation.describe(msg, verbose);
                        printer.println(msg.toString());
                        if (index > 0) {
                            --index;
                            continue;
                        }
                        index = 19;
                    } while ((operation = this.mOperations[index]) != null && ++n < 20);
                } else {
                    printer.println("    <none>");
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }

    private final class PreparedStatementCache
    extends LruCache<String, PreparedStatement> {
        public PreparedStatementCache(int size) {
            super(size);
        }

        @Override
        protected void entryRemoved(boolean evicted, String key, PreparedStatement oldValue, PreparedStatement newValue) {
            oldValue.mInCache = false;
            if (!oldValue.mInUse) {
                SQLiteConnection.this.finalizePreparedStatement(oldValue);
            }
        }

        public void dump(Printer printer) {
            printer.println("  Prepared statement cache:");
            Map cache = this.snapshot();
            if (!cache.isEmpty()) {
                int i = 0;
                for (Map.Entry entry : cache.entrySet()) {
                    PreparedStatement statement = (PreparedStatement)entry.getValue();
                    if (statement.mInCache) {
                        String sql = (String)entry.getKey();
                        printer.println("    " + i + ": statementPtr=0x" + Long.toHexString(statement.mStatementPtr) + ", numParameters=" + statement.mNumParameters + ", type=" + statement.mType + ", readOnly=" + statement.mReadOnly + ", sql=\"" + SQLiteConnection.trimSqlForDisplay(sql) + "\"");
                    }
                    ++i;
                }
            } else {
                printer.println("    <none>");
            }
        }
    }

    private static final class PreparedStatement {
        public PreparedStatement mPoolNext;
        public String mSql;
        public long mStatementPtr;
        public int mNumParameters;
        public int mType;
        public boolean mReadOnly;
        public boolean mInCache;
        public boolean mInUse;

        private PreparedStatement() {
        }
    }
}

