/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class KeyValueMap
extends HashMap<String, Object> {
    public void setKeyValues(Object ... keyValues) {
        if (keyValues.length % 2 != 0) {
            throw new RuntimeException("Key-Value arguments passed into setKeyValues must be an alternating list of keys and values!");
        }
        for (int i = 0; i < keyValues.length; i += 2) {
            if (!(keyValues[i] instanceof String)) {
                throw new RuntimeException("Key-value argument " + i + " must be a key of type String, but found an object of type " + keyValues[i].getClass() + "!");
            }
            String key = (String)keyValues[i];
            Object value = keyValues[i + 1];
            this.put(key, value);
        }
    }

    public static KeyValueMap fromKeyValues(Object ... keyValues) {
        KeyValueMap result = new KeyValueMap();
        result.setKeyValues(keyValues);
        return result;
    }

    public String getString(String key) {
        Object result = this.get(key);
        return result != null ? (String)result : null;
    }

    public int getInt(String key) {
        Object result = this.get(key);
        return result != null ? (Integer)result : null;
    }

    public float getFloat(String key) {
        Object result = this.get(key);
        return (result != null ? (Float)result : null).floatValue();
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        for (Map.Entry entry : this.entrySet()) {
            Object value = entry.getValue();
            String valueString = value instanceof String ? "\"" + value + "\"" : value.toString();
            writer.write((String)entry.getKey() + " = " + valueString + ";\n");
        }
        return writer.toString();
    }
}

