/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.ColorSpace;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.os.Trace;
import android.util.Log;
import android.util.TypedValue;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitmapFactory {
    private static final int DECODE_BUFFER_SIZE = 16384;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeFile(String pathName, Options opts) {
        Options.validate(opts);
        Bitmap bm = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(pathName);
            bm = BitmapFactory.decodeStream(stream, null, opts);
        }
        catch (Exception e) {
            Log.e("BitmapFactory", "Unable to decode stream: " + e);
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return bm;
    }

    public static Bitmap decodeFile(String pathName) {
        return BitmapFactory.decodeFile(pathName, null);
    }

    public static Bitmap decodeResourceStream(Resources res, TypedValue value, InputStream is, Rect pad, Options opts) {
        Options.validate(opts);
        if (opts == null) {
            opts = new Options();
        }
        if (opts.inDensity == 0 && value != null) {
            int density = value.density;
            if (density == 0) {
                opts.inDensity = 160;
            } else if (density != 65535) {
                opts.inDensity = density;
            }
        }
        if (opts.inTargetDensity == 0 && res != null) {
            opts.inTargetDensity = res.getDisplayMetrics().densityDpi;
        }
        return BitmapFactory.decodeStream(is, pad, opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeResource(Resources res, int id2, Options opts) {
        Options.validate(opts);
        Bitmap bm = null;
        InputStream is = null;
        try {
            TypedValue value = new TypedValue();
            is = res.openRawResource(id2, value);
            bm = BitmapFactory.decodeResourceStream(res, value, is, null, opts);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (bm == null && opts != null && opts.inBitmap != null) {
            throw new IllegalArgumentException("Problem decoding into existing bitmap");
        }
        return bm;
    }

    public static Bitmap decodeResource(Resources res, int id2) {
        return BitmapFactory.decodeResource(res, id2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeByteArray(byte[] data, int offset, int length, Options opts) {
        Bitmap bm;
        if ((offset | length) < 0 || data.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Options.validate(opts);
        Trace.traceBegin(2L, "decodeBitmap");
        try {
            bm = BitmapFactory.nativeDecodeByteArray(data, offset, length, opts);
            if (bm == null && opts != null && opts.inBitmap != null) {
                throw new IllegalArgumentException("Problem decoding into existing bitmap");
            }
            BitmapFactory.setDensityFromOptions(bm, opts);
        }
        finally {
            Trace.traceEnd(2L);
        }
        return bm;
    }

    public static Bitmap decodeByteArray(byte[] data, int offset, int length) {
        return BitmapFactory.decodeByteArray(data, offset, length, null);
    }

    private static void setDensityFromOptions(Bitmap outputBitmap, Options opts) {
        if (outputBitmap == null || opts == null) {
            return;
        }
        int density = opts.inDensity;
        if (density != 0) {
            boolean isNinePatch;
            outputBitmap.setDensity(density);
            int targetDensity = opts.inTargetDensity;
            if (targetDensity == 0 || density == targetDensity || density == opts.inScreenDensity) {
                return;
            }
            byte[] np = outputBitmap.getNinePatchChunk();
            boolean bl = isNinePatch = np != null && NinePatch.isNinePatchChunk(np);
            if (opts.inScaled || isNinePatch) {
                outputBitmap.setDensity(targetDensity);
            }
        } else if (opts.inBitmap != null) {
            outputBitmap.setDensity(Bitmap.getDefaultDensity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeStream(InputStream is, Rect outPadding, Options opts) {
        if (is == null) {
            return null;
        }
        Options.validate(opts);
        Bitmap bm = null;
        Trace.traceBegin(2L, "decodeBitmap");
        try {
            if (is instanceof AssetManager.AssetInputStream) {
                long asset = ((AssetManager.AssetInputStream)is).getNativeAsset();
                bm = BitmapFactory.nativeDecodeAsset(asset, outPadding, opts);
            } else {
                bm = BitmapFactory.decodeStreamInternal(is, outPadding, opts);
            }
            if (bm == null && opts != null && opts.inBitmap != null) {
                throw new IllegalArgumentException("Problem decoding into existing bitmap");
            }
            BitmapFactory.setDensityFromOptions(bm, opts);
        }
        finally {
            Trace.traceEnd(2L);
        }
        return bm;
    }

    private static Bitmap decodeStreamInternal(InputStream is, Rect outPadding, Options opts) {
        byte[] tempStorage = null;
        if (opts != null) {
            tempStorage = opts.inTempStorage;
        }
        if (tempStorage == null) {
            tempStorage = new byte[16384];
        }
        return BitmapFactory.nativeDecodeStream(is, tempStorage, outPadding, opts);
    }

    public static Bitmap decodeStream(InputStream is) {
        return BitmapFactory.decodeStream(is, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeFileDescriptor(FileDescriptor fd, Rect outPadding, Options opts) {
        Bitmap bm;
        Options.validate(opts);
        Trace.traceBegin(2L, "decodeFileDescriptor");
        try {
            if (BitmapFactory.nativeIsSeekable(fd)) {
                bm = BitmapFactory.nativeDecodeFileDescriptor(fd, outPadding, opts);
            } else {
                FileInputStream fis = new FileInputStream(fd);
                try {
                    bm = BitmapFactory.decodeStreamInternal(fis, outPadding, opts);
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            if (bm == null && opts != null && opts.inBitmap != null) {
                throw new IllegalArgumentException("Problem decoding into existing bitmap");
            }
            BitmapFactory.setDensityFromOptions(bm, opts);
        }
        finally {
            Trace.traceEnd(2L);
        }
        return bm;
    }

    public static Bitmap decodeFileDescriptor(FileDescriptor fd) {
        return BitmapFactory.decodeFileDescriptor(fd, null, null);
    }

    private static native Bitmap nativeDecodeStream(InputStream var0, byte[] var1, Rect var2, Options var3);

    private static native Bitmap nativeDecodeFileDescriptor(FileDescriptor var0, Rect var1, Options var2);

    private static native Bitmap nativeDecodeAsset(long var0, Rect var2, Options var3);

    private static native Bitmap nativeDecodeByteArray(byte[] var0, int var1, int var2, Options var3);

    private static native boolean nativeIsSeekable(FileDescriptor var0);

    public static class Options {
        public Bitmap inBitmap;
        public boolean inMutable;
        public boolean inJustDecodeBounds;
        public int inSampleSize;
        public Bitmap.Config inPreferredConfig = Bitmap.Config.ARGB_8888;
        public ColorSpace inPreferredColorSpace = null;
        public boolean inPremultiplied = true;
        public boolean inDither;
        public int inDensity;
        public int inTargetDensity;
        public int inScreenDensity;
        public boolean inScaled = true;
        @Deprecated
        public boolean inPurgeable;
        @Deprecated
        public boolean inInputShareable;
        @Deprecated
        public boolean inPreferQualityOverSpeed;
        public int outWidth;
        public int outHeight;
        public String outMimeType;
        public Bitmap.Config outConfig;
        public ColorSpace outColorSpace;
        public byte[] inTempStorage;
        @Deprecated
        public boolean mCancel;

        @Deprecated
        public void requestCancelDecode() {
            this.mCancel = true;
        }

        static void validate(Options opts) {
            if (opts == null) {
                return;
            }
            if (opts.inBitmap != null && opts.inBitmap.getConfig() == Bitmap.Config.HARDWARE) {
                throw new IllegalArgumentException("Bitmaps with Config.HARWARE are always immutable");
            }
            if (opts.inMutable && opts.inPreferredConfig == Bitmap.Config.HARDWARE) {
                throw new IllegalArgumentException("Bitmaps with Config.HARDWARE cannot be decoded into - they are immutable");
            }
            if (opts.inPreferredColorSpace != null) {
                if (!(opts.inPreferredColorSpace instanceof ColorSpace.Rgb)) {
                    throw new IllegalArgumentException("The destination color space must use the RGB color model");
                }
                if (((ColorSpace.Rgb)opts.inPreferredColorSpace).getTransferParameters() == null) {
                    throw new IllegalArgumentException("The destination color space must use an ICC parametric transfer function");
                }
            }
        }
    }
}

