/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.NinePatch;
import android.graphics.PostProcessor;
import android.graphics.Rect;
import android.graphics.drawable.AnimatedImageDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.net.Uri;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Size;
import android.util.TypedValue;
import dalvik.system.CloseGuard;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import libcore.io.IoUtils;

public final class ImageDecoder
implements AutoCloseable {
    public static final int ERROR_SOURCE_EXCEPTION = 1;
    public static final int ERROR_SOURCE_INCOMPLETE = 2;
    public static final int ERROR_SOURCE_ERROR = 3;
    private long mNativePtr;
    private final int mWidth;
    private final int mHeight;
    private final boolean mAnimated;
    private int mDesiredWidth;
    private int mDesiredHeight;
    private int mAllocator = 0;
    private boolean mRequireUnpremultiplied = false;
    private boolean mMutable = false;
    private boolean mPreferRamOverQuality = false;
    private boolean mAsAlphaMask = false;
    private Rect mCropRect;
    private Source mSource;
    private PostProcessor mPostProcessor;
    private OnPartialImageListener mOnPartialImageListener;
    private InputStream mInputStream;
    private boolean mOwnsInputStream;
    private byte[] mTempStorage;
    private AssetFileDescriptor mAssetFd;
    private final AtomicBoolean mClosed = new AtomicBoolean();
    private final CloseGuard mCloseGuard = CloseGuard.get();
    public static final int ALLOCATOR_DEFAULT = 0;
    public static final int ALLOCATOR_SOFTWARE = 1;
    public static final int ALLOCATOR_SHARED_MEMORY = 2;
    public static final int ALLOCATOR_HARDWARE = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageDecoder createFromFile(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        FileDescriptor fd = stream.getFD();
        try {
            Os.lseek(fd, 0L, OsConstants.SEEK_CUR);
        }
        catch (ErrnoException e) {
            return ImageDecoder.createFromStream(stream, true);
        }
        ImageDecoder decoder = null;
        try {
            decoder = ImageDecoder.nCreate(fd);
        }
        finally {
            if (decoder == null) {
                IoUtils.closeQuietly(stream);
            } else {
                decoder.mInputStream = stream;
                decoder.mOwnsInputStream = true;
            }
        }
        return decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageDecoder createFromStream(InputStream is, boolean closeInputStream) throws IOException {
        byte[] storage = new byte[16384];
        ImageDecoder decoder = null;
        try {
            decoder = ImageDecoder.nCreate(is, storage);
        }
        finally {
            if (decoder == null) {
                if (closeInputStream) {
                    IoUtils.closeQuietly(is);
                }
            } else {
                decoder.mInputStream = is;
                decoder.mOwnsInputStream = closeInputStream;
                decoder.mTempStorage = storage;
            }
        }
        return decoder;
    }

    private ImageDecoder(long nativePtr, int width, int height, boolean animated) {
        this.mNativePtr = nativePtr;
        this.mWidth = width;
        this.mHeight = height;
        this.mDesiredWidth = width;
        this.mDesiredHeight = height;
        this.mAnimated = animated;
        this.mCloseGuard.open("close");
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mInputStream = null;
            this.mAssetFd = null;
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public static Source createSource(Resources res, int resId) {
        return new ResourceSource(res, resId);
    }

    public static Source createSource(ContentResolver cr, Uri uri) {
        return new ContentResolverSource(cr, uri, null);
    }

    public static Source createSource(ContentResolver cr, Uri uri, Resources res) {
        return new ContentResolverSource(cr, uri, res);
    }

    public static Source createSource(byte[] data, int offset, int length) throws ArrayIndexOutOfBoundsException {
        if (data == null) {
            throw new NullPointerException("null byte[] in createSource!");
        }
        if (offset < 0 || length < 0 || offset >= data.length || offset + length > data.length) {
            throw new ArrayIndexOutOfBoundsException("invalid offset/length!");
        }
        return new ByteArraySource(data, offset, length);
    }

    public static Source createSource(byte[] data) {
        return ImageDecoder.createSource(data, 0, data.length);
    }

    public static Source createSource(ByteBuffer buffer) {
        return new ByteBufferSource(buffer);
    }

    public static Source createSource(Resources res, InputStream is) {
        return new InputStreamSource(res, is, Bitmap.getDefaultDensity());
    }

    public static Source createSource(Resources res, InputStream is, int density) {
        return new InputStreamSource(res, is, density);
    }

    public static Source createSource(File file) {
        return new FileSource(file);
    }

    public Size getSampledSize(int sampleSize) {
        if (sampleSize <= 0) {
            throw new IllegalArgumentException("sampleSize must be positive! provided " + sampleSize);
        }
        if (this.mNativePtr == 0L) {
            throw new IllegalStateException("ImageDecoder is closed!");
        }
        return ImageDecoder.nGetSampledSize(this.mNativePtr, sampleSize);
    }

    public void setResize(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Dimensions must be positive! provided (" + width + ", " + height + ")");
        }
        this.mDesiredWidth = width;
        this.mDesiredHeight = height;
    }

    public void setResize(int sampleSize) {
        Size size = this.getSampledSize(sampleSize);
        this.setResize(size.getWidth(), size.getHeight());
    }

    private boolean requestedResize() {
        return this.mWidth != this.mDesiredWidth || this.mHeight != this.mDesiredHeight;
    }

    public void setAllocator(int allocator) {
        if (allocator < 0 || allocator > 3) {
            throw new IllegalArgumentException("invalid allocator " + allocator);
        }
        this.mAllocator = allocator;
    }

    public void setRequireUnpremultiplied(boolean requireUnpremultiplied) {
        this.mRequireUnpremultiplied = requireUnpremultiplied;
    }

    public void setPostProcessor(PostProcessor p) {
        this.mPostProcessor = p;
    }

    public void setOnPartialImageListener(OnPartialImageListener l) {
        this.mOnPartialImageListener = l;
    }

    public void setCrop(Rect subset) {
        this.mCropRect = subset;
    }

    public void setMutable(boolean mutable) {
        this.mMutable = mutable;
    }

    public void setPreferRamOverQuality(boolean preferRamOverQuality) {
        this.mPreferRamOverQuality = preferRamOverQuality;
    }

    public void setAsAlphaMask(boolean asAlphaMask) {
        this.mAsAlphaMask = asAlphaMask;
    }

    @Override
    public void close() {
        this.mCloseGuard.close();
        if (!this.mClosed.compareAndSet(false, true)) {
            return;
        }
        ImageDecoder.nClose(this.mNativePtr);
        this.mNativePtr = 0L;
        if (this.mOwnsInputStream) {
            IoUtils.closeQuietly(this.mInputStream);
        }
        IoUtils.closeQuietly(this.mAssetFd);
        this.mInputStream = null;
        this.mAssetFd = null;
        this.mTempStorage = null;
    }

    private void checkState() {
        if (this.mNativePtr == 0L) {
            throw new IllegalStateException("Cannot use closed ImageDecoder!");
        }
        ImageDecoder.checkSubset(this.mDesiredWidth, this.mDesiredHeight, this.mCropRect);
        if (this.mAllocator == 3) {
            if (this.mMutable) {
                throw new IllegalStateException("Cannot make mutable HARDWARE Bitmap!");
            }
            if (this.mAsAlphaMask) {
                throw new IllegalStateException("Cannot make HARDWARE Alpha mask Bitmap!");
            }
        }
        if (this.mPostProcessor != null && this.mRequireUnpremultiplied) {
            throw new IllegalStateException("Cannot draw to unpremultiplied pixels!");
        }
    }

    private static void checkSubset(int width, int height, Rect r) {
        if (r == null) {
            return;
        }
        if (r.left < 0 || r.top < 0 || r.right > width || r.bottom > height) {
            throw new IllegalStateException("Subset " + r + " not contained by scaled image bounds: (" + width + " x " + height + ")");
        }
    }

    private Bitmap decodeBitmap() throws IOException {
        this.checkState();
        ImageDecoder partialImagePtr = this.mOnPartialImageListener == null ? null : this;
        ImageDecoder postProcessPtr = this.mPostProcessor == null ? null : this;
        return ImageDecoder.nDecodeBitmap(this.mNativePtr, partialImagePtr, postProcessPtr, this.mDesiredWidth, this.mDesiredHeight, this.mCropRect, this.mMutable, this.mAllocator, this.mRequireUnpremultiplied, this.mPreferRamOverQuality, this.mAsAlphaMask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callHeaderDecoded(OnHeaderDecodedListener listener, Source src) {
        if (listener != null) {
            ImageInfo info = new ImageInfo(this);
            try {
                listener.onHeaderDecoded(this, info, src);
            }
            finally {
                info.mDecoder = null;
            }
        }
    }

    public static Drawable decodeDrawable(Source src, OnHeaderDecodedListener listener) throws IOException {
        try (ImageDecoder decoder = src.createImageDecoder();){
            decoder.mSource = src;
            decoder.callHeaderDecoded(listener, src);
            if (decoder.mRequireUnpremultiplied) {
                throw new IllegalStateException("Cannot decode a Drawable with unpremultiplied pixels!");
            }
            if (decoder.mMutable) {
                throw new IllegalStateException("Cannot decode a mutable Drawable!");
            }
            int srcDensity = ImageDecoder.computeDensity(src, decoder);
            if (decoder.mAnimated) {
                ImageDecoder postProcessPtr = decoder.mPostProcessor == null ? null : decoder;
                AnimatedImageDrawable d = new AnimatedImageDrawable(decoder.mNativePtr, postProcessPtr, decoder.mDesiredWidth, decoder.mDesiredHeight, srcDensity, src.computeDstDensity(), decoder.mCropRect, decoder.mInputStream, decoder.mAssetFd);
                decoder.mInputStream = null;
                decoder.mAssetFd = null;
                AnimatedImageDrawable animatedImageDrawable = d;
                return animatedImageDrawable;
            }
            Bitmap bm = decoder.decodeBitmap();
            bm.setDensity(srcDensity);
            Resources res = src.getResources();
            byte[] np = bm.getNinePatchChunk();
            if (np != null && NinePatch.isNinePatchChunk(np)) {
                Rect opticalInsets = new Rect();
                bm.getOpticalInsets(opticalInsets);
                Rect padding = new Rect();
                ImageDecoder.nGetPadding(decoder.mNativePtr, padding);
                NinePatchDrawable ninePatchDrawable = new NinePatchDrawable(res, bm, np, padding, opticalInsets, null);
                return ninePatchDrawable;
            }
            BitmapDrawable bitmapDrawable = new BitmapDrawable(res, bm);
            return bitmapDrawable;
        }
    }

    public static Drawable decodeDrawable(Source src) throws IOException {
        return ImageDecoder.decodeDrawable(src, null);
    }

    public static Bitmap decodeBitmap(Source src, OnHeaderDecodedListener listener) throws IOException {
        try (ImageDecoder decoder = src.createImageDecoder();){
            decoder.mSource = src;
            decoder.callHeaderDecoded(listener, src);
            int srcDensity = ImageDecoder.computeDensity(src, decoder);
            Bitmap bm = decoder.decodeBitmap();
            bm.setDensity(srcDensity);
            Bitmap bitmap = bm;
            return bitmap;
        }
    }

    private static int computeDensity(Source src, ImageDecoder decoder) {
        if (decoder.requestedResize()) {
            return 0;
        }
        Resources res = src.getResources();
        int srcDensity = src.getDensity();
        if (res != null && res.getDisplayMetrics().noncompatDensityDpi == srcDensity) {
            return srcDensity;
        }
        int dstDensity = src.computeDstDensity();
        if (srcDensity != 0 && srcDensity > dstDensity) {
            float scale = (float)dstDensity / (float)srcDensity;
            int scaledWidth = (int)((float)decoder.mWidth * scale + 0.5f);
            int scaledHeight = (int)((float)decoder.mHeight * scale + 0.5f);
            decoder.setResize(scaledWidth, scaledHeight);
            return dstDensity;
        }
        return srcDensity;
    }

    private String getMimeType() {
        return ImageDecoder.nGetMimeType(this.mNativePtr);
    }

    public static Bitmap decodeBitmap(Source src) throws IOException {
        return ImageDecoder.decodeBitmap(src, null);
    }

    private int postProcessAndRelease(Canvas canvas) {
        try {
            int n = this.mPostProcessor.onPostProcess(canvas);
            return n;
        }
        finally {
            canvas.release();
        }
    }

    private boolean onPartialImage(int error) {
        return this.mOnPartialImageListener.onPartialImage(error, this.mSource);
    }

    private static native ImageDecoder nCreate(long var0) throws IOException;

    private static native ImageDecoder nCreate(ByteBuffer var0, int var1, int var2) throws IOException;

    private static native ImageDecoder nCreate(byte[] var0, int var1, int var2) throws IOException;

    private static native ImageDecoder nCreate(InputStream var0, byte[] var1);

    private static native ImageDecoder nCreate(FileDescriptor var0) throws IOException;

    private static native Bitmap nDecodeBitmap(long var0, ImageDecoder var2, ImageDecoder var3, int var4, int var5, Rect var6, boolean var7, int var8, boolean var9, boolean var10, boolean var11) throws IOException;

    private static native Size nGetSampledSize(long var0, int var2);

    private static native void nGetPadding(long var0, Rect var2);

    private static native void nClose(long var0);

    private static native String nGetMimeType(long var0);

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Allocator {
    }

    public static interface OnPartialImageListener {
        public boolean onPartialImage(int var1, Source var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Error {
    }

    public static interface OnHeaderDecodedListener {
        public void onHeaderDecoded(ImageDecoder var1, ImageInfo var2, Source var3);
    }

    public static class IncompleteException
    extends IOException {
    }

    public static class ImageInfo {
        private final Size mSize;
        private ImageDecoder mDecoder;

        private ImageInfo(ImageDecoder decoder) {
            this.mSize = new Size(decoder.mWidth, decoder.mHeight);
            this.mDecoder = decoder;
        }

        public Size getSize() {
            return this.mSize;
        }

        public String getMimeType() {
            return this.mDecoder.getMimeType();
        }

        public boolean isAnimated() {
            return this.mDecoder.mAnimated;
        }
    }

    private static class FileSource
    extends Source {
        private final File mFile;

        FileSource(File file) {
            this.mFile = file;
        }

        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            return ImageDecoder.createFromFile(this.mFile);
        }
    }

    private static class ResourceSource
    extends Source {
        final Resources mResources;
        final int mResId;
        int mResDensity;

        ResourceSource(Resources res, int resId) {
            this.mResources = res;
            this.mResId = resId;
            this.mResDensity = 0;
        }

        @Override
        public Resources getResources() {
            return this.mResources;
        }

        @Override
        public int getDensity() {
            return this.mResDensity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            ImageDecoder decoder;
            block9: {
                InputStream is;
                block8: {
                    is = null;
                    decoder = null;
                    TypedValue value = new TypedValue();
                    try {
                        is = this.mResources.openRawResource(this.mResId, value);
                        if (value.density == 0) {
                            this.mResDensity = 160;
                        } else if (value.density != 65535) {
                            this.mResDensity = value.density;
                        }
                        if (!(is instanceof AssetManager.AssetInputStream)) {
                            throw new RuntimeException("Resource is not an asset?");
                        }
                        long asset = ((AssetManager.AssetInputStream)is).getNativeAsset();
                        decoder = ImageDecoder.nCreate(asset);
                        if (decoder != null) break block8;
                    }
                    catch (Throwable throwable) {
                        if (decoder == null) {
                            IoUtils.closeQuietly(is);
                        } else {
                            decoder.mInputStream = is;
                            decoder.mOwnsInputStream = true;
                        }
                        throw throwable;
                    }
                    IoUtils.closeQuietly(is);
                    break block9;
                }
                decoder.mInputStream = is;
                decoder.mOwnsInputStream = true;
            }
            return decoder;
        }
    }

    private static class InputStreamSource
    extends Source {
        final Resources mResources;
        InputStream mInputStream;
        final int mInputDensity;

        InputStreamSource(Resources res, InputStream is, int inputDensity) {
            if (is == null) {
                throw new IllegalArgumentException("The InputStream cannot be null");
            }
            this.mResources = res;
            this.mInputStream = is;
            this.mInputDensity = res != null ? inputDensity : 0;
        }

        @Override
        public Resources getResources() {
            return this.mResources;
        }

        @Override
        public int getDensity() {
            return this.mInputDensity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            InputStreamSource inputStreamSource = this;
            synchronized (inputStreamSource) {
                if (this.mInputStream == null) {
                    throw new IOException("Cannot reuse InputStreamSource");
                }
                InputStream is = this.mInputStream;
                this.mInputStream = null;
                return ImageDecoder.createFromStream(is, false);
            }
        }
    }

    private static class ContentResolverSource
    extends Source {
        private final ContentResolver mResolver;
        private final Uri mUri;
        private final Resources mResources;

        ContentResolverSource(ContentResolver resolver, Uri uri, Resources res) {
            this.mResolver = resolver;
            this.mUri = uri;
            this.mResources = res;
        }

        @Override
        Resources getResources() {
            return this.mResources;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            ImageDecoder decoder;
            block10: {
                AssetFileDescriptor assetFd;
                block9: {
                    assetFd = null;
                    try {
                        assetFd = this.mUri.getScheme() == "content" ? this.mResolver.openTypedAssetFileDescriptor(this.mUri, "image/*", null) : this.mResolver.openAssetFileDescriptor(this.mUri, "r");
                    }
                    catch (FileNotFoundException e) {
                        InputStream is = this.mResolver.openInputStream(this.mUri);
                        if (is == null) {
                            throw new FileNotFoundException(this.mUri.toString());
                        }
                        return ImageDecoder.createFromStream(is, true);
                    }
                    FileDescriptor fd = assetFd.getFileDescriptor();
                    long offset = assetFd.getStartOffset();
                    decoder = null;
                    try {
                        try {
                            Os.lseek(fd, offset, OsConstants.SEEK_SET);
                            decoder = ImageDecoder.nCreate(fd);
                        }
                        catch (ErrnoException e) {
                            decoder = ImageDecoder.createFromStream(new FileInputStream(fd), true);
                        }
                        if (decoder != null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (decoder == null) {
                            IoUtils.closeQuietly(assetFd);
                        } else {
                            decoder.mAssetFd = assetFd;
                        }
                        throw throwable;
                    }
                    IoUtils.closeQuietly(assetFd);
                    break block10;
                }
                decoder.mAssetFd = assetFd;
            }
            return decoder;
        }
    }

    private static class ByteBufferSource
    extends Source {
        private final ByteBuffer mBuffer;

        ByteBufferSource(ByteBuffer buffer) {
            this.mBuffer = buffer;
        }

        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            if (!this.mBuffer.isDirect() && this.mBuffer.hasArray()) {
                int offset = this.mBuffer.arrayOffset() + this.mBuffer.position();
                int length = this.mBuffer.limit() - this.mBuffer.position();
                return ImageDecoder.nCreate(this.mBuffer.array(), offset, length);
            }
            return ImageDecoder.nCreate(this.mBuffer, this.mBuffer.position(), this.mBuffer.limit());
        }
    }

    private static class ByteArraySource
    extends Source {
        private final byte[] mData;
        private final int mOffset;
        private final int mLength;

        ByteArraySource(byte[] data, int offset, int length) {
            this.mData = data;
            this.mOffset = offset;
            this.mLength = length;
        }

        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            return ImageDecoder.nCreate(this.mData, this.mOffset, this.mLength);
        }
    }

    public static abstract class Source {
        private Source() {
        }

        Resources getResources() {
            return null;
        }

        int getDensity() {
            return 0;
        }

        final int computeDstDensity() {
            Resources res = this.getResources();
            if (res == null) {
                return Bitmap.getDefaultDensity();
            }
            return res.getDisplayMetrics().densityDpi;
        }

        abstract ImageDecoder createImageDecoder() throws IOException;
    }
}

