/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import java.io.InputStream;
import java.io.OutputStream;

public class Picture {
    private PictureCanvas mRecordingCanvas;
    private long mNativePicture;
    private boolean mRequiresHwAcceleration;
    private static final int WORKING_STREAM_STORAGE = 16384;

    public Picture() {
        this(Picture.nativeConstructor(0L));
    }

    public Picture(Picture src) {
        this(Picture.nativeConstructor(src != null ? src.mNativePicture : 0L));
    }

    private Picture(long nativePicture) {
        if (nativePicture == 0L) {
            throw new RuntimeException();
        }
        this.mNativePicture = nativePicture;
    }

    protected void finalize() throws Throwable {
        try {
            Picture.nativeDestructor(this.mNativePicture);
            this.mNativePicture = 0L;
        }
        finally {
            super.finalize();
        }
    }

    public Canvas beginRecording(int width, int height) {
        if (this.mRecordingCanvas != null) {
            throw new IllegalStateException("Picture already recording, must call #endRecording()");
        }
        long ni = Picture.nativeBeginRecording(this.mNativePicture, width, height);
        this.mRecordingCanvas = new PictureCanvas(this, ni);
        this.mRequiresHwAcceleration = false;
        return this.mRecordingCanvas;
    }

    public void endRecording() {
        if (this.mRecordingCanvas != null) {
            this.mRequiresHwAcceleration = this.mRecordingCanvas.mHoldsHwBitmap;
            this.mRecordingCanvas = null;
            Picture.nativeEndRecording(this.mNativePicture);
        }
    }

    public int getWidth() {
        return Picture.nativeGetWidth(this.mNativePicture);
    }

    public int getHeight() {
        return Picture.nativeGetHeight(this.mNativePicture);
    }

    public boolean requiresHardwareAcceleration() {
        return this.mRequiresHwAcceleration;
    }

    public void draw(Canvas canvas) {
        if (this.mRecordingCanvas != null) {
            this.endRecording();
        }
        if (this.mRequiresHwAcceleration && !canvas.isHardwareAccelerated()) {
            canvas.onHwBitmapInSwMode();
        }
        Picture.nativeDraw(canvas.getNativeCanvasWrapper(), this.mNativePicture);
    }

    @Deprecated
    public static Picture createFromStream(InputStream stream) {
        return new Picture(Picture.nativeCreateFromStream(stream, new byte[16384]));
    }

    @Deprecated
    public void writeToStream(OutputStream stream) {
        if (stream == null) {
            throw new NullPointerException();
        }
        if (!Picture.nativeWriteToStream(this.mNativePicture, stream, new byte[16384])) {
            throw new RuntimeException();
        }
    }

    private static native long nativeConstructor(long var0);

    private static native long nativeCreateFromStream(InputStream var0, byte[] var1);

    private static native int nativeGetWidth(long var0);

    private static native int nativeGetHeight(long var0);

    private static native long nativeBeginRecording(long var0, int var2, int var3);

    private static native void nativeEndRecording(long var0);

    private static native void nativeDraw(long var0, long var2);

    private static native boolean nativeWriteToStream(long var0, OutputStream var2, byte[] var3);

    private static native void nativeDestructor(long var0);

    private static class PictureCanvas
    extends Canvas {
        private final Picture mPicture;
        boolean mHoldsHwBitmap;

        public PictureCanvas(Picture pict, long nativeCanvas) {
            super(nativeCanvas);
            this.mPicture = pict;
        }

        @Override
        public void setBitmap(Bitmap bitmap) {
            throw new RuntimeException("Cannot call setBitmap on a picture canvas");
        }

        @Override
        public void drawPicture(Picture picture) {
            if (this.mPicture == picture) {
                throw new RuntimeException("Cannot draw a picture into its recording canvas");
            }
            super.drawPicture(picture);
        }

        @Override
        protected void onHwBitmapInSwMode() {
            this.mHoldsHwBitmap = true;
        }
    }
}

