/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ImageDecoder;
import android.graphics.Rect;
import android.graphics.drawable.Animatable2;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.TypedValue;
import com.android.internal.R;
import dalvik.annotation.optimization.FastNative;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import libcore.util.NativeAllocationRegistry;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedImageDrawable
extends Drawable
implements Animatable2 {
    private int mIntrinsicWidth;
    private int mIntrinsicHeight;
    private boolean mStarting;
    private Handler mHandler;
    private State mState;
    private Runnable mRunnable;
    public static final int LOOP_INFINITE = -1;
    private static final int FINISHED = -1;
    private ArrayList<Animatable2.AnimationCallback> mAnimationCallbacks = null;

    public void setLoopCount(int loopCount) {
        if (this.mState == null) {
            throw new IllegalStateException("called setLoopCount on empty AnimatedImageDrawable");
        }
        AnimatedImageDrawable.nSetLoopCount(this.mState.mNativePtr, loopCount);
    }

    public AnimatedImageDrawable() {
        this.mState = null;
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        TypedArray a = AnimatedImageDrawable.obtainAttributes(r, theme, attrs, R.styleable.AnimatedImageDrawable);
        this.updateStateFromTypedArray(a, this.mSrcDensityOverride);
    }

    private void updateStateFromTypedArray(TypedArray a, int srcDensityOverride) throws XmlPullParserException {
        Resources r = a.getResources();
        int srcResId = a.getResourceId(0, 0);
        if (srcResId != 0) {
            TypedValue value = new TypedValue();
            r.getValueForDensity(srcResId, srcDensityOverride, value, true);
            if (srcDensityOverride > 0 && value.density > 0 && value.density != 65535) {
                value.density = value.density == srcDensityOverride ? r.getDisplayMetrics().densityDpi : value.density * r.getDisplayMetrics().densityDpi / srcDensityOverride;
            }
            int density = 0;
            if (value.density == 0) {
                density = 160;
            } else if (value.density != 65535) {
                density = value.density;
            }
            Drawable drawable2 = null;
            try {
                InputStream is = r.openRawResource(srcResId, value);
                ImageDecoder.Source source = ImageDecoder.createSource(r, is, density);
                drawable2 = ImageDecoder.decodeDrawable(source, (decoder, info, src) -> {
                    if (!info.isAnimated()) {
                        throw new IllegalArgumentException("image is not animated");
                    }
                });
            }
            catch (IOException e) {
                throw new XmlPullParserException(a.getPositionDescription() + ": <animated-image> requires a valid 'src' attribute", null, e);
            }
            if (!(drawable2 instanceof AnimatedImageDrawable)) {
                throw new XmlPullParserException(a.getPositionDescription() + ": <animated-image> did not decode animated");
            }
            AnimatedImageDrawable other = (AnimatedImageDrawable)drawable2;
            this.mState = other.mState;
            other.mState = null;
            this.mIntrinsicWidth = other.mIntrinsicWidth;
            this.mIntrinsicHeight = other.mIntrinsicHeight;
        }
    }

    public AnimatedImageDrawable(long nativeImageDecoder, ImageDecoder decoder, int width, int height, int srcDensity, int dstDensity, Rect cropRect, InputStream inputStream, AssetFileDescriptor afd) throws IOException {
        width = Bitmap.scaleFromDensity(width, srcDensity, dstDensity);
        height = Bitmap.scaleFromDensity(height, srcDensity, dstDensity);
        if (cropRect == null) {
            this.mIntrinsicWidth = width;
            this.mIntrinsicHeight = height;
        } else {
            cropRect.set(Bitmap.scaleFromDensity(cropRect.left, srcDensity, dstDensity), Bitmap.scaleFromDensity(cropRect.top, srcDensity, dstDensity), Bitmap.scaleFromDensity(cropRect.right, srcDensity, dstDensity), Bitmap.scaleFromDensity(cropRect.bottom, srcDensity, dstDensity));
            this.mIntrinsicWidth = cropRect.width();
            this.mIntrinsicHeight = cropRect.height();
        }
        this.mState = new State(AnimatedImageDrawable.nCreate(nativeImageDecoder, decoder, width, height, cropRect), inputStream, afd);
        long nativeSize = 200L;
        NativeAllocationRegistry registry = new NativeAllocationRegistry(AnimatedImageDrawable.class.getClassLoader(), AnimatedImageDrawable.nGetNativeFinalizer(), nativeSize);
        registry.registerNativeAllocation((Object)this.mState, this.mState.mNativePtr);
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mIntrinsicWidth;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mIntrinsicHeight;
    }

    @Override
    public void draw(Canvas canvas) {
        long nextUpdate;
        if (this.mState == null) {
            throw new IllegalStateException("called draw on empty AnimatedImageDrawable");
        }
        if (this.mStarting) {
            this.mStarting = false;
            this.postOnAnimationStart();
        }
        if ((nextUpdate = AnimatedImageDrawable.nDraw(this.mState.mNativePtr, canvas.getNativeCanvasWrapper())) > 0L) {
            if (this.mRunnable == null) {
                this.mRunnable = this::invalidateSelf;
            }
            this.scheduleSelf(this.mRunnable, nextUpdate);
        } else if (nextUpdate == -1L) {
            this.postOnAnimationEnd();
        }
    }

    @Override
    public void setAlpha(int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("Alpha must be between 0 and 255! provided " + alpha);
        }
        if (this.mState == null) {
            throw new IllegalStateException("called setAlpha on empty AnimatedImageDrawable");
        }
        AnimatedImageDrawable.nSetAlpha(this.mState.mNativePtr, alpha);
        this.invalidateSelf();
    }

    @Override
    public int getAlpha() {
        if (this.mState == null) {
            throw new IllegalStateException("called getAlpha on empty AnimatedImageDrawable");
        }
        return AnimatedImageDrawable.nGetAlpha(this.mState.mNativePtr);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        if (this.mState == null) {
            throw new IllegalStateException("called setColorFilter on empty AnimatedImageDrawable");
        }
        long nativeFilter = colorFilter == null ? 0L : colorFilter.getNativeInstance();
        AnimatedImageDrawable.nSetColorFilter(this.mState.mNativePtr, nativeFilter);
        this.invalidateSelf();
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        if (!super.setVisible(visible, restart)) {
            return false;
        }
        if (!visible) {
            AnimatedImageDrawable.nMarkInvisible(this.mState.mNativePtr);
        }
        return true;
    }

    @Override
    public boolean isRunning() {
        if (this.mState == null) {
            throw new IllegalStateException("called isRunning on empty AnimatedImageDrawable");
        }
        return AnimatedImageDrawable.nIsRunning(this.mState.mNativePtr);
    }

    @Override
    public void start() {
        if (this.mState == null) {
            throw new IllegalStateException("called start on empty AnimatedImageDrawable");
        }
        if (AnimatedImageDrawable.nStart(this.mState.mNativePtr)) {
            this.mStarting = true;
            this.invalidateSelf();
        }
    }

    @Override
    public void stop() {
        if (this.mState == null) {
            throw new IllegalStateException("called stop on empty AnimatedImageDrawable");
        }
        if (AnimatedImageDrawable.nStop(this.mState.mNativePtr)) {
            this.postOnAnimationEnd();
        }
    }

    @Override
    public void registerAnimationCallback(Animatable2.AnimationCallback callback) {
        if (callback == null) {
            return;
        }
        if (this.mAnimationCallbacks == null) {
            this.mAnimationCallbacks = new ArrayList();
            AnimatedImageDrawable.nSetOnAnimationEndListener(this.mState.mNativePtr, this);
        }
        if (!this.mAnimationCallbacks.contains(callback)) {
            this.mAnimationCallbacks.add(callback);
        }
    }

    @Override
    public boolean unregisterAnimationCallback(Animatable2.AnimationCallback callback) {
        if (callback == null || this.mAnimationCallbacks == null || !this.mAnimationCallbacks.remove(callback)) {
            return false;
        }
        if (this.mAnimationCallbacks.isEmpty()) {
            this.clearAnimationCallbacks();
        }
        return true;
    }

    @Override
    public void clearAnimationCallbacks() {
        if (this.mAnimationCallbacks != null) {
            this.mAnimationCallbacks = null;
            AnimatedImageDrawable.nSetOnAnimationEndListener(this.mState.mNativePtr, null);
        }
    }

    private void postOnAnimationStart() {
        if (this.mAnimationCallbacks == null) {
            return;
        }
        this.getHandler().post(() -> {
            for (Animatable2.AnimationCallback callback : this.mAnimationCallbacks) {
                callback.onAnimationStart(this);
            }
        });
    }

    private void postOnAnimationEnd() {
        if (this.mAnimationCallbacks == null) {
            return;
        }
        this.getHandler().post(() -> {
            for (Animatable2.AnimationCallback callback : this.mAnimationCallbacks) {
                callback.onAnimationEnd(this);
            }
        });
    }

    private Handler getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        return this.mHandler;
    }

    private void onAnimationEnd() {
        if (this.mAnimationCallbacks != null) {
            for (Animatable2.AnimationCallback callback : this.mAnimationCallbacks) {
                callback.onAnimationEnd(this);
            }
        }
    }

    private static native long nCreate(long var0, ImageDecoder var2, int var3, int var4, Rect var5) throws IOException;

    @FastNative
    private static native long nGetNativeFinalizer();

    private static native long nDraw(long var0, long var2);

    @FastNative
    private static native void nSetAlpha(long var0, int var2);

    @FastNative
    private static native int nGetAlpha(long var0);

    @FastNative
    private static native void nSetColorFilter(long var0, long var2);

    @FastNative
    private static native boolean nIsRunning(long var0);

    @FastNative
    private static native boolean nStart(long var0);

    @FastNative
    private static native boolean nStop(long var0);

    @FastNative
    private static native void nSetLoopCount(long var0, int var2);

    private static native void nSetOnAnimationEndListener(long var0, AnimatedImageDrawable var2);

    @FastNative
    private static native long nNativeByteSize(long var0);

    @FastNative
    private static native void nMarkInvisible(long var0);

    private class State {
        public final long mNativePtr;
        private final InputStream mInputStream;
        private final AssetFileDescriptor mAssetFd;

        State(long nativePtr, InputStream is, AssetFileDescriptor afd) {
            this.mNativePtr = nativePtr;
            this.mInputStream = is;
            this.mAssetFd = afd;
        }
    }
}

