/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.broadcastradio.V2_0;

import android.hardware.broadcastradio.V2_0.AnnouncementType;
import android.hardware.broadcastradio.V2_0.ProgramSelector;
import android.hardware.broadcastradio.V2_0.VendorKeyValue;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class Announcement {
    public final ProgramSelector selector = new ProgramSelector();
    public byte type;
    public final ArrayList<VendorKeyValue> vendorInfo = new ArrayList();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != Announcement.class) {
            return false;
        }
        Announcement other = (Announcement)otherObject;
        if (!HidlSupport.deepEquals(this.selector, other.selector)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return HidlSupport.deepEquals(this.vendorInfo, other.vendorInfo);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.selector), HidlSupport.deepHashCode(this.type), HidlSupport.deepHashCode(this.vendorInfo));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".selector = ");
        builder.append(this.selector);
        builder.append(", .type = ");
        builder.append(AnnouncementType.toString(this.type));
        builder.append(", .vendorInfo = ");
        builder.append(this.vendorInfo);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(56L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<Announcement> readVectorFromParcel(HwParcel parcel) {
        ArrayList<Announcement> _hidl_vec = new ArrayList<Announcement>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 56, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            Announcement _hidl_vec_element = new Announcement();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 56);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.selector.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 0L);
        this.type = _hidl_blob.getInt8(_hidl_offset + 32L);
        int _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 40L + 8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 32, _hidl_blob.handle(), _hidl_offset + 40L + 0L, true);
        this.vendorInfo.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            VendorKeyValue _hidl_vec_element = new VendorKeyValue();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 32);
            this.vendorInfo.add(_hidl_vec_element);
        }
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(56);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<Announcement> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 56);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 56);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        this.selector.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 0L);
        _hidl_blob.putInt8(_hidl_offset + 32L, this.type);
        int _hidl_vec_size = this.vendorInfo.size();
        _hidl_blob.putInt32(_hidl_offset + 40L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 40L + 12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 32);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            this.vendorInfo.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 32);
        }
        _hidl_blob.putBlob(_hidl_offset + 40L + 0L, childBlob);
    }
}

