/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.broadcastradio.V2_0;

import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class DabTableEntry {
    public String label = new String();
    public int frequency;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != DabTableEntry.class) {
            return false;
        }
        DabTableEntry other = (DabTableEntry)otherObject;
        if (!HidlSupport.deepEquals(this.label, other.label)) {
            return false;
        }
        return this.frequency == other.frequency;
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.label), HidlSupport.deepHashCode(this.frequency));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".label = ");
        builder.append(this.label);
        builder.append(", .frequency = ");
        builder.append(this.frequency);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(24L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<DabTableEntry> readVectorFromParcel(HwParcel parcel) {
        ArrayList<DabTableEntry> _hidl_vec = new ArrayList<DabTableEntry>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 24, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            DabTableEntry _hidl_vec_element = new DabTableEntry();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 24);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.label = _hidl_blob.getString(_hidl_offset + 0L);
        parcel.readEmbeddedBuffer(this.label.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 0L + 0L, false);
        this.frequency = _hidl_blob.getInt32(_hidl_offset + 16L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(24);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<DabTableEntry> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 24);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 24);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putString(_hidl_offset + 0L, this.label);
        _hidl_blob.putInt32(_hidl_offset + 16L, this.frequency);
    }
}

