/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.legacy.CameraDeviceState;
import android.hardware.camera2.legacy.CaptureCollector;
import android.hardware.camera2.legacy.GLThreadManager;
import android.hardware.camera2.legacy.LegacyCameraDevice;
import android.hardware.camera2.legacy.LegacyExceptionUtils;
import android.hardware.camera2.legacy.LegacyFaceDetectMapper;
import android.hardware.camera2.legacy.LegacyFocusStateMapper;
import android.hardware.camera2.legacy.LegacyMetadataMapper;
import android.hardware.camera2.legacy.LegacyRequest;
import android.hardware.camera2.legacy.LegacyResultMapper;
import android.hardware.camera2.legacy.ParameterUtils;
import android.hardware.camera2.legacy.RequestHandlerThread;
import android.hardware.camera2.legacy.RequestHolder;
import android.hardware.camera2.legacy.RequestQueue;
import android.hardware.camera2.utils.SizeAreaComparator;
import android.hardware.camera2.utils.SubmitInfo;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.util.MutableLong;
import android.util.Pair;
import android.util.Size;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class RequestThreadManager {
    private final String TAG;
    private final int mCameraId;
    private final RequestHandlerThread mRequestThread;
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE = false;
    private Camera mCamera;
    private final CameraCharacteristics mCharacteristics;
    private final CameraDeviceState mDeviceState;
    private final CaptureCollector mCaptureCollector;
    private final LegacyFocusStateMapper mFocusStateMapper;
    private final LegacyFaceDetectMapper mFaceDetectMapper;
    private static final int MSG_CONFIGURE_OUTPUTS = 1;
    private static final int MSG_SUBMIT_CAPTURE_REQUEST = 2;
    private static final int MSG_CLEANUP = 3;
    private static final int MAX_IN_FLIGHT_REQUESTS = 2;
    private static final int PREVIEW_FRAME_TIMEOUT = 1000;
    private static final int JPEG_FRAME_TIMEOUT = 4000;
    private static final int REQUEST_COMPLETE_TIMEOUT = 4000;
    private static final float ASPECT_RATIO_TOLERANCE = 0.01f;
    private boolean mPreviewRunning = false;
    private final List<Surface> mPreviewOutputs = new ArrayList<Surface>();
    private final List<Surface> mCallbackOutputs = new ArrayList<Surface>();
    private GLThreadManager mGLThreadManager;
    private SurfaceTexture mPreviewTexture;
    private Camera.Parameters mParams;
    private final List<Long> mJpegSurfaceIds = new ArrayList<Long>();
    private Size mIntermediateBufferSize;
    private final RequestQueue mRequestQueue = new RequestQueue(this.mJpegSurfaceIds);
    private LegacyRequest mLastRequest = null;
    private SurfaceTexture mDummyTexture;
    private Surface mDummySurface;
    private final Object mIdleLock = new Object();
    private final FpsCounter mPrevCounter = new FpsCounter("Incoming Preview");
    private final FpsCounter mRequestCounter = new FpsCounter("Incoming Requests");
    private final AtomicBoolean mQuit = new AtomicBoolean(false);
    private static final boolean USE_BLOB_FORMAT_OVERRIDE = true;
    private final Camera.ErrorCallback mErrorCallback = new Camera.ErrorCallback(){

        @Override
        public void onError(int i, Camera camera) {
            switch (i) {
                case 2: {
                    RequestThreadManager.this.flush();
                    RequestThreadManager.this.mDeviceState.setError(0);
                    break;
                }
                default: {
                    Log.e(RequestThreadManager.this.TAG, "Received error " + i + " from the Camera1 ErrorCallback");
                    RequestThreadManager.this.mDeviceState.setError(1);
                }
            }
        }
    };
    private final ConditionVariable mReceivedJpeg = new ConditionVariable(false);
    private final Camera.PictureCallback mJpegCallback = new Camera.PictureCallback(){

        @Override
        public void onPictureTaken(byte[] data, Camera camera) {
            Log.i(RequestThreadManager.this.TAG, "Received jpeg.");
            Pair<RequestHolder, Long> captureInfo = RequestThreadManager.this.mCaptureCollector.jpegProduced();
            if (captureInfo == null || captureInfo.first == null) {
                Log.e(RequestThreadManager.this.TAG, "Dropping jpeg frame.");
                return;
            }
            RequestHolder holder = (RequestHolder)captureInfo.first;
            long timestamp = (Long)captureInfo.second;
            for (Surface s : holder.getHolderTargets()) {
                try {
                    if (!LegacyCameraDevice.containsSurfaceId(s, RequestThreadManager.this.mJpegSurfaceIds)) continue;
                    Log.i(RequestThreadManager.this.TAG, "Producing jpeg buffer...");
                    int totalSize = data.length + LegacyCameraDevice.nativeGetJpegFooterSize();
                    totalSize = totalSize + 3 & 0xFFFFFFFC;
                    LegacyCameraDevice.setNextTimestamp(s, timestamp);
                    LegacyCameraDevice.setSurfaceFormat(s, 1);
                    int dimen2 = (int)Math.ceil(Math.sqrt(totalSize));
                    dimen2 = dimen2 + 15 & 0xFFFFFFF0;
                    LegacyCameraDevice.setSurfaceDimens(s, dimen2, dimen2);
                    LegacyCameraDevice.produceFrame(s, data, dimen2, dimen2, 33);
                }
                catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                    Log.w(RequestThreadManager.this.TAG, "Surface abandoned, dropping frame. ", e);
                }
            }
            RequestThreadManager.this.mReceivedJpeg.open();
        }
    };
    private final Camera.ShutterCallback mJpegShutterCallback = new Camera.ShutterCallback(){

        @Override
        public void onShutter() {
            RequestThreadManager.this.mCaptureCollector.jpegCaptured(SystemClock.elapsedRealtimeNanos());
        }
    };
    private final SurfaceTexture.OnFrameAvailableListener mPreviewCallback = new SurfaceTexture.OnFrameAvailableListener(){

        @Override
        public void onFrameAvailable(SurfaceTexture surfaceTexture) {
            RequestThreadManager.this.mGLThreadManager.queueNewFrame();
        }
    };
    private final Handler.Callback mRequestHandlerCb = new Handler.Callback(){
        private boolean mCleanup = false;
        private final LegacyResultMapper mMapper = new LegacyResultMapper();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public boolean handleMessage(Message msg) {
            if (this.mCleanup) {
                return true;
            }
            startTime = 0L;
            switch (msg.what) {
                case 1: {
                    config = (ConfigureHolder)msg.obj;
                    sizes = config.surfaces != null ? config.surfaces.size() : 0;
                    Log.i(RequestThreadManager.access$100(RequestThreadManager.this), "Configure outputs: " + sizes + " surfaces configured.");
                    try {
                        success = RequestThreadManager.access$200(RequestThreadManager.this).waitForEmpty(4000L, TimeUnit.MILLISECONDS);
                        if (!success) {
                            Log.e(RequestThreadManager.access$100(RequestThreadManager.this), "Timed out while queueing configure request.");
                            RequestThreadManager.access$200(RequestThreadManager.this).failAll();
                        }
                    }
                    catch (InterruptedException e) {
                        Log.e(RequestThreadManager.access$100(RequestThreadManager.this), "Interrupted while waiting for requests to complete.");
                        RequestThreadManager.access$000(RequestThreadManager.this).setError(1);
                        break;
                    }
                    RequestThreadManager.access$600(RequestThreadManager.this, config.surfaces);
                    config.condition.open();
                    break;
                }
                case 2: {
                    handler = RequestThreadManager.access$700(RequestThreadManager.this).getHandler();
                    anyRequestOutputAbandoned = false;
                    nextBurst = RequestThreadManager.access$800(RequestThreadManager.this).getNext();
                    if (nextBurst != null) ** GOTO lbl55
                    try {
                        success = RequestThreadManager.access$200(RequestThreadManager.this).waitForEmpty(4000L, TimeUnit.MILLISECONDS);
                        if (!success) {
                            Log.e(RequestThreadManager.access$100(RequestThreadManager.this), "Timed out while waiting for prior requests to complete.");
                            RequestThreadManager.access$200(RequestThreadManager.this).failAll();
                        }
                    }
                    catch (InterruptedException e) {
                        Log.e(RequestThreadManager.access$100(RequestThreadManager.this), "Interrupted while waiting for requests to complete: ", e);
                        RequestThreadManager.access$000(RequestThreadManager.this).setError(1);
                        break;
                    }
                    e = RequestThreadManager.access$900(RequestThreadManager.this);
                    synchronized (e) {
                        nextBurst = RequestThreadManager.access$800(RequestThreadManager.this).getNext();
                        if (nextBurst == null) {
                            RequestThreadManager.access$000(RequestThreadManager.this).setIdle();
                            break;
                        }
                    }
lbl55:
                    // 2 sources

                    if (nextBurst != null) {
                        handler.sendEmptyMessage(2);
                        if (nextBurst.isQueueEmpty()) {
                            RequestThreadManager.access$000(RequestThreadManager.this).setRequestQueueEmpty();
                        }
                    }
                    burstHolder = nextBurst.getBurstHolder();
                    requests = burstHolder.produceRequestHolders(nextBurst.getFrameNumber());
                    for (RequestHolder holder : requests) {
                        request = holder.getRequest();
                        paramsChanged = false;
                        if (RequestThreadManager.access$1000(RequestThreadManager.this) == null || RequestThreadManager.access$1000((RequestThreadManager)RequestThreadManager.this).captureRequest != request) {
                            previewSize = ParameterUtils.convertSize(RequestThreadManager.access$1100(RequestThreadManager.this).getPreviewSize());
                            legacyRequest = new LegacyRequest(RequestThreadManager.access$1200(RequestThreadManager.this), request, previewSize, RequestThreadManager.access$1100(RequestThreadManager.this));
                            LegacyMetadataMapper.convertRequestMetadata(legacyRequest);
                            if (!RequestThreadManager.access$1100(RequestThreadManager.this).same(legacyRequest.parameters)) {
                                try {
                                    RequestThreadManager.access$1300(RequestThreadManager.this).setParameters(legacyRequest.parameters);
                                }
                                catch (RuntimeException e) {
                                    Log.e(RequestThreadManager.access$100(RequestThreadManager.this), "Exception while setting camera parameters: ", e);
                                    holder.failRequest();
                                    RequestThreadManager.access$000(RequestThreadManager.this).setCaptureStart(holder, 0L, 3);
                                    continue;
                                }
                                paramsChanged = true;
                                RequestThreadManager.access$1102(RequestThreadManager.this, legacyRequest.parameters);
                            }
                            RequestThreadManager.access$1002(RequestThreadManager.this, legacyRequest);
                        }
                        try {
                            success = RequestThreadManager.access$200(RequestThreadManager.this).queueRequest(holder, RequestThreadManager.access$1000(RequestThreadManager.this), 4000L, TimeUnit.MILLISECONDS);
                            if (!success) {
                                Log.e(RequestThreadManager.access$100(RequestThreadManager.this), "Timed out while queueing capture request.");
                                holder.failRequest();
                                RequestThreadManager.access$000(RequestThreadManager.this).setCaptureStart(holder, 0L, 3);
                                continue;
                            }
                            if (holder.hasPreviewTargets()) {
                                RequestThreadManager.access$1400(RequestThreadManager.this, holder);
                            }
                            if (holder.hasJpegTargets()) {
                                while (!RequestThreadManager.access$200(RequestThreadManager.this).waitForPreviewsEmpty(1000L, TimeUnit.MILLISECONDS)) {
                                    Log.e(RequestThreadManager.access$100(RequestThreadManager.this), "Timed out while waiting for preview requests to complete.");
                                    RequestThreadManager.access$200(RequestThreadManager.this).failNextPreview();
                                }
                                RequestThreadManager.access$400(RequestThreadManager.this).close();
                                RequestThreadManager.access$1500(RequestThreadManager.this, holder);
                            }
                            RequestThreadManager.access$1600(RequestThreadManager.this).processFaceDetectMode(request, RequestThreadManager.access$1100(RequestThreadManager.this));
                            RequestThreadManager.access$1700(RequestThreadManager.this).processRequestTriggers(request, RequestThreadManager.access$1100(RequestThreadManager.this));
                            if (!holder.hasJpegTargets()) ** GOTO lbl129
                            RequestThreadManager.access$1800(RequestThreadManager.this, holder);
                            if (!RequestThreadManager.access$400(RequestThreadManager.this).block(4000L)) {
                                Log.e(RequestThreadManager.access$100(RequestThreadManager.this), "Hit timeout for jpeg callback!");
                                RequestThreadManager.access$200(RequestThreadManager.this).failNextJpeg();
                            }
                        }
                        catch (IOException e) {
                            Log.e(RequestThreadManager.access$100(RequestThreadManager.this), "Received device exception during capture call: ", e);
                            RequestThreadManager.access$000(RequestThreadManager.this).setError(1);
                            break;
                        }
                        catch (InterruptedException e) {
                            Log.e(RequestThreadManager.access$100(RequestThreadManager.this), "Interrupted during capture: ", e);
                            RequestThreadManager.access$000(RequestThreadManager.this).setError(1);
                            break;
                        }
                        catch (RuntimeException e) {
                            Log.e(RequestThreadManager.access$100(RequestThreadManager.this), "Received device exception during capture call: ", e);
                            RequestThreadManager.access$000(RequestThreadManager.this).setError(1);
                            break;
                        }
lbl129:
                        // 3 sources

                        if (paramsChanged) {
                            try {
                                RequestThreadManager.access$1102(RequestThreadManager.this, RequestThreadManager.access$1300(RequestThreadManager.this).getParameters());
                            }
                            catch (RuntimeException e) {
                                Log.e(RequestThreadManager.access$100(RequestThreadManager.this), "Received device exception: ", e);
                                RequestThreadManager.access$000(RequestThreadManager.this).setError(1);
                                break;
                            }
                            RequestThreadManager.access$1000(RequestThreadManager.this).setParameters(RequestThreadManager.access$1100(RequestThreadManager.this));
                        }
                        timestampMutable = new MutableLong(0L);
                        try {
                            success = RequestThreadManager.access$200(RequestThreadManager.this).waitForRequestCompleted(holder, 4000L, TimeUnit.MILLISECONDS, timestampMutable);
                            if (!success) {
                                Log.e(RequestThreadManager.access$100(RequestThreadManager.this), "Timed out while waiting for request to complete.");
                                RequestThreadManager.access$200(RequestThreadManager.this).failAll();
                            }
                        }
                        catch (InterruptedException e) {
                            Log.e(RequestThreadManager.access$100(RequestThreadManager.this), "Interrupted waiting for request completion: ", e);
                            RequestThreadManager.access$000(RequestThreadManager.this).setError(1);
                            break;
                        }
                        result = this.mMapper.cachedConvertResultMetadata(RequestThreadManager.access$1000(RequestThreadManager.this), timestampMutable.value);
                        RequestThreadManager.access$1700(RequestThreadManager.this).mapResultTriggers(result);
                        RequestThreadManager.access$1600(RequestThreadManager.this).mapResultFaces(result, RequestThreadManager.access$1000(RequestThreadManager.this));
                        if (!holder.requestFailed()) {
                            RequestThreadManager.access$000(RequestThreadManager.this).setCaptureResult(holder, result);
                        }
                        if (!holder.isOutputAbandoned()) continue;
                        anyRequestOutputAbandoned = true;
                    }
                    if (!anyRequestOutputAbandoned || !burstHolder.isRepeating()) break;
                    lastFrameNumber = RequestThreadManager.this.cancelRepeating(burstHolder.getRequestId());
                    RequestThreadManager.access$000(RequestThreadManager.this).setRepeatingRequestError(lastFrameNumber, burstHolder.getRequestId());
                    break;
                }
                case 3: {
                    this.mCleanup = true;
                    try {
                        success = RequestThreadManager.access$200(RequestThreadManager.this).waitForEmpty(4000L, TimeUnit.MILLISECONDS);
                        if (!success) {
                            Log.e(RequestThreadManager.access$100(RequestThreadManager.this), "Timed out while queueing cleanup request.");
                            RequestThreadManager.access$200(RequestThreadManager.this).failAll();
                        }
                    }
                    catch (InterruptedException e) {
                        Log.e(RequestThreadManager.access$100(RequestThreadManager.this), "Interrupted while waiting for requests to complete: ", e);
                        RequestThreadManager.access$000(RequestThreadManager.this).setError(1);
                    }
                    if (RequestThreadManager.access$500(RequestThreadManager.this) != null) {
                        RequestThreadManager.access$500(RequestThreadManager.this).quit();
                        RequestThreadManager.access$502(RequestThreadManager.this, null);
                    }
                    if (RequestThreadManager.access$1300(RequestThreadManager.this) != null) {
                        RequestThreadManager.access$1300(RequestThreadManager.this).release();
                        RequestThreadManager.access$1302(RequestThreadManager.this, null);
                    }
                    RequestThreadManager.access$2000(RequestThreadManager.this, RequestThreadManager.access$1900(RequestThreadManager.this));
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unhandled message " + msg.what + " on RequestThread."));
                }
            }
            return true;
        }
    };

    private void createDummySurface() {
        if (this.mDummyTexture == null || this.mDummySurface == null) {
            this.mDummyTexture = new SurfaceTexture(0);
            this.mDummyTexture.setDefaultBufferSize(640, 480);
            this.mDummySurface = new Surface(this.mDummyTexture);
        }
    }

    private void stopPreview() {
        if (this.mPreviewRunning) {
            this.mCamera.stopPreview();
            this.mPreviewRunning = false;
        }
    }

    private void startPreview() {
        if (!this.mPreviewRunning) {
            this.mCamera.startPreview();
            this.mPreviewRunning = true;
        }
    }

    private void doJpegCapturePrepare(RequestHolder request) throws IOException {
        if (!this.mPreviewRunning) {
            this.createDummySurface();
            this.mCamera.setPreviewTexture(this.mDummyTexture);
            this.startPreview();
        }
    }

    private void doJpegCapture(RequestHolder request) {
        this.mCamera.takePicture(this.mJpegShutterCallback, null, this.mJpegCallback);
        this.mPreviewRunning = false;
    }

    private void doPreviewCapture(RequestHolder request) throws IOException {
        if (this.mPreviewRunning) {
            return;
        }
        if (this.mPreviewTexture == null) {
            throw new IllegalStateException("Preview capture called with no preview surfaces configured.");
        }
        this.mPreviewTexture.setDefaultBufferSize(this.mIntermediateBufferSize.getWidth(), this.mIntermediateBufferSize.getHeight());
        this.mCamera.setPreviewTexture(this.mPreviewTexture);
        this.startPreview();
    }

    private void configureOutputs(Collection<Pair<Surface, Size>> outputs) {
        try {
            this.stopPreview();
        }
        catch (RuntimeException e) {
            Log.e(this.TAG, "Received device exception in configure call: ", e);
            this.mDeviceState.setError(1);
            return;
        }
        try {
            this.mCamera.setPreviewTexture(null);
        }
        catch (IOException e) {
            Log.w(this.TAG, "Failed to clear prior SurfaceTexture, may cause GL deadlock: ", e);
        }
        catch (RuntimeException e) {
            Log.e(this.TAG, "Received device exception in configure call: ", e);
            this.mDeviceState.setError(1);
            return;
        }
        if (this.mGLThreadManager != null) {
            this.mGLThreadManager.waitUntilStarted();
            this.mGLThreadManager.ignoreNewFrames();
            this.mGLThreadManager.waitUntilIdle();
        }
        this.resetJpegSurfaceFormats(this.mCallbackOutputs);
        for (Surface s : this.mCallbackOutputs) {
            try {
                LegacyCameraDevice.disconnectSurface(s);
            }
            catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                Log.w(this.TAG, "Surface abandoned, skipping...", e);
            }
        }
        this.mPreviewOutputs.clear();
        this.mCallbackOutputs.clear();
        this.mJpegSurfaceIds.clear();
        this.mPreviewTexture = null;
        ArrayList<Size> previewOutputSizes = new ArrayList<Size>();
        ArrayList<Size> callbackOutputSizes = new ArrayList<Size>();
        int facing = this.mCharacteristics.get(CameraCharacteristics.LENS_FACING);
        int orientation = this.mCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        if (outputs != null) {
            for (Pair<Surface, Size> outPair : outputs) {
                Surface s = (Surface)outPair.first;
                Size outSize = (Size)outPair.second;
                try {
                    int format = LegacyCameraDevice.detectSurfaceType(s);
                    LegacyCameraDevice.setSurfaceOrientation(s, facing, orientation);
                    switch (format) {
                        case 33: {
                            LegacyCameraDevice.setSurfaceFormat(s, 1);
                            this.mJpegSurfaceIds.add(LegacyCameraDevice.getSurfaceId(s));
                            this.mCallbackOutputs.add(s);
                            callbackOutputSizes.add(outSize);
                            LegacyCameraDevice.connectSurface(s);
                            break;
                        }
                        default: {
                            LegacyCameraDevice.setScalingMode(s, 1);
                            this.mPreviewOutputs.add(s);
                            previewOutputSizes.add(outSize);
                            break;
                        }
                    }
                }
                catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                    Log.w(this.TAG, "Surface abandoned, skipping...", e);
                }
            }
        }
        try {
            this.mParams = this.mCamera.getParameters();
        }
        catch (RuntimeException e) {
            Log.e(this.TAG, "Received device exception: ", e);
            this.mDeviceState.setError(1);
            return;
        }
        List<int[]> supportedFpsRanges = this.mParams.getSupportedPreviewFpsRange();
        int[] bestRange = this.getPhotoPreviewFpsRange(supportedFpsRanges);
        this.mParams.setPreviewFpsRange(bestRange[0], bestRange[1]);
        Size smallestSupportedJpegSize = this.calculatePictureSize(this.mCallbackOutputs, callbackOutputSizes, this.mParams);
        if (previewOutputSizes.size() > 0) {
            Size largestOutput = SizeAreaComparator.findLargestByArea(previewOutputSizes);
            Size largestJpegDimen = ParameterUtils.getLargestSupportedJpegSizeByArea(this.mParams);
            Iterator<Surface> chosenJpegDimen = smallestSupportedJpegSize != null ? smallestSupportedJpegSize : largestJpegDimen;
            List<Size> supportedPreviewSizes = ParameterUtils.convertSizeList(this.mParams.getSupportedPreviewSizes());
            long largestOutputArea = (long)largestOutput.getHeight() * (long)largestOutput.getWidth();
            Size bestPreviewDimen = SizeAreaComparator.findLargestByArea(supportedPreviewSizes);
            for (Size s : supportedPreviewSizes) {
                long currArea = s.getWidth() * s.getHeight();
                long bestArea = bestPreviewDimen.getWidth() * bestPreviewDimen.getHeight();
                if (!RequestThreadManager.checkAspectRatiosMatch(chosenJpegDimen, s) || currArea >= bestArea || currArea < largestOutputArea) continue;
                bestPreviewDimen = s;
            }
            this.mIntermediateBufferSize = bestPreviewDimen;
            this.mParams.setPreviewSize(this.mIntermediateBufferSize.getWidth(), this.mIntermediateBufferSize.getHeight());
        } else {
            this.mIntermediateBufferSize = null;
        }
        if (smallestSupportedJpegSize != null) {
            Log.i(this.TAG, "configureOutputs - set take picture size to " + smallestSupportedJpegSize);
            this.mParams.setPictureSize(smallestSupportedJpegSize.getWidth(), smallestSupportedJpegSize.getHeight());
        }
        if (this.mGLThreadManager == null) {
            this.mGLThreadManager = new GLThreadManager(this.mCameraId, facing, this.mDeviceState);
            this.mGLThreadManager.start();
        }
        this.mGLThreadManager.waitUntilStarted();
        ArrayList<Pair<Surface, Size>> previews = new ArrayList<Pair<Surface, Size>>();
        Iterator previewSizeIter = previewOutputSizes.iterator();
        for (Surface p : this.mPreviewOutputs) {
            previews.add(new Pair<Surface, Size>(p, (Size)previewSizeIter.next()));
        }
        this.mGLThreadManager.setConfigurationAndWait(previews, this.mCaptureCollector);
        for (Surface p : this.mPreviewOutputs) {
            try {
                LegacyCameraDevice.setSurfaceOrientation(p, facing, orientation);
            }
            catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                Log.e(this.TAG, "Surface abandoned, skipping setSurfaceOrientation()", e);
            }
        }
        this.mGLThreadManager.allowNewFrames();
        this.mPreviewTexture = this.mGLThreadManager.getCurrentSurfaceTexture();
        if (this.mPreviewTexture != null) {
            this.mPreviewTexture.setOnFrameAvailableListener(this.mPreviewCallback);
        }
        try {
            this.mCamera.setParameters(this.mParams);
        }
        catch (RuntimeException e) {
            Log.e(this.TAG, "Received device exception while configuring: ", e);
            this.mDeviceState.setError(1);
        }
    }

    private void resetJpegSurfaceFormats(Collection<Surface> surfaces) {
        if (surfaces == null) {
            return;
        }
        for (Surface s : surfaces) {
            if (s == null || !s.isValid()) {
                Log.w(this.TAG, "Jpeg surface is invalid, skipping...");
                continue;
            }
            try {
                LegacyCameraDevice.setSurfaceFormat(s, 33);
            }
            catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                Log.w(this.TAG, "Surface abandoned, skipping...", e);
            }
        }
    }

    private Size calculatePictureSize(List<Surface> callbackOutputs, List<Size> callbackSizes, Camera.Parameters params) {
        if (callbackOutputs.size() != callbackSizes.size()) {
            throw new IllegalStateException("Input collections must be same length");
        }
        ArrayList<Object> configuredJpegSizes = new ArrayList<Object>();
        Iterator<Size> sizeIterator = callbackSizes.iterator();
        for (Surface callbackSurface : callbackOutputs) {
            Size jpegSize = sizeIterator.next();
            if (!LegacyCameraDevice.containsSurfaceId(callbackSurface, this.mJpegSurfaceIds)) continue;
            configuredJpegSizes.add(jpegSize);
        }
        if (!configuredJpegSizes.isEmpty()) {
            int maxConfiguredJpegWidth = -1;
            int maxConfiguredJpegHeight = -1;
            for (Size size : configuredJpegSizes) {
                maxConfiguredJpegWidth = size.getWidth() > maxConfiguredJpegWidth ? size.getWidth() : maxConfiguredJpegWidth;
                maxConfiguredJpegHeight = size.getHeight() > maxConfiguredJpegHeight ? size.getHeight() : maxConfiguredJpegHeight;
            }
            Size smallestBoundJpegSize = new Size(maxConfiguredJpegWidth, maxConfiguredJpegHeight);
            List<Size> list = ParameterUtils.convertSizeList(params.getSupportedPictureSizes());
            ArrayList<Size> candidateSupportedJpegSizes = new ArrayList<Size>();
            for (Size supportedJpegSize : list) {
                if (supportedJpegSize.getWidth() < maxConfiguredJpegWidth || supportedJpegSize.getHeight() < maxConfiguredJpegHeight) continue;
                candidateSupportedJpegSizes.add(supportedJpegSize);
            }
            if (candidateSupportedJpegSizes.isEmpty()) {
                throw new AssertionError((Object)("Could not find any supported JPEG sizes large enough to fit " + smallestBoundJpegSize));
            }
            Size smallestSupportedJpegSize = Collections.min(candidateSupportedJpegSizes, new SizeAreaComparator());
            if (!smallestSupportedJpegSize.equals(smallestBoundJpegSize)) {
                Log.w(this.TAG, String.format("configureOutputs - Will need to crop picture %s into smallest bound size %s", smallestSupportedJpegSize, smallestBoundJpegSize));
            }
            return smallestSupportedJpegSize;
        }
        return null;
    }

    private static boolean checkAspectRatiosMatch(Size a, Size b) {
        float bAspect;
        float aAspect = (float)a.getWidth() / (float)a.getHeight();
        return Math.abs(aAspect - (bAspect = (float)b.getWidth() / (float)b.getHeight())) < 0.01f;
    }

    private int[] getPhotoPreviewFpsRange(List<int[]> frameRates) {
        if (frameRates.size() == 0) {
            Log.e(this.TAG, "No supported frame rates returned!");
            return null;
        }
        int bestMin = 0;
        int bestMax = 0;
        int bestIndex = 0;
        int index = 0;
        for (int[] rate : frameRates) {
            int minFps = rate[0];
            int maxFps = rate[1];
            if (maxFps > bestMax || maxFps == bestMax && minFps > bestMin) {
                bestMin = minFps;
                bestMax = maxFps;
                bestIndex = index;
            }
            ++index;
        }
        return frameRates.get(bestIndex);
    }

    public RequestThreadManager(int cameraId, Camera camera, CameraCharacteristics characteristics, CameraDeviceState deviceState) {
        String name;
        this.mCamera = Preconditions.checkNotNull(camera, "camera must not be null");
        this.mCameraId = cameraId;
        this.mCharacteristics = Preconditions.checkNotNull(characteristics, "characteristics must not be null");
        this.TAG = name = String.format("RequestThread-%d", cameraId);
        this.mDeviceState = Preconditions.checkNotNull(deviceState, "deviceState must not be null");
        this.mFocusStateMapper = new LegacyFocusStateMapper(this.mCamera);
        this.mFaceDetectMapper = new LegacyFaceDetectMapper(this.mCamera, this.mCharacteristics);
        this.mCaptureCollector = new CaptureCollector(2, this.mDeviceState);
        this.mRequestThread = new RequestHandlerThread(name, this.mRequestHandlerCb);
        this.mCamera.setErrorCallback(this.mErrorCallback);
    }

    public void start() {
        this.mRequestThread.start();
    }

    public long flush() {
        Log.i(this.TAG, "Flushing all pending requests.");
        long lastFrame = this.mRequestQueue.stopRepeating();
        this.mCaptureCollector.failAll();
        return lastFrame;
    }

    public void quit() {
        if (!this.mQuit.getAndSet(true)) {
            Handler handler = this.mRequestThread.waitAndGetHandler();
            handler.sendMessageAtFrontOfQueue(handler.obtainMessage(3));
            this.mRequestThread.quitSafely();
            try {
                this.mRequestThread.join();
            }
            catch (InterruptedException e) {
                Log.e(this.TAG, String.format("Thread %s (%d) interrupted while quitting.", this.mRequestThread.getName(), this.mRequestThread.getId()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubmitInfo submitCaptureRequests(CaptureRequest[] requests, boolean repeating) {
        SubmitInfo info;
        Handler handler = this.mRequestThread.waitAndGetHandler();
        Object object = this.mIdleLock;
        synchronized (object) {
            info = this.mRequestQueue.submit(requests, repeating);
            handler.sendEmptyMessage(2);
        }
        return info;
    }

    public long cancelRepeating(int requestId) {
        return this.mRequestQueue.stopRepeating(requestId);
    }

    public void configure(Collection<Pair<Surface, Size>> outputs) {
        Handler handler = this.mRequestThread.waitAndGetHandler();
        ConditionVariable condition = new ConditionVariable(false);
        ConfigureHolder holder = new ConfigureHolder(condition, outputs);
        handler.sendMessage(handler.obtainMessage(1, 0, 0, holder));
        condition.block();
    }

    static /* synthetic */ void access$600(RequestThreadManager x0, Collection x1) {
        x0.configureOutputs(x1);
    }

    static /* synthetic */ RequestHandlerThread access$700(RequestThreadManager x0) {
        return x0.mRequestThread;
    }

    static /* synthetic */ RequestQueue access$800(RequestThreadManager x0) {
        return x0.mRequestQueue;
    }

    static /* synthetic */ Object access$900(RequestThreadManager x0) {
        return x0.mIdleLock;
    }

    static /* synthetic */ LegacyRequest access$1000(RequestThreadManager x0) {
        return x0.mLastRequest;
    }

    static /* synthetic */ Camera.Parameters access$1100(RequestThreadManager x0) {
        return x0.mParams;
    }

    static /* synthetic */ CameraCharacteristics access$1200(RequestThreadManager x0) {
        return x0.mCharacteristics;
    }

    static /* synthetic */ Camera access$1300(RequestThreadManager x0) {
        return x0.mCamera;
    }

    static /* synthetic */ Camera.Parameters access$1102(RequestThreadManager x0, Camera.Parameters x1) {
        x0.mParams = x1;
        return x0.mParams;
    }

    static /* synthetic */ LegacyRequest access$1002(RequestThreadManager x0, LegacyRequest x1) {
        x0.mLastRequest = x1;
        return x0.mLastRequest;
    }

    static /* synthetic */ void access$1400(RequestThreadManager x0, RequestHolder x1) throws IOException {
        x0.doPreviewCapture(x1);
    }

    static /* synthetic */ void access$1500(RequestThreadManager x0, RequestHolder x1) throws IOException {
        x0.doJpegCapturePrepare(x1);
    }

    static /* synthetic */ LegacyFaceDetectMapper access$1600(RequestThreadManager x0) {
        return x0.mFaceDetectMapper;
    }

    static /* synthetic */ LegacyFocusStateMapper access$1700(RequestThreadManager x0) {
        return x0.mFocusStateMapper;
    }

    static /* synthetic */ void access$1800(RequestThreadManager x0, RequestHolder x1) {
        x0.doJpegCapture(x1);
    }

    static /* synthetic */ GLThreadManager access$502(RequestThreadManager x0, GLThreadManager x1) {
        x0.mGLThreadManager = x1;
        return x0.mGLThreadManager;
    }

    static /* synthetic */ Camera access$1302(RequestThreadManager x0, Camera x1) {
        x0.mCamera = x1;
        return x0.mCamera;
    }

    static /* synthetic */ List access$1900(RequestThreadManager x0) {
        return x0.mCallbackOutputs;
    }

    static /* synthetic */ void access$2000(RequestThreadManager x0, Collection x1) {
        x0.resetJpegSurfaceFormats(x1);
    }

    public static class FpsCounter {
        private static final String TAG = "FpsCounter";
        private int mFrameCount = 0;
        private long mLastTime = 0L;
        private long mLastPrintTime = 0L;
        private double mLastFps = 0.0;
        private final String mStreamType;
        private static final long NANO_PER_SECOND = 1000000000L;

        public FpsCounter(String streamType) {
            this.mStreamType = streamType;
        }

        public synchronized void countFrame() {
            ++this.mFrameCount;
            long nextTime = SystemClock.elapsedRealtimeNanos();
            if (this.mLastTime == 0L) {
                this.mLastTime = nextTime;
            }
            if (nextTime > this.mLastTime + 1000000000L) {
                long elapsed = nextTime - this.mLastTime;
                this.mLastFps = (double)this.mFrameCount * (1.0E9 / (double)elapsed);
                this.mFrameCount = 0;
                this.mLastTime = nextTime;
            }
        }

        public synchronized double checkFps() {
            return this.mLastFps;
        }

        public synchronized void staggeredLog() {
            if (this.mLastTime > this.mLastPrintTime + 5000000000L) {
                this.mLastPrintTime = this.mLastTime;
                Log.d(TAG, "FPS for " + this.mStreamType + " stream: " + this.mLastFps);
            }
        }

        public synchronized void countAndLog() {
            this.countFrame();
            this.staggeredLog();
        }
    }

    private static class ConfigureHolder {
        public final ConditionVariable condition;
        public final Collection<Pair<Surface, Size>> surfaces;

        public ConfigureHolder(ConditionVariable condition, Collection<Pair<Surface, Size>> surfaces) {
            this.condition = condition;
            this.surfaces = surfaces;
        }
    }
}

