/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.contexthub.V1_0;

import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class ContextHubMsg {
    public long appName;
    public short hostEndPoint;
    public int msgType;
    public final ArrayList<Byte> msg = new ArrayList();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != ContextHubMsg.class) {
            return false;
        }
        ContextHubMsg other = (ContextHubMsg)otherObject;
        if (this.appName != other.appName) {
            return false;
        }
        if (this.hostEndPoint != other.hostEndPoint) {
            return false;
        }
        if (this.msgType != other.msgType) {
            return false;
        }
        return HidlSupport.deepEquals(this.msg, other.msg);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.appName), HidlSupport.deepHashCode(this.hostEndPoint), HidlSupport.deepHashCode(this.msgType), HidlSupport.deepHashCode(this.msg));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".appName = ");
        builder.append(this.appName);
        builder.append(", .hostEndPoint = ");
        builder.append(this.hostEndPoint);
        builder.append(", .msgType = ");
        builder.append(this.msgType);
        builder.append(", .msg = ");
        builder.append(this.msg);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(32L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<ContextHubMsg> readVectorFromParcel(HwParcel parcel) {
        ArrayList<ContextHubMsg> _hidl_vec = new ArrayList<ContextHubMsg>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 32, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            ContextHubMsg _hidl_vec_element = new ContextHubMsg();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 32);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.appName = _hidl_blob.getInt64(_hidl_offset + 0L);
        this.hostEndPoint = _hidl_blob.getInt16(_hidl_offset + 8L);
        this.msgType = _hidl_blob.getInt32(_hidl_offset + 12L);
        int _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 16L + 8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 1, _hidl_blob.handle(), _hidl_offset + 16L + 0L, true);
        this.msg.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            byte _hidl_vec_element = childBlob.getInt8(_hidl_index_0 * 1);
            this.msg.add(_hidl_vec_element);
        }
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(32);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<ContextHubMsg> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 32);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 32);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt64(_hidl_offset + 0L, this.appName);
        _hidl_blob.putInt16(_hidl_offset + 8L, this.hostEndPoint);
        _hidl_blob.putInt32(_hidl_offset + 12L, this.msgType);
        int _hidl_vec_size = this.msg.size();
        _hidl_blob.putInt32(_hidl_offset + 16L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 16L + 12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 1);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            childBlob.putInt8(_hidl_index_0 * 1, this.msg.get(_hidl_index_0));
        }
        _hidl_blob.putBlob(_hidl_offset + 16L + 0L, childBlob);
    }
}

