/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.contexthub.V1_0;

import android.hardware.contexthub.V1_0.HubMemoryFlag;
import android.hardware.contexthub.V1_0.HubMemoryType;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class MemRange {
    public int totalBytes;
    public int freeBytes;
    public int type;
    public int flags;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != MemRange.class) {
            return false;
        }
        MemRange other = (MemRange)otherObject;
        if (this.totalBytes != other.totalBytes) {
            return false;
        }
        if (this.freeBytes != other.freeBytes) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return HidlSupport.deepEquals(this.flags, other.flags);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.totalBytes), HidlSupport.deepHashCode(this.freeBytes), HidlSupport.deepHashCode(this.type), HidlSupport.deepHashCode(this.flags));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".totalBytes = ");
        builder.append(this.totalBytes);
        builder.append(", .freeBytes = ");
        builder.append(this.freeBytes);
        builder.append(", .type = ");
        builder.append(HubMemoryType.toString(this.type));
        builder.append(", .flags = ");
        builder.append(HubMemoryFlag.dumpBitfield(this.flags));
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(16L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<MemRange> readVectorFromParcel(HwParcel parcel) {
        ArrayList<MemRange> _hidl_vec = new ArrayList<MemRange>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 16, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            MemRange _hidl_vec_element = new MemRange();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 16);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.totalBytes = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.freeBytes = _hidl_blob.getInt32(_hidl_offset + 4L);
        this.type = _hidl_blob.getInt32(_hidl_offset + 8L);
        this.flags = _hidl_blob.getInt32(_hidl_offset + 12L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(16);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<MemRange> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 16);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 16);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.totalBytes);
        _hidl_blob.putInt32(_hidl_offset + 4L, this.freeBytes);
        _hidl_blob.putInt32(_hidl_offset + 8L, this.type);
        _hidl_blob.putInt32(_hidl_offset + 12L, this.flags);
    }
}

