/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.graphics.Rect;
import android.text.TextUtils;

public final class DisplayViewport {
    public boolean valid;
    public int displayId;
    public int orientation;
    public final Rect logicalFrame = new Rect();
    public final Rect physicalFrame = new Rect();
    public int deviceWidth;
    public int deviceHeight;
    public String uniqueId;

    public void copyFrom(DisplayViewport viewport) {
        this.valid = viewport.valid;
        this.displayId = viewport.displayId;
        this.orientation = viewport.orientation;
        this.logicalFrame.set(viewport.logicalFrame);
        this.physicalFrame.set(viewport.physicalFrame);
        this.deviceWidth = viewport.deviceWidth;
        this.deviceHeight = viewport.deviceHeight;
        this.uniqueId = viewport.uniqueId;
    }

    public DisplayViewport makeCopy() {
        DisplayViewport dv = new DisplayViewport();
        dv.copyFrom(this);
        return dv;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisplayViewport)) {
            return false;
        }
        DisplayViewport other = (DisplayViewport)o;
        return this.valid == other.valid && this.displayId == other.displayId && this.orientation == other.orientation && this.logicalFrame.equals(other.logicalFrame) && this.physicalFrame.equals(other.physicalFrame) && this.deviceWidth == other.deviceWidth && this.deviceHeight == other.deviceHeight && TextUtils.equals(this.uniqueId, other.uniqueId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result += 31 * result + (this.valid ? 1 : 0);
        result += 31 * result + this.displayId;
        result += 31 * result + this.orientation;
        result += 31 * result + this.logicalFrame.hashCode();
        result += 31 * result + this.physicalFrame.hashCode();
        result += 31 * result + this.deviceWidth;
        result += 31 * result + this.deviceHeight;
        result += 31 * result + this.uniqueId.hashCode();
        return result;
    }

    public String toString() {
        return "DisplayViewport{valid=" + this.valid + ", displayId=" + this.displayId + ", uniqueId='" + this.uniqueId + "', orientation=" + this.orientation + ", logicalFrame=" + this.logicalFrame + ", physicalFrame=" + this.physicalFrame + ", deviceWidth=" + this.deviceWidth + ", deviceHeight=" + this.deviceHeight + "}";
    }
}

