/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.fingerprint;

import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageManager;
import android.hardware.biometrics.BiometricAuthenticator;
import android.hardware.biometrics.BiometricFingerprintConstants;
import android.hardware.fingerprint.FingerprintManager;
import android.hardware.fingerprint.IFingerprintDialogReceiver;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.text.TextUtils;
import java.security.Signature;
import java.util.concurrent.Executor;
import javax.crypto.Cipher;
import javax.crypto.Mac;

public class FingerprintDialog
implements BiometricAuthenticator,
BiometricFingerprintConstants {
    public static final String KEY_TITLE = "title";
    public static final String KEY_SUBTITLE = "subtitle";
    public static final String KEY_DESCRIPTION = "description";
    public static final String KEY_POSITIVE_TEXT = "positive_text";
    public static final String KEY_NEGATIVE_TEXT = "negative_text";
    public static final int HIDE_DIALOG_DELAY = 3000;
    public static final int DISMISSED_REASON_POSITIVE = 1;
    public static final int DISMISSED_REASON_NEGATIVE = 2;
    public static final int DISMISSED_REASON_USER_CANCEL = 3;
    private PackageManager mPackageManager;
    private FingerprintManager mFingerprintManager;
    private Bundle mBundle;
    private ButtonInfo mPositiveButtonInfo;
    private ButtonInfo mNegativeButtonInfo;
    IFingerprintDialogReceiver mDialogReceiver = new IFingerprintDialogReceiver.Stub(){

        @Override
        public void onDialogDismissed(int reason) {
            if (reason == 1) {
                ((FingerprintDialog)FingerprintDialog.this).mPositiveButtonInfo.executor.execute(() -> ((FingerprintDialog)FingerprintDialog.this).mPositiveButtonInfo.listener.onClick(null, -1));
            } else if (reason == 2) {
                ((FingerprintDialog)FingerprintDialog.this).mNegativeButtonInfo.executor.execute(() -> ((FingerprintDialog)FingerprintDialog.this).mNegativeButtonInfo.listener.onClick(null, -2));
            }
        }
    };

    private FingerprintDialog(Context context, Bundle bundle, ButtonInfo positiveButtonInfo, ButtonInfo negativeButtonInfo) {
        this.mBundle = bundle;
        this.mPositiveButtonInfo = positiveButtonInfo;
        this.mNegativeButtonInfo = negativeButtonInfo;
        this.mFingerprintManager = context.getSystemService(FingerprintManager.class);
        this.mPackageManager = context.getPackageManager();
    }

    @Override
    public void authenticate(android.hardware.biometrics.CryptoObject crypto, CancellationSignal cancel, Executor executor, BiometricAuthenticator.AuthenticationCallback callback) {
        if (!(callback instanceof AuthenticationCallback)) {
            throw new IllegalArgumentException("Callback cannot be casted");
        }
        this.authenticate(crypto, cancel, executor, (BiometricAuthenticator.AuthenticationCallback)((AuthenticationCallback)callback));
    }

    @Override
    public void authenticate(CancellationSignal cancel, Executor executor, BiometricAuthenticator.AuthenticationCallback callback) {
        if (!(callback instanceof AuthenticationCallback)) {
            throw new IllegalArgumentException("Callback cannot be casted");
        }
        this.authenticate(cancel, executor, (AuthenticationCallback)callback);
    }

    public void authenticate(CryptoObject crypto, CancellationSignal cancel, Executor executor, AuthenticationCallback callback) {
        if (this.handlePreAuthenticationErrors(callback, executor)) {
            return;
        }
        this.mFingerprintManager.authenticate(crypto, cancel, this.mBundle, executor, this.mDialogReceiver, callback);
    }

    public void authenticate(CancellationSignal cancel, Executor executor, AuthenticationCallback callback) {
        if (this.handlePreAuthenticationErrors(callback, executor)) {
            return;
        }
        this.mFingerprintManager.authenticate(cancel, this.mBundle, executor, this.mDialogReceiver, callback);
    }

    private boolean handlePreAuthenticationErrors(AuthenticationCallback callback, Executor executor) {
        if (!this.mPackageManager.hasSystemFeature("android.hardware.fingerprint")) {
            this.sendError(12, callback, executor);
            return true;
        }
        if (!this.mFingerprintManager.isHardwareDetected()) {
            this.sendError(1, callback, executor);
            return true;
        }
        if (!this.mFingerprintManager.hasEnrolledFingerprints()) {
            this.sendError(11, callback, executor);
            return true;
        }
        return false;
    }

    private void sendError(int error, AuthenticationCallback callback, Executor executor) {
        executor.execute(() -> callback.onAuthenticationError(error, this.mFingerprintManager.getErrorString(error, 0)));
    }

    public static abstract class AuthenticationCallback
    extends BiometricAuthenticator.AuthenticationCallback {
        @Override
        public void onAuthenticationError(int errorCode, CharSequence errString) {
        }

        @Override
        public void onAuthenticationHelp(int helpCode, CharSequence helpString) {
        }

        public void onAuthenticationSucceeded(AuthenticationResult result) {
        }

        @Override
        public void onAuthenticationFailed() {
        }

        @Override
        public void onAuthenticationAcquired(int acquireInfo) {
        }

        @Override
        public void onAuthenticationSucceeded(BiometricAuthenticator.AuthenticationResult result) {
            this.onAuthenticationSucceeded(new AuthenticationResult((CryptoObject)result.getCryptoObject(), result.getId(), result.getUserId()));
        }
    }

    public static class AuthenticationResult
    extends BiometricAuthenticator.AuthenticationResult {
        public AuthenticationResult(CryptoObject crypto, BiometricAuthenticator.BiometricIdentifier identifier, int userId) {
            super(crypto, identifier, userId);
        }

        @Override
        public CryptoObject getCryptoObject() {
            return (CryptoObject)super.getCryptoObject();
        }
    }

    public static final class CryptoObject
    extends android.hardware.biometrics.CryptoObject {
        public CryptoObject(Signature signature) {
            super(signature);
        }

        public CryptoObject(Cipher cipher) {
            super(cipher);
        }

        public CryptoObject(Mac mac) {
            super(mac);
        }

        @Override
        public Signature getSignature() {
            return super.getSignature();
        }

        @Override
        public Cipher getCipher() {
            return super.getCipher();
        }

        @Override
        public Mac getMac() {
            return super.getMac();
        }
    }

    public static class Builder {
        private final Bundle bundle = new Bundle();
        private ButtonInfo positiveButtonInfo;
        private ButtonInfo negativeButtonInfo;

        public Builder setTitle(CharSequence title) {
            this.bundle.putCharSequence(FingerprintDialog.KEY_TITLE, title);
            return this;
        }

        public Builder setSubtitle(CharSequence subtitle) {
            this.bundle.putCharSequence(FingerprintDialog.KEY_SUBTITLE, subtitle);
            return this;
        }

        public Builder setDescription(CharSequence description) {
            this.bundle.putCharSequence(FingerprintDialog.KEY_DESCRIPTION, description);
            return this;
        }

        public Builder setPositiveButton(CharSequence text, Executor executor, DialogInterface.OnClickListener listener) {
            if (TextUtils.isEmpty(text)) {
                throw new IllegalArgumentException("Text must be set and non-empty");
            }
            if (executor == null) {
                throw new IllegalArgumentException("Executor must not be null");
            }
            if (listener == null) {
                throw new IllegalArgumentException("Listener must not be null");
            }
            this.bundle.putCharSequence(FingerprintDialog.KEY_POSITIVE_TEXT, text);
            this.positiveButtonInfo = new ButtonInfo(executor, listener);
            return this;
        }

        public Builder setNegativeButton(CharSequence text, Executor executor, DialogInterface.OnClickListener listener) {
            if (TextUtils.isEmpty(text)) {
                throw new IllegalArgumentException("Text must be set and non-empty");
            }
            if (executor == null) {
                throw new IllegalArgumentException("Executor must not be null");
            }
            if (listener == null) {
                throw new IllegalArgumentException("Listener must not be null");
            }
            this.bundle.putCharSequence(FingerprintDialog.KEY_NEGATIVE_TEXT, text);
            this.negativeButtonInfo = new ButtonInfo(executor, listener);
            return this;
        }

        public FingerprintDialog build(Context context) {
            CharSequence title = this.bundle.getCharSequence(FingerprintDialog.KEY_TITLE);
            CharSequence negative = this.bundle.getCharSequence(FingerprintDialog.KEY_NEGATIVE_TEXT);
            if (TextUtils.isEmpty(title)) {
                throw new IllegalArgumentException("Title must be set and non-empty");
            }
            if (TextUtils.isEmpty(negative)) {
                throw new IllegalArgumentException("Negative text must be set and non-empty");
            }
            return new FingerprintDialog(context, this.bundle, this.positiveButtonInfo, this.negativeButtonInfo);
        }
    }

    private static class ButtonInfo {
        Executor executor;
        DialogInterface.OnClickListener listener;

        ButtonInfo(Executor ex, DialogInterface.OnClickListener l) {
            this.executor = ex;
            this.listener = l;
        }
    }
}

