/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.health.V1_0;

import android.hardware.health.V1_0.BatteryHealth;
import android.hardware.health.V1_0.BatteryStatus;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class HealthInfo {
    public boolean chargerAcOnline;
    public boolean chargerUsbOnline;
    public boolean chargerWirelessOnline;
    public int maxChargingCurrent;
    public int maxChargingVoltage;
    public int batteryStatus;
    public int batteryHealth;
    public boolean batteryPresent;
    public int batteryLevel;
    public int batteryVoltage;
    public int batteryTemperature;
    public int batteryCurrent;
    public int batteryCycleCount;
    public int batteryFullCharge;
    public int batteryChargeCounter;
    public String batteryTechnology = new String();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != HealthInfo.class) {
            return false;
        }
        HealthInfo other = (HealthInfo)otherObject;
        if (this.chargerAcOnline != other.chargerAcOnline) {
            return false;
        }
        if (this.chargerUsbOnline != other.chargerUsbOnline) {
            return false;
        }
        if (this.chargerWirelessOnline != other.chargerWirelessOnline) {
            return false;
        }
        if (this.maxChargingCurrent != other.maxChargingCurrent) {
            return false;
        }
        if (this.maxChargingVoltage != other.maxChargingVoltage) {
            return false;
        }
        if (this.batteryStatus != other.batteryStatus) {
            return false;
        }
        if (this.batteryHealth != other.batteryHealth) {
            return false;
        }
        if (this.batteryPresent != other.batteryPresent) {
            return false;
        }
        if (this.batteryLevel != other.batteryLevel) {
            return false;
        }
        if (this.batteryVoltage != other.batteryVoltage) {
            return false;
        }
        if (this.batteryTemperature != other.batteryTemperature) {
            return false;
        }
        if (this.batteryCurrent != other.batteryCurrent) {
            return false;
        }
        if (this.batteryCycleCount != other.batteryCycleCount) {
            return false;
        }
        if (this.batteryFullCharge != other.batteryFullCharge) {
            return false;
        }
        if (this.batteryChargeCounter != other.batteryChargeCounter) {
            return false;
        }
        return HidlSupport.deepEquals(this.batteryTechnology, other.batteryTechnology);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.chargerAcOnline), HidlSupport.deepHashCode(this.chargerUsbOnline), HidlSupport.deepHashCode(this.chargerWirelessOnline), HidlSupport.deepHashCode(this.maxChargingCurrent), HidlSupport.deepHashCode(this.maxChargingVoltage), HidlSupport.deepHashCode(this.batteryStatus), HidlSupport.deepHashCode(this.batteryHealth), HidlSupport.deepHashCode(this.batteryPresent), HidlSupport.deepHashCode(this.batteryLevel), HidlSupport.deepHashCode(this.batteryVoltage), HidlSupport.deepHashCode(this.batteryTemperature), HidlSupport.deepHashCode(this.batteryCurrent), HidlSupport.deepHashCode(this.batteryCycleCount), HidlSupport.deepHashCode(this.batteryFullCharge), HidlSupport.deepHashCode(this.batteryChargeCounter), HidlSupport.deepHashCode(this.batteryTechnology));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".chargerAcOnline = ");
        builder.append(this.chargerAcOnline);
        builder.append(", .chargerUsbOnline = ");
        builder.append(this.chargerUsbOnline);
        builder.append(", .chargerWirelessOnline = ");
        builder.append(this.chargerWirelessOnline);
        builder.append(", .maxChargingCurrent = ");
        builder.append(this.maxChargingCurrent);
        builder.append(", .maxChargingVoltage = ");
        builder.append(this.maxChargingVoltage);
        builder.append(", .batteryStatus = ");
        builder.append(BatteryStatus.toString(this.batteryStatus));
        builder.append(", .batteryHealth = ");
        builder.append(BatteryHealth.toString(this.batteryHealth));
        builder.append(", .batteryPresent = ");
        builder.append(this.batteryPresent);
        builder.append(", .batteryLevel = ");
        builder.append(this.batteryLevel);
        builder.append(", .batteryVoltage = ");
        builder.append(this.batteryVoltage);
        builder.append(", .batteryTemperature = ");
        builder.append(this.batteryTemperature);
        builder.append(", .batteryCurrent = ");
        builder.append(this.batteryCurrent);
        builder.append(", .batteryCycleCount = ");
        builder.append(this.batteryCycleCount);
        builder.append(", .batteryFullCharge = ");
        builder.append(this.batteryFullCharge);
        builder.append(", .batteryChargeCounter = ");
        builder.append(this.batteryChargeCounter);
        builder.append(", .batteryTechnology = ");
        builder.append(this.batteryTechnology);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(72L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<HealthInfo> readVectorFromParcel(HwParcel parcel) {
        ArrayList<HealthInfo> _hidl_vec = new ArrayList<HealthInfo>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 72, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            HealthInfo _hidl_vec_element = new HealthInfo();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 72);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.chargerAcOnline = _hidl_blob.getBool(_hidl_offset + 0L);
        this.chargerUsbOnline = _hidl_blob.getBool(_hidl_offset + 1L);
        this.chargerWirelessOnline = _hidl_blob.getBool(_hidl_offset + 2L);
        this.maxChargingCurrent = _hidl_blob.getInt32(_hidl_offset + 4L);
        this.maxChargingVoltage = _hidl_blob.getInt32(_hidl_offset + 8L);
        this.batteryStatus = _hidl_blob.getInt32(_hidl_offset + 12L);
        this.batteryHealth = _hidl_blob.getInt32(_hidl_offset + 16L);
        this.batteryPresent = _hidl_blob.getBool(_hidl_offset + 20L);
        this.batteryLevel = _hidl_blob.getInt32(_hidl_offset + 24L);
        this.batteryVoltage = _hidl_blob.getInt32(_hidl_offset + 28L);
        this.batteryTemperature = _hidl_blob.getInt32(_hidl_offset + 32L);
        this.batteryCurrent = _hidl_blob.getInt32(_hidl_offset + 36L);
        this.batteryCycleCount = _hidl_blob.getInt32(_hidl_offset + 40L);
        this.batteryFullCharge = _hidl_blob.getInt32(_hidl_offset + 44L);
        this.batteryChargeCounter = _hidl_blob.getInt32(_hidl_offset + 48L);
        this.batteryTechnology = _hidl_blob.getString(_hidl_offset + 56L);
        parcel.readEmbeddedBuffer(this.batteryTechnology.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 56L + 0L, false);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(72);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<HealthInfo> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 72);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 72);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putBool(_hidl_offset + 0L, this.chargerAcOnline);
        _hidl_blob.putBool(_hidl_offset + 1L, this.chargerUsbOnline);
        _hidl_blob.putBool(_hidl_offset + 2L, this.chargerWirelessOnline);
        _hidl_blob.putInt32(_hidl_offset + 4L, this.maxChargingCurrent);
        _hidl_blob.putInt32(_hidl_offset + 8L, this.maxChargingVoltage);
        _hidl_blob.putInt32(_hidl_offset + 12L, this.batteryStatus);
        _hidl_blob.putInt32(_hidl_offset + 16L, this.batteryHealth);
        _hidl_blob.putBool(_hidl_offset + 20L, this.batteryPresent);
        _hidl_blob.putInt32(_hidl_offset + 24L, this.batteryLevel);
        _hidl_blob.putInt32(_hidl_offset + 28L, this.batteryVoltage);
        _hidl_blob.putInt32(_hidl_offset + 32L, this.batteryTemperature);
        _hidl_blob.putInt32(_hidl_offset + 36L, this.batteryCurrent);
        _hidl_blob.putInt32(_hidl_offset + 40L, this.batteryCycleCount);
        _hidl_blob.putInt32(_hidl_offset + 44L, this.batteryFullCharge);
        _hidl_blob.putInt32(_hidl_offset + 48L, this.batteryChargeCounter);
        _hidl_blob.putString(_hidl_offset + 56L, this.batteryTechnology);
    }
}

