/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.health.V2_0;

import android.hardware.health.V2_0.StorageAttribute;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class StorageInfo {
    public final StorageAttribute attr = new StorageAttribute();
    public short eol;
    public short lifetimeA;
    public short lifetimeB;
    public String version = new String();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != StorageInfo.class) {
            return false;
        }
        StorageInfo other = (StorageInfo)otherObject;
        if (!HidlSupport.deepEquals(this.attr, other.attr)) {
            return false;
        }
        if (this.eol != other.eol) {
            return false;
        }
        if (this.lifetimeA != other.lifetimeA) {
            return false;
        }
        if (this.lifetimeB != other.lifetimeB) {
            return false;
        }
        return HidlSupport.deepEquals(this.version, other.version);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.attr), HidlSupport.deepHashCode(this.eol), HidlSupport.deepHashCode(this.lifetimeA), HidlSupport.deepHashCode(this.lifetimeB), HidlSupport.deepHashCode(this.version));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".attr = ");
        builder.append(this.attr);
        builder.append(", .eol = ");
        builder.append(this.eol);
        builder.append(", .lifetimeA = ");
        builder.append(this.lifetimeA);
        builder.append(", .lifetimeB = ");
        builder.append(this.lifetimeB);
        builder.append(", .version = ");
        builder.append(this.version);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(48L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<StorageInfo> readVectorFromParcel(HwParcel parcel) {
        ArrayList<StorageInfo> _hidl_vec = new ArrayList<StorageInfo>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 48, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            StorageInfo _hidl_vec_element = new StorageInfo();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 48);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.attr.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 0L);
        this.eol = _hidl_blob.getInt16(_hidl_offset + 24L);
        this.lifetimeA = _hidl_blob.getInt16(_hidl_offset + 26L);
        this.lifetimeB = _hidl_blob.getInt16(_hidl_offset + 28L);
        this.version = _hidl_blob.getString(_hidl_offset + 32L);
        parcel.readEmbeddedBuffer(this.version.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 32L + 0L, false);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(48);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<StorageInfo> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 48);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 48);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        this.attr.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 0L);
        _hidl_blob.putInt16(_hidl_offset + 24L, this.eol);
        _hidl_blob.putInt16(_hidl_offset + 26L, this.lifetimeA);
        _hidl_blob.putInt16(_hidl_offset + 28L, this.lifetimeB);
        _hidl_blob.putString(_hidl_offset + 32L, this.version);
    }
}

