/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.hardware.radio.ITunerCallback;
import android.hardware.radio.ProgramList;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioManager;
import android.hardware.radio.RadioMetadata;
import android.hardware.radio.RadioTuner;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class TunerCallbackAdapter
extends ITunerCallback.Stub {
    private static final String TAG = "BroadcastRadio.TunerCallbackAdapter";
    private final Object mLock = new Object();
    private final RadioTuner.Callback mCallback;
    private final Handler mHandler;
    ProgramList mProgramList;
    boolean mIsAntennaConnected = true;
    List<RadioManager.ProgramInfo> mLastCompleteList;
    private boolean mDelayedCompleteCallback = false;
    RadioManager.ProgramInfo mCurrentProgramInfo;

    TunerCallbackAdapter(RadioTuner.Callback callback, Handler handler) {
        this.mCallback = callback;
        this.mHandler = handler == null ? new Handler(Looper.getMainLooper()) : handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProgramListObserver(ProgramList programList, ProgramList.OnCloseListener closeListener) {
        Objects.requireNonNull(closeListener);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mProgramList != null) {
                Log.w(TAG, "Previous program list observer wasn't properly closed, closing it...");
                this.mProgramList.close();
            }
            this.mProgramList = programList;
            if (programList == null) {
                return;
            }
            programList.setOnCloseListener(() -> {
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mProgramList != programList) {
                        return;
                    }
                    this.mProgramList = null;
                    this.mLastCompleteList = null;
                    closeListener.onClose();
                }
            });
            programList.addOnCompleteListener(() -> {
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mProgramList != programList) {
                        return;
                    }
                    this.mLastCompleteList = programList.toList();
                    if (this.mDelayedCompleteCallback) {
                        Log.d(TAG, "Sending delayed onBackgroundScanComplete callback");
                        this.sendBackgroundScanCompleteLocked();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<RadioManager.ProgramInfo> getLastCompleteList() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mLastCompleteList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearLastCompleteList() {
        Object object = this.mLock;
        synchronized (object) {
            this.mLastCompleteList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RadioManager.ProgramInfo getCurrentProgramInformation() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCurrentProgramInfo;
        }
    }

    boolean isAntennaConnected() {
        return this.mIsAntennaConnected;
    }

    @Override
    public void onError(int status) {
        this.mHandler.post(() -> this.mCallback.onError(status));
    }

    @Override
    public void onTuneFailed(int status, ProgramSelector selector) {
        int errorCode;
        this.mHandler.post(() -> this.mCallback.onTuneFailed(status, selector));
        switch (status) {
            case -32: 
            case -1: {
                errorCode = 1;
                break;
            }
            case -2147483648: 
            case -38: 
            case -22: 
            case -19: {
                Log.i(TAG, "Got an error with no mapping to the legacy API (" + status + "), doing a best-effort conversion to ERROR_SCAN_TIMEOUT");
            }
            default: {
                errorCode = 3;
            }
        }
        this.mHandler.post(() -> this.mCallback.onError(errorCode));
    }

    @Override
    public void onConfigurationChanged(RadioManager.BandConfig config) {
        this.mHandler.post(() -> this.mCallback.onConfigurationChanged(config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCurrentProgramInfoChanged(RadioManager.ProgramInfo info) {
        if (info == null) {
            Log.e(TAG, "ProgramInfo must not be null");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentProgramInfo = info;
        }
        this.mHandler.post(() -> {
            this.mCallback.onProgramInfoChanged(info);
            RadioMetadata metadata = info.getMetadata();
            if (metadata != null) {
                this.mCallback.onMetadataChanged(metadata);
            }
        });
    }

    @Override
    public void onTrafficAnnouncement(boolean active) {
        this.mHandler.post(() -> this.mCallback.onTrafficAnnouncement(active));
    }

    @Override
    public void onEmergencyAnnouncement(boolean active) {
        this.mHandler.post(() -> this.mCallback.onEmergencyAnnouncement(active));
    }

    @Override
    public void onAntennaState(boolean connected) {
        this.mIsAntennaConnected = connected;
        this.mHandler.post(() -> this.mCallback.onAntennaState(connected));
    }

    @Override
    public void onBackgroundScanAvailabilityChange(boolean isAvailable) {
        this.mHandler.post(() -> this.mCallback.onBackgroundScanAvailabilityChange(isAvailable));
    }

    private void sendBackgroundScanCompleteLocked() {
        this.mDelayedCompleteCallback = false;
        this.mHandler.post(() -> this.mCallback.onBackgroundScanComplete());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBackgroundScanComplete() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLastCompleteList == null) {
                Log.i(TAG, "Got onBackgroundScanComplete callback, but the program list didn't get through yet. Delaying it...");
                this.mDelayedCompleteCallback = true;
                return;
            }
            this.sendBackgroundScanCompleteLocked();
        }
    }

    @Override
    public void onProgramListChanged() {
        this.mHandler.post(() -> this.mCallback.onProgramListChanged());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onProgramListUpdated(ProgramList.Chunk chunk) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mProgramList == null) {
                return;
            }
            this.mProgramList.apply(Objects.requireNonNull(chunk));
        }
    }

    @Override
    public void onParametersUpdated(Map parameters) {
        this.mHandler.post(() -> this.mCallback.onParametersUpdated(parameters));
    }
}

