/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_0;

import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public final class ActivityStatsInfo {
    public int sleepModeTimeMs;
    public int idleModeTimeMs;
    public final int[] txmModetimeMs = new int[5];
    public int rxModeTimeMs;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != ActivityStatsInfo.class) {
            return false;
        }
        ActivityStatsInfo other = (ActivityStatsInfo)otherObject;
        if (this.sleepModeTimeMs != other.sleepModeTimeMs) {
            return false;
        }
        if (this.idleModeTimeMs != other.idleModeTimeMs) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.txmModetimeMs, other.txmModetimeMs)) {
            return false;
        }
        return this.rxModeTimeMs == other.rxModeTimeMs;
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.sleepModeTimeMs), HidlSupport.deepHashCode(this.idleModeTimeMs), HidlSupport.deepHashCode(this.txmModetimeMs), HidlSupport.deepHashCode(this.rxModeTimeMs));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".sleepModeTimeMs = ");
        builder.append(this.sleepModeTimeMs);
        builder.append(", .idleModeTimeMs = ");
        builder.append(this.idleModeTimeMs);
        builder.append(", .txmModetimeMs = ");
        builder.append(Arrays.toString(this.txmModetimeMs));
        builder.append(", .rxModeTimeMs = ");
        builder.append(this.rxModeTimeMs);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(32L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<ActivityStatsInfo> readVectorFromParcel(HwParcel parcel) {
        ArrayList<ActivityStatsInfo> _hidl_vec = new ArrayList<ActivityStatsInfo>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 32, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            ActivityStatsInfo _hidl_vec_element = new ActivityStatsInfo();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 32);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.sleepModeTimeMs = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.idleModeTimeMs = _hidl_blob.getInt32(_hidl_offset + 4L);
        long _hidl_array_offset_0 = _hidl_offset + 8L;
        _hidl_blob.copyToInt32Array(_hidl_array_offset_0, this.txmModetimeMs, 5);
        _hidl_array_offset_0 += 20L;
        this.rxModeTimeMs = _hidl_blob.getInt32(_hidl_offset + 28L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(32);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<ActivityStatsInfo> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 32);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 32);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.sleepModeTimeMs);
        _hidl_blob.putInt32(_hidl_offset + 4L, this.idleModeTimeMs);
        long _hidl_array_offset_0 = _hidl_offset + 8L;
        _hidl_blob.putInt32Array(_hidl_array_offset_0, this.txmModetimeMs);
        _hidl_array_offset_0 += 20L;
        _hidl_blob.putInt32(_hidl_offset + 28L, this.rxModeTimeMs);
    }
}

