/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_0;

import android.hardware.radio.V1_0.ApnAuthType;
import android.hardware.radio.V1_0.ApnTypes;
import android.hardware.radio.V1_0.DataProfileId;
import android.hardware.radio.V1_0.DataProfileInfoType;
import android.hardware.radio.V1_0.MvnoType;
import android.hardware.radio.V1_0.RadioAccessFamily;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class DataProfileInfo {
    public int profileId;
    public String apn = new String();
    public String protocol = new String();
    public String roamingProtocol = new String();
    public int authType;
    public String user = new String();
    public String password = new String();
    public int type;
    public int maxConnsTime;
    public int maxConns;
    public int waitTime;
    public boolean enabled;
    public int supportedApnTypesBitmap;
    public int bearerBitmap;
    public int mtu;
    public int mvnoType;
    public String mvnoMatchData = new String();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != DataProfileInfo.class) {
            return false;
        }
        DataProfileInfo other = (DataProfileInfo)otherObject;
        if (this.profileId != other.profileId) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.apn, other.apn)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.protocol, other.protocol)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.roamingProtocol, other.roamingProtocol)) {
            return false;
        }
        if (this.authType != other.authType) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.user, other.user)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.password, other.password)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.maxConnsTime != other.maxConnsTime) {
            return false;
        }
        if (this.maxConns != other.maxConns) {
            return false;
        }
        if (this.waitTime != other.waitTime) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.supportedApnTypesBitmap, other.supportedApnTypesBitmap)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.bearerBitmap, other.bearerBitmap)) {
            return false;
        }
        if (this.mtu != other.mtu) {
            return false;
        }
        if (this.mvnoType != other.mvnoType) {
            return false;
        }
        return HidlSupport.deepEquals(this.mvnoMatchData, other.mvnoMatchData);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.profileId), HidlSupport.deepHashCode(this.apn), HidlSupport.deepHashCode(this.protocol), HidlSupport.deepHashCode(this.roamingProtocol), HidlSupport.deepHashCode(this.authType), HidlSupport.deepHashCode(this.user), HidlSupport.deepHashCode(this.password), HidlSupport.deepHashCode(this.type), HidlSupport.deepHashCode(this.maxConnsTime), HidlSupport.deepHashCode(this.maxConns), HidlSupport.deepHashCode(this.waitTime), HidlSupport.deepHashCode(this.enabled), HidlSupport.deepHashCode(this.supportedApnTypesBitmap), HidlSupport.deepHashCode(this.bearerBitmap), HidlSupport.deepHashCode(this.mtu), HidlSupport.deepHashCode(this.mvnoType), HidlSupport.deepHashCode(this.mvnoMatchData));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".profileId = ");
        builder.append(DataProfileId.toString(this.profileId));
        builder.append(", .apn = ");
        builder.append(this.apn);
        builder.append(", .protocol = ");
        builder.append(this.protocol);
        builder.append(", .roamingProtocol = ");
        builder.append(this.roamingProtocol);
        builder.append(", .authType = ");
        builder.append(ApnAuthType.toString(this.authType));
        builder.append(", .user = ");
        builder.append(this.user);
        builder.append(", .password = ");
        builder.append(this.password);
        builder.append(", .type = ");
        builder.append(DataProfileInfoType.toString(this.type));
        builder.append(", .maxConnsTime = ");
        builder.append(this.maxConnsTime);
        builder.append(", .maxConns = ");
        builder.append(this.maxConns);
        builder.append(", .waitTime = ");
        builder.append(this.waitTime);
        builder.append(", .enabled = ");
        builder.append(this.enabled);
        builder.append(", .supportedApnTypesBitmap = ");
        builder.append(ApnTypes.dumpBitfield(this.supportedApnTypesBitmap));
        builder.append(", .bearerBitmap = ");
        builder.append(RadioAccessFamily.dumpBitfield(this.bearerBitmap));
        builder.append(", .mtu = ");
        builder.append(this.mtu);
        builder.append(", .mvnoType = ");
        builder.append(MvnoType.toString(this.mvnoType));
        builder.append(", .mvnoMatchData = ");
        builder.append(this.mvnoMatchData);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(152L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<DataProfileInfo> readVectorFromParcel(HwParcel parcel) {
        ArrayList<DataProfileInfo> _hidl_vec = new ArrayList<DataProfileInfo>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 152, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            DataProfileInfo _hidl_vec_element = new DataProfileInfo();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 152);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.profileId = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.apn = _hidl_blob.getString(_hidl_offset + 8L);
        parcel.readEmbeddedBuffer(this.apn.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 8L + 0L, false);
        this.protocol = _hidl_blob.getString(_hidl_offset + 24L);
        parcel.readEmbeddedBuffer(this.protocol.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 24L + 0L, false);
        this.roamingProtocol = _hidl_blob.getString(_hidl_offset + 40L);
        parcel.readEmbeddedBuffer(this.roamingProtocol.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 40L + 0L, false);
        this.authType = _hidl_blob.getInt32(_hidl_offset + 56L);
        this.user = _hidl_blob.getString(_hidl_offset + 64L);
        parcel.readEmbeddedBuffer(this.user.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 64L + 0L, false);
        this.password = _hidl_blob.getString(_hidl_offset + 80L);
        parcel.readEmbeddedBuffer(this.password.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 80L + 0L, false);
        this.type = _hidl_blob.getInt32(_hidl_offset + 96L);
        this.maxConnsTime = _hidl_blob.getInt32(_hidl_offset + 100L);
        this.maxConns = _hidl_blob.getInt32(_hidl_offset + 104L);
        this.waitTime = _hidl_blob.getInt32(_hidl_offset + 108L);
        this.enabled = _hidl_blob.getBool(_hidl_offset + 112L);
        this.supportedApnTypesBitmap = _hidl_blob.getInt32(_hidl_offset + 116L);
        this.bearerBitmap = _hidl_blob.getInt32(_hidl_offset + 120L);
        this.mtu = _hidl_blob.getInt32(_hidl_offset + 124L);
        this.mvnoType = _hidl_blob.getInt32(_hidl_offset + 128L);
        this.mvnoMatchData = _hidl_blob.getString(_hidl_offset + 136L);
        parcel.readEmbeddedBuffer(this.mvnoMatchData.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 136L + 0L, false);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(152);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<DataProfileInfo> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 152);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 152);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.profileId);
        _hidl_blob.putString(_hidl_offset + 8L, this.apn);
        _hidl_blob.putString(_hidl_offset + 24L, this.protocol);
        _hidl_blob.putString(_hidl_offset + 40L, this.roamingProtocol);
        _hidl_blob.putInt32(_hidl_offset + 56L, this.authType);
        _hidl_blob.putString(_hidl_offset + 64L, this.user);
        _hidl_blob.putString(_hidl_offset + 80L, this.password);
        _hidl_blob.putInt32(_hidl_offset + 96L, this.type);
        _hidl_blob.putInt32(_hidl_offset + 100L, this.maxConnsTime);
        _hidl_blob.putInt32(_hidl_offset + 104L, this.maxConns);
        _hidl_blob.putInt32(_hidl_offset + 108L, this.waitTime);
        _hidl_blob.putBool(_hidl_offset + 112L, this.enabled);
        _hidl_blob.putInt32(_hidl_offset + 116L, this.supportedApnTypesBitmap);
        _hidl_blob.putInt32(_hidl_offset + 120L, this.bearerBitmap);
        _hidl_blob.putInt32(_hidl_offset + 124L, this.mtu);
        _hidl_blob.putInt32(_hidl_offset + 128L, this.mvnoType);
        _hidl_blob.putString(_hidl_offset + 136L, this.mvnoMatchData);
    }
}

