/*
 * Decompiled with CFR 0.152.
 */
package android.icu.number;

import android.icu.impl.number.DecimalQuantity;
import android.icu.impl.number.MicroProps;
import android.icu.impl.number.NumberStringBuilder;
import android.icu.text.PluralRules;
import android.icu.util.ICUUncheckedIOException;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.util.Arrays;

public class FormattedNumber {
    NumberStringBuilder nsb;
    DecimalQuantity fq;
    MicroProps micros;

    FormattedNumber(NumberStringBuilder nsb, DecimalQuantity fq, MicroProps micros) {
        this.nsb = nsb;
        this.fq = fq;
        this.micros = micros;
    }

    public String toString() {
        return this.nsb.toString();
    }

    public <A extends Appendable> A appendTo(A appendable) {
        try {
            appendable.append(this.nsb);
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
        return appendable;
    }

    public void populateFieldPosition(FieldPosition fieldPosition) {
        this.populateFieldPosition(fieldPosition, 0);
    }

    @Deprecated
    public void populateFieldPosition(FieldPosition fieldPosition, int offset) {
        this.nsb.populateFieldPosition(fieldPosition, offset);
        this.fq.populateUFieldPosition(fieldPosition);
    }

    public AttributedCharacterIterator getFieldIterator() {
        return this.nsb.getIterator();
    }

    public BigDecimal toBigDecimal() {
        return this.fq.toBigDecimal();
    }

    @Deprecated
    public String getPrefix() {
        NumberStringBuilder temp = new NumberStringBuilder();
        int length = this.micros.modOuter.apply(temp, 0, 0);
        length += this.micros.modMiddle.apply(temp, 0, length);
        this.micros.modInner.apply(temp, 0, length);
        int prefixLength = this.micros.modOuter.getPrefixLength() + this.micros.modMiddle.getPrefixLength() + this.micros.modInner.getPrefixLength();
        return temp.subSequence(0, prefixLength).toString();
    }

    @Deprecated
    public String getSuffix() {
        NumberStringBuilder temp = new NumberStringBuilder();
        int length = this.micros.modOuter.apply(temp, 0, 0);
        length += this.micros.modMiddle.apply(temp, 0, length);
        length += this.micros.modInner.apply(temp, 0, length);
        int prefixLength = this.micros.modOuter.getPrefixLength() + this.micros.modMiddle.getPrefixLength() + this.micros.modInner.getPrefixLength();
        return temp.subSequence(prefixLength, length).toString();
    }

    @Deprecated
    public PluralRules.IFixedDecimal getFixedDecimal() {
        return this.fq;
    }

    public int hashCode() {
        return Arrays.hashCode(this.nsb.toCharArray()) ^ Arrays.hashCode(this.nsb.toFieldArray()) ^ this.fq.toBigDecimal().hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof FormattedNumber)) {
            return false;
        }
        FormattedNumber _other = (FormattedNumber)other;
        return Arrays.equals(this.nsb.toCharArray(), _other.nsb.toCharArray()) ^ Arrays.equals(this.nsb.toFieldArray(), _other.nsb.toFieldArray()) ^ this.fq.toBigDecimal().equals(_other.fq.toBigDecimal());
    }
}

