/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class AudioPresentation {
    private final int mPresentationId;
    private final int mProgramId;
    private final Map<String, String> mLabels;
    private final String mLanguage;
    private final int mMasteringIndication;
    private final boolean mAudioDescriptionAvailable;
    private final boolean mSpokenSubtitlesAvailable;
    private final boolean mDialogueEnhancementAvailable;
    public static final int MASTERING_NOT_INDICATED = 0;
    public static final int MASTERED_FOR_STEREO = 1;
    public static final int MASTERED_FOR_SURROUND = 2;
    public static final int MASTERED_FOR_3D = 3;
    public static final int MASTERED_FOR_HEADPHONE = 4;

    AudioPresentation(int presentationId, int programId, Map<String, String> labels, String language, int masteringIndication, boolean audioDescriptionAvailable, boolean spokenSubtitlesAvailable, boolean dialogueEnhancementAvailable) {
        this.mPresentationId = presentationId;
        this.mProgramId = programId;
        this.mLanguage = language;
        this.mMasteringIndication = masteringIndication;
        this.mAudioDescriptionAvailable = audioDescriptionAvailable;
        this.mSpokenSubtitlesAvailable = spokenSubtitlesAvailable;
        this.mDialogueEnhancementAvailable = dialogueEnhancementAvailable;
        this.mLabels = new HashMap<String, String>(labels);
    }

    public int getPresentationId() {
        return this.mPresentationId;
    }

    public int getProgramId() {
        return this.mProgramId;
    }

    public Map<Locale, String> getLabels() {
        HashMap<Locale, String> localeLabels = new HashMap<Locale, String>();
        for (Map.Entry<String, String> entry : this.mLabels.entrySet()) {
            localeLabels.put(new Locale(entry.getKey()), entry.getValue());
        }
        return localeLabels;
    }

    public Locale getLocale() {
        return new Locale(this.mLanguage);
    }

    public int getMasteringIndication() {
        return this.mMasteringIndication;
    }

    public boolean hasAudioDescription() {
        return this.mAudioDescriptionAvailable;
    }

    public boolean hasSpokenSubtitles() {
        return this.mSpokenSubtitlesAvailable;
    }

    public boolean hasDialogueEnhancement() {
        return this.mDialogueEnhancementAvailable;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MasteringIndicationType {
    }
}

