/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioPresentation;
import android.media.AudioRouting;
import android.media.AudioSystem;
import android.media.AudioTimestamp;
import android.media.NativeRoutingEventHandlerDelegate;
import android.media.PlaybackParams;
import android.media.PlayerBase;
import android.media.VolumeAutomation;
import android.media.VolumeShaper;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.NioUtils;
import java.util.concurrent.Executor;

public class AudioTrack
extends PlayerBase
implements AudioRouting,
VolumeAutomation {
    private static final float GAIN_MIN = 0.0f;
    private static final float GAIN_MAX = 1.0f;
    public static final int CHANNEL_COUNT_MAX = AudioTrack.native_get_FCC_8();
    public static final int PLAYSTATE_STOPPED = 1;
    public static final int PLAYSTATE_PAUSED = 2;
    public static final int PLAYSTATE_PLAYING = 3;
    public static final int MODE_STATIC = 0;
    public static final int MODE_STREAM = 1;
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_NO_STATIC_DATA = 2;
    public static final int SUCCESS = 0;
    public static final int ERROR = -1;
    public static final int ERROR_BAD_VALUE = -2;
    public static final int ERROR_INVALID_OPERATION = -3;
    public static final int ERROR_DEAD_OBJECT = -6;
    public static final int ERROR_WOULD_BLOCK = -7;
    private static final int ERROR_NATIVESETUP_AUDIOSYSTEM = -16;
    private static final int ERROR_NATIVESETUP_INVALIDCHANNELMASK = -17;
    private static final int ERROR_NATIVESETUP_INVALIDFORMAT = -18;
    private static final int ERROR_NATIVESETUP_INVALIDSTREAMTYPE = -19;
    private static final int ERROR_NATIVESETUP_NATIVEINITFAILED = -20;
    private static final int NATIVE_EVENT_MARKER = 3;
    private static final int NATIVE_EVENT_NEW_POS = 4;
    private static final int NATIVE_EVENT_MORE_DATA = 0;
    private static final int NATIVE_EVENT_NEW_IAUDIOTRACK = 6;
    private static final int NATIVE_EVENT_STREAM_END = 7;
    private static final String TAG = "android.media.AudioTrack";
    public static final int WRITE_BLOCKING = 0;
    public static final int WRITE_NON_BLOCKING = 1;
    public static final int PERFORMANCE_MODE_NONE = 0;
    public static final int PERFORMANCE_MODE_LOW_LATENCY = 1;
    public static final int PERFORMANCE_MODE_POWER_SAVING = 2;
    private static final int AUDIO_OUTPUT_FLAG_FAST = 4;
    private static final int AUDIO_OUTPUT_FLAG_DEEP_BUFFER = 8;
    private static final float HEADER_V2_SIZE_BYTES = 20.0f;
    private int mState = 0;
    private int mPlayState = 1;
    private final Object mPlayStateLock = new Object();
    private int mNativeBufferSizeInBytes = 0;
    private int mNativeBufferSizeInFrames = 0;
    private NativePositionEventHandlerDelegate mEventHandlerDelegate;
    private final Looper mInitializationLooper;
    private int mSampleRate;
    private int mChannelCount = 1;
    private int mChannelMask = 4;
    private int mStreamType = 3;
    private int mDataLoadMode = 1;
    private int mChannelConfiguration = 4;
    private int mChannelIndexMask = 0;
    private int mAudioFormat;
    private int mSessionId = 0;
    private ByteBuffer mAvSyncHeader = null;
    private int mAvSyncBytesRemaining = 0;
    private int mOffset = 0;
    protected long mNativeTrackInJavaObj;
    private long mJniData;
    private static final int SUPPORTED_OUT_CHANNELS = 7420;
    private AudioDeviceInfo mPreferredDevice = null;
    @GuardedBy(value="mRoutingChangeListeners")
    private ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> mRoutingChangeListeners = new ArrayMap();
    private Executor mStreamEventExec;
    private StreamEventCallback mStreamEventCb;
    private final Object mStreamEventCbLock = new Object();

    public AudioTrack(int streamType, int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes, int mode) throws IllegalArgumentException {
        this(streamType, sampleRateInHz, channelConfig, audioFormat, bufferSizeInBytes, mode, 0);
    }

    public AudioTrack(int streamType, int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes, int mode, int sessionId) throws IllegalArgumentException {
        this(new AudioAttributes.Builder().setLegacyStreamType(streamType).build(), new AudioFormat.Builder().setChannelMask(channelConfig).setEncoding(audioFormat).setSampleRate(sampleRateInHz).build(), bufferSizeInBytes, mode, sessionId);
        AudioTrack.deprecateStreamTypeForPlayback(streamType, "AudioTrack", "AudioTrack()");
    }

    public AudioTrack(AudioAttributes attributes, AudioFormat format, int bufferSizeInBytes, int mode, int sessionId) throws IllegalArgumentException {
        this(attributes, format, bufferSizeInBytes, mode, sessionId, false);
    }

    private AudioTrack(AudioAttributes attributes, AudioFormat format, int bufferSizeInBytes, int mode, int sessionId, boolean offload) throws IllegalArgumentException {
        super(attributes, 1);
        int rate;
        Looper looper;
        if (format == null) {
            throw new IllegalArgumentException("Illegal null AudioFormat");
        }
        if (AudioTrack.shouldEnablePowerSaving(this.mAttributes, format, bufferSizeInBytes, mode)) {
            this.mAttributes = new AudioAttributes.Builder(this.mAttributes).replaceFlags((this.mAttributes.getAllFlags() | 0x200) & 0xFFFFFEFF).build();
        }
        if ((looper = Looper.myLooper()) == null) {
            looper = Looper.getMainLooper();
        }
        if ((rate = format.getSampleRate()) == 0) {
            rate = 0;
        }
        int channelIndexMask = 0;
        if ((format.getPropertySetMask() & 8) != 0) {
            channelIndexMask = format.getChannelIndexMask();
        }
        int channelMask = 0;
        if ((format.getPropertySetMask() & 4) != 0) {
            channelMask = format.getChannelMask();
        } else if (channelIndexMask == 0) {
            channelMask = 12;
        }
        int encoding = 1;
        if ((format.getPropertySetMask() & 1) != 0) {
            encoding = format.getEncoding();
        }
        this.audioParamCheck(rate, channelMask, channelIndexMask, encoding, mode);
        this.mStreamType = -1;
        this.audioBuffSizeCheck(bufferSizeInBytes);
        this.mInitializationLooper = looper;
        if (sessionId < 0) {
            throw new IllegalArgumentException("Invalid audio session ID: " + sessionId);
        }
        int[] sampleRate = new int[]{this.mSampleRate};
        int[] session = new int[]{sessionId};
        int initResult = this.native_setup(new WeakReference<AudioTrack>(this), this.mAttributes, sampleRate, this.mChannelMask, this.mChannelIndexMask, this.mAudioFormat, this.mNativeBufferSizeInBytes, this.mDataLoadMode, session, 0L, offload);
        if (initResult != 0) {
            AudioTrack.loge("Error code " + initResult + " when initializing AudioTrack.");
            return;
        }
        this.mSampleRate = sampleRate[0];
        this.mSessionId = session[0];
        if ((this.mAttributes.getFlags() & 0x10) != 0) {
            int frameSizeInBytes = AudioFormat.isEncodingLinearFrames(this.mAudioFormat) ? this.mChannelCount * AudioFormat.getBytesPerSample(this.mAudioFormat) : 1;
            this.mOffset = (int)Math.ceil(20.0f / (float)frameSizeInBytes) * frameSizeInBytes;
        }
        this.mState = this.mDataLoadMode == 0 ? 2 : 1;
        this.baseRegisterPlayer();
    }

    AudioTrack(long nativeTrackInJavaObj) {
        super(new AudioAttributes.Builder().build(), 1);
        this.mNativeTrackInJavaObj = 0L;
        this.mJniData = 0L;
        Looper looper = Looper.myLooper();
        if (looper == null) {
            looper = Looper.getMainLooper();
        }
        this.mInitializationLooper = looper;
        if (nativeTrackInJavaObj != 0L) {
            this.baseRegisterPlayer();
            this.deferred_connect(nativeTrackInJavaObj);
        } else {
            this.mState = 0;
        }
    }

    void deferred_connect(long nativeTrackInJavaObj) {
        if (this.mState != 1) {
            int[] session = new int[]{0};
            int[] rates = new int[]{0};
            int initResult = this.native_setup(new WeakReference<AudioTrack>(this), null, rates, 0, 0, 0, 0, 0, session, nativeTrackInJavaObj, false);
            if (initResult != 0) {
                AudioTrack.loge("Error code " + initResult + " when initializing AudioTrack.");
                return;
            }
            this.mSessionId = session[0];
            this.mState = 1;
        }
    }

    private static boolean shouldEnablePowerSaving(AudioAttributes attributes, AudioFormat format, int bufferSizeInBytes, int mode) {
        if (attributes != null && (attributes.getAllFlags() != 0 || attributes.getUsage() != 1 || attributes.getContentType() != 0 && attributes.getContentType() != 2 && attributes.getContentType() != 3)) {
            return false;
        }
        if (format == null || format.getSampleRate() == 0 || !AudioFormat.isEncodingLinearPcm(format.getEncoding()) || !AudioFormat.isValidEncoding(format.getEncoding()) || format.getChannelCount() < 1) {
            return false;
        }
        if (mode != 1) {
            return false;
        }
        if (bufferSizeInBytes != 0) {
            long BUFFER_TARGET_MODE_STREAM_MS = 100L;
            int MILLIS_PER_SECOND = 1000;
            long bufferTargetSize = 100L * (long)format.getChannelCount() * (long)AudioFormat.getBytesPerSample(format.getEncoding()) * (long)format.getSampleRate() / 1000L;
            if ((long)bufferSizeInBytes < bufferTargetSize) {
                return false;
            }
        }
        return true;
    }

    private void audioParamCheck(int sampleRateInHz, int channelConfig, int channelIndexMask, int audioFormat, int mode) {
        if ((sampleRateInHz < 4000 || sampleRateInHz > 192000) && sampleRateInHz != 0) {
            throw new IllegalArgumentException(sampleRateInHz + "Hz is not a supported sample rate.");
        }
        this.mSampleRate = sampleRateInHz;
        if (audioFormat == 13 && channelConfig != 12) {
            throw new IllegalArgumentException("ENCODING_IEC61937 must be configured as CHANNEL_OUT_STEREO");
        }
        this.mChannelConfiguration = channelConfig;
        switch (channelConfig) {
            case 1: 
            case 2: 
            case 4: {
                this.mChannelCount = 1;
                this.mChannelMask = 4;
                break;
            }
            case 3: 
            case 12: {
                this.mChannelCount = 2;
                this.mChannelMask = 12;
                break;
            }
            default: {
                if (channelConfig == 0 && channelIndexMask != 0) {
                    this.mChannelCount = 0;
                    break;
                }
                if (!AudioTrack.isMultichannelConfigSupported(channelConfig)) {
                    throw new IllegalArgumentException("Unsupported channel configuration.");
                }
                this.mChannelMask = channelConfig;
                this.mChannelCount = AudioFormat.channelCountFromOutChannelMask(channelConfig);
            }
        }
        this.mChannelIndexMask = channelIndexMask;
        if (this.mChannelIndexMask != 0) {
            int indexMask = (1 << CHANNEL_COUNT_MAX) - 1;
            if ((channelIndexMask & ~indexMask) != 0) {
                throw new IllegalArgumentException("Unsupported channel index configuration " + channelIndexMask);
            }
            int channelIndexCount = Integer.bitCount(channelIndexMask);
            if (this.mChannelCount == 0) {
                this.mChannelCount = channelIndexCount;
            } else if (this.mChannelCount != channelIndexCount) {
                throw new IllegalArgumentException("Channel count must match");
            }
        }
        if (audioFormat == 1) {
            audioFormat = 2;
        }
        if (!AudioFormat.isPublicEncoding(audioFormat)) {
            throw new IllegalArgumentException("Unsupported audio encoding.");
        }
        this.mAudioFormat = audioFormat;
        if (mode != 1 && mode != 0 || mode != 1 && !AudioFormat.isEncodingLinearPcm(this.mAudioFormat)) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        this.mDataLoadMode = mode;
    }

    private static boolean isMultichannelConfigSupported(int channelConfig) {
        if ((channelConfig & 0x1CFC) != channelConfig) {
            AudioTrack.loge("Channel configuration features unsupported channels");
            return false;
        }
        int channelCount = AudioFormat.channelCountFromOutChannelMask(channelConfig);
        if (channelCount > CHANNEL_COUNT_MAX) {
            AudioTrack.loge("Channel configuration contains too many channels " + channelCount + ">" + CHANNEL_COUNT_MAX);
            return false;
        }
        int frontPair = 12;
        if ((channelConfig & 0xC) != 12) {
            AudioTrack.loge("Front channels must be present in multichannel configurations");
            return false;
        }
        int backPair = 192;
        if ((channelConfig & 0xC0) != 0 && (channelConfig & 0xC0) != 192) {
            AudioTrack.loge("Rear channels can't be used independently");
            return false;
        }
        int sidePair = 6144;
        if ((channelConfig & 0x1800) != 0 && (channelConfig & 0x1800) != 6144) {
            AudioTrack.loge("Side channels can't be used independently");
            return false;
        }
        return true;
    }

    private void audioBuffSizeCheck(int audioBufferSize) {
        int frameSizeInBytes = AudioFormat.isEncodingLinearFrames(this.mAudioFormat) ? this.mChannelCount * AudioFormat.getBytesPerSample(this.mAudioFormat) : 1;
        if (audioBufferSize % frameSizeInBytes != 0 || audioBufferSize < 1) {
            throw new IllegalArgumentException("Invalid audio buffer size.");
        }
        this.mNativeBufferSizeInBytes = audioBufferSize;
        this.mNativeBufferSizeInFrames = audioBufferSize / frameSizeInBytes;
    }

    public void release() {
        try {
            this.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.baseRelease();
        this.native_release();
        this.mState = 0;
    }

    protected void finalize() {
        this.baseRelease();
        this.native_finalize();
    }

    public static float getMinVolume() {
        return 0.0f;
    }

    public static float getMaxVolume() {
        return 1.0f;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int getPlaybackRate() {
        return this.native_get_playback_rate();
    }

    public PlaybackParams getPlaybackParams() {
        return this.native_get_playback_params();
    }

    public int getAudioFormat() {
        return this.mAudioFormat;
    }

    public int getStreamType() {
        return this.mStreamType;
    }

    public int getChannelConfiguration() {
        return this.mChannelConfiguration;
    }

    public AudioFormat getFormat() {
        AudioFormat.Builder builder = new AudioFormat.Builder().setSampleRate(this.mSampleRate).setEncoding(this.mAudioFormat);
        if (this.mChannelConfiguration != 0) {
            builder.setChannelMask(this.mChannelConfiguration);
        }
        if (this.mChannelIndexMask != 0) {
            builder.setChannelIndexMask(this.mChannelIndexMask);
        }
        return builder.build();
    }

    public int getChannelCount() {
        return this.mChannelCount;
    }

    public int getState() {
        return this.mState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayState() {
        Object object = this.mPlayStateLock;
        synchronized (object) {
            return this.mPlayState;
        }
    }

    public int getBufferSizeInFrames() {
        return this.native_get_buffer_size_frames();
    }

    public int setBufferSizeInFrames(int bufferSizeInFrames) {
        if (this.mDataLoadMode == 0 || this.mState == 0) {
            return -3;
        }
        if (bufferSizeInFrames < 0) {
            return -2;
        }
        return this.native_set_buffer_size_frames(bufferSizeInFrames);
    }

    public int getBufferCapacityInFrames() {
        return this.native_get_buffer_capacity_frames();
    }

    @Deprecated
    protected int getNativeFrameCount() {
        return this.native_get_buffer_capacity_frames();
    }

    public int getNotificationMarkerPosition() {
        return this.native_get_marker_pos();
    }

    public int getPositionNotificationPeriod() {
        return this.native_get_pos_update_period();
    }

    public int getPlaybackHeadPosition() {
        return this.native_get_position();
    }

    public int getLatency() {
        return this.native_get_latency();
    }

    public int getUnderrunCount() {
        return this.native_get_underrun_count();
    }

    public int getPerformanceMode() {
        int flags = this.native_get_flags();
        if ((flags & 4) != 0) {
            return 1;
        }
        if ((flags & 8) != 0) {
            return 2;
        }
        return 0;
    }

    public static int getNativeOutputSampleRate(int streamType) {
        return AudioTrack.native_get_output_sample_rate(streamType);
    }

    public static int getMinBufferSize(int sampleRateInHz, int channelConfig, int audioFormat) {
        int channelCount = 0;
        switch (channelConfig) {
            case 2: 
            case 4: {
                channelCount = 1;
                break;
            }
            case 3: 
            case 12: {
                channelCount = 2;
                break;
            }
            default: {
                if (!AudioTrack.isMultichannelConfigSupported(channelConfig)) {
                    AudioTrack.loge("getMinBufferSize(): Invalid channel configuration.");
                    return -2;
                }
                channelCount = AudioFormat.channelCountFromOutChannelMask(channelConfig);
            }
        }
        if (!AudioFormat.isPublicEncoding(audioFormat)) {
            AudioTrack.loge("getMinBufferSize(): Invalid audio format.");
            return -2;
        }
        if (sampleRateInHz < 4000 || sampleRateInHz > 192000) {
            AudioTrack.loge("getMinBufferSize(): " + sampleRateInHz + " Hz is not a supported sample rate.");
            return -2;
        }
        int size = AudioTrack.native_get_min_buff_size(sampleRateInHz, channelCount, audioFormat);
        if (size <= 0) {
            AudioTrack.loge("getMinBufferSize(): error querying hardware");
            return -1;
        }
        return size;
    }

    public int getAudioSessionId() {
        return this.mSessionId;
    }

    public boolean getTimestamp(AudioTimestamp timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException();
        }
        long[] longArray = new long[2];
        int ret = this.native_get_timestamp(longArray);
        if (ret != 0) {
            return false;
        }
        timestamp.framePosition = longArray[0];
        timestamp.nanoTime = longArray[1];
        return true;
    }

    public int getTimestampWithStatus(AudioTimestamp timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException();
        }
        long[] longArray = new long[2];
        int ret = this.native_get_timestamp(longArray);
        timestamp.framePosition = longArray[0];
        timestamp.nanoTime = longArray[1];
        return ret;
    }

    public PersistableBundle getMetrics() {
        PersistableBundle bundle = this.native_getMetrics();
        return bundle;
    }

    private native PersistableBundle native_getMetrics();

    public void setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener listener) {
        this.setPlaybackPositionUpdateListener(listener, null);
    }

    public void setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener listener, Handler handler) {
        this.mEventHandlerDelegate = listener != null ? new NativePositionEventHandlerDelegate(this, listener, handler) : null;
    }

    private static float clampGainOrLevel(float gainOrLevel) {
        if (Float.isNaN(gainOrLevel)) {
            throw new IllegalArgumentException();
        }
        if (gainOrLevel < 0.0f) {
            gainOrLevel = 0.0f;
        } else if (gainOrLevel > 1.0f) {
            gainOrLevel = 1.0f;
        }
        return gainOrLevel;
    }

    @Deprecated
    public int setStereoVolume(float leftGain, float rightGain) {
        if (this.mState == 0) {
            return -3;
        }
        this.baseSetVolume(leftGain, rightGain);
        return 0;
    }

    @Override
    void playerSetVolume(boolean muting, float leftVolume, float rightVolume) {
        leftVolume = AudioTrack.clampGainOrLevel(muting ? 0.0f : leftVolume);
        rightVolume = AudioTrack.clampGainOrLevel(muting ? 0.0f : rightVolume);
        this.native_setVolume(leftVolume, rightVolume);
    }

    public int setVolume(float gain) {
        return this.setStereoVolume(gain, gain);
    }

    @Override
    int playerApplyVolumeShaper(VolumeShaper.Configuration configuration, VolumeShaper.Operation operation) {
        return this.native_applyVolumeShaper(configuration, operation);
    }

    @Override
    VolumeShaper.State playerGetVolumeShaperState(int id2) {
        return this.native_getVolumeShaperState(id2);
    }

    @Override
    public VolumeShaper createVolumeShaper(VolumeShaper.Configuration configuration) {
        return new VolumeShaper(configuration, this);
    }

    public int setPlaybackRate(int sampleRateInHz) {
        if (this.mState != 1) {
            return -3;
        }
        if (sampleRateInHz <= 0) {
            return -2;
        }
        return this.native_set_playback_rate(sampleRateInHz);
    }

    public void setPlaybackParams(PlaybackParams params) {
        if (params == null) {
            throw new IllegalArgumentException("params is null");
        }
        this.native_set_playback_params(params);
    }

    public int setNotificationMarkerPosition(int markerInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_marker_pos(markerInFrames);
    }

    public int setPositionNotificationPeriod(int periodInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_pos_update_period(periodInFrames);
    }

    public int setPlaybackHeadPosition(int positionInFrames) {
        if (this.mDataLoadMode == 1 || this.mState == 0 || this.getPlayState() == 3) {
            return -3;
        }
        if (0 > positionInFrames || positionInFrames > this.mNativeBufferSizeInFrames) {
            return -2;
        }
        return this.native_set_position(positionInFrames);
    }

    public int setLoopPoints(int startInFrames, int endInFrames, int loopCount) {
        if (this.mDataLoadMode == 1 || this.mState == 0 || this.getPlayState() == 3) {
            return -3;
        }
        if (loopCount != 0 && (0 > startInFrames || startInFrames >= this.mNativeBufferSizeInFrames || startInFrames >= endInFrames || endInFrames > this.mNativeBufferSizeInFrames)) {
            return -2;
        }
        return this.native_set_loop(startInFrames, endInFrames, loopCount);
    }

    public int setPresentation(AudioPresentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException("audio presentation is null");
        }
        return this.native_setPresentation(presentation.getPresentationId(), presentation.getProgramId());
    }

    @Deprecated
    protected void setState(int state) {
        this.mState = state;
    }

    public void play() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("play() called on uninitialized AudioTrack.");
        }
        final int delay = this.getStartDelayMs();
        if (delay == 0) {
            this.startImpl();
        } else {
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    AudioTrack.this.baseSetStartDelayMs(0);
                    try {
                        AudioTrack.this.startImpl();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startImpl() {
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.baseStart();
            this.native_start();
            this.mPlayState = 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("stop() called on uninitialized AudioTrack.");
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_stop();
            this.baseStop();
            this.mPlayState = 1;
            this.mAvSyncHeader = null;
            this.mAvSyncBytesRemaining = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("pause() called on uninitialized AudioTrack.");
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_pause();
            this.basePause();
            this.mPlayState = 2;
        }
    }

    public void flush() {
        if (this.mState == 1) {
            this.native_flush();
            this.mAvSyncHeader = null;
            this.mAvSyncBytesRemaining = 0;
        }
    }

    public int write(byte[] audioData, int offsetInBytes, int sizeInBytes) {
        return this.write(audioData, offsetInBytes, sizeInBytes, 0);
    }

    public int write(byte[] audioData, int offsetInBytes, int sizeInBytes, int writeMode) {
        if (this.mState == 0 || this.mAudioFormat == 4) {
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e(TAG, "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || offsetInBytes < 0 || sizeInBytes < 0 || offsetInBytes + sizeInBytes < 0 || offsetInBytes + sizeInBytes > audioData.length) {
            return -2;
        }
        int ret = this.native_write_byte(audioData, offsetInBytes, sizeInBytes, this.mAudioFormat, writeMode == 0);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        return ret;
    }

    public int write(short[] audioData, int offsetInShorts, int sizeInShorts) {
        return this.write(audioData, offsetInShorts, sizeInShorts, 0);
    }

    public int write(short[] audioData, int offsetInShorts, int sizeInShorts, int writeMode) {
        if (this.mState == 0 || this.mAudioFormat == 4) {
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e(TAG, "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || offsetInShorts < 0 || sizeInShorts < 0 || offsetInShorts + sizeInShorts < 0 || offsetInShorts + sizeInShorts > audioData.length) {
            return -2;
        }
        int ret = this.native_write_short(audioData, offsetInShorts, sizeInShorts, this.mAudioFormat, writeMode == 0);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        return ret;
    }

    public int write(float[] audioData, int offsetInFloats, int sizeInFloats, int writeMode) {
        if (this.mState == 0) {
            Log.e(TAG, "AudioTrack.write() called in invalid state STATE_UNINITIALIZED");
            return -3;
        }
        if (this.mAudioFormat != 4) {
            Log.e(TAG, "AudioTrack.write(float[] ...) requires format ENCODING_PCM_FLOAT");
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e(TAG, "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || offsetInFloats < 0 || sizeInFloats < 0 || offsetInFloats + sizeInFloats < 0 || offsetInFloats + sizeInFloats > audioData.length) {
            Log.e(TAG, "AudioTrack.write() called with invalid array, offset, or size");
            return -2;
        }
        int ret = this.native_write_float(audioData, offsetInFloats, sizeInFloats, this.mAudioFormat, writeMode == 0);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        return ret;
    }

    public int write(ByteBuffer audioData, int sizeInBytes, int writeMode) {
        if (this.mState == 0) {
            Log.e(TAG, "AudioTrack.write() called in invalid state STATE_UNINITIALIZED");
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e(TAG, "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || sizeInBytes < 0 || sizeInBytes > audioData.remaining()) {
            Log.e(TAG, "AudioTrack.write() called with invalid size (" + sizeInBytes + ") value");
            return -2;
        }
        int ret = 0;
        ret = audioData.isDirect() ? this.native_write_native_bytes(audioData, audioData.position(), sizeInBytes, this.mAudioFormat, writeMode == 0) : this.native_write_byte(NioUtils.unsafeArray(audioData), NioUtils.unsafeArrayOffset(audioData) + audioData.position(), sizeInBytes, this.mAudioFormat, writeMode == 0);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        if (ret > 0) {
            audioData.position(audioData.position() + ret);
        }
        return ret;
    }

    public int write(ByteBuffer audioData, int sizeInBytes, int writeMode, long timestamp) {
        int sizeToWrite;
        if (this.mState == 0) {
            Log.e(TAG, "AudioTrack.write() called in invalid state STATE_UNINITIALIZED");
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e(TAG, "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (this.mDataLoadMode != 1) {
            Log.e(TAG, "AudioTrack.write() with timestamp called for non-streaming mode track");
            return -3;
        }
        if ((this.mAttributes.getFlags() & 0x10) == 0) {
            Log.d(TAG, "AudioTrack.write() called on a regular AudioTrack. Ignoring pts...");
            return this.write(audioData, sizeInBytes, writeMode);
        }
        if (audioData == null || sizeInBytes < 0 || sizeInBytes > audioData.remaining()) {
            Log.e(TAG, "AudioTrack.write() called with invalid size (" + sizeInBytes + ") value");
            return -2;
        }
        if (this.mAvSyncHeader == null) {
            this.mAvSyncHeader = ByteBuffer.allocate(this.mOffset);
            this.mAvSyncHeader.order(ByteOrder.BIG_ENDIAN);
            this.mAvSyncHeader.putInt(0x55550002);
        }
        if (this.mAvSyncBytesRemaining == 0) {
            this.mAvSyncHeader.putInt(4, sizeInBytes);
            this.mAvSyncHeader.putLong(8, timestamp);
            this.mAvSyncHeader.putInt(16, this.mOffset);
            this.mAvSyncHeader.position(0);
            this.mAvSyncBytesRemaining = sizeInBytes;
        }
        int ret = 0;
        if (this.mAvSyncHeader.remaining() != 0) {
            ret = this.write(this.mAvSyncHeader, this.mAvSyncHeader.remaining(), writeMode);
            if (ret < 0) {
                Log.e(TAG, "AudioTrack.write() could not write timestamp header!");
                this.mAvSyncHeader = null;
                this.mAvSyncBytesRemaining = 0;
                return ret;
            }
            if (this.mAvSyncHeader.remaining() > 0) {
                Log.v(TAG, "AudioTrack.write() partial timestamp header written.");
                return 0;
            }
        }
        if ((ret = this.write(audioData, sizeToWrite = Math.min(this.mAvSyncBytesRemaining, sizeInBytes), writeMode)) < 0) {
            Log.e(TAG, "AudioTrack.write() could not write audio data!");
            this.mAvSyncHeader = null;
            this.mAvSyncBytesRemaining = 0;
            return ret;
        }
        this.mAvSyncBytesRemaining -= ret;
        return ret;
    }

    public int reloadStaticData() {
        if (this.mDataLoadMode == 1 || this.mState != 1) {
            return -3;
        }
        return this.native_reload_static();
    }

    public int attachAuxEffect(int effectId) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_attachAuxEffect(effectId);
    }

    public int setAuxEffectSendLevel(float level) {
        if (this.mState == 0) {
            return -3;
        }
        return this.baseSetAuxEffectSendLevel(level);
    }

    @Override
    int playerSetAuxEffectSendLevel(boolean muting, float level) {
        level = AudioTrack.clampGainOrLevel(muting ? 0.0f : level);
        int err = this.native_setAuxEffectSendLevel(level);
        return err == 0 ? 0 : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPreferredDevice(AudioDeviceInfo deviceInfo) {
        if (deviceInfo != null && !deviceInfo.isSink()) {
            return false;
        }
        int preferredDeviceId = deviceInfo != null ? deviceInfo.getId() : 0;
        boolean status = this.native_setOutputDevice(preferredDeviceId);
        if (status) {
            AudioTrack audioTrack = this;
            synchronized (audioTrack) {
                this.mPreferredDevice = deviceInfo;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioDeviceInfo getPreferredDevice() {
        AudioTrack audioTrack = this;
        synchronized (audioTrack) {
            return this.mPreferredDevice;
        }
    }

    @Override
    public AudioDeviceInfo getRoutedDevice() {
        int deviceId = this.native_getRoutedDeviceId();
        if (deviceId == 0) {
            return null;
        }
        AudioDeviceInfo[] devices = AudioManager.getDevicesStatic(2);
        for (int i = 0; i < devices.length; ++i) {
            if (devices[i].getId() != deviceId) continue;
            return devices[i];
        }
        return null;
    }

    private void testEnableNativeRoutingCallbacksLocked() {
        if (this.mRoutingChangeListeners.size() == 0) {
            this.native_enableDeviceCallback();
        }
    }

    private void testDisableNativeRoutingCallbacksLocked() {
        if (this.mRoutingChangeListeners.size() == 0) {
            this.native_disableDeviceCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener, Handler handler) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (listener != null && !this.mRoutingChangeListeners.containsKey(listener)) {
                this.testEnableNativeRoutingCallbacksLocked();
                this.mRoutingChangeListeners.put(listener, new NativeRoutingEventHandlerDelegate(this, listener, handler != null ? handler : new Handler(this.mInitializationLooper)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (this.mRoutingChangeListeners.containsKey(listener)) {
                this.mRoutingChangeListeners.remove(listener);
            }
            this.testDisableNativeRoutingCallbacksLocked();
        }
    }

    @Deprecated
    public void addOnRoutingChangedListener(OnRoutingChangedListener listener, Handler handler) {
        this.addOnRoutingChangedListener((AudioRouting.OnRoutingChangedListener)listener, handler);
    }

    @Deprecated
    public void removeOnRoutingChangedListener(OnRoutingChangedListener listener) {
        this.removeOnRoutingChangedListener((AudioRouting.OnRoutingChangedListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastRoutingChange() {
        AudioManager.resetAudioPortGeneration();
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            for (NativeRoutingEventHandlerDelegate delegate : this.mRoutingChangeListeners.values()) {
                delegate.notifyClient();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamEventCallback(Executor executor, StreamEventCallback eventCallback) {
        if (eventCallback == null) {
            throw new IllegalArgumentException("Illegal null StreamEventCallback");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Illegal null Executor for the StreamEventCallback");
        }
        Object object = this.mStreamEventCbLock;
        synchronized (object) {
            this.mStreamEventExec = executor;
            this.mStreamEventCb = eventCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStreamEventCallback() {
        Object object = this.mStreamEventCbLock;
        synchronized (object) {
            this.mStreamEventExec = null;
            this.mStreamEventCb = null;
        }
    }

    @Override
    void playerStart() {
        this.play();
    }

    @Override
    void playerPause() {
        this.pause();
    }

    @Override
    void playerStop() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void postEventFromNative(Object audiotrack_ref, int what, int arg1, int arg2, Object obj) {
        Handler handler;
        NativePositionEventHandlerDelegate delegate;
        AudioTrack track = (AudioTrack)((WeakReference)audiotrack_ref).get();
        if (track == null) {
            return;
        }
        if (what == 1000) {
            track.broadcastRoutingChange();
            return;
        }
        if (what == 0 || what == 6 || what == 7) {
            StreamEventCallback cb;
            Executor exec;
            Object object = track.mStreamEventCbLock;
            synchronized (object) {
                exec = track.mStreamEventExec;
                cb = track.mStreamEventCb;
            }
            if (exec == null || cb == null) {
                return;
            }
            switch (what) {
                case 0: {
                    exec.execute(() -> cb.onStreamDataRequest(track));
                    return;
                }
                case 6: {
                    exec.execute(() -> cb.onTearDown(track));
                    return;
                }
                case 7: {
                    exec.execute(() -> cb.onStreamPresentationEnd(track));
                    return;
                }
            }
        }
        if ((delegate = track.mEventHandlerDelegate) != null && (handler = delegate.getHandler()) != null) {
            Message m = handler.obtainMessage(what, arg1, arg2, obj);
            handler.sendMessage(m);
        }
    }

    private final native int native_setup(Object var1, Object var2, int[] var3, int var4, int var5, int var6, int var7, int var8, int[] var9, long var10, boolean var12);

    private final native void native_finalize();

    public final native void native_release();

    private final native void native_start();

    private final native void native_stop();

    private final native void native_pause();

    private final native void native_flush();

    private final native int native_write_byte(byte[] var1, int var2, int var3, int var4, boolean var5);

    private final native int native_write_short(short[] var1, int var2, int var3, int var4, boolean var5);

    private final native int native_write_float(float[] var1, int var2, int var3, int var4, boolean var5);

    private final native int native_write_native_bytes(Object var1, int var2, int var3, int var4, boolean var5);

    private final native int native_reload_static();

    private final native int native_get_buffer_size_frames();

    private final native int native_set_buffer_size_frames(int var1);

    private final native int native_get_buffer_capacity_frames();

    private final native void native_setVolume(float var1, float var2);

    private final native int native_set_playback_rate(int var1);

    private final native int native_get_playback_rate();

    private final native void native_set_playback_params(PlaybackParams var1);

    private final native PlaybackParams native_get_playback_params();

    private final native int native_set_marker_pos(int var1);

    private final native int native_get_marker_pos();

    private final native int native_set_pos_update_period(int var1);

    private final native int native_get_pos_update_period();

    private final native int native_set_position(int var1);

    private final native int native_get_position();

    private final native int native_get_latency();

    private final native int native_get_underrun_count();

    private final native int native_get_flags();

    private final native int native_get_timestamp(long[] var1);

    private final native int native_set_loop(int var1, int var2, int var3);

    private static final native int native_get_output_sample_rate(int var0);

    private static final native int native_get_min_buff_size(int var0, int var1, int var2);

    private final native int native_attachAuxEffect(int var1);

    private final native int native_setAuxEffectSendLevel(float var1);

    private final native boolean native_setOutputDevice(int var1);

    private final native int native_getRoutedDeviceId();

    private final native void native_enableDeviceCallback();

    private final native void native_disableDeviceCallback();

    private static native int native_get_FCC_8();

    private native int native_applyVolumeShaper(VolumeShaper.Configuration var1, VolumeShaper.Operation var2);

    private native VolumeShaper.State native_getVolumeShaperState(int var1);

    private final native int native_setPresentation(int var1, int var2);

    private static void logd(String msg) {
        Log.d(TAG, msg);
    }

    private static void loge(String msg) {
        Log.e(TAG, msg);
    }

    public static final class MetricsConstants {
        public static final String STREAMTYPE = "android.media.audiotrack.streamtype";
        public static final String CONTENTTYPE = "android.media.audiotrack.type";
        public static final String USAGE = "android.media.audiotrack.usage";
        public static final String SAMPLERATE = "android.media.audiorecord.samplerate";
        public static final String CHANNELMASK = "android.media.audiorecord.channelmask";

        private MetricsConstants() {
        }
    }

    private class NativePositionEventHandlerDelegate {
        private final Handler mHandler;

        NativePositionEventHandlerDelegate(final AudioTrack track, final OnPlaybackPositionUpdateListener listener, Handler handler) {
            Looper looper = handler != null ? handler.getLooper() : AudioTrack.this.mInitializationLooper;
            this.mHandler = looper != null ? new Handler(looper){

                @Override
                public void handleMessage(Message msg) {
                    if (track == null) {
                        return;
                    }
                    switch (msg.what) {
                        case 3: {
                            if (listener == null) break;
                            listener.onMarkerReached(track);
                            break;
                        }
                        case 4: {
                            if (listener == null) break;
                            listener.onPeriodicNotification(track);
                            break;
                        }
                        default: {
                            AudioTrack.loge("Unknown native event type: " + msg.what);
                        }
                    }
                }
            } : null;
        }

        Handler getHandler() {
            return this.mHandler;
        }
    }

    public static abstract class StreamEventCallback {
        public void onTearDown(AudioTrack track) {
        }

        public void onStreamPresentationEnd(AudioTrack track) {
        }

        public void onStreamDataRequest(AudioTrack track) {
        }
    }

    public static interface OnPlaybackPositionUpdateListener {
        public void onMarkerReached(AudioTrack var1);

        public void onPeriodicNotification(AudioTrack var1);
    }

    @Deprecated
    public static interface OnRoutingChangedListener
    extends AudioRouting.OnRoutingChangedListener {
        public void onRoutingChanged(AudioTrack var1);

        @Override
        default public void onRoutingChanged(AudioRouting router) {
            if (router instanceof AudioTrack) {
                this.onRoutingChanged((AudioTrack)router);
            }
        }
    }

    public static class Builder {
        private AudioAttributes mAttributes;
        private AudioFormat mFormat;
        private int mBufferSizeInBytes;
        private int mSessionId = 0;
        private int mMode = 1;
        private int mPerformanceMode = 0;
        private boolean mOffload = false;

        public Builder setAudioAttributes(AudioAttributes attributes) throws IllegalArgumentException {
            if (attributes == null) {
                throw new IllegalArgumentException("Illegal null AudioAttributes argument");
            }
            this.mAttributes = attributes;
            return this;
        }

        public Builder setAudioFormat(AudioFormat format) throws IllegalArgumentException {
            if (format == null) {
                throw new IllegalArgumentException("Illegal null AudioFormat argument");
            }
            this.mFormat = format;
            return this;
        }

        public Builder setBufferSizeInBytes(int bufferSizeInBytes) throws IllegalArgumentException {
            if (bufferSizeInBytes <= 0) {
                throw new IllegalArgumentException("Invalid buffer size " + bufferSizeInBytes);
            }
            this.mBufferSizeInBytes = bufferSizeInBytes;
            return this;
        }

        public Builder setTransferMode(int mode) throws IllegalArgumentException {
            switch (mode) {
                case 0: 
                case 1: {
                    this.mMode = mode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid transfer mode " + mode);
                }
            }
            return this;
        }

        public Builder setSessionId(int sessionId) throws IllegalArgumentException {
            if (sessionId != 0 && sessionId < 1) {
                throw new IllegalArgumentException("Invalid audio session ID " + sessionId);
            }
            this.mSessionId = sessionId;
            return this;
        }

        public Builder setPerformanceMode(int performanceMode) {
            switch (performanceMode) {
                case 0: 
                case 1: 
                case 2: {
                    this.mPerformanceMode = performanceMode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid performance mode " + performanceMode);
                }
            }
            return this;
        }

        public Builder setOffloadedPlayback(boolean offload) {
            this.mOffload = offload;
            return this;
        }

        public AudioTrack build() throws UnsupportedOperationException {
            if (this.mAttributes == null) {
                this.mAttributes = new AudioAttributes.Builder().setUsage(1).build();
            }
            switch (this.mPerformanceMode) {
                case 1: {
                    this.mAttributes = new AudioAttributes.Builder(this.mAttributes).replaceFlags((this.mAttributes.getAllFlags() | 0x100) & 0xFFFFFDFF).build();
                    break;
                }
                case 0: {
                    if (!AudioTrack.shouldEnablePowerSaving(this.mAttributes, this.mFormat, this.mBufferSizeInBytes, this.mMode)) break;
                }
                case 2: {
                    this.mAttributes = new AudioAttributes.Builder(this.mAttributes).replaceFlags((this.mAttributes.getAllFlags() | 0x200) & 0xFFFFFEFF).build();
                }
            }
            if (this.mFormat == null) {
                this.mFormat = new AudioFormat.Builder().setChannelMask(12).setEncoding(1).build();
            }
            if (this.mOffload) {
                if (this.mAttributes.getUsage() != 1) {
                    throw new UnsupportedOperationException("Cannot create AudioTrack, offload requires USAGE_MEDIA");
                }
                if (!AudioSystem.isOffloadSupported(this.mFormat)) {
                    throw new UnsupportedOperationException("Cannot create AudioTrack, offload format not supported");
                }
            }
            try {
                AudioTrack track;
                if (this.mMode == 1 && this.mBufferSizeInBytes == 0) {
                    this.mBufferSizeInBytes = this.mFormat.getChannelCount() * AudioFormat.getBytesPerSample(this.mFormat.getEncoding());
                }
                if ((track = new AudioTrack(this.mAttributes, this.mFormat, this.mBufferSizeInBytes, this.mMode, this.mSessionId, this.mOffload)).getState() == 0) {
                    throw new UnsupportedOperationException("Cannot create AudioTrack");
                }
                return track;
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedOperationException(e.getMessage());
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PerformanceMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WriteMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TransferMode {
    }
}

