/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.media.Cea608CCWidget;
import android.media.Cea608CaptionTrack;
import android.media.MediaFormat;
import android.media.SubtitleController;
import android.media.SubtitleTrack;

public class ClosedCaptionRenderer
extends SubtitleController.Renderer {
    private final Context mContext;
    private Cea608CCWidget mCCWidget;

    public ClosedCaptionRenderer(Context context) {
        this.mContext = context;
    }

    @Override
    public boolean supports(MediaFormat format) {
        if (format.containsKey("mime")) {
            String mimeType = format.getString("mime");
            return "text/cea-608".equals(mimeType);
        }
        return false;
    }

    @Override
    public SubtitleTrack createTrack(MediaFormat format) {
        String mimeType = format.getString("mime");
        if ("text/cea-608".equals(mimeType)) {
            if (this.mCCWidget == null) {
                this.mCCWidget = new Cea608CCWidget(this.mContext);
            }
            return new Cea608CaptionTrack(this.mCCWidget, format);
        }
        throw new RuntimeException("No matching format: " + format.toString());
    }
}

