/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.MediaItem2;
import android.media.MediaSession2;
import android.media.PlaybackState2;
import android.media.Rating2;
import android.media.SessionToken2;
import android.media.update.ApiLoader;
import android.media.update.MediaController2Provider;
import android.net.Uri;
import android.os.Bundle;
import android.os.ResultReceiver;
import java.util.List;
import java.util.concurrent.Executor;

public class MediaController2
implements AutoCloseable {
    private final MediaController2Provider mProvider;

    public MediaController2(Context context, SessionToken2 token, Executor executor, ControllerCallback callback) {
        this.mProvider = this.createProvider(context, token, executor, callback);
        this.mProvider.initialize();
    }

    MediaController2Provider createProvider(Context context, SessionToken2 token, Executor executor, ControllerCallback callback) {
        return ApiLoader.getProvider(context).createMediaController2(context, this, token, executor, callback);
    }

    @Override
    public void close() {
        this.mProvider.close_impl();
    }

    @SystemApi
    public MediaController2Provider getProvider() {
        return this.mProvider;
    }

    public SessionToken2 getSessionToken() {
        return this.mProvider.getSessionToken_impl();
    }

    public boolean isConnected() {
        return this.mProvider.isConnected_impl();
    }

    public void play() {
        this.mProvider.play_impl();
    }

    public void pause() {
        this.mProvider.pause_impl();
    }

    public void stop() {
        this.mProvider.stop_impl();
    }

    public void skipToPrevious() {
        this.mProvider.skipToPrevious_impl();
    }

    public void skipToNext() {
        this.mProvider.skipToNext_impl();
    }

    public void prepare() {
        this.mProvider.prepare_impl();
    }

    public void fastForward() {
        this.mProvider.fastForward_impl();
    }

    public void rewind() {
        this.mProvider.rewind_impl();
    }

    public void seekTo(long pos) {
        this.mProvider.seekTo_impl(pos);
    }

    public void setCurrentPlaylistItem(int index) {
        this.mProvider.setCurrentPlaylistItem_impl(index);
    }

    public void setPlaylistParams(MediaSession2.PlaylistParams params) {
        this.mProvider.setPlaylistParams_impl(params);
    }

    public void skipForward() {
    }

    public void skipBackward() {
    }

    public void playFromMediaId(String mediaId, Bundle extras) {
        this.mProvider.playFromMediaId_impl(mediaId, extras);
    }

    public void playFromSearch(String query, Bundle extras) {
        this.mProvider.playFromSearch_impl(query, extras);
    }

    public void playFromUri(Uri uri, Bundle extras) {
        this.mProvider.playFromUri_impl(uri, extras);
    }

    public void prepareFromMediaId(String mediaId, Bundle extras) {
        this.mProvider.prepareMediaId_impl(mediaId, extras);
    }

    public void prepareFromSearch(String query, Bundle extras) {
        this.mProvider.prepareFromSearch_impl(query, extras);
    }

    public void prepareFromUri(Uri uri, Bundle extras) {
        this.mProvider.prepareFromUri_impl(uri, extras);
    }

    public void setVolumeTo(int value, int flags) {
        this.mProvider.setVolumeTo_impl(value, flags);
    }

    public void adjustVolume(int direction, int flags) {
        this.mProvider.adjustVolume_impl(direction, flags);
    }

    public int getRatingType() {
        return this.mProvider.getRatingType_impl();
    }

    public PendingIntent getSessionActivity() {
        return this.mProvider.getSessionActivity_impl();
    }

    public PlaybackState2 getPlaybackState() {
        return this.mProvider.getPlaybackState_impl();
    }

    public PlaybackInfo getPlaybackInfo() {
        return this.mProvider.getPlaybackInfo_impl();
    }

    public void setRating(Rating2 rating) {
        this.mProvider.setRating_impl(rating);
    }

    public void sendCustomCommand(MediaSession2.Command command, Bundle args, ResultReceiver cb) {
        this.mProvider.sendCustomCommand_impl(command, args, cb);
    }

    public List<MediaItem2> getPlaylist() {
        return this.mProvider.getPlaylist_impl();
    }

    public MediaSession2.PlaylistParams getPlaylistParams() {
        return this.mProvider.getPlaylistParams_impl();
    }

    public void removePlaylistItem(MediaItem2 item) {
        this.mProvider.removePlaylistItem_impl(item);
    }

    public void addPlaylistItem(int index, MediaItem2 item) {
        this.mProvider.addPlaylistItem_impl(index, item);
    }

    public static final class PlaybackInfo {
        public static final int PLAYBACK_TYPE_REMOTE = 2;
        public static final int PLAYBACK_TYPE_LOCAL = 1;
        private final MediaController2Provider.PlaybackInfoProvider mProvider;

        @SystemApi
        public PlaybackInfo(MediaController2Provider.PlaybackInfoProvider provider) {
            this.mProvider = provider;
        }

        @SystemApi
        public MediaController2Provider.PlaybackInfoProvider getProvider() {
            return this.mProvider;
        }

        public int getPlaybackType() {
            return this.mProvider.getPlaybackType_impl();
        }

        public AudioAttributes getAudioAttributes() {
            return this.mProvider.getAudioAttributes_impl();
        }

        public int getControlType() {
            return this.mProvider.getControlType_impl();
        }

        public int getMaxVolume() {
            return this.mProvider.getMaxVolume_impl();
        }

        public int getCurrentVolume() {
            return this.mProvider.getCurrentVolume_impl();
        }
    }

    public static abstract class ControllerCallback {
        public void onConnected(MediaSession2.CommandGroup allowedCommands) {
        }

        public void onDisconnected() {
        }

        public void onCustomLayoutChanged(List<MediaSession2.CommandButton> layout2) {
        }

        public void onPlaybackInfoChanged(PlaybackInfo info) {
        }

        public void onAllowedCommandsChanged(MediaSession2.CommandGroup commands) {
        }

        public void onCustomCommand(MediaSession2.Command command, Bundle args, ResultReceiver receiver) {
        }

        public void onPlaylistChanged(List<MediaItem2> playlist) {
        }

        public void onPlaybackStateChanged(PlaybackState2 state) {
        }

        public void onPlaylistParamsChanged(MediaSession2.PlaylistParams params) {
        }
    }
}

