/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioPresentation;
import android.media.DrmInitData;
import android.media.MediaCas;
import android.media.MediaCodec;
import android.media.MediaDataSource;
import android.media.MediaFormat;
import android.media.MediaHTTPService;
import android.net.Uri;
import android.os.IBinder;
import android.os.IHwBinder;
import android.os.PersistableBundle;
import com.android.internal.util.Preconditions;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class MediaExtractor {
    public static final int SEEK_TO_PREVIOUS_SYNC = 0;
    public static final int SEEK_TO_NEXT_SYNC = 1;
    public static final int SEEK_TO_CLOSEST_SYNC = 2;
    public static final int SAMPLE_FLAG_SYNC = 1;
    public static final int SAMPLE_FLAG_ENCRYPTED = 2;
    public static final int SAMPLE_FLAG_PARTIAL_FRAME = 4;
    private MediaCas mMediaCas;
    private long mNativeContext;

    public MediaExtractor() {
        this.native_setup();
    }

    public final native void setDataSource(MediaDataSource var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDataSource(Context context, Uri uri, Map<String, String> headers) throws IOException {
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.setDataSource(uri.getPath());
            return;
        }
        try (AssetFileDescriptor fd = null;){
            ContentResolver resolver = context.getContentResolver();
            fd = resolver.openAssetFileDescriptor(uri, "r");
            if (fd == null) {
                return;
            }
            if (fd.getDeclaredLength() < 0L) {
                this.setDataSource(fd.getFileDescriptor());
            } else {
                this.setDataSource(fd.getFileDescriptor(), fd.getStartOffset(), fd.getDeclaredLength());
            }
            return;
        }
        this.setDataSource(uri.toString(), headers);
    }

    public final void setDataSource(String path, Map<String, String> headers) throws IOException {
        String[] keys = null;
        String[] values = null;
        if (headers != null) {
            keys = new String[headers.size()];
            values = new String[headers.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
        }
        this.nativeSetDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(path), path, keys, values);
    }

    private final native void nativeSetDataSource(IBinder var1, String var2, String[] var3, String[] var4) throws IOException;

    public final void setDataSource(String path) throws IOException {
        this.nativeSetDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(path), path, null, null);
    }

    public final void setDataSource(AssetFileDescriptor afd) throws IOException, IllegalArgumentException, IllegalStateException {
        Preconditions.checkNotNull(afd);
        if (afd.getDeclaredLength() < 0L) {
            this.setDataSource(afd.getFileDescriptor());
        } else {
            this.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getDeclaredLength());
        }
    }

    public final void setDataSource(FileDescriptor fd) throws IOException {
        this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    public final native void setDataSource(FileDescriptor var1, long var2, long var4) throws IOException;

    public final void setMediaCas(MediaCas mediaCas) {
        this.mMediaCas = mediaCas;
        this.nativeSetMediaCas(mediaCas.getBinder());
    }

    private final native void nativeSetMediaCas(IHwBinder var1);

    private ArrayList<Byte> toByteArray(byte[] data) {
        ArrayList<Byte> byteArray = new ArrayList<Byte>(data.length);
        for (int i = 0; i < data.length; ++i) {
            byteArray.add(i, data[i]);
        }
        return byteArray;
    }

    public CasInfo getCasInfo(int index) {
        Map<String, Object> formatMap = this.getTrackFormatNative(index);
        if (formatMap.containsKey("ca-system-id")) {
            int systemId = (Integer)formatMap.get("ca-system-id");
            MediaCas.Session session = null;
            if (this.mMediaCas != null && formatMap.containsKey("ca-session-id")) {
                ByteBuffer buf = (ByteBuffer)formatMap.get("ca-session-id");
                buf.rewind();
                byte[] sessionId = new byte[buf.remaining()];
                buf.get(sessionId);
                session = this.mMediaCas.createFromSessionId(this.toByteArray(sessionId));
            }
            return new CasInfo(systemId, session);
        }
        return null;
    }

    protected void finalize() {
        this.native_finalize();
    }

    public final native void release();

    public final native int getTrackCount();

    public DrmInitData getDrmInitData() {
        Map<String, Object> formatMap = this.getFileFormatNative();
        if (formatMap == null) {
            return null;
        }
        if (formatMap.containsKey("pssh")) {
            Map<UUID, byte[]> psshMap = this.getPsshInfo();
            final HashMap<UUID, DrmInitData.SchemeInitData> initDataMap = new HashMap<UUID, DrmInitData.SchemeInitData>();
            for (Map.Entry<UUID, byte[]> e : psshMap.entrySet()) {
                UUID uuid = e.getKey();
                byte[] data = e.getValue();
                initDataMap.put(uuid, new DrmInitData.SchemeInitData("cenc", data));
            }
            return new DrmInitData(){

                @Override
                public DrmInitData.SchemeInitData get(UUID schemeUuid) {
                    return (DrmInitData.SchemeInitData)initDataMap.get(schemeUuid);
                }
            };
        }
        int numTracks = this.getTrackCount();
        for (int i = 0; i < numTracks; ++i) {
            Map<String, Object> trackFormatMap = this.getTrackFormatNative(i);
            if (!trackFormatMap.containsKey("crypto-key")) continue;
            ByteBuffer buf = (ByteBuffer)trackFormatMap.get("crypto-key");
            buf.rewind();
            final byte[] data = new byte[buf.remaining()];
            buf.get(data);
            return new DrmInitData(){

                @Override
                public DrmInitData.SchemeInitData get(UUID schemeUuid) {
                    return new DrmInitData.SchemeInitData("webm", data);
                }
            };
        }
        return null;
    }

    public List<AudioPresentation> getAudioPresentations(int trackIndex) {
        return new ArrayList<AudioPresentation>();
    }

    public Map<UUID, byte[]> getPsshInfo() {
        HashMap<UUID, byte[]> psshMap = null;
        Map<String, Object> formatMap = this.getFileFormatNative();
        if (formatMap != null && formatMap.containsKey("pssh")) {
            ByteBuffer rawpssh = (ByteBuffer)formatMap.get("pssh");
            rawpssh.order(ByteOrder.nativeOrder());
            rawpssh.rewind();
            formatMap.remove("pssh");
            psshMap = new HashMap<UUID, byte[]>();
            while (rawpssh.remaining() > 0) {
                rawpssh.order(ByteOrder.BIG_ENDIAN);
                long msb = rawpssh.getLong();
                long lsb = rawpssh.getLong();
                UUID uuid = new UUID(msb, lsb);
                rawpssh.order(ByteOrder.nativeOrder());
                int datalen = rawpssh.getInt();
                byte[] psshdata = new byte[datalen];
                rawpssh.get(psshdata);
                psshMap.put(uuid, psshdata);
            }
        }
        return psshMap;
    }

    private native Map<String, Object> getFileFormatNative();

    public MediaFormat getTrackFormat(int index) {
        return new MediaFormat(this.getTrackFormatNative(index));
    }

    private native Map<String, Object> getTrackFormatNative(int var1);

    public native void selectTrack(int var1);

    public native void unselectTrack(int var1);

    public native void seekTo(long var1, int var3);

    public native boolean advance();

    public native int readSampleData(ByteBuffer var1, int var2);

    public native int getSampleTrackIndex();

    public native long getSampleTime();

    public native long getSampleSize();

    public native int getSampleFlags();

    public native boolean getSampleCryptoInfo(MediaCodec.CryptoInfo var1);

    public native long getCachedDuration();

    public native boolean hasCacheReachedEndOfStream();

    public PersistableBundle getMetrics() {
        PersistableBundle bundle = this.native_getMetrics();
        return bundle;
    }

    private native PersistableBundle native_getMetrics();

    private static final native void native_init();

    private final native void native_setup();

    private final native void native_finalize();

    static {
        System.loadLibrary("media_jni");
        MediaExtractor.native_init();
    }

    public static final class MetricsConstants {
        public static final String FORMAT = "android.media.mediaextractor.fmt";
        public static final String MIME_TYPE = "android.media.mediaextractor.mime";
        public static final String TRACKS = "android.media.mediaextractor.ntrk";

        private MetricsConstants() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SampleFlag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SeekMode {
    }

    public static final class CasInfo {
        private final int mSystemId;
        private final MediaCas.Session mSession;

        CasInfo(int systemId, MediaCas.Session session) {
            this.mSystemId = systemId;
            this.mSession = session;
        }

        public int getSystemId() {
            return this.mSystemId;
        }

        public MediaCas.Session getSession() {
            return this.mSession;
        }
    }
}

