/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SystemApi;
import android.content.Context;
import android.media.DataSourceDesc;
import android.media.MediaMetadata2;
import android.media.update.ApiLoader;
import android.media.update.MediaItem2Provider;
import android.os.Bundle;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class MediaItem2 {
    public static final int FLAG_BROWSABLE = 1;
    public static final int FLAG_PLAYABLE = 2;
    private final MediaItem2Provider mProvider;

    public MediaItem2(Context context, String mediaId, DataSourceDesc dsd, MediaMetadata2 metadata, int flags) {
        this.mProvider = ApiLoader.getProvider(context).createMediaItem2(context, this, mediaId, dsd, metadata, flags);
    }

    @SystemApi
    public MediaItem2(MediaItem2Provider provider) {
        this.mProvider = provider;
    }

    public Bundle toBundle() {
        return this.mProvider.toBundle_impl();
    }

    public static MediaItem2 fromBundle(Context context, Bundle bundle) {
        return ApiLoader.getProvider(context).fromBundle_MediaItem2(context, bundle);
    }

    public String toString() {
        return this.mProvider.toString_impl();
    }

    public int getFlags() {
        return this.mProvider.getFlags_impl();
    }

    public boolean isBrowsable() {
        return this.mProvider.isBrowsable_impl();
    }

    public boolean isPlayable() {
        return this.mProvider.isPlayable_impl();
    }

    public void setMetadata(MediaMetadata2 metadata) {
        this.mProvider.setMetadata_impl(metadata);
    }

    public MediaMetadata2 getMetadata() {
        return this.mProvider.getMetadata_impl();
    }

    public String getMediaId() {
        return this.mProvider.getMediaId_impl();
    }

    public DataSourceDesc getDataSourceDesc() {
        return this.mProvider.getDataSourceDesc_impl();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

