/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaCodec;
import android.media.MediaFormat;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.Map;

public final class MediaMuxer {
    private static final int MUXER_STATE_UNINITIALIZED = -1;
    private static final int MUXER_STATE_INITIALIZED = 0;
    private static final int MUXER_STATE_STARTED = 1;
    private static final int MUXER_STATE_STOPPED = 2;
    private int mState = -1;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private int mLastTrackIndex = -1;
    private long mNativeObject;

    private static native long nativeSetup(FileDescriptor var0, int var1) throws IllegalArgumentException, IOException;

    private static native void nativeRelease(long var0);

    private static native void nativeStart(long var0);

    private static native void nativeStop(long var0);

    private static native int nativeAddTrack(long var0, String[] var2, Object[] var3);

    private static native void nativeSetOrientationHint(long var0, int var2);

    private static native void nativeSetLocation(long var0, int var2, int var3);

    private static native void nativeWriteSampleData(long var0, int var2, ByteBuffer var3, int var4, int var5, long var6, int var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaMuxer(String path, int format) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        try (RandomAccessFile file = null;){
            file = new RandomAccessFile(path, "rws");
            FileDescriptor fd = file.getFD();
            this.setUpMediaMuxer(fd, format);
        }
    }

    public MediaMuxer(FileDescriptor fd, int format) throws IOException {
        this.setUpMediaMuxer(fd, format);
    }

    private void setUpMediaMuxer(FileDescriptor fd, int format) throws IOException {
        if (format < 0 || format > 3) {
            throw new IllegalArgumentException("format: " + format + " is invalid");
        }
        this.mNativeObject = MediaMuxer.nativeSetup(fd, format);
        this.mState = 0;
        this.mCloseGuard.open("release");
    }

    public void setOrientationHint(int degrees) {
        if (degrees != 0 && degrees != 90 && degrees != 180 && degrees != 270) {
            throw new IllegalArgumentException("Unsupported angle: " + degrees);
        }
        if (this.mState != 0) {
            throw new IllegalStateException("Can't set rotation degrees due to wrong state.");
        }
        MediaMuxer.nativeSetOrientationHint(this.mNativeObject, degrees);
    }

    public void setLocation(float latitude, float longitude) {
        int latitudex10000 = (int)((double)(latitude * 10000.0f) + 0.5);
        int longitudex10000 = (int)((double)(longitude * 10000.0f) + 0.5);
        if (latitudex10000 > 900000 || latitudex10000 < -900000) {
            String msg = "Latitude: " + latitude + " out of range.";
            throw new IllegalArgumentException(msg);
        }
        if (longitudex10000 > 1800000 || longitudex10000 < -1800000) {
            String msg = "Longitude: " + longitude + " out of range";
            throw new IllegalArgumentException(msg);
        }
        if (this.mState != 0 || this.mNativeObject == 0L) {
            throw new IllegalStateException("Can't set location due to wrong state.");
        }
        MediaMuxer.nativeSetLocation(this.mNativeObject, latitudex10000, longitudex10000);
    }

    public void start() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Muxer has been released!");
        }
        if (this.mState != 0) {
            throw new IllegalStateException("Can't start due to wrong state.");
        }
        MediaMuxer.nativeStart(this.mNativeObject);
        this.mState = 1;
    }

    public void stop() {
        if (this.mState != 1) {
            throw new IllegalStateException("Can't stop due to wrong state.");
        }
        MediaMuxer.nativeStop(this.mNativeObject);
        this.mState = 2;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            if (this.mNativeObject != 0L) {
                MediaMuxer.nativeRelease(this.mNativeObject);
                this.mNativeObject = 0L;
            }
        }
        finally {
            super.finalize();
        }
    }

    public int addTrack(MediaFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("format must not be null.");
        }
        if (this.mState != 0) {
            throw new IllegalStateException("Muxer is not initialized.");
        }
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Muxer has been released!");
        }
        int trackIndex = -1;
        Map<String, Object> formatMap = format.getMap();
        String[] keys = null;
        Object[] values = null;
        int mapSize = formatMap.size();
        if (mapSize > 0) {
            keys = new String[mapSize];
            values = new Object[mapSize];
            int i = 0;
            for (Map.Entry<String, Object> entry : formatMap.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
        } else {
            throw new IllegalArgumentException("format must not be empty.");
        }
        trackIndex = MediaMuxer.nativeAddTrack(this.mNativeObject, keys, values);
        if (this.mLastTrackIndex >= trackIndex) {
            throw new IllegalArgumentException("Invalid format.");
        }
        this.mLastTrackIndex = trackIndex;
        return trackIndex;
    }

    public void writeSampleData(int trackIndex, ByteBuffer byteBuf, MediaCodec.BufferInfo bufferInfo) {
        if (trackIndex < 0 || trackIndex > this.mLastTrackIndex) {
            throw new IllegalArgumentException("trackIndex is invalid");
        }
        if (byteBuf == null) {
            throw new IllegalArgumentException("byteBuffer must not be null");
        }
        if (bufferInfo == null) {
            throw new IllegalArgumentException("bufferInfo must not be null");
        }
        if (bufferInfo.size < 0 || bufferInfo.offset < 0 || bufferInfo.offset + bufferInfo.size > byteBuf.capacity() || bufferInfo.presentationTimeUs < 0L) {
            throw new IllegalArgumentException("bufferInfo must specify a valid buffer offset, size and presentation time");
        }
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Muxer has been released!");
        }
        if (this.mState != 1) {
            throw new IllegalStateException("Can't write, muxer is not started");
        }
        MediaMuxer.nativeWriteSampleData(this.mNativeObject, trackIndex, byteBuf, bufferInfo.offset, bufferInfo.size, bufferInfo.presentationTimeUs, bufferInfo.flags);
    }

    public void release() {
        if (this.mState == 1) {
            this.stop();
        }
        if (this.mNativeObject != 0L) {
            MediaMuxer.nativeRelease(this.mNativeObject);
            this.mNativeObject = 0L;
            this.mCloseGuard.close();
        }
        this.mState = -1;
    }

    static {
        System.loadLibrary("media_jni");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Format {
    }

    public static final class OutputFormat {
        public static final int MUXER_OUTPUT_FIRST = 0;
        public static final int MUXER_OUTPUT_MPEG_4 = 0;
        public static final int MUXER_OUTPUT_WEBM = 1;
        public static final int MUXER_OUTPUT_3GPP = 2;
        public static final int MUXER_OUTPUT_HEIF = 3;
        public static final int MUXER_OUTPUT_LAST = 3;

        private OutputFormat() {
        }
    }
}

