/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioRouting;
import android.media.BufferingParams;
import android.media.DataSourceDesc;
import android.media.DeniedByServerException;
import android.media.MediaDrm;
import android.media.MediaDrmException;
import android.media.MediaFormat;
import android.media.MediaPlayer2Impl;
import android.media.MediaTimeProvider;
import android.media.MediaTimestamp;
import android.media.Metadata;
import android.media.PlaybackParams;
import android.media.ResourceBusyException;
import android.media.SubtitleController;
import android.media.SubtitleData;
import android.media.SubtitleTrack;
import android.media.SyncParams;
import android.media.TimedMetaData;
import android.media.TimedText;
import android.media.UnsupportedSchemeException;
import android.net.Uri;
import android.os.Handler;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.view.Surface;
import android.view.SurfaceHolder;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;

public abstract class MediaPlayer2
implements SubtitleController.Listener,
AudioRouting,
AutoCloseable {
    public static final boolean METADATA_UPDATE_ONLY = true;
    public static final boolean METADATA_ALL = false;
    public static final boolean APPLY_METADATA_FILTER = true;
    public static final boolean BYPASS_METADATA_FILTER = false;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT = 1;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING = 2;
    public static final int LOOPING_MODE_NONE = 0;
    public static final int LOOPING_MODE_FULL = 1;
    public static final int LOOPING_MODE_SINGLE = 2;
    public static final int LOOPING_MODE_SHUFFLE = 3;
    public static final int PLAYBACK_RATE_AUDIO_MODE_RESAMPLE = 2;
    public static final int PLAYBACK_RATE_AUDIO_MODE_STRETCH = 1;
    public static final int PLAYBACK_RATE_AUDIO_MODE_DEFAULT = 0;
    public static final int SEEK_PREVIOUS_SYNC = 0;
    public static final int SEEK_NEXT_SYNC = 1;
    public static final int SEEK_CLOSEST_SYNC = 2;
    public static final int SEEK_CLOSEST = 3;
    public static final String MEDIA_MIMETYPE_TEXT_SUBRIP = "application/x-subrip";
    public static final String MEDIA_MIMETYPE_TEXT_VTT = "text/vtt";
    public static final String MEDIA_MIMETYPE_TEXT_CEA_608 = "text/cea-608";
    public static final String MEDIA_MIMETYPE_TEXT_CEA_708 = "text/cea-708";
    public static final int MEDIA_ERROR_UNKNOWN = 1;
    public static final int MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK = 200;
    public static final int MEDIA_ERROR_IO = -1004;
    public static final int MEDIA_ERROR_MALFORMED = -1007;
    public static final int MEDIA_ERROR_UNSUPPORTED = -1010;
    public static final int MEDIA_ERROR_TIMED_OUT = -110;
    public static final int MEDIA_ERROR_SYSTEM = Integer.MIN_VALUE;
    public static final int MEDIA_INFO_UNKNOWN = 1;
    public static final int MEDIA_INFO_STARTED_AS_NEXT = 2;
    public static final int MEDIA_INFO_VIDEO_RENDERING_START = 3;
    public static final int MEDIA_INFO_AUDIO_RENDERING_START = 4;
    public static final int MEDIA_INFO_PLAYBACK_COMPLETE = 5;
    public static final int MEDIA_INFO_PLAYLIST_END = 6;
    public static final int MEDIA_INFO_PREPARED = 100;
    public static final int MEDIA_INFO_COMPLETE_CALL_PLAY = 101;
    public static final int MEDIA_INFO_COMPLETE_CALL_PAUSE = 102;
    public static final int MEDIA_INFO_COMPLETE_CALL_SEEK = 103;
    public static final int MEDIA_INFO_VIDEO_TRACK_LAGGING = 700;
    public static final int MEDIA_INFO_BUFFERING_START = 701;
    public static final int MEDIA_INFO_BUFFERING_END = 702;
    public static final int MEDIA_INFO_NETWORK_BANDWIDTH = 703;
    public static final int MEDIA_INFO_BAD_INTERLEAVING = 800;
    public static final int MEDIA_INFO_NOT_SEEKABLE = 801;
    public static final int MEDIA_INFO_METADATA_UPDATE = 802;
    public static final int MEDIA_INFO_EXTERNAL_METADATA_UPDATE = 803;
    public static final int MEDIA_INFO_AUDIO_NOT_PLAYING = 804;
    public static final int MEDIA_INFO_VIDEO_NOT_PLAYING = 805;
    public static final int MEDIA_INFO_TIMED_TEXT_ERROR = 900;
    public static final int MEDIA_INFO_UNSUPPORTED_SUBTITLE = 901;
    public static final int MEDIA_INFO_SUBTITLE_TIMED_OUT = 902;
    public static final int PREPARE_DRM_STATUS_SUCCESS = 0;
    public static final int PREPARE_DRM_STATUS_PROVISIONING_NETWORK_ERROR = 1;
    public static final int PREPARE_DRM_STATUS_PROVISIONING_SERVER_ERROR = 2;
    public static final int PREPARE_DRM_STATUS_PREPARATION_ERROR = 3;

    public static final MediaPlayer2 create() {
        return new MediaPlayer2Impl();
    }

    public Parcel newRequest() {
        return null;
    }

    public void invoke(Parcel request, Parcel reply) {
    }

    public abstract void setDisplay(SurfaceHolder var1);

    public abstract void setSurface(Surface var1);

    public void setVideoScalingMode(int mode) {
    }

    public abstract void clearPendingCommands();

    public abstract void setDataSource(DataSourceDesc var1) throws IOException;

    public abstract DataSourceDesc getCurrentDataSource();

    public abstract void setPlaylist(List<DataSourceDesc> var1, int var2) throws IOException;

    public abstract List<DataSourceDesc> getPlaylist();

    public abstract void setCurrentPlaylistItem(int var1);

    public abstract void setNextPlaylistItem(int var1);

    public abstract int getCurrentPlaylistItemIndex();

    public abstract void setLoopingMode(int var1);

    public abstract int getLoopingMode();

    public abstract void movePlaylistItem(int var1, int var2);

    public abstract DataSourceDesc removePlaylistItem(int var1);

    public abstract void addPlaylistItem(int var1, DataSourceDesc var2);

    public abstract DataSourceDesc editPlaylistItem(int var1, DataSourceDesc var2);

    public void prepare() throws IOException {
    }

    public abstract void prepareAsync();

    public abstract void play();

    public void stop() {
    }

    public abstract void pause();

    @Override
    public abstract boolean setPreferredDevice(AudioDeviceInfo var1);

    @Override
    public abstract AudioDeviceInfo getPreferredDevice();

    @Override
    public abstract AudioDeviceInfo getRoutedDevice();

    @Override
    public abstract void addOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener var1, Handler var2);

    @Override
    public abstract void removeOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener var1);

    public abstract void setWakeMode(Context var1, int var2);

    public abstract void setScreenOnWhilePlaying(boolean var1);

    public abstract int getVideoWidth();

    public abstract int getVideoHeight();

    public abstract PersistableBundle getMetrics();

    public abstract boolean isPlaying();

    public BufferingParams getBufferingParams() {
        return new BufferingParams.Builder().build();
    }

    public void setBufferingParams(BufferingParams params) {
    }

    public PlaybackParams easyPlaybackParams(float rate, int audioMode) {
        return new PlaybackParams();
    }

    public abstract void setPlaybackParams(PlaybackParams var1);

    public abstract PlaybackParams getPlaybackParams();

    public abstract void setSyncParams(SyncParams var1);

    public abstract SyncParams getSyncParams();

    public abstract void seekTo(long var1, int var3);

    public abstract MediaTimestamp getTimestamp();

    public abstract int getCurrentPosition();

    public abstract int getDuration();

    public Metadata getMetadata(boolean update_only, boolean apply_filter) {
        return null;
    }

    public int setMetadataFilter(Set<Integer> allow, Set<Integer> block) {
        return 0;
    }

    public void setNextMediaPlayer(MediaPlayer2 next) {
    }

    public abstract void reset();

    public void notifyAt(long mediaTimeUs) {
    }

    public abstract void setAudioAttributes(AudioAttributes var1);

    public void setLooping(boolean looping) {
    }

    public boolean isLooping() {
        return false;
    }

    public abstract void setVolume(float var1, float var2);

    public void setVolume(float volume) {
    }

    public abstract void setAudioSessionId(int var1);

    public abstract int getAudioSessionId();

    public abstract void attachAuxEffect(int var1);

    public abstract void setAuxEffectSendLevel(float var1);

    public abstract List<TrackInfo> getTrackInfo();

    public void setSubtitleAnchor(SubtitleController controller, SubtitleController.Anchor anchor) {
    }

    @Override
    public void onSubtitleTrackSelected(SubtitleTrack track) {
    }

    public void addSubtitleSource(InputStream is, MediaFormat format) {
    }

    public void addTimedTextSource(String path, String mimeType) throws IOException {
    }

    public void addTimedTextSource(Context context, Uri uri, String mimeType) throws IOException {
    }

    public void addTimedTextSource(FileDescriptor fd, String mimeType) {
    }

    public abstract void addTimedTextSource(FileDescriptor var1, long var2, long var4, String var6);

    public abstract int getSelectedTrack(int var1);

    public abstract void selectTrack(int var1);

    public abstract void deselectTrack(int var1);

    @Override
    public abstract void close();

    public MediaTimeProvider getMediaTimeProvider() {
        return null;
    }

    public abstract void registerEventCallback(Executor var1, EventCallback var2);

    public abstract void unregisterEventCallback(EventCallback var1);

    public void setOnSubtitleDataListener(OnSubtitleDataListener listener) {
    }

    public abstract void setOnDrmConfigHelper(OnDrmConfigHelper var1);

    public abstract void registerDrmEventCallback(Executor var1, DrmEventCallback var2);

    public abstract void unregisterDrmEventCallback(DrmEventCallback var1);

    public abstract DrmInfo getDrmInfo();

    public abstract void prepareDrm(UUID var1) throws UnsupportedSchemeException, ResourceBusyException, ProvisioningNetworkErrorException, ProvisioningServerErrorException;

    public abstract void releaseDrm() throws NoDrmSchemeException;

    public abstract MediaDrm.KeyRequest getKeyRequest(byte[] var1, byte[] var2, String var3, int var4, Map<String, String> var5) throws NoDrmSchemeException;

    public abstract byte[] provideKeyResponse(byte[] var1, byte[] var2) throws NoDrmSchemeException, DeniedByServerException;

    public abstract void restoreKeys(byte[] var1) throws NoDrmSchemeException;

    public abstract String getDrmPropertyString(String var1) throws NoDrmSchemeException;

    public abstract void setDrmPropertyString(String var1, String var2) throws NoDrmSchemeException;

    public static final class MetricsConstants {
        public static final String MIME_TYPE_VIDEO = "android.media.mediaplayer.video.mime";
        public static final String CODEC_VIDEO = "android.media.mediaplayer.video.codec";
        public static final String WIDTH = "android.media.mediaplayer.width";
        public static final String HEIGHT = "android.media.mediaplayer.height";
        public static final String FRAMES = "android.media.mediaplayer.frames";
        public static final String FRAMES_DROPPED = "android.media.mediaplayer.dropped";
        public static final String MIME_TYPE_AUDIO = "android.media.mediaplayer.audio.mime";
        public static final String CODEC_AUDIO = "android.media.mediaplayer.audio.codec";
        public static final String DURATION = "android.media.mediaplayer.durationMs";
        public static final String PLAYING = "android.media.mediaplayer.playingMs";
        public static final String ERRORS = "android.media.mediaplayer.err";
        public static final String ERROR_CODE = "android.media.mediaplayer.errcode";

        private MetricsConstants() {
        }
    }

    public static abstract class ProvisioningServerErrorException
    extends MediaDrmException {
        protected ProvisioningServerErrorException(String detailMessage) {
            super(detailMessage);
        }
    }

    public static abstract class ProvisioningNetworkErrorException
    extends MediaDrmException {
        protected ProvisioningNetworkErrorException(String detailMessage) {
            super(detailMessage);
        }
    }

    public static abstract class NoDrmSchemeException
    extends MediaDrmException {
        protected NoDrmSchemeException(String detailMessage) {
            super(detailMessage);
        }
    }

    public static abstract class DrmInfo {
        public abstract Map<UUID, byte[]> getPssh();

        public abstract List<UUID> getSupportedSchemes();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PrepareDrmStatusCode {
    }

    public static abstract class DrmEventCallback {
        public void onDrmInfo(MediaPlayer2 mp, DrmInfo drmInfo) {
        }

        public void onDrmPrepared(MediaPlayer2 mp, int status) {
        }
    }

    public static interface OnDrmConfigHelper {
        public void onDrmConfig(MediaPlayer2 var1);
    }

    public static interface OnSubtitleDataListener {
        public void onSubtitleData(MediaPlayer2 var1, SubtitleData var2);
    }

    public static abstract class EventCallback {
        public void onBufferingUpdate(MediaPlayer2 mp, long srcId, int percent) {
        }

        public void onVideoSizeChanged(MediaPlayer2 mp, long srcId, int width, int height) {
        }

        public void onTimedText(MediaPlayer2 mp, long srcId, TimedText text) {
        }

        public void onTimedMetaDataAvailable(MediaPlayer2 mp, long srcId, TimedMetaData data) {
        }

        public void onError(MediaPlayer2 mp, long srcId, int what, int extra) {
        }

        public void onInfo(MediaPlayer2 mp, long srcId, int what, int extra) {
        }
    }

    public static abstract class TrackInfo {
        public static final int MEDIA_TRACK_TYPE_UNKNOWN = 0;
        public static final int MEDIA_TRACK_TYPE_VIDEO = 1;
        public static final int MEDIA_TRACK_TYPE_AUDIO = 2;
        public static final int MEDIA_TRACK_TYPE_TIMEDTEXT = 3;
        public static final int MEDIA_TRACK_TYPE_SUBTITLE = 4;
        public static final int MEDIA_TRACK_TYPE_METADATA = 5;

        public abstract int getTrackType();

        public abstract String getLanguage();

        public abstract MediaFormat getFormat();

        public abstract String toString();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SeekMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlaybackRateAudioMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LoopingMode {
    }
}

