/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.app.Application;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.AudioRouting;
import android.media.BufferingParams;
import android.media.DataSourceDesc;
import android.media.DeniedByServerException;
import android.media.Media2DataSource;
import android.media.Media2HTTPService;
import android.media.MediaDrm;
import android.media.MediaFormat;
import android.media.MediaPlayer2;
import android.media.MediaTimeProvider;
import android.media.MediaTimestamp;
import android.media.Metadata;
import android.media.NativeRoutingEventHandlerDelegate;
import android.media.NotProvisionedException;
import android.media.PlaybackParams;
import android.media.ResourceBusyException;
import android.media.RingtoneManager;
import android.media.SRTRenderer;
import android.media.SubtitleController;
import android.media.SubtitleData;
import android.media.SubtitleTrack;
import android.media.SyncParams;
import android.media.TimedMetaData;
import android.media.TimedText;
import android.media.UnsupportedSchemeException;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.PowerManager;
import android.os.SystemProperties;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import dalvik.system.CloseGuard;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.Executor;
import libcore.io.IoBridge;
import libcore.io.Streams;

public final class MediaPlayer2Impl
extends MediaPlayer2 {
    private static final String TAG = "MediaPlayer2Impl";
    private long mNativeContext;
    private long mNativeSurfaceTexture;
    private int mListenerContext;
    private SurfaceHolder mSurfaceHolder;
    private EventHandler mEventHandler;
    private PowerManager.WakeLock mWakeLock = null;
    private boolean mScreenOnWhilePlaying;
    private boolean mStayAwake;
    private int mStreamType = Integer.MIN_VALUE;
    private int mUsage = -1;
    private boolean mBypassInterruptionPolicy;
    private final CloseGuard mGuard = CloseGuard.get();
    private List<DataSourceDesc> mPlaylist;
    private int mPLCurrentIndex = 0;
    private int mPLNextIndex = -1;
    private int mLoopingMode = 0;
    private UUID mDrmUUID;
    private final Object mDrmLock = new Object();
    private DrmInfoImpl mDrmInfoImpl;
    private MediaDrm mDrmObj;
    private byte[] mDrmSessionId;
    private boolean mDrmInfoResolved;
    private boolean mActiveDrmScheme;
    private boolean mDrmConfigAllowed;
    private boolean mDrmProvisioningInProgress;
    private boolean mPrepareDrmInProgress;
    private ProvisioningThread mDrmProvisioningThread;
    private static final int INVOKE_ID_GET_TRACK_INFO = 1;
    private static final int INVOKE_ID_ADD_EXTERNAL_SOURCE = 2;
    private static final int INVOKE_ID_ADD_EXTERNAL_SOURCE_FD = 3;
    private static final int INVOKE_ID_SELECT_TRACK = 4;
    private static final int INVOKE_ID_DESELECT_TRACK = 5;
    private static final int INVOKE_ID_SET_VIDEO_SCALE_MODE = 6;
    private static final int INVOKE_ID_GET_SELECTED_TRACK = 7;
    private AudioDeviceInfo mPreferredDevice = null;
    @GuardedBy(value="mRoutingChangeListeners")
    private ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> mRoutingChangeListeners = new ArrayMap();
    private static final int KEY_PARAMETER_AUDIO_ATTRIBUTES = 1400;
    private Vector<Pair<Integer, SubtitleTrack>> mIndexTrackPairs = new Vector();
    private BitSet mInbandTrackIndices = new BitSet();
    private SubtitleController mSubtitleController;
    private int mSelectedSubtitleTrackIndex = -1;
    private Vector<InputStream> mOpenSubtitleSources;
    private MediaPlayer2.OnSubtitleDataListener mSubtitleDataListener = new MediaPlayer2.OnSubtitleDataListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSubtitleData(MediaPlayer2 mp, SubtitleData data) {
            int index = data.getTrackIndex();
            Vector vector = MediaPlayer2Impl.this.mIndexTrackPairs;
            synchronized (vector) {
                for (Pair p : MediaPlayer2Impl.this.mIndexTrackPairs) {
                    if (p.first == null || (Integer)p.first != index || p.second == null) continue;
                    SubtitleTrack track = (SubtitleTrack)p.second;
                    track.onData(data);
                }
            }
        }
    };
    private static final int MEDIA_NOP = 0;
    private static final int MEDIA_PREPARED = 1;
    private static final int MEDIA_PLAYBACK_COMPLETE = 2;
    private static final int MEDIA_BUFFERING_UPDATE = 3;
    private static final int MEDIA_SEEK_COMPLETE = 4;
    private static final int MEDIA_SET_VIDEO_SIZE = 5;
    private static final int MEDIA_STARTED = 6;
    private static final int MEDIA_PAUSED = 7;
    private static final int MEDIA_STOPPED = 8;
    private static final int MEDIA_SKIPPED = 9;
    private static final int MEDIA_NOTIFY_TIME = 98;
    private static final int MEDIA_TIMED_TEXT = 99;
    private static final int MEDIA_ERROR = 100;
    private static final int MEDIA_INFO = 200;
    private static final int MEDIA_SUBTITLE_DATA = 201;
    private static final int MEDIA_META_DATA = 202;
    private static final int MEDIA_DRM_INFO = 210;
    private static final int MEDIA_AUDIO_ROUTING_CHANGED = 10000;
    private TimeProvider mTimeProvider;
    private final Object mEventCbLock = new Object();
    private ArrayList<Pair<Executor, MediaPlayer2.EventCallback>> mEventCallbackRecords = new ArrayList();
    private MediaPlayer2.OnSubtitleDataListener mOnSubtitleDataListener;
    private MediaPlayer2.OnDrmConfigHelper mOnDrmConfigHelper;
    private final Object mDrmEventCbLock = new Object();
    private ArrayList<Pair<Executor, MediaPlayer2.DrmEventCallback>> mDrmEventCallbackRecords = new ArrayList();

    public MediaPlayer2Impl() {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.mTimeProvider = new TimeProvider(this);
        this.mOpenSubtitleSources = new Vector();
        this.mGuard.open("close");
        this.native_setup(new WeakReference<MediaPlayer2Impl>(this));
    }

    private native void _setVideoSurface(Surface var1);

    @Override
    public Parcel newRequest() {
        Parcel parcel = Parcel.obtain();
        return parcel;
    }

    @Override
    public void invoke(Parcel request, Parcel reply) {
        int retcode = this.native_invoke(request, reply);
        reply.setDataPosition(0);
        if (retcode != 0) {
            throw new RuntimeException("failure code: " + retcode);
        }
    }

    @Override
    public void setDisplay(SurfaceHolder sh) {
        this.mSurfaceHolder = sh;
        Surface surface = sh != null ? sh.getSurface() : null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    @Override
    public void setSurface(Surface surface) {
        if (this.mScreenOnWhilePlaying && surface != null) {
            Log.w(TAG, "setScreenOnWhilePlaying(true) is ineffective for Surface");
        }
        this.mSurfaceHolder = null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVideoScalingMode(int mode) {
        if (!this.isVideoScalingModeSupported(mode)) {
            String msg = "Scaling mode " + mode + " is not supported";
            throw new IllegalArgumentException(msg);
        }
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeInt(6);
            request.writeInt(mode);
            this.invoke(request, reply);
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    @Override
    public void clearPendingCommands() {
    }

    @Override
    public void setDataSource(DataSourceDesc dsd) throws IOException {
        Preconditions.checkNotNull(dsd, "the DataSourceDesc cannot be null");
        this.mPlaylist = Collections.synchronizedList(new ArrayList(1));
        this.mPlaylist.add(dsd);
        this.mPLCurrentIndex = 0;
        this.setDataSourcePriv(dsd);
    }

    @Override
    public DataSourceDesc getCurrentDataSource() {
        if (this.mPlaylist == null) {
            return null;
        }
        return this.mPlaylist.get(this.mPLCurrentIndex);
    }

    @Override
    public void setPlaylist(List<DataSourceDesc> pl, int startIndex) throws IOException {
        if (pl == null || pl.size() == 0) {
            throw new IllegalArgumentException("play list cannot be null or empty.");
        }
        HashSet<Long> ids = new HashSet<Long>(pl.size());
        for (DataSourceDesc dsd : pl) {
            if (dsd == null) {
                throw new IllegalArgumentException("DataSourceDesc in play list cannot be null.");
            }
            if (ids.add(dsd.getId())) continue;
            throw new IllegalArgumentException("DataSourceDesc Id in play list should be unique.");
        }
        if (startIndex < 0) {
            startIndex = 0;
        } else if (startIndex >= pl.size()) {
            startIndex = pl.size() - 1;
        }
        this.mPlaylist = Collections.synchronizedList(new ArrayList<DataSourceDesc>(pl));
        this.mPLCurrentIndex = startIndex;
        this.setDataSourcePriv(this.mPlaylist.get(startIndex));
    }

    @Override
    public List<DataSourceDesc> getPlaylist() {
        if (this.mPlaylist == null) {
            return null;
        }
        return new ArrayList<DataSourceDesc>(this.mPlaylist);
    }

    @Override
    public void setCurrentPlaylistItem(int index) {
        if (this.mPlaylist == null) {
            throw new IllegalArgumentException("play list has not been set yet.");
        }
        if (index < 0 || index >= this.mPlaylist.size()) {
            throw new IndexOutOfBoundsException("index is out of play list range.");
        }
        if (index == this.mPLCurrentIndex) {
            return;
        }
        this.mPLCurrentIndex = index;
    }

    @Override
    public void setNextPlaylistItem(int index) {
        if (this.mPlaylist == null) {
            throw new IllegalArgumentException("play list has not been set yet.");
        }
        if (index < 0 || index >= this.mPlaylist.size()) {
            throw new IndexOutOfBoundsException("index is out of play list range.");
        }
        if (index == this.mPLNextIndex) {
            return;
        }
        this.mPLNextIndex = index;
    }

    @Override
    public int getCurrentPlaylistItemIndex() {
        return this.mPLCurrentIndex;
    }

    @Override
    public void setLoopingMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2 && mode != 3) {
            throw new IllegalArgumentException("mode is not supported.");
        }
        this.mLoopingMode = mode;
        if (this.mPlaylist == null) {
            return;
        }
    }

    @Override
    public int getLoopingMode() {
        return this.mPLCurrentIndex;
    }

    @Override
    public void movePlaylistItem(int indexFrom, int indexTo) {
        if (this.mPlaylist == null) {
            throw new IllegalArgumentException("play list has not been set yet.");
        }
    }

    @Override
    public DataSourceDesc removePlaylistItem(int index) {
        if (this.mPlaylist == null) {
            throw new IllegalArgumentException("play list has not been set yet.");
        }
        DataSourceDesc oldDsd = this.mPlaylist.remove(index);
        return oldDsd;
    }

    @Override
    public void addPlaylistItem(int index, DataSourceDesc dsd) {
        Preconditions.checkNotNull(dsd, "the DataSourceDesc cannot be null");
        if (this.mPlaylist == null) {
            if (index == 0) {
                this.mPlaylist = Collections.synchronizedList(new ArrayList());
                this.mPlaylist.add(dsd);
                this.mPLCurrentIndex = 0;
                return;
            }
            throw new IllegalArgumentException("index should be 0 for first DataSourceDesc.");
        }
        long id2 = dsd.getId();
        for (DataSourceDesc pldsd : this.mPlaylist) {
            if (id2 != pldsd.getId()) continue;
            throw new IllegalArgumentException("Id of dsd already exists in the play list.");
        }
        this.mPlaylist.add(index, dsd);
        if (index <= this.mPLCurrentIndex) {
            ++this.mPLCurrentIndex;
        }
    }

    @Override
    public DataSourceDesc editPlaylistItem(int index, DataSourceDesc dsd) {
        Preconditions.checkNotNull(dsd, "the DataSourceDesc cannot be null");
        Preconditions.checkNotNull(this.mPlaylist, "the play list cannot be null");
        long id2 = dsd.getId();
        for (int i = 0; i < this.mPlaylist.size(); ++i) {
            if (i == index || id2 != this.mPlaylist.get(i).getId()) continue;
            throw new IllegalArgumentException("Id of dsd already exists in the play list.");
        }
        DataSourceDesc oldDsd = this.mPlaylist.set(index, dsd);
        return this.mPlaylist.set(index, dsd);
    }

    private void setDataSourcePriv(DataSourceDesc dsd) throws IOException {
        Preconditions.checkNotNull(dsd, "the DataSourceDesc cannot be null");
        switch (dsd.getType()) {
            case 1: {
                this.setDataSourcePriv(dsd.getId(), dsd.getMedia2DataSource());
                break;
            }
            case 2: {
                this.setDataSourcePriv(dsd.getId(), dsd.getFileDescriptor(), dsd.getFileDescriptorOffset(), dsd.getFileDescriptorLength());
                break;
            }
            case 3: {
                this.setDataSourcePriv(dsd.getId(), dsd.getUriContext(), dsd.getUri(), dsd.getUriHeaders(), dsd.getUriCookies());
                break;
            }
        }
    }

    private void setDataSourcePriv(long srcId, Context context, Uri uri, Map<String, String> headers, List<HttpCookie> cookies) throws IOException {
        CookieHandler cookieHandler;
        if (context == null) {
            throw new NullPointerException("context param can not be null.");
        }
        if (uri == null) {
            throw new NullPointerException("uri param can not be null.");
        }
        if (cookies != null && (cookieHandler = CookieHandler.getDefault()) != null && !(cookieHandler instanceof CookieManager)) {
            throw new IllegalArgumentException("The cookie handler has to be of CookieManager type when cookies are provided.");
        }
        ContentResolver resolver = context.getContentResolver();
        String scheme = uri.getScheme();
        String authority = ContentProvider.getAuthorityWithoutUserId(uri.getAuthority());
        if ("file".equals(scheme)) {
            this.setDataSourcePriv(srcId, uri.getPath(), null, null);
            return;
        }
        if ("content".equals(scheme) && "settings".equals(authority)) {
            int type = RingtoneManager.getDefaultType(uri);
            Uri cacheUri = RingtoneManager.getCacheForType(type, context.getUserId());
            Uri actualUri = RingtoneManager.getActualDefaultRingtoneUri(context, type);
            if (this.attemptDataSource(srcId, resolver, cacheUri)) {
                return;
            }
            if (this.attemptDataSource(srcId, resolver, actualUri)) {
                return;
            }
            this.setDataSourcePriv(srcId, uri.toString(), headers, cookies);
        } else {
            if (this.attemptDataSource(srcId, resolver, uri)) {
                return;
            }
            this.setDataSourcePriv(srcId, uri.toString(), headers, cookies);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean attemptDataSource(long srcId, ContentResolver resolver, Uri uri) {
        try (AssetFileDescriptor afd = resolver.openAssetFileDescriptor(uri, "r");){
            if (afd.getDeclaredLength() < 0L) {
                this.setDataSourcePriv(srcId, afd.getFileDescriptor(), 0L, 0x7FFFFFFFFFFFFFFL);
            } else {
                this.setDataSourcePriv(srcId, afd.getFileDescriptor(), afd.getStartOffset(), afd.getDeclaredLength());
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | NullPointerException | SecurityException ex) {
            Log.w(TAG, "Couldn't open " + uri + ": " + ex);
            return false;
        }
    }

    private void setDataSourcePriv(long srcId, String path, Map<String, String> headers, List<HttpCookie> cookies) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        String[] keys = null;
        String[] values = null;
        if (headers != null) {
            keys = new String[headers.size()];
            values = new String[headers.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
        }
        this.setDataSourcePriv(srcId, path, keys, values, cookies);
    }

    private void setDataSourcePriv(long srcId, String path, String[] keys, String[] values, List<HttpCookie> cookies) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        Uri uri = Uri.parse(path);
        String scheme = uri.getScheme();
        if ("file".equals(scheme)) {
            path = uri.getPath();
        } else if (scheme != null) {
            this.nativeSetDataSource(Media2HTTPService.createHTTPService(path, cookies), path, keys, values);
            return;
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new IOException("setDataSourcePriv failed.");
        }
        FileInputStream is = new FileInputStream(file);
        FileDescriptor fd = is.getFD();
        this.setDataSourcePriv(srcId, fd, 0L, 0x7FFFFFFFFFFFFFFL);
        is.close();
    }

    private native void nativeSetDataSource(Media2HTTPService var1, String var2, String[] var3, String[] var4) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException;

    private void setDataSourcePriv(long srcId, FileDescriptor fd, long offset, long length) throws IOException {
        this._setDataSource(fd, offset, length);
    }

    private native void _setDataSource(FileDescriptor var1, long var2, long var4) throws IOException;

    private void setDataSourcePriv(long srcId, Media2DataSource dataSource) {
        this._setDataSource(dataSource);
    }

    private native void _setDataSource(Media2DataSource var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws IOException {
        this._prepare();
        this.scanInternalSubtitleTracks();
        Object object = this.mDrmLock;
        synchronized (object) {
            this.mDrmInfoResolved = true;
        }
    }

    private native void _prepare() throws IOException, IllegalStateException;

    @Override
    public native void prepareAsync();

    @Override
    public void play() {
        this.stayAwake(true);
        this._start();
    }

    private native void _start() throws IllegalStateException;

    private int getAudioStreamType() {
        if (this.mStreamType == Integer.MIN_VALUE) {
            this.mStreamType = this._getAudioStreamType();
        }
        return this.mStreamType;
    }

    private native int _getAudioStreamType() throws IllegalStateException;

    @Override
    public void stop() {
        this.stayAwake(false);
        this._stop();
    }

    private native void _stop() throws IllegalStateException;

    @Override
    public void pause() {
        this.stayAwake(false);
        this._pause();
    }

    private native void _pause() throws IllegalStateException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPreferredDevice(AudioDeviceInfo deviceInfo) {
        if (deviceInfo != null && !deviceInfo.isSink()) {
            return false;
        }
        int preferredDeviceId = deviceInfo != null ? deviceInfo.getId() : 0;
        boolean status = this.native_setOutputDevice(preferredDeviceId);
        if (status) {
            MediaPlayer2Impl mediaPlayer2Impl = this;
            synchronized (mediaPlayer2Impl) {
                this.mPreferredDevice = deviceInfo;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioDeviceInfo getPreferredDevice() {
        MediaPlayer2Impl mediaPlayer2Impl = this;
        synchronized (mediaPlayer2Impl) {
            return this.mPreferredDevice;
        }
    }

    @Override
    public AudioDeviceInfo getRoutedDevice() {
        int deviceId = this.native_getRoutedDeviceId();
        if (deviceId == 0) {
            return null;
        }
        AudioDeviceInfo[] devices = AudioManager.getDevicesStatic(2);
        for (int i = 0; i < devices.length; ++i) {
            if (devices[i].getId() != deviceId) continue;
            return devices[i];
        }
        return null;
    }

    private void enableNativeRoutingCallbacksLocked(boolean enabled) {
        if (this.mRoutingChangeListeners.size() == 0) {
            this.native_enableDeviceCallback(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener, Handler handler) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (listener != null && !this.mRoutingChangeListeners.containsKey(listener)) {
                this.enableNativeRoutingCallbacksLocked(true);
                this.mRoutingChangeListeners.put(listener, new NativeRoutingEventHandlerDelegate(this, listener, handler != null ? handler : this.mEventHandler));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (this.mRoutingChangeListeners.containsKey(listener)) {
                this.mRoutingChangeListeners.remove(listener);
                this.enableNativeRoutingCallbacksLocked(false);
            }
        }
    }

    private final native boolean native_setOutputDevice(int var1);

    private final native int native_getRoutedDeviceId();

    private final native void native_enableDeviceCallback(boolean var1);

    @Override
    public void setWakeMode(Context context, int mode) {
        boolean washeld = false;
        if (SystemProperties.getBoolean("audio.offload.ignore_setawake", false)) {
            Log.w(TAG, "IGNORING setWakeMode " + mode);
            return;
        }
        if (this.mWakeLock != null) {
            if (this.mWakeLock.isHeld()) {
                washeld = true;
                this.mWakeLock.release();
            }
            this.mWakeLock = null;
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(mode | 0x20000000, MediaPlayer2Impl.class.getName());
        this.mWakeLock.setReferenceCounted(false);
        if (washeld) {
            this.mWakeLock.acquire();
        }
    }

    @Override
    public void setScreenOnWhilePlaying(boolean screenOn) {
        if (this.mScreenOnWhilePlaying != screenOn) {
            if (screenOn && this.mSurfaceHolder == null) {
                Log.w(TAG, "setScreenOnWhilePlaying(true) is ineffective without a SurfaceHolder");
            }
            this.mScreenOnWhilePlaying = screenOn;
            this.updateSurfaceScreenOn();
        }
    }

    private void stayAwake(boolean awake) {
        if (this.mWakeLock != null) {
            if (awake && !this.mWakeLock.isHeld()) {
                this.mWakeLock.acquire();
            } else if (!awake && this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
        this.mStayAwake = awake;
        this.updateSurfaceScreenOn();
    }

    private void updateSurfaceScreenOn() {
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.setKeepScreenOn(this.mScreenOnWhilePlaying && this.mStayAwake);
        }
    }

    @Override
    public native int getVideoWidth();

    @Override
    public native int getVideoHeight();

    @Override
    public PersistableBundle getMetrics() {
        PersistableBundle bundle = this.native_getMetrics();
        return bundle;
    }

    private native PersistableBundle native_getMetrics();

    @Override
    public native boolean isPlaying();

    @Override
    public native BufferingParams getBufferingParams();

    @Override
    public native void setBufferingParams(BufferingParams var1);

    @Override
    public PlaybackParams easyPlaybackParams(float rate, int audioMode) {
        PlaybackParams params = new PlaybackParams();
        params.allowDefaults();
        switch (audioMode) {
            case 0: {
                params.setSpeed(rate).setPitch(1.0f);
                break;
            }
            case 1: {
                params.setSpeed(rate).setPitch(1.0f).setAudioFallbackMode(2);
                break;
            }
            case 2: {
                params.setSpeed(rate).setPitch(rate);
                break;
            }
            default: {
                String msg = "Audio playback mode " + audioMode + " is not supported";
                throw new IllegalArgumentException(msg);
            }
        }
        return params;
    }

    @Override
    public native void setPlaybackParams(PlaybackParams var1);

    @Override
    public native PlaybackParams getPlaybackParams();

    @Override
    public native void setSyncParams(SyncParams var1);

    @Override
    public native SyncParams getSyncParams();

    private final native void _seekTo(long var1, int var3);

    @Override
    public void seekTo(long msec, int mode) {
        if (mode < 0 || mode > 3) {
            String msg = "Illegal seek mode: " + mode;
            throw new IllegalArgumentException(msg);
        }
        if (msec > Integer.MAX_VALUE) {
            Log.w(TAG, "seekTo offset " + msec + " is too large, cap to " + Integer.MAX_VALUE);
            msec = Integer.MAX_VALUE;
        } else if (msec < Integer.MIN_VALUE) {
            Log.w(TAG, "seekTo offset " + msec + " is too small, cap to " + Integer.MIN_VALUE);
            msec = Integer.MIN_VALUE;
        }
        this._seekTo(msec, mode);
    }

    @Override
    public MediaTimestamp getTimestamp() {
        try {
            return new MediaTimestamp((long)this.getCurrentPosition() * 1000L, System.nanoTime(), this.isPlaying() ? this.getPlaybackParams().getSpeed() : 0.0f);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    @Override
    public native int getCurrentPosition();

    @Override
    public native int getDuration();

    @Override
    public Metadata getMetadata(boolean update_only, boolean apply_filter) {
        Parcel reply = Parcel.obtain();
        Metadata data = new Metadata();
        if (!this.native_getMetadata(update_only, apply_filter, reply)) {
            reply.recycle();
            return null;
        }
        if (!data.parse(reply)) {
            reply.recycle();
            return null;
        }
        return data;
    }

    @Override
    public int setMetadataFilter(Set<Integer> allow, Set<Integer> block) {
        Parcel request = this.newRequest();
        int capacity = request.dataSize() + 4 * (1 + allow.size() + 1 + block.size());
        if (request.dataCapacity() < capacity) {
            request.setDataCapacity(capacity);
        }
        request.writeInt(allow.size());
        for (Integer t : allow) {
            request.writeInt(t);
        }
        request.writeInt(block.size());
        for (Integer t : block) {
            request.writeInt(t);
        }
        return this.native_setMetadataFilter(request);
    }

    @Override
    public native void setNextMediaPlayer(MediaPlayer2 var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.mSelectedSubtitleTrackIndex = -1;
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mOpenSubtitleSources;
        synchronized (vector) {
            for (InputStream is : this.mOpenSubtitleSources) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            this.mOpenSubtitleSources.clear();
        }
        if (this.mSubtitleController != null) {
            this.mSubtitleController.reset();
        }
        if (this.mTimeProvider != null) {
            this.mTimeProvider.close();
            this.mTimeProvider = null;
        }
        vector = this.mEventCbLock;
        synchronized (vector) {
            this.mEventCallbackRecords.clear();
        }
        vector = this.mDrmEventCbLock;
        synchronized (vector) {
            this.mDrmEventCallbackRecords.clear();
        }
        this.stayAwake(false);
        this._reset();
        if (this.mEventHandler != null) {
            this.mEventHandler.removeCallbacksAndMessages(null);
        }
        vector = this.mIndexTrackPairs;
        synchronized (vector) {
            this.mIndexTrackPairs.clear();
            this.mInbandTrackIndices.clear();
        }
        this.resetDrmState();
    }

    private native void _reset();

    @Override
    public void notifyAt(long mediaTimeUs) {
        this._notifyAt(mediaTimeUs);
    }

    private native void _notifyAt(long var1);

    private native boolean setParameter(int var1, Parcel var2);

    @Override
    public void setAudioAttributes(AudioAttributes attributes) {
        if (attributes == null) {
            String msg = "Cannot set AudioAttributes to null";
            throw new IllegalArgumentException("Cannot set AudioAttributes to null");
        }
        this.mUsage = attributes.getUsage();
        this.mBypassInterruptionPolicy = (attributes.getAllFlags() & 0x40) != 0;
        Parcel pattributes = Parcel.obtain();
        attributes.writeToParcel(pattributes, 1);
        this.setParameter(1400, pattributes);
        pattributes.recycle();
    }

    @Override
    public native void setLooping(boolean var1);

    @Override
    public native boolean isLooping();

    @Override
    public void setVolume(float leftVolume, float rightVolume) {
        this._setVolume(leftVolume, rightVolume);
    }

    private native void _setVolume(float var1, float var2);

    @Override
    public void setVolume(float volume) {
        this.setVolume(volume, volume);
    }

    @Override
    public native void setAudioSessionId(int var1);

    @Override
    public native int getAudioSessionId();

    @Override
    public native void attachAuxEffect(int var1);

    @Override
    public void setAuxEffectSendLevel(float level) {
        this._setAuxEffectSendLevel(level);
    }

    private native void _setAuxEffectSendLevel(float var1);

    private final native int native_invoke(Parcel var1, Parcel var2);

    private final native boolean native_getMetadata(boolean var1, boolean var2, Parcel var3);

    private final native int native_setMetadataFilter(Parcel var1);

    private static final native void native_init();

    private final native void native_setup(Object var1);

    private final native void native_finalize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MediaPlayer2.TrackInfo> getTrackInfo() {
        TrackInfoImpl[] trackInfo = this.getInbandTrackInfoImpl();
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
        synchronized (vector) {
            TrackInfoImpl[] allTrackInfo = new TrackInfoImpl[this.mIndexTrackPairs.size()];
            for (int i = 0; i < allTrackInfo.length; ++i) {
                Pair<Integer, SubtitleTrack> p = this.mIndexTrackPairs.get(i);
                if (p.first != null) {
                    allTrackInfo[i] = trackInfo[(Integer)p.first];
                    continue;
                }
                SubtitleTrack track = (SubtitleTrack)p.second;
                allTrackInfo[i] = new TrackInfoImpl(track.getTrackType(), track.getFormat());
            }
            return Arrays.asList(allTrackInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrackInfoImpl[] getInbandTrackInfoImpl() throws IllegalStateException {
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            TrackInfoImpl[] trackInfo;
            request.writeInt(1);
            this.invoke(request, reply);
            TrackInfoImpl[] trackInfoImplArray = trackInfo = reply.createTypedArray(TrackInfoImpl.CREATOR);
            return trackInfoImplArray;
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    private static boolean availableMimeTypeForExternalSource(String mimeType) {
        return "application/x-subrip".equals(mimeType);
    }

    @Override
    public void setSubtitleAnchor(SubtitleController controller, SubtitleController.Anchor anchor) {
        this.mSubtitleController = controller;
        this.mSubtitleController.setAnchor(anchor);
    }

    private synchronized void setSubtitleAnchor() {
        if (this.mSubtitleController == null && ActivityThread.currentApplication() != null) {
            final HandlerThread thread = new HandlerThread("SetSubtitleAnchorThread");
            thread.start();
            Handler handler = new Handler(thread.getLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    Application context = ActivityThread.currentApplication();
                    MediaPlayer2Impl.this.mSubtitleController = new SubtitleController(context, MediaPlayer2Impl.this.mTimeProvider, MediaPlayer2Impl.this);
                    MediaPlayer2Impl.this.mSubtitleController.setAnchor(new SubtitleController.Anchor(){

                        @Override
                        public void setSubtitleWidget(SubtitleTrack.RenderingWidget subtitleWidget) {
                        }

                        @Override
                        public Looper getSubtitleLooper() {
                            return Looper.getMainLooper();
                        }
                    });
                    thread.getLooper().quitSafely();
                }
            });
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Log.w(TAG, "failed to join SetSubtitleAnchorThread");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubtitleTrackSelected(SubtitleTrack track) {
        if (this.mSelectedSubtitleTrackIndex >= 0) {
            try {
                this.selectOrDeselectInbandTrack(this.mSelectedSubtitleTrackIndex, false);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.mSelectedSubtitleTrackIndex = -1;
        }
        this.setOnSubtitleDataListener(null);
        if (track == null) {
            return;
        }
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
        synchronized (vector) {
            for (Pair<Integer, SubtitleTrack> p : this.mIndexTrackPairs) {
                if (p.first == null || p.second != track) continue;
                this.mSelectedSubtitleTrackIndex = (Integer)p.first;
                break;
            }
        }
        if (this.mSelectedSubtitleTrackIndex >= 0) {
            try {
                this.selectOrDeselectInbandTrack(this.mSelectedSubtitleTrackIndex, true);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.setOnSubtitleDataListener(this.mSubtitleDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSubtitleSource(InputStream is, MediaFormat format) throws IllegalStateException {
        final InputStream fIs = is;
        final MediaFormat fFormat = format;
        if (is != null) {
            Vector<InputStream> vector = this.mOpenSubtitleSources;
            synchronized (vector) {
                this.mOpenSubtitleSources.add(is);
            }
        } else {
            Log.w(TAG, "addSubtitleSource called with null InputStream");
        }
        this.getMediaTimeProvider();
        final HandlerThread thread = new HandlerThread("SubtitleReadThread", 9);
        thread.start();
        Handler handler = new Handler(thread.getLooper());
        handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private int addTrack() {
                if (fIs == null || MediaPlayer2Impl.this.mSubtitleController == null) {
                    return 901;
                }
                SubtitleTrack track = MediaPlayer2Impl.this.mSubtitleController.addTrack(fFormat);
                if (track == null) {
                    return 901;
                }
                Scanner scanner = new Scanner(fIs, "UTF-8");
                String contents = scanner.useDelimiter("\\A").next();
                Vector vector = MediaPlayer2Impl.this.mOpenSubtitleSources;
                synchronized (vector) {
                    MediaPlayer2Impl.this.mOpenSubtitleSources.remove(fIs);
                }
                scanner.close();
                vector = MediaPlayer2Impl.this.mIndexTrackPairs;
                synchronized (vector) {
                    MediaPlayer2Impl.this.mIndexTrackPairs.add(Pair.create(null, track));
                }
                Handler h = MediaPlayer2Impl.this.mTimeProvider.mEventHandler;
                int what = 1;
                int arg1 = 4;
                Pair<SubtitleTrack, byte[]> trackData = Pair.create(track, contents.getBytes());
                Message m = h.obtainMessage(what, arg1, 0, trackData);
                h.sendMessage(m);
                return 803;
            }

            @Override
            public void run() {
                int res = this.addTrack();
                if (MediaPlayer2Impl.this.mEventHandler != null) {
                    Message m = MediaPlayer2Impl.this.mEventHandler.obtainMessage(200, res, 0, null);
                    MediaPlayer2Impl.this.mEventHandler.sendMessage(m);
                }
                thread.getLooper().quitSafely();
            }
        });
    }

    private void scanInternalSubtitleTracks() {
        this.setSubtitleAnchor();
        this.populateInbandTracks();
        if (this.mSubtitleController != null) {
            this.mSubtitleController.selectDefaultTrack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateInbandTracks() {
        TrackInfoImpl[] tracks = this.getInbandTrackInfoImpl();
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
        synchronized (vector) {
            for (int i = 0; i < tracks.length; ++i) {
                if (this.mInbandTrackIndices.get(i)) continue;
                this.mInbandTrackIndices.set(i);
                if (tracks[i].getTrackType() == 4) {
                    SubtitleTrack track = this.mSubtitleController.addTrack(tracks[i].getFormat());
                    this.mIndexTrackPairs.add(Pair.create(i, track));
                    continue;
                }
                this.mIndexTrackPairs.add(Pair.create(i, null));
            }
        }
    }

    @Override
    public void addTimedTextSource(String path, String mimeType) throws IOException {
        if (!MediaPlayer2Impl.availableMimeTypeForExternalSource(mimeType)) {
            String msg = "Illegal mimeType for timed text source: " + mimeType;
            throw new IllegalArgumentException(msg);
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new IOException(path);
        }
        FileInputStream is = new FileInputStream(file);
        FileDescriptor fd = is.getFD();
        this.addTimedTextSource(fd, mimeType);
        is.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTimedTextSource(Context context, Uri uri, String mimeType) throws IOException {
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.addTimedTextSource(uri.getPath(), mimeType);
            return;
        }
        try (AssetFileDescriptor fd = null;){
            ContentResolver resolver = context.getContentResolver();
            fd = resolver.openAssetFileDescriptor(uri, "r");
            if (fd == null) {
                return;
            }
            this.addTimedTextSource(fd.getFileDescriptor(), mimeType);
            return;
        }
    }

    @Override
    public void addTimedTextSource(FileDescriptor fd, String mimeType) {
        this.addTimedTextSource(fd, 0L, 0x7FFFFFFFFFFFFFFL, mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTimedTextSource(FileDescriptor fd, long offset, long length, String mime) {
        FileDescriptor dupedFd;
        if (!MediaPlayer2Impl.availableMimeTypeForExternalSource(mime)) {
            throw new IllegalArgumentException("Illegal mimeType for timed text source: " + mime);
        }
        try {
            dupedFd = Os.dup(fd);
        }
        catch (ErrnoException ex) {
            Log.e(TAG, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
        MediaFormat fFormat = new MediaFormat();
        fFormat.setString("mime", mime);
        fFormat.setInteger("is-timed-text", 1);
        if (this.mSubtitleController == null) {
            this.setSubtitleAnchor();
        }
        if (!this.mSubtitleController.hasRendererFor(fFormat)) {
            Application context = ActivityThread.currentApplication();
            this.mSubtitleController.registerRenderer(new SRTRenderer(context, this.mEventHandler));
        }
        final SubtitleTrack track = this.mSubtitleController.addTrack(fFormat);
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
        synchronized (vector) {
            this.mIndexTrackPairs.add(Pair.create(null, track));
        }
        this.getMediaTimeProvider();
        final long offset2 = offset;
        final long length2 = length;
        final HandlerThread thread = new HandlerThread("TimedTextReadThread", 9);
        thread.start();
        Handler handler = new Handler(thread.getLooper());
        handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private int addTrack() {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    int bytesToRead;
                    int bytes;
                    Os.lseek(dupedFd, offset2, OsConstants.SEEK_SET);
                    byte[] buffer = new byte[4096];
                    for (long total = 0L; total < length2 && (bytes = IoBridge.read(dupedFd, buffer, 0, bytesToRead = (int)Math.min((long)buffer.length, length2 - total))) >= 0; total += (long)bytes) {
                        bos.write(buffer, 0, bytes);
                    }
                    Handler h = MediaPlayer2Impl.this.mTimeProvider.mEventHandler;
                    int what = 1;
                    int arg1 = 4;
                    Pair<SubtitleTrack, byte[]> trackData = Pair.create(track, bos.toByteArray());
                    Message m = h.obtainMessage(what, arg1, 0, trackData);
                    h.sendMessage(m);
                    int n = 803;
                    return n;
                }
                catch (Exception e) {
                    Log.e(MediaPlayer2Impl.TAG, e.getMessage(), e);
                    int n = 900;
                    return n;
                }
                finally {
                    try {
                        Os.close(dupedFd);
                    }
                    catch (ErrnoException e) {
                        Log.e(MediaPlayer2Impl.TAG, e.getMessage(), e);
                    }
                }
            }

            @Override
            public void run() {
                int res = this.addTrack();
                if (MediaPlayer2Impl.this.mEventHandler != null) {
                    Message m = MediaPlayer2Impl.this.mEventHandler.obtainMessage(200, res, 0, null);
                    MediaPlayer2Impl.this.mEventHandler.sendMessage(m);
                }
                thread.getLooper().quitSafely();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getSelectedTrack(int trackType) {
        SubtitleTrack subtitleTrack;
        if (this.mSubtitleController != null && (trackType == 4 || trackType == 3) && (subtitleTrack = this.mSubtitleController.getSelectedTrack()) != null) {
            Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
            synchronized (vector) {
                for (int i = 0; i < this.mIndexTrackPairs.size(); ++i) {
                    Pair<Integer, SubtitleTrack> p = this.mIndexTrackPairs.get(i);
                    if (p.second != subtitleTrack || subtitleTrack.getTrackType() != trackType) continue;
                    return i;
                }
            }
        }
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeInt(7);
            request.writeInt(trackType);
            this.invoke(request, reply);
            int inbandTrackIndex = reply.readInt();
            Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
            synchronized (vector) {
                for (int i = 0; i < this.mIndexTrackPairs.size(); ++i) {
                    Pair<Integer, SubtitleTrack> p = this.mIndexTrackPairs.get(i);
                    if (p.first == null || (Integer)p.first != inbandTrackIndex) continue;
                    int n = i;
                    return n;
                }
            }
            int n = -1;
            return n;
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    @Override
    public void selectTrack(int index) {
        this.selectOrDeselectTrack(index, true);
    }

    @Override
    public void deselectTrack(int index) {
        this.selectOrDeselectTrack(index, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectOrDeselectTrack(int index, boolean select) throws IllegalStateException {
        this.populateInbandTracks();
        Pair<Integer, SubtitleTrack> p = null;
        try {
            p = this.mIndexTrackPairs.get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
        SubtitleTrack track = (SubtitleTrack)p.second;
        if (track == null) {
            this.selectOrDeselectInbandTrack((Integer)p.first, select);
            return;
        }
        if (this.mSubtitleController == null) {
            return;
        }
        if (!select) {
            if (this.mSubtitleController.getSelectedTrack() == track) {
                this.mSubtitleController.selectTrack(null);
            } else {
                Log.w(TAG, "trying to deselect track that was not selected");
            }
            return;
        }
        if (track.getTrackType() == 3) {
            int ttIndex = this.getSelectedTrack(3);
            Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
            synchronized (vector) {
                if (ttIndex >= 0 && ttIndex < this.mIndexTrackPairs.size()) {
                    Pair<Integer, SubtitleTrack> p2 = this.mIndexTrackPairs.get(ttIndex);
                    if (p2.first != null && p2.second == null) {
                        this.selectOrDeselectInbandTrack((Integer)p2.first, false);
                    }
                }
            }
        }
        this.mSubtitleController.selectTrack(track);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectOrDeselectInbandTrack(int index, boolean select) throws IllegalStateException {
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeInt(select ? 4 : 5);
            request.writeInt(index);
            this.invoke(request, reply);
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        CloseGuard closeGuard = this.mGuard;
        synchronized (closeGuard) {
            this.release();
        }
    }

    protected void finalize() throws Throwable {
        if (this.mGuard != null) {
            this.mGuard.warnIfOpen();
        }
        this.close();
        this.native_finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        this.stayAwake(false);
        this.updateSurfaceScreenOn();
        Object object = this.mEventCbLock;
        synchronized (object) {
            this.mEventCallbackRecords.clear();
        }
        if (this.mTimeProvider != null) {
            this.mTimeProvider.close();
            this.mTimeProvider = null;
        }
        this.mOnSubtitleDataListener = null;
        this.mOnDrmConfigHelper = null;
        object = this.mDrmEventCbLock;
        synchronized (object) {
            this.mDrmEventCallbackRecords.clear();
        }
        this.resetDrmState();
        this._release();
    }

    private native void _release();

    @Override
    public MediaTimeProvider getMediaTimeProvider() {
        if (this.mTimeProvider == null) {
            this.mTimeProvider = new TimeProvider(this);
        }
        return this.mTimeProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void postEventFromNative(Object mediaplayer2_ref, int what, int arg1, int arg2, Object obj) {
        final MediaPlayer2Impl mp = (MediaPlayer2Impl)((WeakReference)mediaplayer2_ref).get();
        if (mp == null) {
            return;
        }
        switch (what) {
            case 200: {
                if (arg1 != 2) break;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        mp.play();
                    }
                }).start();
                Thread.yield();
                break;
            }
            case 210: {
                Object parcel;
                Log.v(TAG, "postEventFromNative MEDIA_DRM_INFO");
                if (obj instanceof Parcel) {
                    parcel = (Parcel)obj;
                    DrmInfoImpl drmInfo = new DrmInfoImpl((Parcel)parcel);
                    Object object = mp.mDrmLock;
                    synchronized (object) {
                        mp.mDrmInfoImpl = drmInfo;
                        break;
                    }
                }
                Log.w(TAG, "MEDIA_DRM_INFO msg.obj of unexpected type " + obj);
                break;
            }
            case 1: {
                Object parcel = mp.mDrmLock;
                synchronized (parcel) {
                    mp.mDrmInfoResolved = true;
                    break;
                }
            }
        }
        if (mp.mEventHandler != null) {
            Message m = mp.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            mp.mEventHandler.sendMessage(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerEventCallback(Executor executor, MediaPlayer2.EventCallback eventCallback) {
        if (eventCallback == null) {
            throw new IllegalArgumentException("Illegal null EventCallback");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Illegal null Executor for the EventCallback");
        }
        Object object = this.mEventCbLock;
        synchronized (object) {
            this.mEventCallbackRecords.add(new Pair<Executor, MediaPlayer2.EventCallback>(executor, eventCallback));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterEventCallback(MediaPlayer2.EventCallback callback) {
        Object object = this.mEventCbLock;
        synchronized (object) {
            for (Pair<Executor, MediaPlayer2.EventCallback> cb : this.mEventCallbackRecords) {
                if (cb.second != callback) continue;
                this.mEventCallbackRecords.remove(cb);
            }
        }
    }

    @Override
    public void setOnSubtitleDataListener(MediaPlayer2.OnSubtitleDataListener listener) {
        this.mOnSubtitleDataListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOnDrmConfigHelper(MediaPlayer2.OnDrmConfigHelper listener) {
        Object object = this.mDrmLock;
        synchronized (object) {
            this.mOnDrmConfigHelper = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDrmEventCallback(Executor executor, MediaPlayer2.DrmEventCallback eventCallback) {
        if (eventCallback == null) {
            throw new IllegalArgumentException("Illegal null EventCallback");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Illegal null Executor for the EventCallback");
        }
        Object object = this.mDrmEventCbLock;
        synchronized (object) {
            this.mDrmEventCallbackRecords.add(new Pair<Executor, MediaPlayer2.DrmEventCallback>(executor, eventCallback));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterDrmEventCallback(MediaPlayer2.DrmEventCallback callback) {
        Object object = this.mDrmEventCbLock;
        synchronized (object) {
            for (Pair<Executor, MediaPlayer2.DrmEventCallback> cb : this.mDrmEventCallbackRecords) {
                if (cb.second != callback) continue;
                this.mDrmEventCallbackRecords.remove(cb);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaPlayer2.DrmInfo getDrmInfo() {
        DrmInfoImpl drmInfo = null;
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mDrmInfoResolved && this.mDrmInfoImpl == null) {
                String msg = "The Player has not been prepared yet";
                Log.v(TAG, "The Player has not been prepared yet");
                throw new IllegalStateException("The Player has not been prepared yet");
            }
            if (this.mDrmInfoImpl != null) {
                drmInfo = this.mDrmInfoImpl.makeCopy();
            }
        }
        return drmInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareDrm(UUID uuid) throws UnsupportedSchemeException, ResourceBusyException, MediaPlayer2.ProvisioningNetworkErrorException, MediaPlayer2.ProvisioningServerErrorException {
        Log.v(TAG, "prepareDrm: uuid: " + uuid + " mOnDrmConfigHelper: " + this.mOnDrmConfigHelper);
        boolean allDoneWithoutProvisioning = false;
        Object object = this.mDrmLock;
        synchronized (object) {
            if (this.mDrmInfoImpl == null) {
                String msg = "prepareDrm(): Wrong usage: The player must be prepared and DRM info be retrieved before this call.";
                Log.e(TAG, "prepareDrm(): Wrong usage: The player must be prepared and DRM info be retrieved before this call.");
                throw new IllegalStateException("prepareDrm(): Wrong usage: The player must be prepared and DRM info be retrieved before this call.");
            }
            if (this.mActiveDrmScheme) {
                String msg = "prepareDrm(): Wrong usage: There is already an active DRM scheme with " + this.mDrmUUID;
                Log.e(TAG, msg);
                throw new IllegalStateException(msg);
            }
            if (this.mPrepareDrmInProgress) {
                String msg = "prepareDrm(): Wrong usage: There is already a pending prepareDrm call.";
                Log.e(TAG, "prepareDrm(): Wrong usage: There is already a pending prepareDrm call.");
                throw new IllegalStateException("prepareDrm(): Wrong usage: There is already a pending prepareDrm call.");
            }
            if (this.mDrmProvisioningInProgress) {
                String msg = "prepareDrm(): Unexpectd: Provisioning is already in progress.";
                Log.e(TAG, "prepareDrm(): Unexpectd: Provisioning is already in progress.");
                throw new IllegalStateException("prepareDrm(): Unexpectd: Provisioning is already in progress.");
            }
            this.cleanDrmObj();
            this.mPrepareDrmInProgress = true;
            try {
                this.prepareDrm_createDrmStep(uuid);
            }
            catch (Exception e) {
                Log.w(TAG, "prepareDrm(): Exception ", e);
                this.mPrepareDrmInProgress = false;
                throw e;
            }
            this.mDrmConfigAllowed = true;
        }
        if (this.mOnDrmConfigHelper != null) {
            this.mOnDrmConfigHelper.onDrmConfig(this);
        }
        object = this.mDrmLock;
        synchronized (object) {
            this.mDrmConfigAllowed = false;
            boolean earlyExit = false;
            try {
                this.prepareDrm_openSessionStep(uuid);
                this.mDrmUUID = uuid;
                this.mActiveDrmScheme = true;
                allDoneWithoutProvisioning = true;
            }
            catch (IllegalStateException e) {
                String msg = "prepareDrm(): Wrong usage: The player must be in the prepared state to call prepareDrm().";
                Log.e(TAG, "prepareDrm(): Wrong usage: The player must be in the prepared state to call prepareDrm().");
                earlyExit = true;
                throw new IllegalStateException("prepareDrm(): Wrong usage: The player must be in the prepared state to call prepareDrm().");
            }
            catch (NotProvisionedException e) {
                Log.w(TAG, "prepareDrm: NotProvisionedException");
                int result = this.HandleProvisioninig(uuid);
                if (result != 0) {
                    earlyExit = true;
                    switch (result) {
                        case 1: {
                            String msg = "prepareDrm: Provisioning was required but failed due to a network error.";
                            Log.e(TAG, msg);
                            throw new ProvisioningNetworkErrorExceptionImpl(msg);
                        }
                        case 2: {
                            String msg = "prepareDrm: Provisioning was required but the request was denied by the server.";
                            Log.e(TAG, msg);
                            throw new ProvisioningServerErrorExceptionImpl(msg);
                        }
                    }
                    String msg = "prepareDrm: Post-provisioning preparation failed.";
                    Log.e(TAG, msg);
                    throw new IllegalStateException(msg);
                }
            }
            catch (Exception e) {
                Log.e(TAG, "prepareDrm: Exception " + e);
                earlyExit = true;
                throw e;
            }
            finally {
                if (!this.mDrmProvisioningInProgress) {
                    this.mPrepareDrmInProgress = false;
                }
                if (earlyExit) {
                    this.cleanDrmObj();
                }
            }
        }
        if (allDoneWithoutProvisioning) {
            object = this.mDrmEventCbLock;
            synchronized (object) {
                for (Pair<Executor, MediaPlayer2.DrmEventCallback> cb : this.mDrmEventCallbackRecords) {
                    ((Executor)cb.first).execute(() -> ((MediaPlayer2.DrmEventCallback)cb.second).onDrmPrepared(this, 0));
                }
            }
        }
    }

    private native void _releaseDrm();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseDrm() throws MediaPlayer2.NoDrmSchemeException {
        Log.v(TAG, "releaseDrm:");
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme) {
                Log.e(TAG, "releaseDrm(): No active DRM scheme to release.");
                throw new NoDrmSchemeExceptionImpl("releaseDrm: No active DRM scheme to release.");
            }
            try {
                this._releaseDrm();
                this.cleanDrmObj();
                this.mActiveDrmScheme = false;
            }
            catch (IllegalStateException e) {
                Log.w(TAG, "releaseDrm: Exception ", e);
                throw new IllegalStateException("releaseDrm: The player is not in a valid state.");
            }
            catch (Exception e) {
                Log.e(TAG, "releaseDrm: Exception ", e);
            }
        }
    }

    @Override
    public MediaDrm.KeyRequest getKeyRequest(byte[] keySetId, byte[] initData, String mimeType, int keyType, Map<String, String> optionalParameters) throws MediaPlayer2.NoDrmSchemeException {
        Log.v(TAG, "getKeyRequest:  keySetId: " + keySetId + " initData:" + initData + " mimeType: " + mimeType + " keyType: " + keyType + " optionalParameters: " + optionalParameters);
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme) {
                Log.e(TAG, "getKeyRequest NoDrmSchemeException");
                throw new NoDrmSchemeExceptionImpl("getKeyRequest: Has to set a DRM scheme first.");
            }
            try {
                byte[] scope = keyType != 3 ? this.mDrmSessionId : keySetId;
                HashMap<String, String> hmapOptionalParameters = optionalParameters != null ? new HashMap<String, String>(optionalParameters) : null;
                MediaDrm.KeyRequest request = this.mDrmObj.getKeyRequest(scope, initData, mimeType, keyType, hmapOptionalParameters);
                Log.v(TAG, "getKeyRequest:   --> request: " + request);
                return request;
            }
            catch (NotProvisionedException e) {
                Log.w(TAG, "getKeyRequest NotProvisionedException: Unexpected. Shouldn't have reached here.");
                throw new IllegalStateException("getKeyRequest: Unexpected provisioning error.");
            }
            catch (Exception e) {
                Log.w(TAG, "getKeyRequest Exception " + e);
                throw e;
            }
        }
    }

    @Override
    public byte[] provideKeyResponse(byte[] keySetId, byte[] response) throws MediaPlayer2.NoDrmSchemeException, DeniedByServerException {
        Log.v(TAG, "provideKeyResponse: keySetId: " + keySetId + " response: " + response);
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme) {
                Log.e(TAG, "getKeyRequest NoDrmSchemeException");
                throw new NoDrmSchemeExceptionImpl("getKeyRequest: Has to set a DRM scheme first.");
            }
            try {
                byte[] scope = keySetId == null ? this.mDrmSessionId : keySetId;
                byte[] keySetResult = this.mDrmObj.provideKeyResponse(scope, response);
                Log.v(TAG, "provideKeyResponse: keySetId: " + keySetId + " response: " + response + " --> " + keySetResult);
                return keySetResult;
            }
            catch (NotProvisionedException e) {
                Log.w(TAG, "provideKeyResponse NotProvisionedException: Unexpected. Shouldn't have reached here.");
                throw new IllegalStateException("provideKeyResponse: Unexpected provisioning error.");
            }
            catch (Exception e) {
                Log.w(TAG, "provideKeyResponse Exception " + e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreKeys(byte[] keySetId) throws MediaPlayer2.NoDrmSchemeException {
        Log.v(TAG, "restoreKeys: keySetId: " + keySetId);
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme) {
                Log.w(TAG, "restoreKeys NoDrmSchemeException");
                throw new NoDrmSchemeExceptionImpl("restoreKeys: Has to set a DRM scheme first.");
            }
            try {
                this.mDrmObj.restoreKeys(this.mDrmSessionId, keySetId);
            }
            catch (Exception e) {
                Log.w(TAG, "restoreKeys Exception " + e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDrmPropertyString(String propertyName) throws MediaPlayer2.NoDrmSchemeException {
        String value;
        Log.v(TAG, "getDrmPropertyString: propertyName: " + propertyName);
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme && !this.mDrmConfigAllowed) {
                Log.w(TAG, "getDrmPropertyString NoDrmSchemeException");
                throw new NoDrmSchemeExceptionImpl("getDrmPropertyString: Has to prepareDrm() first.");
            }
            try {
                value = this.mDrmObj.getPropertyString(propertyName);
            }
            catch (Exception e) {
                Log.w(TAG, "getDrmPropertyString Exception " + e);
                throw e;
            }
        }
        Log.v(TAG, "getDrmPropertyString: propertyName: " + propertyName + " --> value: " + value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDrmPropertyString(String propertyName, String value) throws MediaPlayer2.NoDrmSchemeException {
        Log.v(TAG, "setDrmPropertyString: propertyName: " + propertyName + " value: " + value);
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme && !this.mDrmConfigAllowed) {
                Log.w(TAG, "setDrmPropertyString NoDrmSchemeException");
                throw new NoDrmSchemeExceptionImpl("setDrmPropertyString: Has to prepareDrm() first.");
            }
            try {
                this.mDrmObj.setPropertyString(propertyName, value);
            }
            catch (Exception e) {
                Log.w(TAG, "setDrmPropertyString Exception " + e);
                throw e;
            }
        }
    }

    private native void _prepareDrm(byte[] var1, byte[] var2);

    private void prepareDrm_createDrmStep(UUID uuid) throws UnsupportedSchemeException {
        Log.v(TAG, "prepareDrm_createDrmStep: UUID: " + uuid);
        try {
            this.mDrmObj = new MediaDrm(uuid);
            Log.v(TAG, "prepareDrm_createDrmStep: Created mDrmObj=" + this.mDrmObj);
        }
        catch (Exception e) {
            Log.e(TAG, "prepareDrm_createDrmStep: MediaDrm failed with " + e);
            throw e;
        }
    }

    private void prepareDrm_openSessionStep(UUID uuid) throws NotProvisionedException, ResourceBusyException {
        Log.v(TAG, "prepareDrm_openSessionStep: uuid: " + uuid);
        try {
            this.mDrmSessionId = this.mDrmObj.openSession();
            Log.v(TAG, "prepareDrm_openSessionStep: mDrmSessionId=" + this.mDrmSessionId);
            this._prepareDrm(MediaPlayer2Impl.getByteArrayFromUUID(uuid), this.mDrmSessionId);
            Log.v(TAG, "prepareDrm_openSessionStep: _prepareDrm/Crypto succeeded");
        }
        catch (Exception e) {
            Log.e(TAG, "prepareDrm_openSessionStep: open/crypto failed with " + e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int HandleProvisioninig(UUID uuid) {
        int result;
        if (this.mDrmProvisioningInProgress) {
            Log.e(TAG, "HandleProvisioninig: Unexpected mDrmProvisioningInProgress");
            return 3;
        }
        MediaDrm.ProvisionRequest provReq = this.mDrmObj.getProvisionRequest();
        if (provReq == null) {
            Log.e(TAG, "HandleProvisioninig: getProvisionRequest returned null.");
            return 3;
        }
        Log.v(TAG, "HandleProvisioninig provReq  data: " + provReq.getData() + " url: " + provReq.getDefaultUrl());
        this.mDrmProvisioningInProgress = true;
        this.mDrmProvisioningThread = new ProvisioningThread().initialize(provReq, uuid, this);
        this.mDrmProvisioningThread.start();
        boolean hasCallback = false;
        Object object = this.mDrmEventCbLock;
        synchronized (object) {
            hasCallback = !this.mDrmEventCallbackRecords.isEmpty();
        }
        if (hasCallback) {
            result = 0;
        } else {
            try {
                this.mDrmProvisioningThread.join();
            }
            catch (Exception e) {
                Log.w(TAG, "HandleProvisioninig: Thread.join Exception " + e);
            }
            result = this.mDrmProvisioningThread.status();
            this.mDrmProvisioningThread = null;
        }
        return result;
    }

    private boolean resumePrepareDrm(UUID uuid) {
        Log.v(TAG, "resumePrepareDrm: uuid: " + uuid);
        boolean success = false;
        try {
            this.prepareDrm_openSessionStep(uuid);
            this.mDrmUUID = uuid;
            this.mActiveDrmScheme = true;
            success = true;
        }
        catch (Exception e) {
            Log.w(TAG, "HandleProvisioninig: Thread run _prepareDrm resume failed with " + e);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDrmState() {
        Object object = this.mDrmLock;
        synchronized (object) {
            Log.v(TAG, "resetDrmState:  mDrmInfoImpl=" + this.mDrmInfoImpl + " mDrmProvisioningThread=" + this.mDrmProvisioningThread + " mPrepareDrmInProgress=" + this.mPrepareDrmInProgress + " mActiveDrmScheme=" + this.mActiveDrmScheme);
            this.mDrmInfoResolved = false;
            this.mDrmInfoImpl = null;
            if (this.mDrmProvisioningThread != null) {
                try {
                    this.mDrmProvisioningThread.join();
                }
                catch (InterruptedException e) {
                    Log.w(TAG, "resetDrmState: ProvThread.join Exception " + e);
                }
                this.mDrmProvisioningThread = null;
            }
            this.mPrepareDrmInProgress = false;
            this.mActiveDrmScheme = false;
            this.cleanDrmObj();
        }
    }

    private void cleanDrmObj() {
        Log.v(TAG, "cleanDrmObj: mDrmObj=" + this.mDrmObj + " mDrmSessionId=" + this.mDrmSessionId);
        if (this.mDrmSessionId != null) {
            this.mDrmObj.closeSession(this.mDrmSessionId);
            this.mDrmSessionId = null;
        }
        if (this.mDrmObj != null) {
            this.mDrmObj.release();
            this.mDrmObj = null;
        }
    }

    private static final byte[] getByteArrayFromUUID(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] uuidBytes = new byte[16];
        for (int i = 0; i < 8; ++i) {
            uuidBytes[i] = (byte)(msb >>> 8 * (7 - i));
            uuidBytes[8 + i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return uuidBytes;
    }

    private boolean isVideoScalingModeSupported(int mode) {
        return mode == 1 || mode == 2;
    }

    static {
        System.loadLibrary("media2_jni");
        MediaPlayer2Impl.native_init();
    }

    static class TimeProvider
    implements MediaTimeProvider {
        private static final String TAG = "MTP";
        private static final long MAX_NS_WITHOUT_POSITION_CHECK = 5000000000L;
        private static final long MAX_EARLY_CALLBACK_US = 1000L;
        private static final long TIME_ADJUSTMENT_RATE = 2L;
        private long mLastTimeUs = 0L;
        private MediaPlayer2Impl mPlayer;
        private boolean mPaused = true;
        private boolean mStopped = true;
        private boolean mBuffering;
        private long mLastReportedTime;
        private MediaTimeProvider.OnMediaTimeListener[] mListeners;
        private long[] mTimes;
        private Handler mEventHandler;
        private boolean mRefresh = false;
        private boolean mPausing = false;
        private boolean mSeeking = false;
        private static final int NOTIFY = 1;
        private static final int NOTIFY_TIME = 0;
        private static final int NOTIFY_STOP = 2;
        private static final int NOTIFY_SEEK = 3;
        private static final int NOTIFY_TRACK_DATA = 4;
        private HandlerThread mHandlerThread;
        public boolean DEBUG = false;

        public TimeProvider(MediaPlayer2Impl mp) {
            this.mPlayer = mp;
            try {
                this.getCurrentTimeUs(true, false);
            }
            catch (IllegalStateException e) {
                this.mRefresh = true;
            }
            Looper looper = Looper.myLooper();
            if (looper == null && (looper = Looper.getMainLooper()) == null) {
                this.mHandlerThread = new HandlerThread("MediaPlayer2MTPEventThread", -2);
                this.mHandlerThread.start();
                looper = this.mHandlerThread.getLooper();
            }
            this.mEventHandler = new EventHandler(looper);
            this.mListeners = new MediaTimeProvider.OnMediaTimeListener[0];
            this.mTimes = new long[0];
            this.mLastTimeUs = 0L;
        }

        private void scheduleNotification(int type, long delayUs) {
            if (this.mSeeking && type == 0) {
                return;
            }
            if (this.DEBUG) {
                Log.v(TAG, "scheduleNotification " + type + " in " + delayUs);
            }
            this.mEventHandler.removeMessages(1);
            Message msg = this.mEventHandler.obtainMessage(1, type, 0);
            this.mEventHandler.sendMessageDelayed(msg, (int)(delayUs / 1000L));
        }

        public void close() {
            this.mEventHandler.removeMessages(1);
            if (this.mHandlerThread != null) {
                this.mHandlerThread.quitSafely();
                this.mHandlerThread = null;
            }
        }

        protected void finalize() {
            if (this.mHandlerThread != null) {
                this.mHandlerThread.quitSafely();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNotifyTime() {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "onNotifyTime: ");
                }
                this.scheduleNotification(0, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPaused(boolean paused) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "onPaused: " + paused);
                }
                if (this.mStopped) {
                    this.mStopped = false;
                    this.mSeeking = true;
                    this.scheduleNotification(3, 0L);
                } else {
                    this.mPausing = paused;
                    this.mSeeking = false;
                    this.scheduleNotification(0, 0L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onBuffering(boolean buffering) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "onBuffering: " + buffering);
                }
                this.mBuffering = buffering;
                this.scheduleNotification(0, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStopped() {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "onStopped");
                }
                this.mPaused = true;
                this.mStopped = true;
                this.mSeeking = false;
                this.mBuffering = false;
                this.scheduleNotification(2, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSeekComplete(MediaPlayer2Impl mp) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                this.mStopped = false;
                this.mSeeking = true;
                this.scheduleNotification(3, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNewPlayer() {
            if (this.mRefresh) {
                TimeProvider timeProvider = this;
                synchronized (timeProvider) {
                    this.mStopped = false;
                    this.mSeeking = true;
                    this.mBuffering = false;
                    this.scheduleNotification(3, 0L);
                }
            }
        }

        private synchronized void notifySeek() {
            this.mSeeking = false;
            try {
                long timeUs = this.getCurrentTimeUs(true, false);
                if (this.DEBUG) {
                    Log.d(TAG, "onSeekComplete at " + timeUs);
                }
                for (MediaTimeProvider.OnMediaTimeListener listener : this.mListeners) {
                    if (listener == null) break;
                    listener.onSeek(timeUs);
                }
            }
            catch (IllegalStateException e) {
                if (this.DEBUG) {
                    Log.d(TAG, "onSeekComplete but no player");
                }
                this.mPausing = true;
                this.notifyTimedEvent(false);
            }
        }

        private synchronized void notifyTrackData(Pair<SubtitleTrack, byte[]> trackData) {
            SubtitleTrack track = (SubtitleTrack)trackData.first;
            byte[] data = (byte[])trackData.second;
            track.onData(data, true, -1L);
        }

        private synchronized void notifyStop() {
            for (MediaTimeProvider.OnMediaTimeListener listener : this.mListeners) {
                if (listener == null) break;
                listener.onStop();
            }
        }

        private int registerListener(MediaTimeProvider.OnMediaTimeListener listener) {
            int i;
            for (i = 0; i < this.mListeners.length && this.mListeners[i] != listener && this.mListeners[i] != null; ++i) {
            }
            if (i >= this.mListeners.length) {
                MediaTimeProvider.OnMediaTimeListener[] newListeners = new MediaTimeProvider.OnMediaTimeListener[i + 1];
                long[] newTimes = new long[i + 1];
                System.arraycopy(this.mListeners, 0, newListeners, 0, this.mListeners.length);
                System.arraycopy((long[])this.mTimes, (int)0, (long[])newTimes, (int)0, (int)this.mTimes.length);
                this.mListeners = newListeners;
                this.mTimes = newTimes;
            }
            if (this.mListeners[i] == null) {
                this.mListeners[i] = listener;
                this.mTimes[i] = -1L;
            }
            return i;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyAt(long timeUs, MediaTimeProvider.OnMediaTimeListener listener) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "notifyAt " + timeUs);
                }
                this.mTimes[this.registerListener((MediaTimeProvider.OnMediaTimeListener)listener)] = timeUs;
                this.scheduleNotification(0, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scheduleUpdate(MediaTimeProvider.OnMediaTimeListener listener) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "scheduleUpdate");
                }
                int i = this.registerListener(listener);
                if (!this.mStopped) {
                    this.mTimes[i] = 0L;
                    this.scheduleNotification(0, 0L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelNotifications(MediaTimeProvider.OnMediaTimeListener listener) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                for (int i = 0; i < this.mListeners.length; ++i) {
                    if (this.mListeners[i] == listener) {
                        System.arraycopy(this.mListeners, i + 1, this.mListeners, i, this.mListeners.length - i - 1);
                        System.arraycopy((long[])this.mTimes, (int)(i + 1), (long[])this.mTimes, (int)i, (int)(this.mTimes.length - i - 1));
                        this.mListeners[this.mListeners.length - 1] = null;
                        this.mTimes[this.mTimes.length - 1] = -1L;
                        break;
                    }
                    if (this.mListeners[i] == null) break;
                }
                this.scheduleNotification(0, 0L);
            }
        }

        private synchronized void notifyTimedEvent(boolean refreshTime) {
            long nowUs;
            try {
                nowUs = this.getCurrentTimeUs(refreshTime, true);
            }
            catch (IllegalStateException e) {
                this.mRefresh = true;
                this.mPausing = true;
                nowUs = this.getCurrentTimeUs(refreshTime, true);
            }
            long nextTimeUs = nowUs;
            if (this.mSeeking) {
                return;
            }
            if (this.DEBUG) {
                StringBuilder sb = new StringBuilder();
                sb.append("notifyTimedEvent(").append(this.mLastTimeUs).append(" -> ").append(nowUs).append(") from {");
                boolean first = true;
                for (long time : this.mTimes) {
                    if (time == -1L) continue;
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(time);
                    first = false;
                }
                sb.append("}");
                Log.d(TAG, sb.toString());
            }
            Vector<MediaTimeProvider.OnMediaTimeListener> activatedListeners = new Vector<MediaTimeProvider.OnMediaTimeListener>();
            for (int ix = 0; ix < this.mTimes.length && this.mListeners[ix] != null; ++ix) {
                if (this.mTimes[ix] <= -1L) continue;
                if (this.mTimes[ix] <= nowUs + 1000L) {
                    activatedListeners.add(this.mListeners[ix]);
                    if (this.DEBUG) {
                        Log.d(TAG, "removed");
                    }
                    this.mTimes[ix] = -1L;
                    continue;
                }
                if (nextTimeUs != nowUs && this.mTimes[ix] >= nextTimeUs) continue;
                nextTimeUs = this.mTimes[ix];
            }
            if (nextTimeUs > nowUs && !this.mPaused) {
                if (this.DEBUG) {
                    Log.d(TAG, "scheduling for " + nextTimeUs + " and " + nowUs);
                }
                this.mPlayer.notifyAt(nextTimeUs);
            } else {
                this.mEventHandler.removeMessages(1);
            }
            for (MediaTimeProvider.OnMediaTimeListener listener : activatedListeners) {
                listener.onTimedEvent(nowUs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getCurrentTimeUs(boolean refreshTime, boolean monotonic) throws IllegalStateException {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.mPaused && !refreshTime) {
                    return this.mLastReportedTime;
                }
                try {
                    this.mLastTimeUs = (long)this.mPlayer.getCurrentPosition() * 1000L;
                    boolean bl = this.mPaused = !this.mPlayer.isPlaying() || this.mBuffering;
                    if (this.DEBUG) {
                        Log.v(TAG, (this.mPaused ? "paused" : "playing") + " at " + this.mLastTimeUs);
                    }
                }
                catch (IllegalStateException e) {
                    if (this.mPausing) {
                        this.mPausing = false;
                        if (!monotonic || this.mLastReportedTime < this.mLastTimeUs) {
                            this.mLastReportedTime = this.mLastTimeUs;
                        }
                        this.mPaused = true;
                        if (this.DEBUG) {
                            Log.d(TAG, "illegal state, but pausing: estimating at " + this.mLastReportedTime);
                        }
                        return this.mLastReportedTime;
                    }
                    throw e;
                }
                if (monotonic && this.mLastTimeUs < this.mLastReportedTime) {
                    if (this.mLastReportedTime - this.mLastTimeUs > 1000000L) {
                        this.mStopped = false;
                        this.mSeeking = true;
                        this.scheduleNotification(3, 0L);
                    }
                } else {
                    this.mLastReportedTime = this.mLastTimeUs;
                }
                return this.mLastReportedTime;
            }
        }

        private class EventHandler
        extends Handler {
            public EventHandler(Looper looper) {
                super(looper);
            }

            @Override
            public void handleMessage(Message msg) {
                if (msg.what == 1) {
                    switch (msg.arg1) {
                        case 0: {
                            TimeProvider.this.notifyTimedEvent(true);
                            break;
                        }
                        case 2: {
                            TimeProvider.this.notifyStop();
                            break;
                        }
                        case 3: {
                            TimeProvider.this.notifySeek();
                            break;
                        }
                        case 4: {
                            TimeProvider.this.notifyTrackData((Pair)msg.obj);
                        }
                    }
                }
            }
        }
    }

    private class ProvisioningThread
    extends Thread {
        public static final int TIMEOUT_MS = 60000;
        private UUID uuid;
        private String urlStr;
        private Object drmLock;
        private MediaPlayer2Impl mediaPlayer;
        private int status;
        private boolean finished;

        private ProvisioningThread() {
        }

        public int status() {
            return this.status;
        }

        public ProvisioningThread initialize(MediaDrm.ProvisionRequest request, UUID uuid, MediaPlayer2Impl mediaPlayer) {
            this.drmLock = mediaPlayer.mDrmLock;
            this.mediaPlayer = mediaPlayer;
            this.urlStr = request.getDefaultUrl() + "&signedRequest=" + new String(request.getData());
            this.uuid = uuid;
            this.status = 3;
            Log.v(MediaPlayer2Impl.TAG, "HandleProvisioninig: Thread is initialised url: " + this.urlStr);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] response = null;
            boolean provisioningSucceeded = false;
            try {
                URL url = new URL(this.urlStr);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                try {
                    connection.setRequestMethod("POST");
                    connection.setDoOutput(false);
                    connection.setDoInput(true);
                    connection.setConnectTimeout(60000);
                    connection.setReadTimeout(60000);
                    connection.connect();
                    response = Streams.readFully(connection.getInputStream());
                    Log.v(MediaPlayer2Impl.TAG, "HandleProvisioninig: Thread run: response " + response.length + " " + response);
                }
                catch (Exception e) {
                    this.status = 1;
                    Log.w(MediaPlayer2Impl.TAG, "HandleProvisioninig: Thread run: connect " + e + " url: " + url);
                }
                finally {
                    connection.disconnect();
                }
            }
            catch (Exception e) {
                this.status = 1;
                Log.w(MediaPlayer2Impl.TAG, "HandleProvisioninig: Thread run: openConnection " + e);
            }
            if (response != null) {
                try {
                    MediaPlayer2Impl.this.mDrmObj.provideProvisionResponse(response);
                    Log.v(MediaPlayer2Impl.TAG, "HandleProvisioninig: Thread run: provideProvisionResponse SUCCEEDED!");
                    provisioningSucceeded = true;
                }
                catch (Exception e) {
                    this.status = 2;
                    Log.w(MediaPlayer2Impl.TAG, "HandleProvisioninig: Thread run: provideProvisionResponse " + e);
                }
            }
            boolean succeeded = false;
            boolean hasCallback = false;
            Object object = MediaPlayer2Impl.this.mDrmEventCbLock;
            synchronized (object) {
                hasCallback = !MediaPlayer2Impl.this.mDrmEventCallbackRecords.isEmpty();
            }
            if (hasCallback) {
                object = this.drmLock;
                synchronized (object) {
                    if (provisioningSucceeded) {
                        succeeded = this.mediaPlayer.resumePrepareDrm(this.uuid);
                        this.status = succeeded ? 0 : 3;
                    }
                    this.mediaPlayer.mDrmProvisioningInProgress = false;
                    this.mediaPlayer.mPrepareDrmInProgress = false;
                    if (!succeeded) {
                        MediaPlayer2Impl.this.cleanDrmObj();
                    }
                }
                object = MediaPlayer2Impl.this.mDrmEventCbLock;
                synchronized (object) {
                    for (Pair cb : MediaPlayer2Impl.this.mDrmEventCallbackRecords) {
                        ((Executor)cb.first).execute(() -> ((MediaPlayer2.DrmEventCallback)cb.second).onDrmPrepared(this.mediaPlayer, this.status));
                    }
                }
            }
            if (provisioningSucceeded) {
                succeeded = this.mediaPlayer.resumePrepareDrm(this.uuid);
                this.status = succeeded ? 0 : 3;
            }
            this.mediaPlayer.mDrmProvisioningInProgress = false;
            this.mediaPlayer.mPrepareDrmInProgress = false;
            if (!succeeded) {
                MediaPlayer2Impl.this.cleanDrmObj();
            }
            this.finished = true;
        }
    }

    public static final class ProvisioningServerErrorExceptionImpl
    extends MediaPlayer2.ProvisioningServerErrorException {
        public ProvisioningServerErrorExceptionImpl(String detailMessage) {
            super(detailMessage);
        }
    }

    public static final class ProvisioningNetworkErrorExceptionImpl
    extends MediaPlayer2.ProvisioningNetworkErrorException {
        public ProvisioningNetworkErrorExceptionImpl(String detailMessage) {
            super(detailMessage);
        }
    }

    public static final class NoDrmSchemeExceptionImpl
    extends MediaPlayer2.NoDrmSchemeException {
        public NoDrmSchemeExceptionImpl(String detailMessage) {
            super(detailMessage);
        }
    }

    public static final class DrmInfoImpl
    extends MediaPlayer2.DrmInfo {
        private Map<UUID, byte[]> mapPssh;
        private UUID[] supportedSchemes;

        @Override
        public Map<UUID, byte[]> getPssh() {
            return this.mapPssh;
        }

        @Override
        public List<UUID> getSupportedSchemes() {
            return Arrays.asList(this.supportedSchemes);
        }

        private DrmInfoImpl(Map<UUID, byte[]> Pssh, UUID[] SupportedSchemes) {
            this.mapPssh = Pssh;
            this.supportedSchemes = SupportedSchemes;
        }

        private DrmInfoImpl(Parcel parcel) {
            Log.v(MediaPlayer2Impl.TAG, "DrmInfoImpl(" + parcel + ") size " + parcel.dataSize());
            int psshsize = parcel.readInt();
            byte[] pssh = new byte[psshsize];
            parcel.readByteArray(pssh);
            Log.v(MediaPlayer2Impl.TAG, "DrmInfoImpl() PSSH: " + this.arrToHex(pssh));
            this.mapPssh = this.parsePSSH(pssh, psshsize);
            Log.v(MediaPlayer2Impl.TAG, "DrmInfoImpl() PSSH: " + this.mapPssh);
            int supportedDRMsCount = parcel.readInt();
            this.supportedSchemes = new UUID[supportedDRMsCount];
            for (int i = 0; i < supportedDRMsCount; ++i) {
                byte[] uuid = new byte[16];
                parcel.readByteArray(uuid);
                this.supportedSchemes[i] = this.bytesToUUID(uuid);
                Log.v(MediaPlayer2Impl.TAG, "DrmInfoImpl() supportedScheme[" + i + "]: " + this.supportedSchemes[i]);
            }
            Log.v(MediaPlayer2Impl.TAG, "DrmInfoImpl() Parcel psshsize: " + psshsize + " supportedDRMsCount: " + supportedDRMsCount);
        }

        private DrmInfoImpl makeCopy() {
            return new DrmInfoImpl(this.mapPssh, this.supportedSchemes);
        }

        private String arrToHex(byte[] bytes) {
            String out = "0x";
            for (int i = 0; i < bytes.length; ++i) {
                out = out + String.format("%02x", bytes[i]);
            }
            return out;
        }

        private UUID bytesToUUID(byte[] uuid) {
            long msb = 0L;
            long lsb = 0L;
            for (int i = 0; i < 8; ++i) {
                msb |= ((long)uuid[i] & 0xFFL) << 8 * (7 - i);
                lsb |= ((long)uuid[i + 8] & 0xFFL) << 8 * (7 - i);
            }
            return new UUID(msb, lsb);
        }

        private Map<UUID, byte[]> parsePSSH(byte[] pssh, int psshsize) {
            HashMap<UUID, byte[]> result = new HashMap<UUID, byte[]>();
            int UUID_SIZE = 16;
            int DATALEN_SIZE = 4;
            int len = psshsize;
            int numentries = 0;
            int i = 0;
            while (len > 0) {
                if (len < 16) {
                    Log.w(MediaPlayer2Impl.TAG, String.format("parsePSSH: len is too short to parse UUID: (%d < 16) pssh: %d", len, psshsize));
                    return null;
                }
                byte[] subset = Arrays.copyOfRange(pssh, i, i + 16);
                UUID uuid = this.bytesToUUID(subset);
                i += 16;
                if ((len -= 16) < 4) {
                    Log.w(MediaPlayer2Impl.TAG, String.format("parsePSSH: len is too short to parse datalen: (%d < 4) pssh: %d", len, psshsize));
                    return null;
                }
                subset = Arrays.copyOfRange(pssh, i, i + 4);
                int datalen = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? (subset[3] & 0xFF) << 24 | (subset[2] & 0xFF) << 16 | (subset[1] & 0xFF) << 8 | subset[0] & 0xFF : (subset[0] & 0xFF) << 24 | (subset[1] & 0xFF) << 16 | (subset[2] & 0xFF) << 8 | subset[3] & 0xFF;
                i += 4;
                if ((len -= 4) < datalen) {
                    Log.w(MediaPlayer2Impl.TAG, String.format("parsePSSH: len is too short to parse data: (%d < %d) pssh: %d", len, datalen, psshsize));
                    return null;
                }
                byte[] data = Arrays.copyOfRange(pssh, i, i + datalen);
                i += datalen;
                len -= datalen;
                Log.v(MediaPlayer2Impl.TAG, String.format("parsePSSH[%d]: <%s, %s> pssh: %d", numentries, uuid, this.arrToHex(data), psshsize));
                ++numentries;
                result.put(uuid, data);
            }
            return result;
        }
    }

    private class EventHandler
    extends Handler {
        private MediaPlayer2Impl mMediaPlayer;

        public EventHandler(MediaPlayer2Impl mp, Looper looper) {
            super(looper);
            this.mMediaPlayer = mp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            if (this.mMediaPlayer.mNativeContext == 0L) {
                Log.w(MediaPlayer2Impl.TAG, "mediaplayer2 went away with unhandled events");
                return;
            }
            int what = msg.arg1;
            int extra = msg.arg2;
            switch (msg.what) {
                case 1: {
                    try {
                        MediaPlayer2Impl.this.scanInternalSubtitleTracks();
                    }
                    catch (RuntimeException e) {
                        Message msg2 = this.obtainMessage(100, 1, -1010, null);
                        this.sendMessage(msg2);
                    }
                    Object e = MediaPlayer2Impl.this.mEventCbLock;
                    synchronized (e) {
                        for (Pair cb : MediaPlayer2Impl.this.mEventCallbackRecords) {
                            ((Executor)cb.first).execute(() -> ((MediaPlayer2.EventCallback)cb.second).onInfo(this.mMediaPlayer, 0L, 100, 0));
                        }
                    }
                    return;
                }
                case 210: {
                    if (msg.obj == null) {
                        Log.w(MediaPlayer2Impl.TAG, "MEDIA_DRM_INFO msg.obj=NULL");
                    } else if (msg.obj instanceof Parcel) {
                        DrmInfoImpl drmInfo;
                        Object msg2 = MediaPlayer2Impl.this.mDrmLock;
                        synchronized (msg2) {
                            drmInfo = MediaPlayer2Impl.this.mDrmInfoImpl != null ? MediaPlayer2Impl.this.mDrmInfoImpl.makeCopy() : null;
                        }
                        if (drmInfo != null) {
                            msg2 = MediaPlayer2Impl.this.mEventCbLock;
                            synchronized (msg2) {
                                for (Pair cb : MediaPlayer2Impl.this.mDrmEventCallbackRecords) {
                                    ((Executor)cb.first).execute(() -> ((MediaPlayer2.DrmEventCallback)cb.second).onDrmInfo(this.mMediaPlayer, drmInfo));
                                }
                            }
                        }
                    } else {
                        Log.w(MediaPlayer2Impl.TAG, "MEDIA_DRM_INFO msg.obj of unexpected type " + msg.obj);
                    }
                    return;
                }
                case 2: {
                    Object drmInfo = MediaPlayer2Impl.this.mEventCbLock;
                    synchronized (drmInfo) {
                        for (Pair cb : MediaPlayer2Impl.this.mEventCallbackRecords) {
                            ((Executor)cb.first).execute(() -> ((MediaPlayer2.EventCallback)cb.second).onInfo(this.mMediaPlayer, 0L, 5, 0));
                        }
                    }
                    MediaPlayer2Impl.this.stayAwake(false);
                    return;
                }
                case 8: {
                    TimeProvider timeProvider = MediaPlayer2Impl.this.mTimeProvider;
                    if (timeProvider == null) break;
                    timeProvider.onStopped();
                    break;
                }
                case 6: 
                case 7: {
                    TimeProvider timeProvider = MediaPlayer2Impl.this.mTimeProvider;
                    if (timeProvider == null) break;
                    timeProvider.onPaused(msg.what == 7);
                    break;
                }
                case 3: {
                    int percent = msg.arg1;
                    Object msg2 = MediaPlayer2Impl.this.mEventCbLock;
                    synchronized (msg2) {
                        for (Pair cb : MediaPlayer2Impl.this.mEventCallbackRecords) {
                            ((Executor)cb.first).execute(() -> ((MediaPlayer2.EventCallback)cb.second).onBufferingUpdate(this.mMediaPlayer, 0L, percent));
                        }
                    }
                    return;
                }
                case 4: {
                    Object msg2 = MediaPlayer2Impl.this.mEventCbLock;
                    synchronized (msg2) {
                        for (Pair cb : MediaPlayer2Impl.this.mEventCallbackRecords) {
                            ((Executor)cb.first).execute(() -> ((MediaPlayer2.EventCallback)cb.second).onInfo(this.mMediaPlayer, 0L, 103, 0));
                        }
                    }
                }
                case 9: {
                    TimeProvider timeProvider = MediaPlayer2Impl.this.mTimeProvider;
                    if (timeProvider != null) {
                        timeProvider.onSeekComplete(this.mMediaPlayer);
                    }
                    return;
                }
                case 5: {
                    int width = msg.arg1;
                    int height = msg.arg2;
                    Object cb = MediaPlayer2Impl.this.mEventCbLock;
                    synchronized (cb) {
                        for (Pair cb2 : MediaPlayer2Impl.this.mEventCallbackRecords) {
                            ((Executor)cb2.first).execute(() -> ((MediaPlayer2.EventCallback)cb.second).onVideoSizeChanged(this.mMediaPlayer, 0L, width, height));
                        }
                    }
                    return;
                }
                case 100: {
                    Log.e(MediaPlayer2Impl.TAG, "Error (" + msg.arg1 + "," + msg.arg2 + ")");
                    Object cb = MediaPlayer2Impl.this.mEventCbLock;
                    synchronized (cb) {
                        for (Pair cb3 : MediaPlayer2Impl.this.mEventCallbackRecords) {
                            ((Executor)cb3.first).execute(() -> ((MediaPlayer2.EventCallback)cb.second).onError(this.mMediaPlayer, 0L, what, extra));
                            ((Executor)cb3.first).execute(() -> ((MediaPlayer2.EventCallback)cb.second).onInfo(this.mMediaPlayer, 0L, 5, 0));
                        }
                    }
                    MediaPlayer2Impl.this.stayAwake(false);
                    return;
                }
                case 200: {
                    Object timeProvider;
                    switch (msg.arg1) {
                        case 700: {
                            Log.i(MediaPlayer2Impl.TAG, "Info (" + msg.arg1 + "," + msg.arg2 + ")");
                            break;
                        }
                        case 802: {
                            try {
                                MediaPlayer2Impl.this.scanInternalSubtitleTracks();
                            }
                            catch (RuntimeException e) {
                                Message msg2 = this.obtainMessage(100, 1, -1010, null);
                                this.sendMessage(msg2);
                            }
                        }
                        case 803: {
                            msg.arg1 = 802;
                            if (MediaPlayer2Impl.this.mSubtitleController == null) break;
                            MediaPlayer2Impl.this.mSubtitleController.selectDefaultTrack();
                            break;
                        }
                        case 701: 
                        case 702: {
                            timeProvider = MediaPlayer2Impl.this.mTimeProvider;
                            if (timeProvider == null) break;
                            ((TimeProvider)timeProvider).onBuffering(msg.arg1 == 701);
                        }
                    }
                    timeProvider = MediaPlayer2Impl.this.mEventCbLock;
                    synchronized (timeProvider) {
                        for (Pair cb : MediaPlayer2Impl.this.mEventCallbackRecords) {
                            ((Executor)cb.first).execute(() -> ((MediaPlayer2.EventCallback)cb.second).onInfo(this.mMediaPlayer, 0L, what, extra));
                        }
                    }
                    return;
                }
                case 98: {
                    TimeProvider timeProvider = MediaPlayer2Impl.this.mTimeProvider;
                    if (timeProvider != null) {
                        timeProvider.onNotifyTime();
                    }
                    return;
                }
                case 99: {
                    TimedText text;
                    Object parcel;
                    if (msg.obj instanceof Parcel) {
                        parcel = (Parcel)msg.obj;
                        text = new TimedText((Parcel)parcel);
                        ((Parcel)parcel).recycle();
                    } else {
                        text = null;
                    }
                    parcel = MediaPlayer2Impl.this.mEventCbLock;
                    synchronized (parcel) {
                        for (Pair cb : MediaPlayer2Impl.this.mEventCallbackRecords) {
                            ((Executor)cb.first).execute(() -> ((MediaPlayer2.EventCallback)cb.second).onTimedText(this.mMediaPlayer, 0L, text));
                        }
                    }
                    return;
                }
                case 201: {
                    MediaPlayer2.OnSubtitleDataListener onSubtitleDataListener = MediaPlayer2Impl.this.mOnSubtitleDataListener;
                    if (onSubtitleDataListener == null) {
                        return;
                    }
                    if (msg.obj instanceof Parcel) {
                        Parcel parcel = (Parcel)msg.obj;
                        SubtitleData data = new SubtitleData(parcel);
                        parcel.recycle();
                        onSubtitleDataListener.onSubtitleData(this.mMediaPlayer, data);
                    }
                    return;
                }
                case 202: {
                    TimedMetaData data;
                    if (msg.obj instanceof Parcel) {
                        Parcel parcel = (Parcel)msg.obj;
                        data = TimedMetaData.createTimedMetaDataFromParcel(parcel);
                        parcel.recycle();
                    } else {
                        data = null;
                    }
                    Object object = MediaPlayer2Impl.this.mEventCbLock;
                    synchronized (object) {
                        for (Pair cb : MediaPlayer2Impl.this.mEventCallbackRecords) {
                            ((Executor)cb.first).execute(() -> ((MediaPlayer2.EventCallback)cb.second).onTimedMetaDataAvailable(this.mMediaPlayer, 0L, data));
                        }
                    }
                    return;
                }
                case 0: {
                    break;
                }
                case 10000: {
                    AudioManager.resetAudioPortGeneration();
                    ArrayMap arrayMap = MediaPlayer2Impl.this.mRoutingChangeListeners;
                    synchronized (arrayMap) {
                        for (NativeRoutingEventHandlerDelegate delegate : MediaPlayer2Impl.this.mRoutingChangeListeners.values()) {
                            delegate.notifyClient();
                        }
                    }
                    return;
                }
                default: {
                    Log.e(MediaPlayer2Impl.TAG, "Unknown message type " + msg.what);
                    return;
                }
            }
        }
    }

    public static final class TrackInfoImpl
    extends MediaPlayer2.TrackInfo {
        final int mTrackType;
        final MediaFormat mFormat;
        static final Parcelable.Creator<TrackInfoImpl> CREATOR = new Parcelable.Creator<TrackInfoImpl>(){

            @Override
            public TrackInfoImpl createFromParcel(Parcel in) {
                return new TrackInfoImpl(in);
            }

            public TrackInfoImpl[] newArray(int size) {
                return new TrackInfoImpl[size];
            }
        };

        @Override
        public int getTrackType() {
            return this.mTrackType;
        }

        @Override
        public String getLanguage() {
            String language = this.mFormat.getString("language");
            return language == null ? "und" : language;
        }

        @Override
        public MediaFormat getFormat() {
            if (this.mTrackType == 3 || this.mTrackType == 4) {
                return this.mFormat;
            }
            return null;
        }

        TrackInfoImpl(Parcel in) {
            this.mTrackType = in.readInt();
            String mime = in.readString();
            String language = in.readString();
            this.mFormat = MediaFormat.createSubtitleFormat(mime, language);
            if (this.mTrackType == 4) {
                this.mFormat.setInteger("is-autoselect", in.readInt());
                this.mFormat.setInteger("is-default", in.readInt());
                this.mFormat.setInteger("is-forced-subtitle", in.readInt());
            }
        }

        TrackInfoImpl(int type, MediaFormat format) {
            this.mTrackType = type;
            this.mFormat = format;
        }

        void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mTrackType);
            dest.writeString(this.getLanguage());
            if (this.mTrackType == 4) {
                dest.writeString(this.mFormat.getString("mime"));
                dest.writeInt(this.mFormat.getInteger("is-autoselect"));
                dest.writeInt(this.mFormat.getInteger("is-default"));
                dest.writeInt(this.mFormat.getInteger("is-forced-subtitle"));
            }
        }

        @Override
        public String toString() {
            StringBuilder out = new StringBuilder(128);
            out.append(this.getClass().getName());
            out.append('{');
            switch (this.mTrackType) {
                case 1: {
                    out.append("VIDEO");
                    break;
                }
                case 2: {
                    out.append("AUDIO");
                    break;
                }
                case 3: {
                    out.append("TIMEDTEXT");
                    break;
                }
                case 4: {
                    out.append("SUBTITLE");
                    break;
                }
                default: {
                    out.append("UNKNOWN");
                }
            }
            out.append(", " + this.mFormat.toString());
            out.append("}");
            return out.toString();
        }
    }
}

