/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.content.Context;
import android.media.MediaItem2;
import android.media.MediaMetadata2;
import android.media.MediaPlayerInterface;
import android.media.PlaybackState2;
import android.media.Rating2;
import android.media.SessionToken2;
import android.media.VolumeProvider2;
import android.media.update.ApiLoader;
import android.media.update.MediaSession2Provider;
import android.media.update.ProviderCreator;
import android.net.Uri;
import android.os.Bundle;
import android.os.IInterface;
import android.os.ResultReceiver;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.concurrent.Executor;

public class MediaSession2
implements AutoCloseable {
    private final MediaSession2Provider mProvider;
    public static final int COMMAND_CODE_CUSTOM = 0;
    public static final int COMMAND_CODE_PLAYBACK_PLAY = 1;
    public static final int COMMAND_CODE_PLAYBACK_PAUSE = 2;
    public static final int COMMAND_CODE_PLAYBACK_STOP = 3;
    public static final int COMMAND_CODE_PLAYBACK_SKIP_NEXT_ITEM = 4;
    public static final int COMMAND_CODE_PLAYBACK_SKIP_PREV_ITEM = 5;
    public static final int COMMAND_CODE_PLAYBACK_PREPARE = 6;
    public static final int COMMAND_CODE_PLAYBACK_FAST_FORWARD = 7;
    public static final int COMMAND_CODE_PLAYBACK_REWIND = 8;
    public static final int COMMAND_CODE_PLAYBACK_SEEK_TO = 9;
    public static final int COMMAND_CODE_PLAYBACK_SET_CURRENT_PLAYLIST_ITEM = 10;
    public static final int COMMAND_CODE_PLAYBACK_SET_PLAYLIST_PARAMS = 11;
    public static final int COMMAND_CODE_PLAYLIST_ADD = 12;
    public static final int COMMAND_CODE_PLAYLIST_REMOVE = 13;
    public static final int COMMAND_CODE_PLAYLIST_GET = 14;
    public static final int COMMAND_CODE_SET_VOLUME = 15;
    public static final int COMMAND_CODE_PLAY_FROM_MEDIA_ID = 16;
    public static final int COMMAND_CODE_PLAY_FROM_URI = 17;
    public static final int COMMAND_CODE_PLAY_FROM_SEARCH = 18;
    public static final int COMMAND_CODE_PREPARE_FROM_MEDIA_ID = 19;
    public static final int COMMAND_CODE_PREPARE_FROM_URI = 20;
    public static final int COMMAND_CODE_PREPARE_FROM_SEARCH = 21;
    public static final int COMMAND_CODE_BROWSER = 22;

    @SystemApi
    public MediaSession2(MediaSession2Provider provider) {
        this.mProvider = provider;
    }

    @SystemApi
    public MediaSession2Provider getProvider() {
        return this.mProvider;
    }

    public void setPlayer(MediaPlayerInterface player) {
        this.mProvider.setPlayer_impl(player);
    }

    public void setPlayer(MediaPlayerInterface player, VolumeProvider2 volumeProvider) {
        this.mProvider.setPlayer_impl(player, volumeProvider);
    }

    @Override
    public void close() {
        this.mProvider.close_impl();
    }

    public MediaPlayerInterface getPlayer() {
        return this.mProvider.getPlayer_impl();
    }

    public SessionToken2 getToken() {
        return this.mProvider.getToken_impl();
    }

    public List<ControllerInfo> getConnectedControllers() {
        return this.mProvider.getConnectedControllers_impl();
    }

    public void setAudioFocusRequest(int focusGain) {
        this.mProvider.setAudioFocusRequest_impl(focusGain);
    }

    public void setCustomLayout(ControllerInfo controller, List<CommandButton> layout2) {
        this.mProvider.setCustomLayout_impl(controller, layout2);
    }

    public void setAllowedCommands(ControllerInfo controller, CommandGroup commands) {
        this.mProvider.setAllowedCommands_impl(controller, commands);
    }

    public void notifyMetadataChanged() {
        this.mProvider.notifyMetadataChanged_impl();
    }

    public void sendCustomCommand(Command command, Bundle args) {
        this.mProvider.sendCustomCommand_impl(command, args);
    }

    public void sendCustomCommand(ControllerInfo controller, Command command, Bundle args, ResultReceiver receiver) {
        this.mProvider.sendCustomCommand_impl(controller, command, args, receiver);
    }

    public void play() {
        this.mProvider.play_impl();
    }

    public void pause() {
        this.mProvider.pause_impl();
    }

    public void stop() {
        this.mProvider.stop_impl();
    }

    public void skipToPrevious() {
        this.mProvider.skipToPrevious_impl();
    }

    public void skipToNext() {
        this.mProvider.skipToNext_impl();
    }

    public void prepare() {
        this.mProvider.prepare_impl();
    }

    public void fastForward() {
        this.mProvider.fastForward_impl();
    }

    public void rewind() {
        this.mProvider.rewind_impl();
    }

    public void seekTo(long pos) {
        this.mProvider.seekTo_impl(pos);
    }

    public void setCurrentPlaylistItem(int index) {
        this.mProvider.setCurrentPlaylistItem_impl(index);
    }

    public void skipForward() {
    }

    public void skipBackward() {
    }

    public void setPlaylist(List<MediaItem2> playlist) {
        this.mProvider.setPlaylist_impl(playlist);
    }

    public List<MediaItem2> getPlaylist() {
        return this.mProvider.getPlaylist_impl();
    }

    public void setPlaylistParams(PlaylistParams params) {
        this.mProvider.setPlaylistParams_impl(params);
    }

    public PlaylistParams getPlaylistParams() {
        return this.mProvider.getPlaylistParams_impl();
    }

    public void addPlaybackListener(Executor executor, MediaPlayerInterface.PlaybackListener listener) {
        this.mProvider.addPlaybackListener_impl(executor, listener);
    }

    public void removePlaybackListener(MediaPlayerInterface.PlaybackListener listener) {
        this.mProvider.removePlaybackListener_impl(listener);
    }

    public PlaybackState2 getPlaybackState() {
        return this.mProvider.getPlaybackState_impl();
    }

    public static final class PlaylistParams {
        public static final int REPEAT_MODE_NONE = 0;
        public static final int REPEAT_MODE_ONE = 1;
        public static final int REPEAT_MODE_ALL = 2;
        public static final int REPEAT_MODE_GROUP = 3;
        public static final int SHUFFLE_MODE_NONE = 0;
        public static final int SHUFFLE_MODE_ALL = 1;
        public static final int SHUFFLE_MODE_GROUP = 2;
        private final MediaSession2Provider.PlaylistParamsProvider mProvider;

        public PlaylistParams(Context context, int repeatMode, int shuffleMode, MediaMetadata2 playlistMetadata) {
            this.mProvider = ApiLoader.getProvider(context).createMediaSession2PlaylistParams(context, this, repeatMode, shuffleMode, playlistMetadata);
        }

        public Bundle toBundle() {
            return this.mProvider.toBundle_impl();
        }

        public static PlaylistParams fromBundle(Context context, Bundle bundle) {
            return ApiLoader.getProvider(context).fromBundle_PlaylistParams(context, bundle);
        }

        public int getRepeatMode() {
            return this.mProvider.getRepeatMode_impl();
        }

        public int getShuffleMode() {
            return this.mProvider.getShuffleMode_impl();
        }

        public MediaMetadata2 getPlaylistMetadata() {
            return this.mProvider.getPlaylistMetadata_impl();
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ShuffleMode {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RepeatMode {
        }
    }

    public static class CommandButton {
        private final MediaSession2Provider.CommandButtonProvider mProvider;

        @SystemApi
        public CommandButton(MediaSession2Provider.CommandButtonProvider provider) {
            this.mProvider = provider;
        }

        public Command getCommand() {
            return this.mProvider.getCommand_impl();
        }

        public int getIconResId() {
            return this.mProvider.getIconResId_impl();
        }

        public String getDisplayName() {
            return this.mProvider.getDisplayName_impl();
        }

        public Bundle getExtra() {
            return this.mProvider.getExtra_impl();
        }

        public boolean isEnabled() {
            return this.mProvider.isEnabled_impl();
        }

        @SystemApi
        public MediaSession2Provider.CommandButtonProvider getProvider() {
            return this.mProvider;
        }

        public static class Builder {
            private final MediaSession2Provider.CommandButtonProvider.BuilderProvider mProvider;

            public Builder(Context context) {
                this.mProvider = ApiLoader.getProvider(context).createMediaSession2CommandButtonBuilder(context, this);
            }

            public Builder setCommand(Command command) {
                return this.mProvider.setCommand_impl(command);
            }

            public Builder setIconResId(int resId) {
                return this.mProvider.setIconResId_impl(resId);
            }

            public Builder setDisplayName(String displayName) {
                return this.mProvider.setDisplayName_impl(displayName);
            }

            public Builder setEnabled(boolean enabled) {
                return this.mProvider.setEnabled_impl(enabled);
            }

            public Builder setExtra(Bundle extra) {
                return this.mProvider.setExtra_impl(extra);
            }

            public CommandButton build() {
                return this.mProvider.build_impl();
            }
        }
    }

    public static final class ControllerInfo {
        private final MediaSession2Provider.ControllerInfoProvider mProvider;

        public ControllerInfo(Context context, int uid, int pid, String packageName, IInterface callback) {
            this.mProvider = ApiLoader.getProvider(context).createMediaSession2ControllerInfo(context, this, uid, pid, packageName, callback);
        }

        public String getPackageName() {
            return this.mProvider.getPackageName_impl();
        }

        public int getUid() {
            return this.mProvider.getUid_impl();
        }

        public boolean isTrusted() {
            return this.mProvider.isTrusted_impl();
        }

        @SystemApi
        public MediaSession2Provider.ControllerInfoProvider getProvider() {
            return this.mProvider;
        }

        public int hashCode() {
            return this.mProvider.hashCode_impl();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ControllerInfo)) {
                return false;
            }
            ControllerInfo other = (ControllerInfo)obj;
            return this.mProvider.equals_impl(other.mProvider);
        }

        public String toString() {
            return "ControllerInfo {pkg=" + this.getPackageName() + ", uid=" + this.getUid() + ", trusted=" + this.isTrusted() + "}";
        }
    }

    public static final class Builder
    extends BuilderBase<MediaSession2, Builder, SessionCallback> {
        public Builder(Context context, MediaPlayerInterface player) {
            super(instance -> ApiLoader.getProvider(context).createMediaSession2Builder(context, (Builder)instance, player));
        }

        @Override
        public Builder setVolumeProvider(VolumeProvider2 volumeProvider) {
            return (Builder)super.setVolumeProvider(volumeProvider);
        }

        @Override
        public Builder setRatingType(int type) {
            return (Builder)super.setRatingType(type);
        }

        @Override
        public Builder setSessionActivity(PendingIntent pi) {
            return (Builder)super.setSessionActivity(pi);
        }

        @Override
        public Builder setId(String id2) {
            return (Builder)super.setId(id2);
        }

        @Override
        public Builder setSessionCallback(Executor executor, SessionCallback callback) {
            return (Builder)super.setSessionCallback(executor, callback);
        }

        @Override
        public MediaSession2 build() {
            return super.build();
        }
    }

    static abstract class BuilderBase<T extends MediaSession2, U extends BuilderBase<T, U, C>, C extends SessionCallback> {
        private final MediaSession2Provider.BuilderBaseProvider<T, C> mProvider;

        BuilderBase(ProviderCreator<BuilderBase<T, U, C>, MediaSession2Provider.BuilderBaseProvider<T, C>> creator) {
            this.mProvider = creator.createProvider(this);
        }

        U setVolumeProvider(VolumeProvider2 volumeProvider) {
            this.mProvider.setVolumeProvider_impl(volumeProvider);
            return (U)this;
        }

        U setRatingType(int type) {
            this.mProvider.setRatingType_impl(type);
            return (U)this;
        }

        U setSessionActivity(PendingIntent pi) {
            this.mProvider.setSessionActivity_impl(pi);
            return (U)this;
        }

        U setId(String id2) {
            this.mProvider.setId_impl(id2);
            return (U)this;
        }

        U setSessionCallback(Executor executor, C callback) {
            this.mProvider.setSessionCallback_impl(executor, callback);
            return (U)this;
        }

        T build() {
            return this.mProvider.build_impl();
        }
    }

    public static class SessionCallback {
        private final Context mContext;

        public SessionCallback(Context context) {
            this.mContext = context;
        }

        public CommandGroup onConnect(ControllerInfo controller) {
            CommandGroup commands = new CommandGroup(this.mContext);
            commands.addAllPredefinedCommands();
            return commands;
        }

        public void onDisconnected(ControllerInfo controller) {
        }

        public boolean onCommandRequest(ControllerInfo controller, Command command) {
            return true;
        }

        public void onSetRating(ControllerInfo controller, Rating2 rating) {
        }

        public void onCustomCommand(ControllerInfo controller, Command customCommand, Bundle args, ResultReceiver cb) {
        }

        public void onPlayFromMediaId(ControllerInfo controller, String mediaId, Bundle extras) {
        }

        public void onPlayFromSearch(ControllerInfo controller, String query, Bundle extras) {
        }

        public void onPlayFromUri(ControllerInfo controller, Uri uri, Bundle extras) {
        }

        public void onPrepareFromMediaId(ControllerInfo controller, String mediaId, Bundle extras) {
        }

        public void onPrepareFromSearch(ControllerInfo controller, String query, Bundle extras) {
        }

        public void onPrepareFromUri(ControllerInfo controller, Uri uri, Bundle extras) {
        }
    }

    public static class CommandGroup {
        private final MediaSession2Provider.CommandGroupProvider mProvider;

        public CommandGroup(Context context) {
            this.mProvider = ApiLoader.getProvider(context).createMediaSession2CommandGroup(context, this, null);
        }

        public CommandGroup(Context context, CommandGroup others) {
            this.mProvider = ApiLoader.getProvider(context).createMediaSession2CommandGroup(context, this, others);
        }

        public void addCommand(Command command) {
            this.mProvider.addCommand_impl(command);
        }

        public void addAllPredefinedCommands() {
            this.mProvider.addAllPredefinedCommands_impl();
        }

        public void removeCommand(Command command) {
            this.mProvider.removeCommand_impl(command);
        }

        public boolean hasCommand(Command command) {
            return this.mProvider.hasCommand_impl(command);
        }

        public boolean hasCommand(int code) {
            return this.mProvider.hasCommand_impl(code);
        }

        @SystemApi
        public MediaSession2Provider.CommandGroupProvider getProvider() {
            return this.mProvider;
        }

        public Bundle toBundle() {
            return this.mProvider.toBundle_impl();
        }

        public static CommandGroup fromBundle(Context context, Bundle commands) {
            return ApiLoader.getProvider(context).fromBundle_MediaSession2CommandGroup(context, commands);
        }
    }

    public static final class Command {
        private final MediaSession2Provider.CommandProvider mProvider;

        public Command(Context context, int commandCode) {
            this.mProvider = ApiLoader.getProvider(context).createMediaSession2Command(this, commandCode, null, null);
        }

        public Command(Context context, String action, Bundle extra) {
            if (action == null) {
                throw new IllegalArgumentException("action shouldn't be null");
            }
            this.mProvider = ApiLoader.getProvider(context).createMediaSession2Command(this, 0, action, extra);
        }

        public int getCommandCode() {
            return this.mProvider.getCommandCode_impl();
        }

        public String getCustomCommand() {
            return this.mProvider.getCustomCommand_impl();
        }

        public Bundle getExtra() {
            return this.mProvider.getExtra_impl();
        }

        public Bundle toBundle() {
            return this.mProvider.toBundle_impl();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Command)) {
                return false;
            }
            return this.mProvider.equals_impl(((Command)obj).mProvider);
        }

        public int hashCode() {
            return this.mProvider.hashCode_impl();
        }

        public static Command fromBundle(Context context, Bundle command) {
            return ApiLoader.getProvider(context).fromBundle_MediaSession2Command(context, command);
        }
    }
}

