/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.media.update.ApiLoader;
import android.media.update.PlaybackState2Provider;
import android.os.Bundle;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class PlaybackState2 {
    public static final int STATE_NONE = 0;
    public static final int STATE_STOPPED = 1;
    public static final int STATE_PAUSED = 2;
    public static final int STATE_PLAYING = 3;
    public static final int STATE_BUFFERING = 4;
    public static final int STATE_ERROR = 5;
    public static final long PLAYBACK_POSITION_UNKNOWN = -1L;
    private final PlaybackState2Provider mProvider;

    public PlaybackState2(Context context, int state, long position, long updateTime, float speed, long bufferedPosition, long activeItemId, CharSequence error) {
        this.mProvider = ApiLoader.getProvider(context).createPlaybackState2(context, this, state, position, updateTime, speed, bufferedPosition, activeItemId, error);
    }

    public String toString() {
        return this.mProvider.toString_impl();
    }

    public int getState() {
        return this.mProvider.getState_impl();
    }

    public long getPosition() {
        return this.mProvider.getPosition_impl();
    }

    public long getBufferedPosition() {
        return this.mProvider.getBufferedPosition_impl();
    }

    public float getPlaybackSpeed() {
        return this.mProvider.getPlaybackSpeed_impl();
    }

    public CharSequence getErrorMessage() {
        return this.mProvider.getErrorMessage_impl();
    }

    public long getLastPositionUpdateTime() {
        return this.mProvider.getLastPositionUpdateTime_impl();
    }

    public long getCurrentPlaylistItemIndex() {
        return this.mProvider.getCurrentPlaylistItemIndex_impl();
    }

    public Bundle toBundle() {
        return this.mProvider.toBundle_impl();
    }

    public static PlaybackState2 fromBundle(Context context, Bundle bundle) {
        return ApiLoader.getProvider(context).fromBundle_PlaybackState2(context, bundle);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

