/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.annotation.SystemApi;
import android.content.ComponentName;
import android.content.Context;
import android.media.IRemoteVolumeController;
import android.media.ISessionTokensListener;
import android.media.SessionToken2;
import android.media.session.IActiveSessionsListener;
import android.media.session.ICallback;
import android.media.session.IOnMediaKeyListener;
import android.media.session.IOnVolumeKeyLongPressListener;
import android.media.session.ISession;
import android.media.session.ISessionController;
import android.media.session.ISessionManager;
import android.media.session.MediaController;
import android.media.session.MediaSession;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Log;
import android.view.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;

public final class MediaSessionManager {
    private static final String TAG = "SessionManager";
    public static final int RESULT_MEDIA_KEY_NOT_HANDLED = 0;
    public static final int RESULT_MEDIA_KEY_HANDLED = 1;
    private final ArrayMap<OnActiveSessionsChangedListener, SessionsChangedWrapper> mListeners = new ArrayMap();
    private final ArrayMap<OnSessionTokensChangedListener, SessionTokensChangedWrapper> mSessionTokensListener = new ArrayMap();
    private final Object mLock = new Object();
    private final ISessionManager mService;
    private Context mContext;
    private CallbackImpl mCallback;
    private OnVolumeKeyLongPressListenerImpl mOnVolumeKeyLongPressListener;
    private OnMediaKeyListenerImpl mOnMediaKeyListener;

    public MediaSessionManager(Context context) {
        this.mContext = context;
        IBinder b = ServiceManager.getService("media_session");
        this.mService = ISessionManager.Stub.asInterface(b);
    }

    public ISession createSession(MediaSession.CallbackStub cbStub, String tag, int userId) throws RemoteException {
        return this.mService.createSession(this.mContext.getPackageName(), cbStub, tag, userId);
    }

    public List<MediaController> getActiveSessions(ComponentName notificationListener) {
        return this.getActiveSessionsForUser(notificationListener, UserHandle.myUserId());
    }

    public List<MediaController> getActiveSessionsForUser(ComponentName notificationListener, int userId) {
        ArrayList<MediaController> controllers = new ArrayList<MediaController>();
        try {
            List<IBinder> binders = this.mService.getSessions(notificationListener, userId);
            int size = binders.size();
            for (int i = 0; i < size; ++i) {
                MediaController controller = new MediaController(this.mContext, ISessionController.Stub.asInterface(binders.get(i)));
                controllers.add(controller);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get active sessions: ", e);
        }
        return controllers;
    }

    public void addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener sessionListener, ComponentName notificationListener) {
        this.addOnActiveSessionsChangedListener(sessionListener, notificationListener, null);
    }

    public void addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener sessionListener, ComponentName notificationListener, Handler handler) {
        this.addOnActiveSessionsChangedListener(sessionListener, notificationListener, UserHandle.myUserId(), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener sessionListener, ComponentName notificationListener, int userId, Handler handler) {
        if (sessionListener == null) {
            throw new IllegalArgumentException("listener may not be null");
        }
        if (handler == null) {
            handler = new Handler();
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mListeners.get(sessionListener) != null) {
                Log.w(TAG, "Attempted to add session listener twice, ignoring.");
                return;
            }
            SessionsChangedWrapper wrapper = new SessionsChangedWrapper(this.mContext, sessionListener, handler);
            try {
                this.mService.addSessionsListener(wrapper.mStub, notificationListener, userId);
                this.mListeners.put(sessionListener, wrapper);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error in addOnActiveSessionsChangedListener.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnActiveSessionsChangedListener(OnActiveSessionsChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener may not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            SessionsChangedWrapper wrapper = this.mListeners.remove(listener);
            if (wrapper != null) {
                try {
                    this.mService.removeSessionsListener(wrapper.mStub);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Error in removeOnActiveSessionsChangedListener.", e);
                }
                finally {
                    wrapper.release();
                }
            }
        }
    }

    public void setRemoteVolumeController(IRemoteVolumeController rvc) {
        try {
            this.mService.setRemoteVolumeController(rvc);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in setRemoteVolumeController.", e);
        }
    }

    public void dispatchMediaKeyEvent(KeyEvent keyEvent) {
        this.dispatchMediaKeyEvent(keyEvent, false);
    }

    public void dispatchMediaKeyEvent(KeyEvent keyEvent, boolean needWakeLock) {
        try {
            this.mService.dispatchMediaKeyEvent(keyEvent, needWakeLock);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to send key event.", e);
        }
    }

    public void dispatchVolumeKeyEvent(KeyEvent keyEvent, int stream, boolean musicOnly) {
        try {
            this.mService.dispatchVolumeKeyEvent(keyEvent, stream, musicOnly);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to send volume key event.", e);
        }
    }

    public void dispatchAdjustVolume(int suggestedStream, int direction, int flags) {
        try {
            this.mService.dispatchAdjustVolume(suggestedStream, direction, flags);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to send adjust volume.", e);
        }
    }

    public boolean onSessionCreated(SessionToken2 token) {
        if (token == null) {
            return false;
        }
        try {
            return this.mService.onSessionCreated(token.toBundle());
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Cannot communicate with the service.", e);
            return false;
        }
    }

    public void onSessionDestroyed(SessionToken2 token) {
        if (token == null) {
            return;
        }
        try {
            this.mService.onSessionDestroyed(token.toBundle());
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Cannot communicate with the service.", e);
        }
    }

    public List<SessionToken2> getActiveSessionTokens() {
        try {
            List<Bundle> bundles = this.mService.getSessionTokens(true, false);
            return MediaSessionManager.toTokenList(this.mContext, bundles);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Cannot communicate with the service.", e);
            return Collections.emptyList();
        }
    }

    public List<SessionToken2> getSessionServiceTokens() {
        try {
            List<Bundle> bundles = this.mService.getSessionTokens(false, true);
            return MediaSessionManager.toTokenList(this.mContext, bundles);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Cannot communicate with the service.", e);
            return Collections.emptyList();
        }
    }

    public List<SessionToken2> getAllSessionTokens() {
        try {
            List<Bundle> bundles = this.mService.getSessionTokens(false, false);
            return MediaSessionManager.toTokenList(this.mContext, bundles);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Cannot communicate with the service.", e);
            return Collections.emptyList();
        }
    }

    public void addOnSessionTokensChangedListener(Executor executor, OnSessionTokensChangedListener listener) {
        this.addOnSessionTokensChangedListener(UserHandle.myUserId(), executor, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnSessionTokensChangedListener(int userId, Executor executor, OnSessionTokensChangedListener listener) {
        if (executor == null) {
            throw new IllegalArgumentException("executor may not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener may not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionTokensListener.get(listener) != null) {
                Log.w(TAG, "Attempted to add session listener twice, ignoring.");
                return;
            }
            SessionTokensChangedWrapper wrapper = new SessionTokensChangedWrapper(this.mContext, executor, listener);
            try {
                this.mService.addSessionTokensListener(wrapper.mStub, userId, this.mContext.getPackageName());
                this.mSessionTokensListener.put(listener, wrapper);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error in addSessionTokensListener.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnSessionTokensChangedListener(OnSessionTokensChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener may not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            SessionTokensChangedWrapper wrapper = this.mSessionTokensListener.remove(listener);
            if (wrapper != null) {
                try {
                    this.mService.removeSessionTokensListener(wrapper.mStub);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Error in removeSessionTokensListener.", e);
                }
                finally {
                    wrapper.release();
                }
            }
        }
    }

    private static List<SessionToken2> toTokenList(Context context, List<Bundle> bundles) {
        ArrayList<SessionToken2> tokens = new ArrayList<SessionToken2>();
        if (bundles != null) {
            for (int i = 0; i < bundles.size(); ++i) {
                SessionToken2 token = SessionToken2.fromBundle(context, bundles.get(i));
                if (token == null) continue;
                tokens.add(token);
            }
        }
        return tokens;
    }

    public boolean isGlobalPriorityActive() {
        try {
            return this.mService.isGlobalPriorityActive();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to check if the global priority is active.", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void setOnVolumeKeyLongPressListener(OnVolumeKeyLongPressListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (listener == null) {
                    this.mOnVolumeKeyLongPressListener = null;
                    this.mService.setOnVolumeKeyLongPressListener(null);
                } else {
                    if (handler == null) {
                        handler = new Handler();
                    }
                    this.mOnVolumeKeyLongPressListener = new OnVolumeKeyLongPressListenerImpl(listener, handler);
                    this.mService.setOnVolumeKeyLongPressListener(this.mOnVolumeKeyLongPressListener);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to set volume key long press listener", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void setOnMediaKeyListener(OnMediaKeyListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (listener == null) {
                    this.mOnMediaKeyListener = null;
                    this.mService.setOnMediaKeyListener(null);
                } else {
                    if (handler == null) {
                        handler = new Handler();
                    }
                    this.mOnMediaKeyListener = new OnMediaKeyListenerImpl(listener, handler);
                    this.mService.setOnMediaKeyListener(this.mOnMediaKeyListener);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to set media key listener", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(Callback callback, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (callback == null) {
                    this.mCallback = null;
                    this.mService.setCallback(null);
                } else {
                    if (handler == null) {
                        handler = new Handler();
                    }
                    this.mCallback = new CallbackImpl(callback, handler);
                    this.mService.setCallback(this.mCallback);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to set media key callback", e);
            }
        }
    }

    private static final class CallbackImpl
    extends ICallback.Stub {
        private final Callback mCallback;
        private final Handler mHandler;

        public CallbackImpl(Callback callback, Handler handler) {
            this.mCallback = callback;
            this.mHandler = handler;
        }

        @Override
        public void onMediaKeyEventDispatchedToMediaSession(final KeyEvent event, final MediaSession.Token sessionToken) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mCallback.onMediaKeyEventDispatched(event, sessionToken);
                }
            });
        }

        @Override
        public void onMediaKeyEventDispatchedToMediaButtonReceiver(final KeyEvent event, final ComponentName mediaButtonReceiver) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mCallback.onMediaKeyEventDispatched(event, mediaButtonReceiver);
                }
            });
        }

        @Override
        public void onAddressedPlayerChangedToMediaSession(final MediaSession.Token sessionToken) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mCallback.onAddressedPlayerChanged(sessionToken);
                }
            });
        }

        @Override
        public void onAddressedPlayerChangedToMediaButtonReceiver(final ComponentName mediaButtonReceiver) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mCallback.onAddressedPlayerChanged(mediaButtonReceiver);
                }
            });
        }
    }

    private static final class OnMediaKeyListenerImpl
    extends IOnMediaKeyListener.Stub {
        private OnMediaKeyListener mListener;
        private Handler mHandler;

        public OnMediaKeyListenerImpl(OnMediaKeyListener listener, Handler handler) {
            this.mListener = listener;
            this.mHandler = handler;
        }

        @Override
        public void onMediaKey(final KeyEvent event, final ResultReceiver result) {
            if (this.mListener == null || this.mHandler == null) {
                Log.w(MediaSessionManager.TAG, "Failed to call media key listener. Either mListener or mHandler is null");
                return;
            }
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    boolean handled = mListener.onMediaKey(event);
                    Log.d(MediaSessionManager.TAG, "The media key listener is returned " + handled);
                    if (result != null) {
                        result.send(handled ? 1 : 0, null);
                    }
                }
            });
        }
    }

    private static final class OnVolumeKeyLongPressListenerImpl
    extends IOnVolumeKeyLongPressListener.Stub {
        private OnVolumeKeyLongPressListener mListener;
        private Handler mHandler;

        public OnVolumeKeyLongPressListenerImpl(OnVolumeKeyLongPressListener listener, Handler handler) {
            this.mListener = listener;
            this.mHandler = handler;
        }

        @Override
        public void onVolumeKeyLongPress(final KeyEvent event) {
            if (this.mListener == null || this.mHandler == null) {
                Log.w(MediaSessionManager.TAG, "Failed to call volume key long-press listener. Either mListener or mHandler is null");
                return;
            }
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mListener.onVolumeKeyLongPress(event);
                }
            });
        }
    }

    private static final class SessionTokensChangedWrapper {
        private Context mContext;
        private Executor mExecutor;
        private OnSessionTokensChangedListener mListener;
        private final ISessionTokensListener.Stub mStub = new ISessionTokensListener.Stub(){

            @Override
            public void onSessionTokensChanged(List<Bundle> bundles) {
                mExecutor.execute(() -> {
                    List tokens = MediaSessionManager.toTokenList(mContext, bundles);
                    mListener.onSessionTokensChanged(tokens);
                });
            }
        };

        public SessionTokensChangedWrapper(Context context, Executor executor, OnSessionTokensChangedListener listener) {
            this.mContext = context;
            this.mExecutor = executor;
            this.mListener = listener;
        }

        private void release() {
            this.mListener = null;
            this.mContext = null;
            this.mExecutor = null;
        }
    }

    private static final class SessionsChangedWrapper {
        private Context mContext;
        private OnActiveSessionsChangedListener mListener;
        private Handler mHandler;
        private final IActiveSessionsListener.Stub mStub = new IActiveSessionsListener.Stub(){

            @Override
            public void onActiveSessionsChanged(final List<MediaSession.Token> tokens) {
                Handler handler = mHandler;
                if (handler != null) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            Context context = mContext;
                            if (context != null) {
                                ArrayList<MediaController> controllers = new ArrayList<MediaController>();
                                int size = tokens.size();
                                for (int i = 0; i < size; ++i) {
                                    controllers.add(new MediaController(context, (MediaSession.Token)tokens.get(i)));
                                }
                                OnActiveSessionsChangedListener listener = mListener;
                                if (listener != null) {
                                    listener.onActiveSessionsChanged(controllers);
                                }
                            }
                        }
                    });
                }
            }
        };

        public SessionsChangedWrapper(Context context, OnActiveSessionsChangedListener listener, Handler handler) {
            this.mContext = context;
            this.mListener = listener;
            this.mHandler = handler;
        }

        private void release() {
            this.mListener = null;
            this.mContext = null;
            this.mHandler = null;
        }
    }

    public static abstract class Callback {
        public abstract void onMediaKeyEventDispatched(KeyEvent var1, MediaSession.Token var2);

        public abstract void onMediaKeyEventDispatched(KeyEvent var1, ComponentName var2);

        public abstract void onAddressedPlayerChanged(MediaSession.Token var1);

        public abstract void onAddressedPlayerChanged(ComponentName var1);
    }

    @SystemApi
    public static interface OnMediaKeyListener {
        public boolean onMediaKey(KeyEvent var1);
    }

    @SystemApi
    public static interface OnVolumeKeyLongPressListener {
        public void onVolumeKeyLongPress(KeyEvent var1);
    }

    public static interface OnSessionTokensChangedListener {
        public void onSessionTokensChanged(List<SessionToken2> var1);
    }

    public static interface OnActiveSessionsChangedListener {
        public void onActiveSessionsChanged(List<MediaController> var1);
    }
}

