/*
 * Decompiled with CFR 0.152.
 */
package android.media.update;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.media.update.StaticProvider;
import android.os.Build;

public final class ApiLoader {
    private static Object sMediaLibrary;
    private static final String UPDATE_PACKAGE = "com.android.media.update";
    private static final String UPDATE_CLASS = "com.android.media.update.ApiFactory";
    private static final String UPDATE_METHOD = "initialize";

    private ApiLoader() {
    }

    public static StaticProvider getProvider(Context context) {
        try {
            return (StaticProvider)ApiLoader.getMediaLibraryImpl(context);
        }
        catch (PackageManager.NameNotFoundException | ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static synchronized Object getMediaLibraryImpl(Context context) throws PackageManager.NameNotFoundException, ReflectiveOperationException {
        if (sMediaLibrary != null) {
            return sMediaLibrary;
        }
        int flags = Build.IS_DEBUGGABLE ? 0 : 0x200000;
        Context libContext = context.createApplicationContext(context.getPackageManager().getPackageInfo((String)UPDATE_PACKAGE, (int)flags).applicationInfo, 3);
        sMediaLibrary = libContext.getClassLoader().loadClass(UPDATE_CLASS).getMethod(UPDATE_METHOD, Resources.class, Resources.Theme.class).invoke(null, libContext.getResources(), libContext.getTheme());
        return sMediaLibrary;
    }
}

