/*
 * Decompiled with CFR 0.152.
 */
package android.mtp;

import android.content.ContentProviderClient;
import android.database.Cursor;
import android.mtp.MtpPropertyList;
import android.mtp.MtpStorageManager;
import android.net.Uri;
import android.os.RemoteException;
import android.provider.MediaStore;
import android.util.Log;
import java.util.ArrayList;

class MtpPropertyGroup {
    private static final String TAG = MtpPropertyGroup.class.getSimpleName();
    private final ContentProviderClient mProvider;
    private final String mVolumeName;
    private final Uri mUri;
    private final Property[] mProperties;
    private String[] mColumns;
    private static final String PATH_WHERE = "_data=?";

    public MtpPropertyGroup(ContentProviderClient provider, String volumeName, int[] properties) {
        int i;
        this.mProvider = provider;
        this.mVolumeName = volumeName;
        this.mUri = MediaStore.Files.getMtpObjectsUri(volumeName);
        int count = properties.length;
        ArrayList<String> columns = new ArrayList<String>(count);
        columns.add("_id");
        this.mProperties = new Property[count];
        for (i = 0; i < count; ++i) {
            this.mProperties[i] = this.createProperty(properties[i], columns);
        }
        count = columns.size();
        this.mColumns = new String[count];
        for (i = 0; i < count; ++i) {
            this.mColumns[i] = columns.get(i);
        }
    }

    private Property createProperty(int code, ArrayList<String> columns) {
        int type;
        String column = null;
        switch (code) {
            case 56321: {
                type = 6;
                break;
            }
            case 56322: {
                type = 4;
                break;
            }
            case 56323: {
                type = 4;
                break;
            }
            case 56324: {
                type = 8;
                break;
            }
            case 56327: {
                type = 65535;
                break;
            }
            case 56388: {
                type = 65535;
                break;
            }
            case 56329: {
                type = 65535;
                break;
            }
            case 56398: {
                type = 65535;
                break;
            }
            case 56473: {
                column = "year";
                type = 65535;
                break;
            }
            case 56331: {
                type = 6;
                break;
            }
            case 56385: {
                type = 10;
                break;
            }
            case 56457: {
                column = "duration";
                type = 6;
                break;
            }
            case 56459: {
                column = "track";
                type = 4;
                break;
            }
            case 56544: {
                type = 65535;
                break;
            }
            case 56390: {
                type = 65535;
                break;
            }
            case 56474: {
                type = 65535;
                break;
            }
            case 56475: {
                column = "album_artist";
                type = 65535;
                break;
            }
            case 56460: {
                type = 65535;
                break;
            }
            case 56470: {
                column = "composer";
                type = 65535;
                break;
            }
            case 56392: {
                column = "description";
                type = 65535;
                break;
            }
            case 56979: 
            case 56985: 
            case 56986: {
                type = 6;
                break;
            }
            case 56978: 
            case 56980: {
                type = 4;
                break;
            }
            default: {
                type = 0;
                Log.e(TAG, "unsupported property " + code);
            }
        }
        if (column != null) {
            columns.add(column);
            return new Property(code, type, columns.size() - 1);
        }
        return new Property(code, type, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String queryAudio(String path, String column) {
        try (Cursor c = null;){
            c = this.mProvider.query(MediaStore.Audio.Media.getContentUri(this.mVolumeName), new String[]{column}, PATH_WHERE, new String[]{path}, null, null);
            if (c != null && c.moveToNext()) {
                String string2 = c.getString(0);
                return string2;
            }
            String string3 = "";
            return string3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String queryGenre(String path) {
        try (Cursor c = null;){
            c = this.mProvider.query(MediaStore.Audio.Genres.getContentUri(this.mVolumeName), new String[]{"name"}, PATH_WHERE, new String[]{path}, null, null);
            if (c != null && c.moveToNext()) {
                String string2 = c.getString(0);
                return string2;
            }
            String string3 = "";
            return string3;
        }
    }

    public int getPropertyList(MtpStorageManager.MtpObject object, MtpPropertyList list) {
        Cursor c = null;
        int id2 = object.getId();
        String path = object.getPath().toString();
        block23: for (Property property : this.mProperties) {
            if (property.column != -1 && c == null) {
                try {
                    c = this.mProvider.query(this.mUri, this.mColumns, PATH_WHERE, new String[]{path}, null, null);
                    if (c != null && !c.moveToNext()) {
                        c.close();
                        c = null;
                    }
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Mediaprovider lookup failed");
                }
            }
            switch (property.code) {
                case 56323: {
                    list.append(id2, property.code, property.type, 0L);
                    continue block23;
                }
                case 56327: 
                case 56388: 
                case 56544: {
                    list.append(id2, property.code, object.getName());
                    continue block23;
                }
                case 56329: 
                case 56398: {
                    list.append(id2, property.code, this.format_date_time(object.getModifiedTime()));
                    continue block23;
                }
                case 56321: {
                    list.append(id2, property.code, property.type, object.getStorageId());
                    continue block23;
                }
                case 56322: {
                    list.append(id2, property.code, property.type, object.getFormat());
                    continue block23;
                }
                case 56324: {
                    list.append(id2, property.code, property.type, object.getSize());
                    continue block23;
                }
                case 56331: {
                    list.append(id2, property.code, property.type, object.getParent().isRoot() ? 0L : (long)object.getParent().getId());
                    continue block23;
                }
                case 56385: {
                    long puid = (long)(object.getPath().toString().hashCode() << 32) + object.getModifiedTime();
                    list.append(id2, property.code, property.type, puid);
                    continue block23;
                }
                case 56473: {
                    int year = 0;
                    if (c != null) {
                        year = c.getInt(property.column);
                    }
                    String dateTime = Integer.toString(year) + "0101T000000";
                    list.append(id2, property.code, dateTime);
                    continue block23;
                }
                case 56459: {
                    int track = 0;
                    if (c != null) {
                        track = c.getInt(property.column);
                    }
                    list.append(id2, property.code, 4, track % 1000);
                    continue block23;
                }
                case 56390: {
                    list.append(id2, property.code, this.queryAudio(path, "artist"));
                    continue block23;
                }
                case 56474: {
                    list.append(id2, property.code, this.queryAudio(path, "album"));
                    continue block23;
                }
                case 56460: {
                    String genre = this.queryGenre(path);
                    if (genre == null) continue block23;
                    list.append(id2, property.code, genre);
                    continue block23;
                }
                case 56979: 
                case 56985: 
                case 56986: {
                    list.append(id2, property.code, 6, 0L);
                    continue block23;
                }
                case 56978: 
                case 56980: {
                    list.append(id2, property.code, 4, 0L);
                    continue block23;
                }
                default: {
                    switch (property.type) {
                        case 0: {
                            list.append(id2, property.code, property.type, 0L);
                            continue block23;
                        }
                        case 65535: {
                            String value = "";
                            if (c != null) {
                                value = c.getString(property.column);
                            }
                            list.append(id2, property.code, value);
                            continue block23;
                        }
                    }
                    long longValue = 0L;
                    if (c != null) {
                        longValue = c.getLong(property.column);
                    }
                    list.append(id2, property.code, property.type, longValue);
                }
            }
        }
        if (c != null) {
            c.close();
        }
        return 8193;
    }

    private native String format_date_time(long var1);

    private class Property {
        int code;
        int type;
        int column;

        Property(int code, int type, int column) {
            this.code = code;
            this.type = type;
            this.column = column;
        }
    }
}

