/*
 * Decompiled with CFR 0.152.
 */
package android.mtp;

import java.util.ArrayList;
import java.util.List;

class MtpPropertyList {
    private List<Integer> mObjectHandles;
    private List<Integer> mPropertyCodes;
    private List<Integer> mDataTypes;
    private List<Long> mLongValues;
    private List<String> mStringValues;
    private int mCode;

    public MtpPropertyList(int code) {
        this.mCode = code;
        this.mObjectHandles = new ArrayList<Integer>();
        this.mPropertyCodes = new ArrayList<Integer>();
        this.mDataTypes = new ArrayList<Integer>();
        this.mLongValues = new ArrayList<Long>();
        this.mStringValues = new ArrayList<String>();
    }

    public void append(int handle, int property, int type, long value) {
        this.mObjectHandles.add(handle);
        this.mPropertyCodes.add(property);
        this.mDataTypes.add(type);
        this.mLongValues.add(value);
        this.mStringValues.add(null);
    }

    public void append(int handle, int property, String value) {
        this.mObjectHandles.add(handle);
        this.mPropertyCodes.add(property);
        this.mDataTypes.add(65535);
        this.mStringValues.add(value);
        this.mLongValues.add(0L);
    }

    public int getCode() {
        return this.mCode;
    }

    public int getCount() {
        return this.mObjectHandles.size();
    }

    public int[] getObjectHandles() {
        return this.mObjectHandles.stream().mapToInt(Integer::intValue).toArray();
    }

    public int[] getPropertyCodes() {
        return this.mPropertyCodes.stream().mapToInt(Integer::intValue).toArray();
    }

    public int[] getDataTypes() {
        return this.mDataTypes.stream().mapToInt(Integer::intValue).toArray();
    }

    public long[] getLongValues() {
        return this.mLongValues.stream().mapToLong(Long::longValue).toArray();
    }

    public String[] getStringValues() {
        return this.mStringValues.toArray(new String[0]);
    }
}

