/*
 * Decompiled with CFR 0.152.
 */
package android.mtp;

import android.media.MediaFile;
import android.mtp.MtpStorage;
import android.os.FileObserver;
import android.os.storage.StorageVolume;
import android.util.Log;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class MtpStorageManager {
    private static final String TAG = MtpStorageManager.class.getSimpleName();
    public static boolean sDebug = false;
    private static final int IN_ONLYDIR = 0x1000000;
    private static final int IN_Q_OVERFLOW = 16384;
    private static final int IN_IGNORED = 32768;
    private static final int IN_ISDIR = 0x40000000;
    private MtpNotifier mMtpNotifier;
    private HashMap<Integer, MtpObject> mObjects;
    private HashMap<Integer, MtpObject> mRoots;
    private int mNextObjectId;
    private int mNextStorageId;
    private Set<String> mSubdirectories;
    private volatile boolean mCheckConsistency;
    private Thread mConsistencyThread;

    public MtpStorageManager(MtpNotifier notifier, Set<String> subdirectories) {
        this.mMtpNotifier = notifier;
        this.mSubdirectories = subdirectories;
        this.mObjects = new HashMap();
        this.mRoots = new HashMap();
        this.mNextObjectId = 1;
        this.mNextStorageId = 1;
        this.mCheckConsistency = false;
        this.mConsistencyThread = new Thread(() -> {
            while (this.mCheckConsistency) {
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                if (this.checkConsistency()) {
                    Log.v(TAG, "Cache is consistent");
                    continue;
                }
                Log.w(TAG, "Cache is not consistent");
            }
        });
        if (this.mCheckConsistency) {
            this.mConsistencyThread.start();
        }
    }

    public synchronized void close() {
        Stream<MtpObject> objs = Stream.concat(this.mRoots.values().stream(), this.mObjects.values().stream());
        Iterator iter = objs.iterator();
        while (iter.hasNext()) {
            MtpObject obj = (MtpObject)iter.next();
            if (obj.getObserver() == null) continue;
            obj.getObserver().stopWatching();
            obj.setObserver(null);
        }
        if (this.mCheckConsistency) {
            this.mCheckConsistency = false;
            this.mConsistencyThread.interrupt();
            try {
                this.mConsistencyThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void setSubdirectories(Set<String> subDirs) {
        this.mSubdirectories = subDirs;
    }

    public synchronized MtpStorage addMtpStorage(StorageVolume volume) {
        int storageId = ((this.getNextStorageId() & 0xFFFF) << 16) + 1;
        MtpObject root = new MtpObject(volume.getPath(), storageId, null, true);
        MtpStorage storage = new MtpStorage(volume, storageId);
        this.mRoots.put(storageId, root);
        return storage;
    }

    public synchronized void removeMtpStorage(MtpStorage storage) {
        this.removeObjectFromCache(this.getStorageRoot(storage.getStorageId()), true, true);
    }

    private synchronized boolean isSpecialSubDir(MtpObject obj) {
        return obj.getParent().isRoot() && this.mSubdirectories != null && !this.mSubdirectories.contains(obj.getName());
    }

    public synchronized MtpObject getByPath(String path) {
        MtpObject obj = null;
        for (MtpObject root : this.mRoots.values()) {
            if (!path.startsWith(root.getName())) continue;
            obj = root;
            path = path.substring(root.getName().length());
        }
        for (String name : path.split("/")) {
            if (obj == null || !obj.isDir()) {
                return null;
            }
            if ("".equals(name)) continue;
            if (!obj.isVisited()) {
                this.getChildren(obj);
            }
            obj = obj.getChild(name);
        }
        return obj;
    }

    public synchronized MtpObject getObject(int id2) {
        if (id2 == 0 || id2 == -1) {
            Log.w(TAG, "Can't get root storages with getObject()");
            return null;
        }
        if (!this.mObjects.containsKey(id2)) {
            Log.w(TAG, "Id " + id2 + " doesn't exist");
            return null;
        }
        return this.mObjects.get(id2);
    }

    public MtpObject getStorageRoot(int id2) {
        if (!this.mRoots.containsKey(id2)) {
            Log.w(TAG, "StorageId " + id2 + " doesn't exist");
            return null;
        }
        return this.mRoots.get(id2);
    }

    private int getNextObjectId() {
        int ret = this.mNextObjectId;
        this.mNextObjectId = (int)((long)this.mNextObjectId + 1L);
        return ret;
    }

    private int getNextStorageId() {
        return this.mNextStorageId++;
    }

    public synchronized Stream<MtpObject> getObjects(int parent, int format, int storageId) {
        MtpObject obj;
        boolean recursive;
        boolean bl = recursive = parent == 0;
        if (parent == -1) {
            parent = 0;
        }
        if (storageId == -1 && parent == 0) {
            ArrayList<Stream<MtpObject>> streamList = new ArrayList<Stream<MtpObject>>();
            for (MtpObject root : this.mRoots.values()) {
                streamList.add(this.getObjects(root, format, recursive));
            }
            return Stream.of(streamList).flatMap(Collection::stream).reduce(Stream::concat).orElseGet(Stream::empty);
        }
        MtpObject mtpObject = obj = parent == 0 ? this.getStorageRoot(storageId) : this.getObject(parent);
        if (obj == null) {
            return null;
        }
        return this.getObjects(obj, format, recursive);
    }

    private synchronized Stream<MtpObject> getObjects(MtpObject parent, int format, boolean rec) {
        Collection<MtpObject> children = this.getChildren(parent);
        if (children == null) {
            return null;
        }
        Stream ret = Stream.of(children).flatMap(Collection::stream);
        if (format != 0) {
            ret = ret.filter(o -> o.getFormat() == format);
        }
        if (rec) {
            ArrayList<Stream<MtpObject>> streamList = new ArrayList<Stream<MtpObject>>();
            streamList.add(ret);
            for (MtpObject o2 : children) {
                if (!o2.isDir()) continue;
                streamList.add(this.getObjects(o2, format, true));
            }
            ret = Stream.of(streamList).filter(Objects::nonNull).flatMap(Collection::stream).reduce(Stream::concat).orElseGet(Stream::empty);
        }
        return ret;
    }

    private synchronized Collection<MtpObject> getChildren(MtpObject object) {
        if (object == null || !object.isDir()) {
            Log.w(TAG, "Can't find children of " + (object == null ? "null" : Integer.valueOf(object.getId())));
            return null;
        }
        if (!object.isVisited()) {
            Path dir = object.getPath();
            if (object.getObserver() != null) {
                Log.e(TAG, "Observer is not null!");
            }
            object.setObserver(new MtpObjectObserver(object));
            object.getObserver().startWatching();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
                for (Path file : stream) {
                    this.addObjectToCache(object, file.getFileName().toString(), file.toFile().isDirectory());
                }
            }
            catch (IOException | DirectoryIteratorException e) {
                Log.e(TAG, e.toString());
                object.getObserver().stopWatching();
                object.setObserver(null);
                return null;
            }
            object.setVisited(true);
        }
        return object.getChildren();
    }

    private synchronized MtpObject addObjectToCache(MtpObject parent, String newName, boolean isDir) {
        if (!parent.isRoot() && this.getObject(parent.getId()) != parent) {
            return null;
        }
        if (parent.getChild(newName) != null) {
            return null;
        }
        if (this.mSubdirectories != null && parent.isRoot() && !this.mSubdirectories.contains(newName)) {
            return null;
        }
        MtpObject obj = new MtpObject(newName, this.getNextObjectId(), parent, isDir);
        this.mObjects.put(obj.getId(), obj);
        parent.addChild(obj);
        return obj;
    }

    private synchronized boolean removeObjectFromCache(MtpObject removed, boolean removeGlobal, boolean recursive) {
        boolean ret;
        boolean bl = ret = removed.isRoot() || removed.getParent().mChildren.remove(removed.getName(), removed);
        if (!ret && sDebug) {
            Log.w(TAG, "Failed to remove from parent " + removed.getPath());
        }
        if (removed.isRoot()) {
            ret = this.mRoots.remove(removed.getId(), removed) && ret;
        } else if (removeGlobal) {
            boolean bl2 = ret = this.mObjects.remove(removed.getId(), removed) && ret;
        }
        if (!ret && sDebug) {
            Log.w(TAG, "Failed to remove from global cache " + removed.getPath());
        }
        if (removed.getObserver() != null) {
            removed.getObserver().stopWatching();
            removed.setObserver(null);
        }
        if (removed.isDir() && recursive) {
            ArrayList children = new ArrayList(removed.getChildren());
            for (MtpObject child : children) {
                ret = this.removeObjectFromCache(child, removeGlobal, true) && ret;
            }
        }
        return ret;
    }

    private synchronized void handleAddedObject(MtpObject parent, String path, boolean isDir) {
        MtpOperation op = MtpOperation.NONE;
        MtpObject obj = parent.getChild(path);
        if (obj != null) {
            MtpObjectState state = obj.getState();
            op = obj.getOperation();
            if (obj.isDir() != isDir && state != MtpObjectState.FROZEN_REMOVED) {
                Log.d(TAG, "Inconsistent directory info! " + obj.getPath());
            }
            obj.setDir(isDir);
            switch (state) {
                case FROZEN: 
                case FROZEN_REMOVED: {
                    obj.setState(MtpObjectState.FROZEN_ADDED);
                    break;
                }
                case FROZEN_ONESHOT_ADD: {
                    obj.setState(MtpObjectState.NORMAL);
                    break;
                }
                case NORMAL: 
                case FROZEN_ADDED: {
                    return;
                }
                default: {
                    Log.w(TAG, "Unexpected state in add " + path + " " + (Object)((Object)state));
                }
            }
            if (sDebug) {
                Log.i(TAG, (Object)((Object)state) + " transitioned to " + (Object)((Object)obj.getState()) + " in op " + (Object)((Object)op));
            }
        } else {
            obj = this.addObjectToCache(parent, path, isDir);
            if (obj != null) {
                this.mMtpNotifier.sendObjectAdded(obj.getId());
            } else {
                if (sDebug) {
                    Log.w(TAG, "object " + path + " already exists");
                }
                return;
            }
        }
        if (isDir) {
            if (op == MtpOperation.RENAME) {
                return;
            }
            if (op == MtpOperation.COPY && !obj.isVisited()) {
                return;
            }
            if (obj.getObserver() != null) {
                Log.e(TAG, "Observer is not null!");
                return;
            }
            obj.setObserver(new MtpObjectObserver(obj));
            obj.getObserver().startWatching();
            obj.setVisited(true);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(obj.getPath());){
                for (Path file : stream) {
                    if (sDebug) {
                        Log.i(TAG, "Manually handling event for " + file.getFileName().toString());
                    }
                    this.handleAddedObject(obj, file.getFileName().toString(), file.toFile().isDirectory());
                }
            }
            catch (IOException | DirectoryIteratorException e) {
                Log.e(TAG, e.toString());
                obj.getObserver().stopWatching();
                obj.setObserver(null);
            }
        }
    }

    private synchronized void handleRemovedObject(MtpObject obj) {
        MtpObjectState state = obj.getState();
        MtpOperation op = obj.getOperation();
        switch (state) {
            case FROZEN_ADDED: {
                obj.setState(MtpObjectState.FROZEN_REMOVED);
                break;
            }
            case FROZEN_ONESHOT_DEL: {
                this.removeObjectFromCache(obj, op != MtpOperation.RENAME, false);
                break;
            }
            case FROZEN: {
                obj.setState(MtpObjectState.FROZEN_REMOVED);
                break;
            }
            case NORMAL: {
                if (!this.removeObjectFromCache(obj, true, true)) break;
                this.mMtpNotifier.sendObjectRemoved(obj.getId());
                break;
            }
            default: {
                Log.e(TAG, "Got unexpected object remove for " + obj.getName());
            }
        }
        if (sDebug) {
            Log.i(TAG, (Object)((Object)state) + " transitioned to " + (Object)((Object)obj.getState()) + " in op " + (Object)((Object)op));
        }
    }

    public void flushEvents() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void dump() {
        for (int key : this.mObjects.keySet()) {
            MtpObject obj = this.mObjects.get(key);
            Log.i(TAG, key + " | " + (obj.getParent() == null ? Integer.valueOf(obj.getParent().getId()) : "null") + " | " + obj.getName() + " | " + (obj.isDir() ? "dir" : "obj") + " | " + (obj.isVisited() ? "v" : "nv") + " | " + (Object)((Object)obj.getState()));
        }
    }

    public synchronized boolean checkConsistency() {
        Stream<MtpObject> objs = Stream.concat(this.mRoots.values().stream(), this.mObjects.values().stream());
        Iterator iter = objs.iterator();
        boolean ret = true;
        while (iter.hasNext()) {
            MtpObject obj = (MtpObject)iter.next();
            if (!obj.exists()) {
                Log.w(TAG, "Object doesn't exist " + obj.getPath() + " " + obj.getId());
                ret = false;
            }
            if (obj.getState() != MtpObjectState.NORMAL) {
                Log.w(TAG, "Object " + obj.getPath() + " in state " + (Object)((Object)obj.getState()));
                ret = false;
            }
            if (obj.getOperation() != MtpOperation.NONE) {
                Log.w(TAG, "Object " + obj.getPath() + " in operation " + (Object)((Object)obj.getOperation()));
                ret = false;
            }
            if (!obj.isRoot() && this.mObjects.get(obj.getId()) != obj) {
                Log.w(TAG, "Object " + obj.getPath() + " is not in map correctly");
                ret = false;
            }
            if (obj.getParent() != null) {
                if (obj.getParent().isRoot() && obj.getParent() != this.mRoots.get(obj.getParent().getId())) {
                    Log.w(TAG, "Root parent is not in root mapping " + obj.getPath());
                    ret = false;
                }
                if (!obj.getParent().isRoot() && obj.getParent() != this.mObjects.get(obj.getParent().getId())) {
                    Log.w(TAG, "Parent is not in object mapping " + obj.getPath());
                    ret = false;
                }
                if (obj.getParent().getChild(obj.getName()) != obj) {
                    Log.w(TAG, "Child does not exist in parent " + obj.getPath());
                    ret = false;
                }
            }
            if (!obj.isDir()) continue;
            if (obj.isVisited() == (obj.getObserver() == null)) {
                Log.w(TAG, obj.getPath() + " is " + (obj.isVisited() ? "" : "not ") + " visited but observer is " + obj.getObserver());
                ret = false;
            }
            if (!obj.isVisited() && obj.getChildren().size() > 0) {
                Log.w(TAG, obj.getPath() + " is not visited but has children");
                ret = false;
            }
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(obj.getPath());
                Throwable throwable = null;
                try {
                    HashSet<String> files = new HashSet<String>();
                    for (Path file : stream) {
                        if (obj.isVisited() && obj.getChild(file.getFileName().toString()) == null && (this.mSubdirectories == null || !obj.isRoot() || this.mSubdirectories.contains(file.getFileName().toString()))) {
                            Log.w(TAG, "File exists in fs but not in children " + file);
                            ret = false;
                        }
                        files.add(file.toString());
                    }
                    for (MtpObject child : obj.getChildren()) {
                        if (!files.contains(child.getPath().toString())) {
                            Log.w(TAG, "File in children doesn't exist in fs " + child.getPath());
                            ret = false;
                        }
                        if (child == this.mObjects.get(child.getId())) continue;
                        Log.w(TAG, "Child is not in object map " + child.getPath());
                        ret = false;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    MtpStorageManager.$closeResource(throwable, stream);
                }
            }
            catch (IOException | DirectoryIteratorException e) {
                Log.w(TAG, e.toString());
                ret = false;
            }
        }
        return ret;
    }

    public synchronized int beginSendObject(MtpObject parent, String name, int format) {
        if (sDebug) {
            Log.v(TAG, "beginSendObject " + name);
        }
        if (!parent.isDir()) {
            return -1;
        }
        if (parent.isRoot() && this.mSubdirectories != null && !this.mSubdirectories.contains(name)) {
            return -1;
        }
        this.getChildren(parent);
        MtpObject obj = this.addObjectToCache(parent, name, format == 12289);
        if (obj == null) {
            return -1;
        }
        obj.setState(MtpObjectState.FROZEN);
        obj.setOperation(MtpOperation.ADD);
        return obj.getId();
    }

    public synchronized boolean endSendObject(MtpObject obj, boolean succeeded) {
        if (sDebug) {
            Log.v(TAG, "endSendObject " + succeeded);
        }
        return this.generalEndAddObject(obj, succeeded, true);
    }

    public synchronized boolean beginRenameObject(MtpObject obj, String newName) {
        if (sDebug) {
            Log.v(TAG, "beginRenameObject " + obj.getName() + " " + newName);
        }
        if (obj.isRoot()) {
            return false;
        }
        if (this.isSpecialSubDir(obj)) {
            return false;
        }
        if (obj.getParent().getChild(newName) != null) {
            return false;
        }
        MtpObject oldObj = obj.copy(false);
        obj.setName(newName);
        obj.getParent().addChild(obj);
        oldObj.getParent().addChild(oldObj);
        return this.generalBeginRenameObject(oldObj, obj);
    }

    public synchronized boolean endRenameObject(MtpObject obj, String oldName, boolean success) {
        if (sDebug) {
            Log.v(TAG, "endRenameObject " + success);
        }
        MtpObject parent = obj.getParent();
        MtpObject oldObj = parent.getChild(oldName);
        if (!success) {
            MtpObject temp = oldObj;
            MtpObjectState oldState = oldObj.getState();
            temp.setName(obj.getName());
            temp.setState(obj.getState());
            oldObj = obj;
            oldObj.setName(oldName);
            oldObj.setState(oldState);
            obj = temp;
            parent.addChild(obj);
            parent.addChild(oldObj);
        }
        return this.generalEndRenameObject(oldObj, obj, success);
    }

    public synchronized boolean beginRemoveObject(MtpObject obj) {
        if (sDebug) {
            Log.v(TAG, "beginRemoveObject " + obj.getName());
        }
        return !obj.isRoot() && !this.isSpecialSubDir(obj) && this.generalBeginRemoveObject(obj, MtpOperation.DELETE);
    }

    public synchronized boolean endRemoveObject(MtpObject obj, boolean success) {
        if (sDebug) {
            Log.v(TAG, "endRemoveObject " + success);
        }
        boolean ret = true;
        if (obj.isDir()) {
            for (MtpObject child : new ArrayList(obj.getChildren())) {
                if (child.getOperation() != MtpOperation.DELETE) continue;
                ret = this.endRemoveObject(child, success) && ret;
            }
        }
        return this.generalEndRemoveObject(obj, success, true) && ret;
    }

    public synchronized boolean beginMoveObject(MtpObject obj, MtpObject newParent) {
        if (sDebug) {
            Log.v(TAG, "beginMoveObject " + newParent.getPath());
        }
        if (obj.isRoot()) {
            return false;
        }
        if (this.isSpecialSubDir(obj)) {
            return false;
        }
        this.getChildren(newParent);
        if (newParent.getChild(obj.getName()) != null) {
            return false;
        }
        if (obj.getStorageId() != newParent.getStorageId()) {
            MtpObject newObj = obj.copy(true);
            newObj.setParent(newParent);
            newParent.addChild(newObj);
            return this.generalBeginRemoveObject(obj, MtpOperation.RENAME) && this.generalBeginCopyObject(newObj, false);
        }
        MtpObject oldObj = obj.copy(false);
        obj.setParent(newParent);
        oldObj.getParent().addChild(oldObj);
        obj.getParent().addChild(obj);
        return this.generalBeginRenameObject(oldObj, obj);
    }

    public synchronized boolean endMoveObject(MtpObject oldParent, MtpObject newParent, String name, boolean success) {
        if (sDebug) {
            Log.v(TAG, "endMoveObject " + success);
        }
        MtpObject oldObj = oldParent.getChild(name);
        MtpObject newObj = newParent.getChild(name);
        if (oldObj == null || newObj == null) {
            return false;
        }
        if (oldParent.getStorageId() != newObj.getStorageId()) {
            boolean ret = this.endRemoveObject(oldObj, success);
            return this.generalEndCopyObject(newObj, success, true) && ret;
        }
        if (!success) {
            MtpObject temp = oldObj;
            MtpObjectState oldState = oldObj.getState();
            temp.setParent(newObj.getParent());
            temp.setState(newObj.getState());
            oldObj = newObj;
            oldObj.setParent(oldParent);
            oldObj.setState(oldState);
            newObj = temp;
            newObj.getParent().addChild(newObj);
            oldParent.addChild(oldObj);
        }
        return this.generalEndRenameObject(oldObj, newObj, success);
    }

    public synchronized int beginCopyObject(MtpObject object, MtpObject newParent) {
        if (sDebug) {
            Log.v(TAG, "beginCopyObject " + object.getName() + " to " + newParent.getPath());
        }
        String name = object.getName();
        if (!newParent.isDir()) {
            return -1;
        }
        if (newParent.isRoot() && this.mSubdirectories != null && !this.mSubdirectories.contains(name)) {
            return -1;
        }
        this.getChildren(newParent);
        if (newParent.getChild(name) != null) {
            return -1;
        }
        MtpObject newObj = object.copy(object.isDir());
        newParent.addChild(newObj);
        newObj.setParent(newParent);
        if (!this.generalBeginCopyObject(newObj, true)) {
            return -1;
        }
        return newObj.getId();
    }

    public synchronized boolean endCopyObject(MtpObject object, boolean success) {
        if (sDebug) {
            Log.v(TAG, "endCopyObject " + object.getName() + " " + success);
        }
        return this.generalEndCopyObject(object, success, false);
    }

    private synchronized boolean generalEndAddObject(MtpObject obj, boolean succeeded, boolean removeGlobal) {
        switch (obj.getState()) {
            case FROZEN: {
                if (succeeded) {
                    obj.setState(MtpObjectState.FROZEN_ONESHOT_ADD);
                    break;
                }
                if (this.removeObjectFromCache(obj, removeGlobal, false)) break;
                return false;
            }
            case FROZEN_ADDED: {
                obj.setState(MtpObjectState.NORMAL);
                if (succeeded) break;
                MtpObject parent = obj.getParent();
                if (!this.removeObjectFromCache(obj, removeGlobal, false)) {
                    return false;
                }
                this.handleAddedObject(parent, obj.getName(), obj.isDir());
                break;
            }
            case FROZEN_REMOVED: {
                if (!this.removeObjectFromCache(obj, removeGlobal, false)) {
                    return false;
                }
                if (!succeeded) break;
                this.mMtpNotifier.sendObjectRemoved(obj.getId());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private synchronized boolean generalEndRemoveObject(MtpObject obj, boolean success, boolean removeGlobal) {
        switch (obj.getState()) {
            case FROZEN: {
                if (success) {
                    obj.setState(MtpObjectState.FROZEN_ONESHOT_DEL);
                    break;
                }
                obj.setState(MtpObjectState.NORMAL);
                break;
            }
            case FROZEN_ADDED: {
                obj.setState(MtpObjectState.NORMAL);
                if (!success) break;
                MtpObject parent = obj.getParent();
                if (!this.removeObjectFromCache(obj, removeGlobal, false)) {
                    return false;
                }
                this.handleAddedObject(parent, obj.getName(), obj.isDir());
                break;
            }
            case FROZEN_REMOVED: {
                if (!this.removeObjectFromCache(obj, removeGlobal, false)) {
                    return false;
                }
                if (success) break;
                this.mMtpNotifier.sendObjectRemoved(obj.getId());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private synchronized boolean generalBeginRenameObject(MtpObject fromObj, MtpObject toObj) {
        fromObj.setState(MtpObjectState.FROZEN);
        toObj.setState(MtpObjectState.FROZEN);
        fromObj.setOperation(MtpOperation.RENAME);
        toObj.setOperation(MtpOperation.RENAME);
        return true;
    }

    private synchronized boolean generalEndRenameObject(MtpObject fromObj, MtpObject toObj, boolean success) {
        boolean ret = this.generalEndRemoveObject(fromObj, success, !success);
        return this.generalEndAddObject(toObj, success, success) && ret;
    }

    private synchronized boolean generalBeginRemoveObject(MtpObject obj, MtpOperation op) {
        obj.setState(MtpObjectState.FROZEN);
        obj.setOperation(op);
        if (obj.isDir()) {
            for (MtpObject child : obj.getChildren()) {
                this.generalBeginRemoveObject(child, op);
            }
        }
        return true;
    }

    private synchronized boolean generalBeginCopyObject(MtpObject obj, boolean newId) {
        obj.setState(MtpObjectState.FROZEN);
        obj.setOperation(MtpOperation.COPY);
        if (newId) {
            obj.setId(this.getNextObjectId());
            this.mObjects.put(obj.getId(), obj);
        }
        if (obj.isDir()) {
            for (MtpObject child : obj.getChildren()) {
                if (this.generalBeginCopyObject(child, newId)) continue;
                return false;
            }
        }
        return true;
    }

    private synchronized boolean generalEndCopyObject(MtpObject obj, boolean success, boolean addGlobal) {
        if (success && addGlobal) {
            this.mObjects.put(obj.getId(), obj);
        }
        boolean ret = true;
        if (obj.isDir()) {
            for (MtpObject child : new ArrayList(obj.getChildren())) {
                if (child.getOperation() != MtpOperation.COPY) continue;
                ret = this.generalEndCopyObject(child, success, addGlobal) && ret;
            }
        }
        ret = this.generalEndAddObject(obj, success, success || !addGlobal) && ret;
        return ret;
    }

    public static abstract class MtpNotifier {
        public abstract void sendObjectAdded(int var1);

        public abstract void sendObjectRemoved(int var1);
    }

    public static class MtpObject {
        private MtpObject mParent;
        private String mName;
        private int mId;
        private MtpObjectState mState;
        private MtpOperation mOp;
        private boolean mVisited;
        private boolean mIsDir;
        private HashMap<String, MtpObject> mChildren;
        private FileObserver mObserver;

        MtpObject(String name, int id2, MtpObject parent, boolean isDir) {
            this.mId = id2;
            this.mName = name;
            this.mParent = parent;
            this.mObserver = null;
            this.mVisited = false;
            this.mState = MtpObjectState.NORMAL;
            this.mIsDir = isDir;
            this.mOp = MtpOperation.NONE;
            this.mChildren = this.mIsDir ? new HashMap() : null;
        }

        public String getName() {
            return this.mName;
        }

        public int getId() {
            return this.mId;
        }

        public boolean isDir() {
            return this.mIsDir;
        }

        public int getFormat() {
            return this.mIsDir ? 12289 : MediaFile.getFormatCode(this.mName, null);
        }

        public int getStorageId() {
            return this.getRoot().getId();
        }

        public long getModifiedTime() {
            return this.getPath().toFile().lastModified() / 1000L;
        }

        public MtpObject getParent() {
            return this.mParent;
        }

        public MtpObject getRoot() {
            return this.isRoot() ? this : this.mParent.getRoot();
        }

        public long getSize() {
            return this.mIsDir ? 0L : this.getPath().toFile().length();
        }

        public Path getPath() {
            return this.isRoot() ? Paths.get(this.mName, new String[0]) : this.mParent.getPath().resolve(this.mName);
        }

        public boolean isRoot() {
            return this.mParent == null;
        }

        private void setName(String name) {
            this.mName = name;
        }

        private void setId(int id2) {
            this.mId = id2;
        }

        private boolean isVisited() {
            return this.mVisited;
        }

        private void setParent(MtpObject parent) {
            this.mParent = parent;
        }

        private void setDir(boolean dir) {
            if (dir != this.mIsDir) {
                this.mIsDir = dir;
                this.mChildren = this.mIsDir ? new HashMap() : null;
            }
        }

        private void setVisited(boolean visited) {
            this.mVisited = visited;
        }

        private MtpObjectState getState() {
            return this.mState;
        }

        private void setState(MtpObjectState state) {
            this.mState = state;
            if (this.mState == MtpObjectState.NORMAL) {
                this.mOp = MtpOperation.NONE;
            }
        }

        private MtpOperation getOperation() {
            return this.mOp;
        }

        private void setOperation(MtpOperation op) {
            this.mOp = op;
        }

        private FileObserver getObserver() {
            return this.mObserver;
        }

        private void setObserver(FileObserver observer) {
            this.mObserver = observer;
        }

        private void addChild(MtpObject child) {
            this.mChildren.put(child.getName(), child);
        }

        private MtpObject getChild(String name) {
            return this.mChildren.get(name);
        }

        private Collection<MtpObject> getChildren() {
            return this.mChildren.values();
        }

        private boolean exists() {
            return this.getPath().toFile().exists();
        }

        private MtpObject copy(boolean recursive) {
            MtpObject copy = new MtpObject(this.mName, this.mId, this.mParent, this.mIsDir);
            copy.mIsDir = this.mIsDir;
            copy.mVisited = this.mVisited;
            copy.mState = this.mState;
            HashMap hashMap = copy.mChildren = this.mIsDir ? new HashMap() : null;
            if (recursive && this.mIsDir) {
                for (MtpObject child : this.mChildren.values()) {
                    MtpObject childCopy = child.copy(true);
                    childCopy.setParent(copy);
                    copy.addChild(childCopy);
                }
            }
            return copy;
        }
    }

    private static enum MtpOperation {
        NONE,
        ADD,
        RENAME,
        COPY,
        DELETE;

    }

    private static enum MtpObjectState {
        NORMAL,
        FROZEN,
        FROZEN_ADDED,
        FROZEN_REMOVED,
        FROZEN_ONESHOT_ADD,
        FROZEN_ONESHOT_DEL;

    }

    private class MtpObjectObserver
    extends FileObserver {
        MtpObject mObject;

        MtpObjectObserver(MtpObject object) {
            super(object.getPath().toString(), 16778176);
            this.mObject = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(int event, String path) {
            MtpStorageManager mtpStorageManager = MtpStorageManager.this;
            synchronized (mtpStorageManager) {
                if ((event & 0x4000) != 0) {
                    Log.e(TAG, "Received Inotify overflow event!");
                }
                MtpObject obj = this.mObject.getChild(path);
                if ((event & 0x80) != 0 || (event & 0x100) != 0) {
                    if (sDebug) {
                        Log.i(TAG, "Got inotify added event for " + path + " " + event);
                    }
                    MtpStorageManager.this.handleAddedObject(this.mObject, path, (event & 0x40000000) != 0);
                } else if ((event & 0x40) != 0 || (event & 0x200) != 0) {
                    if (obj == null) {
                        Log.w(TAG, "Object was null in event " + path);
                        return;
                    }
                    if (sDebug) {
                        Log.i(TAG, "Got inotify removed event for " + path + " " + event);
                    }
                    MtpStorageManager.this.handleRemovedObject(obj);
                } else if ((event & 0x8000) != 0) {
                    if (sDebug) {
                        Log.i(TAG, "inotify for " + this.mObject.getPath() + " deleted");
                    }
                    if (this.mObject.mObserver != null) {
                        this.mObject.mObserver.stopWatching();
                    }
                    this.mObject.mObserver = null;
                } else {
                    Log.w(TAG, "Got unrecognized event " + path + " " + event);
                }
            }
        }

        @Override
        public void finalize() {
        }
    }
}

