/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.net.IIpSecService;
import android.net.IpSecSpiResponse;
import android.net.IpSecTransform;
import android.net.IpSecTunnelInterfaceResponse;
import android.net.IpSecUdpEncapResponse;
import android.net.LinkAddress;
import android.net.Network;
import android.os.Binder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.AndroidException;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;

public final class IpSecManager {
    private static final String TAG = "IpSecManager";
    public static final int DIRECTION_IN = 0;
    public static final int DIRECTION_OUT = 1;
    public static final int INVALID_SECURITY_PARAMETER_INDEX = 0;
    public static final int INVALID_RESOURCE_ID = -1;
    private final IIpSecService mService;

    public SecurityParameterIndex allocateSecurityParameterIndex(InetAddress destinationAddress) throws ResourceUnavailableException {
        try {
            return new SecurityParameterIndex(this.mService, destinationAddress, 0);
        }
        catch (SpiUnavailableException unlikely) {
            throw new ResourceUnavailableException("No SPIs available");
        }
    }

    public SecurityParameterIndex allocateSecurityParameterIndex(InetAddress destinationAddress, int requestedSpi) throws SpiUnavailableException, ResourceUnavailableException {
        if (requestedSpi == 0) {
            throw new IllegalArgumentException("Requested SPI must be a valid (non-zero) SPI");
        }
        return new SecurityParameterIndex(this.mService, destinationAddress, requestedSpi);
    }

    public void applyTransportModeTransform(Socket socket, int direction, IpSecTransform transform) throws IOException {
        this.applyTransportModeTransform(socket.getFileDescriptor$(), direction, transform);
    }

    public void applyTransportModeTransform(DatagramSocket socket, int direction, IpSecTransform transform) throws IOException {
        this.applyTransportModeTransform(socket.getFileDescriptor$(), direction, transform);
    }

    public void applyTransportModeTransform(FileDescriptor socket, int direction, IpSecTransform transform) throws IOException {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.dup(socket);){
            this.mService.applyTransportModeTransform(pfd, direction, transform.getResourceId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void applyTunnelModeTransform(Network net, IpSecTransform transform) {
    }

    public void removeTransportModeTransforms(Socket socket) throws IOException {
        this.removeTransportModeTransforms(socket.getFileDescriptor$());
    }

    public void removeTransportModeTransforms(DatagramSocket socket) throws IOException {
        this.removeTransportModeTransforms(socket.getFileDescriptor$());
    }

    public void removeTransportModeTransforms(FileDescriptor socket) throws IOException {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.dup(socket);){
            this.mService.removeTransportModeTransforms(pfd);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeTunnelModeTransform(Network net, IpSecTransform transform) {
    }

    public UdpEncapsulationSocket openUdpEncapsulationSocket(int port) throws IOException, ResourceUnavailableException {
        if (port == 0) {
            throw new IllegalArgumentException("Specified port must be a valid port number!");
        }
        return new UdpEncapsulationSocket(this.mService, port);
    }

    public UdpEncapsulationSocket openUdpEncapsulationSocket() throws IOException, ResourceUnavailableException {
        return new UdpEncapsulationSocket(this.mService, 0);
    }

    @SystemApi
    public IpSecTunnelInterface createIpSecTunnelInterface(InetAddress localAddress, InetAddress remoteAddress, Network underlyingNetwork) throws ResourceUnavailableException, IOException {
        return new IpSecTunnelInterface(this.mService, localAddress, remoteAddress, underlyingNetwork);
    }

    @SystemApi
    public void applyTunnelModeTransform(IpSecTunnelInterface tunnel, int direction, IpSecTransform transform) throws IOException {
        try {
            this.mService.applyTunnelModeTransform(tunnel.getResourceId(), direction, transform.getResourceId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public IpSecManager(IIpSecService service) {
        this.mService = Preconditions.checkNotNull(service, "missing service");
    }

    @SystemApi
    public static final class IpSecTunnelInterface
    implements AutoCloseable {
        private final IIpSecService mService;
        private final InetAddress mRemoteAddress;
        private final InetAddress mLocalAddress;
        private final Network mUnderlyingNetwork;
        private final CloseGuard mCloseGuard = CloseGuard.get();
        private String mInterfaceName;
        private int mResourceId = -1;

        public String getInterfaceName() {
            return this.mInterfaceName;
        }

        public void addAddress(LinkAddress address) throws IOException {
        }

        public void removeAddress(LinkAddress address) throws IOException {
        }

        private IpSecTunnelInterface(IIpSecService service, InetAddress localAddress, InetAddress remoteAddress, Network underlyingNetwork) throws ResourceUnavailableException, IOException {
            this.mService = service;
            this.mLocalAddress = localAddress;
            this.mRemoteAddress = remoteAddress;
            this.mUnderlyingNetwork = underlyingNetwork;
            try {
                IpSecTunnelInterfaceResponse result = this.mService.createTunnelInterface(localAddress.getHostAddress(), remoteAddress.getHostAddress(), underlyingNetwork, new Binder());
                switch (result.status) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        throw new ResourceUnavailableException("No more tunnel interfaces may be allocated by this requester.");
                    }
                    default: {
                        throw new RuntimeException("Unknown status returned by IpSecService: " + result.status);
                    }
                }
                this.mResourceId = result.resourceId;
                this.mInterfaceName = result.interfaceName;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCloseGuard.open("constructor");
        }

        @Override
        public void close() {
            try {
                this.mService.deleteTunnelInterface(this.mResourceId);
                this.mResourceId = -1;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCloseGuard.close();
        }

        protected void finalize() throws Throwable {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }

        @VisibleForTesting
        public int getResourceId() {
            return this.mResourceId;
        }
    }

    public static final class UdpEncapsulationSocket
    implements AutoCloseable {
        private final ParcelFileDescriptor mPfd;
        private final IIpSecService mService;
        private int mResourceId = -1;
        private final int mPort;
        private final CloseGuard mCloseGuard = CloseGuard.get();

        private UdpEncapsulationSocket(IIpSecService service, int port) throws ResourceUnavailableException, IOException {
            this.mService = service;
            try {
                IpSecUdpEncapResponse result = this.mService.openUdpEncapsulationSocket(port, new Binder());
                switch (result.status) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        throw new ResourceUnavailableException("No more Sockets may be allocated by this requester.");
                    }
                    default: {
                        throw new RuntimeException("Unknown status returned by IpSecService: " + result.status);
                    }
                }
                this.mResourceId = result.resourceId;
                this.mPort = result.port;
                this.mPfd = result.fileDescriptor;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCloseGuard.open("constructor");
        }

        public FileDescriptor getSocket() {
            if (this.mPfd == null) {
                return null;
            }
            return this.mPfd.getFileDescriptor();
        }

        public int getPort() {
            return this.mPort;
        }

        @Override
        public void close() throws IOException {
            try {
                this.mService.closeUdpEncapsulationSocket(this.mResourceId);
                this.mResourceId = -1;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            try {
                this.mPfd.close();
            }
            catch (IOException e) {
                Log.e(IpSecManager.TAG, "Failed to close UDP Encapsulation Socket with Port= " + this.mPort);
                throw e;
            }
            this.mCloseGuard.close();
        }

        protected void finalize() throws Throwable {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }

        @VisibleForTesting
        public int getResourceId() {
            return this.mResourceId;
        }
    }

    public static final class SecurityParameterIndex
    implements AutoCloseable {
        private final IIpSecService mService;
        private final InetAddress mDestinationAddress;
        private final CloseGuard mCloseGuard = CloseGuard.get();
        private int mSpi = 0;
        private int mResourceId = -1;

        public int getSpi() {
            return this.mSpi;
        }

        @Override
        public void close() {
            try {
                this.mService.releaseSecurityParameterIndex(this.mResourceId);
                this.mResourceId = -1;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCloseGuard.close();
        }

        protected void finalize() throws Throwable {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }

        private SecurityParameterIndex(IIpSecService service, InetAddress destinationAddress, int spi) throws ResourceUnavailableException, SpiUnavailableException {
            this.mService = service;
            this.mDestinationAddress = destinationAddress;
            try {
                IpSecSpiResponse result = this.mService.allocateSecurityParameterIndex(destinationAddress.getHostAddress(), spi, new Binder());
                if (result == null) {
                    throw new NullPointerException("Received null response from IpSecService");
                }
                int status = result.status;
                switch (status) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        throw new ResourceUnavailableException("No more SPIs may be allocated by this requester.");
                    }
                    case 2: {
                        throw new SpiUnavailableException("Requested SPI is unavailable", spi);
                    }
                    default: {
                        throw new RuntimeException("Unknown status returned by IpSecService: " + status);
                    }
                }
                this.mSpi = result.spi;
                this.mResourceId = result.resourceId;
                if (this.mSpi == 0) {
                    throw new RuntimeException("Invalid SPI returned by IpSecService: " + status);
                }
                if (this.mResourceId == -1) {
                    throw new RuntimeException("Invalid Resource ID returned by IpSecService: " + status);
                }
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCloseGuard.open("open");
        }

        @VisibleForTesting
        public int getResourceId() {
            return this.mResourceId;
        }
    }

    public static final class ResourceUnavailableException
    extends AndroidException {
        ResourceUnavailableException(String msg) {
            super(msg);
        }
    }

    public static final class SpiUnavailableException
    extends AndroidException {
        private final int mSpi;

        SpiUnavailableException(String msg, int spi) {
            super(msg + " (spi: " + spi + ")");
            this.mSpi = spi;
        }

        public int getSpi() {
            return this.mSpi;
        }
    }

    public static interface Status {
        public static final int OK = 0;
        public static final int RESOURCE_UNAVAILABLE = 1;
        public static final int SPI_UNAVAILABLE = 2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PolicyDirection {
    }
}

