/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.Slog;
import android.util.SparseBooleanArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import libcore.util.EmptyArray;

public class NetworkStats
implements Parcelable {
    private static final String TAG = "NetworkStats";
    public static final String IFACE_ALL = null;
    public static final int UID_ALL = -1;
    public static final int TAG_ALL = -1;
    public static final int SET_ALL = -1;
    public static final int SET_DEFAULT = 0;
    public static final int SET_FOREGROUND = 1;
    public static final int SET_DEBUG_START = 1000;
    public static final int SET_DBG_VPN_IN = 1001;
    public static final int SET_DBG_VPN_OUT = 1002;
    public static final int TAG_NONE = 0;
    public static final int METERED_ALL = -1;
    public static final int METERED_NO = 0;
    public static final int METERED_YES = 1;
    public static final int ROAMING_ALL = -1;
    public static final int ROAMING_NO = 0;
    public static final int ROAMING_YES = 1;
    public static final int DEFAULT_NETWORK_ALL = -1;
    public static final int DEFAULT_NETWORK_NO = 0;
    public static final int DEFAULT_NETWORK_YES = 1;
    public static final int STATS_PER_IFACE = 0;
    public static final int STATS_PER_UID = 1;
    private long elapsedRealtime;
    private int size;
    private int capacity;
    private String[] iface;
    private int[] uid;
    private int[] set;
    private int[] tag;
    private int[] metered;
    private int[] roaming;
    private int[] defaultNetwork;
    private long[] rxBytes;
    private long[] rxPackets;
    private long[] txBytes;
    private long[] txPackets;
    private long[] operations;
    public static final Parcelable.Creator<NetworkStats> CREATOR = new Parcelable.Creator<NetworkStats>(){

        @Override
        public NetworkStats createFromParcel(Parcel in) {
            return new NetworkStats(in);
        }

        public NetworkStats[] newArray(int size) {
            return new NetworkStats[size];
        }
    };

    public NetworkStats(long elapsedRealtime, int initialSize) {
        this.elapsedRealtime = elapsedRealtime;
        this.size = 0;
        if (initialSize >= 0) {
            this.capacity = initialSize;
            this.iface = new String[initialSize];
            this.uid = new int[initialSize];
            this.set = new int[initialSize];
            this.tag = new int[initialSize];
            this.metered = new int[initialSize];
            this.roaming = new int[initialSize];
            this.defaultNetwork = new int[initialSize];
            this.rxBytes = new long[initialSize];
            this.rxPackets = new long[initialSize];
            this.txBytes = new long[initialSize];
            this.txPackets = new long[initialSize];
            this.operations = new long[initialSize];
        } else {
            this.capacity = 0;
            this.iface = EmptyArray.STRING;
            this.uid = EmptyArray.INT;
            this.set = EmptyArray.INT;
            this.tag = EmptyArray.INT;
            this.metered = EmptyArray.INT;
            this.roaming = EmptyArray.INT;
            this.defaultNetwork = EmptyArray.INT;
            this.rxBytes = EmptyArray.LONG;
            this.rxPackets = EmptyArray.LONG;
            this.txBytes = EmptyArray.LONG;
            this.txPackets = EmptyArray.LONG;
            this.operations = EmptyArray.LONG;
        }
    }

    public NetworkStats(Parcel parcel) {
        this.elapsedRealtime = parcel.readLong();
        this.size = parcel.readInt();
        this.capacity = parcel.readInt();
        this.iface = parcel.createStringArray();
        this.uid = parcel.createIntArray();
        this.set = parcel.createIntArray();
        this.tag = parcel.createIntArray();
        this.metered = parcel.createIntArray();
        this.roaming = parcel.createIntArray();
        this.defaultNetwork = parcel.createIntArray();
        this.rxBytes = parcel.createLongArray();
        this.rxPackets = parcel.createLongArray();
        this.txBytes = parcel.createLongArray();
        this.txPackets = parcel.createLongArray();
        this.operations = parcel.createLongArray();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.elapsedRealtime);
        dest.writeInt(this.size);
        dest.writeInt(this.capacity);
        dest.writeStringArray(this.iface);
        dest.writeIntArray(this.uid);
        dest.writeIntArray(this.set);
        dest.writeIntArray(this.tag);
        dest.writeIntArray(this.metered);
        dest.writeIntArray(this.roaming);
        dest.writeIntArray(this.defaultNetwork);
        dest.writeLongArray(this.rxBytes);
        dest.writeLongArray(this.rxPackets);
        dest.writeLongArray(this.txBytes);
        dest.writeLongArray(this.txPackets);
        dest.writeLongArray(this.operations);
    }

    public NetworkStats clone() {
        NetworkStats clone = new NetworkStats(this.elapsedRealtime, this.size);
        Entry entry = null;
        for (int i = 0; i < this.size; ++i) {
            entry = this.getValues(i, entry);
            clone.addValues(entry);
        }
        return clone;
    }

    @VisibleForTesting
    public NetworkStats addIfaceValues(String iface, long rxBytes, long rxPackets, long txBytes, long txPackets) {
        return this.addValues(iface, -1, 0, 0, rxBytes, rxPackets, txBytes, txPackets, 0L);
    }

    @VisibleForTesting
    public NetworkStats addValues(String iface, int uid, int set, int tag, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        return this.addValues(new Entry(iface, uid, set, tag, rxBytes, rxPackets, txBytes, txPackets, operations));
    }

    @VisibleForTesting
    public NetworkStats addValues(String iface, int uid, int set, int tag, int metered, int roaming, int defaultNetwork, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        return this.addValues(new Entry(iface, uid, set, tag, metered, roaming, defaultNetwork, rxBytes, rxPackets, txBytes, txPackets, operations));
    }

    public NetworkStats addValues(Entry entry) {
        if (this.size >= this.capacity) {
            int newLength = Math.max(this.size, 10) * 3 / 2;
            this.iface = Arrays.copyOf(this.iface, newLength);
            this.uid = Arrays.copyOf(this.uid, newLength);
            this.set = Arrays.copyOf(this.set, newLength);
            this.tag = Arrays.copyOf(this.tag, newLength);
            this.metered = Arrays.copyOf(this.metered, newLength);
            this.roaming = Arrays.copyOf(this.roaming, newLength);
            this.defaultNetwork = Arrays.copyOf(this.defaultNetwork, newLength);
            this.rxBytes = Arrays.copyOf(this.rxBytes, newLength);
            this.rxPackets = Arrays.copyOf(this.rxPackets, newLength);
            this.txBytes = Arrays.copyOf(this.txBytes, newLength);
            this.txPackets = Arrays.copyOf(this.txPackets, newLength);
            this.operations = Arrays.copyOf(this.operations, newLength);
            this.capacity = newLength;
        }
        this.iface[this.size] = entry.iface;
        this.uid[this.size] = entry.uid;
        this.set[this.size] = entry.set;
        this.tag[this.size] = entry.tag;
        this.metered[this.size] = entry.metered;
        this.roaming[this.size] = entry.roaming;
        this.defaultNetwork[this.size] = entry.defaultNetwork;
        this.rxBytes[this.size] = entry.rxBytes;
        this.rxPackets[this.size] = entry.rxPackets;
        this.txBytes[this.size] = entry.txBytes;
        this.txPackets[this.size] = entry.txPackets;
        this.operations[this.size] = entry.operations;
        ++this.size;
        return this;
    }

    public Entry getValues(int i, Entry recycle) {
        Entry entry = recycle != null ? recycle : new Entry();
        entry.iface = this.iface[i];
        entry.uid = this.uid[i];
        entry.set = this.set[i];
        entry.tag = this.tag[i];
        entry.metered = this.metered[i];
        entry.roaming = this.roaming[i];
        entry.defaultNetwork = this.defaultNetwork[i];
        entry.rxBytes = this.rxBytes[i];
        entry.rxPackets = this.rxPackets[i];
        entry.txBytes = this.txBytes[i];
        entry.txPackets = this.txPackets[i];
        entry.operations = this.operations[i];
        return entry;
    }

    public long getElapsedRealtime() {
        return this.elapsedRealtime;
    }

    public void setElapsedRealtime(long time) {
        this.elapsedRealtime = time;
    }

    public long getElapsedRealtimeAge() {
        return SystemClock.elapsedRealtime() - this.elapsedRealtime;
    }

    public int size() {
        return this.size;
    }

    @VisibleForTesting
    public int internalSize() {
        return this.capacity;
    }

    @Deprecated
    public NetworkStats combineValues(String iface, int uid, int tag, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        return this.combineValues(iface, uid, 0, tag, rxBytes, rxPackets, txBytes, txPackets, operations);
    }

    public NetworkStats combineValues(String iface, int uid, int set, int tag, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        return this.combineValues(new Entry(iface, uid, set, tag, rxBytes, rxPackets, txBytes, txPackets, operations));
    }

    public NetworkStats combineValues(Entry entry) {
        int i = this.findIndex(entry.iface, entry.uid, entry.set, entry.tag, entry.metered, entry.roaming, entry.defaultNetwork);
        if (i == -1) {
            this.addValues(entry);
        } else {
            int n = i;
            this.rxBytes[n] = this.rxBytes[n] + entry.rxBytes;
            int n2 = i;
            this.rxPackets[n2] = this.rxPackets[n2] + entry.rxPackets;
            int n3 = i;
            this.txBytes[n3] = this.txBytes[n3] + entry.txBytes;
            int n4 = i;
            this.txPackets[n4] = this.txPackets[n4] + entry.txPackets;
            int n5 = i;
            this.operations[n5] = this.operations[n5] + entry.operations;
        }
        return this;
    }

    public void combineAllValues(NetworkStats another) {
        Entry entry = null;
        for (int i = 0; i < another.size; ++i) {
            entry = another.getValues(i, entry);
            this.combineValues(entry);
        }
    }

    public int findIndex(String iface, int uid, int set, int tag, int metered, int roaming, int defaultNetwork) {
        for (int i = 0; i < this.size; ++i) {
            if (uid != this.uid[i] || set != this.set[i] || tag != this.tag[i] || metered != this.metered[i] || roaming != this.roaming[i] || defaultNetwork != this.defaultNetwork[i] || !Objects.equals(iface, this.iface[i])) continue;
            return i;
        }
        return -1;
    }

    @VisibleForTesting
    public int findIndexHinted(String iface, int uid, int set, int tag, int metered, int roaming, int defaultNetwork, int hintIndex) {
        for (int offset = 0; offset < this.size; ++offset) {
            int halfOffset = offset / 2;
            int i = offset % 2 == 0 ? (hintIndex + halfOffset) % this.size : (this.size + hintIndex - halfOffset - 1) % this.size;
            if (uid != this.uid[i] || set != this.set[i] || tag != this.tag[i] || metered != this.metered[i] || roaming != this.roaming[i] || defaultNetwork != this.defaultNetwork[i] || !Objects.equals(iface, this.iface[i])) continue;
            return i;
        }
        return -1;
    }

    public void spliceOperationsFrom(NetworkStats stats) {
        for (int i = 0; i < this.size; ++i) {
            int j = stats.findIndex(this.iface[i], this.uid[i], this.set[i], this.tag[i], this.metered[i], this.roaming[i], this.defaultNetwork[i]);
            this.operations[i] = j == -1 ? 0L : stats.operations[j];
        }
    }

    public String[] getUniqueIfaces() {
        HashSet<String> ifaces = new HashSet<String>();
        for (String iface : this.iface) {
            if (iface == IFACE_ALL) continue;
            ifaces.add(iface);
        }
        return ifaces.toArray(new String[ifaces.size()]);
    }

    public int[] getUniqueUids() {
        SparseBooleanArray uids = new SparseBooleanArray();
        for (int uid : this.uid) {
            uids.put(uid, true);
        }
        int size = uids.size();
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = uids.keyAt(i);
        }
        return result;
    }

    public long getTotalBytes() {
        Entry entry = this.getTotal(null);
        return entry.rxBytes + entry.txBytes;
    }

    public Entry getTotal(Entry recycle) {
        return this.getTotal(recycle, null, -1, false);
    }

    public Entry getTotal(Entry recycle, int limitUid) {
        return this.getTotal(recycle, null, limitUid, false);
    }

    public Entry getTotal(Entry recycle, HashSet<String> limitIface) {
        return this.getTotal(recycle, limitIface, -1, false);
    }

    public Entry getTotalIncludingTags(Entry recycle) {
        return this.getTotal(recycle, null, -1, true);
    }

    private Entry getTotal(Entry recycle, HashSet<String> limitIface, int limitUid, boolean includeTags) {
        Entry entry = recycle != null ? recycle : new Entry();
        entry.iface = IFACE_ALL;
        entry.uid = limitUid;
        entry.set = -1;
        entry.tag = 0;
        entry.metered = -1;
        entry.roaming = -1;
        entry.defaultNetwork = -1;
        entry.rxBytes = 0L;
        entry.rxPackets = 0L;
        entry.txBytes = 0L;
        entry.txPackets = 0L;
        entry.operations = 0L;
        for (int i = 0; i < this.size; ++i) {
            boolean matchesIface;
            boolean matchesUid = limitUid == -1 || limitUid == this.uid[i];
            boolean bl = matchesIface = limitIface == null || limitIface.contains(this.iface[i]);
            if (!matchesUid || !matchesIface || this.tag[i] != 0 && !includeTags) continue;
            entry.rxBytes += this.rxBytes[i];
            entry.rxPackets += this.rxPackets[i];
            entry.txBytes += this.txBytes[i];
            entry.txPackets += this.txPackets[i];
            entry.operations += this.operations[i];
        }
        return entry;
    }

    public long getTotalPackets() {
        long total = 0L;
        for (int i = this.size - 1; i >= 0; --i) {
            total += this.rxPackets[i] + this.txPackets[i];
        }
        return total;
    }

    public NetworkStats subtract(NetworkStats right) {
        return NetworkStats.subtract(this, right, null, null);
    }

    public static <C> NetworkStats subtract(NetworkStats left, NetworkStats right, NonMonotonicObserver<C> observer, C cookie) {
        return NetworkStats.subtract(left, right, observer, cookie, null);
    }

    public static <C> NetworkStats subtract(NetworkStats left, NetworkStats right, NonMonotonicObserver<C> observer, C cookie, NetworkStats recycle) {
        NetworkStats result;
        long deltaRealtime = left.elapsedRealtime - right.elapsedRealtime;
        if (deltaRealtime < 0L) {
            if (observer != null) {
                observer.foundNonMonotonic(left, -1, right, -1, cookie);
            }
            deltaRealtime = 0L;
        }
        Entry entry = new Entry();
        if (recycle != null && recycle.capacity >= left.size) {
            result = recycle;
            result.size = 0;
            result.elapsedRealtime = deltaRealtime;
        } else {
            result = new NetworkStats(deltaRealtime, left.size);
        }
        for (int i = 0; i < left.size; ++i) {
            entry.iface = left.iface[i];
            entry.uid = left.uid[i];
            entry.set = left.set[i];
            entry.tag = left.tag[i];
            entry.metered = left.metered[i];
            entry.roaming = left.roaming[i];
            entry.defaultNetwork = left.defaultNetwork[i];
            entry.rxBytes = left.rxBytes[i];
            entry.rxPackets = left.rxPackets[i];
            entry.txBytes = left.txBytes[i];
            entry.txPackets = left.txPackets[i];
            entry.operations = left.operations[i];
            int j = right.findIndexHinted(entry.iface, entry.uid, entry.set, entry.tag, entry.metered, entry.roaming, entry.defaultNetwork, i);
            if (j != -1) {
                entry.rxBytes -= right.rxBytes[j];
                entry.rxPackets -= right.rxPackets[j];
                entry.txBytes -= right.txBytes[j];
                entry.txPackets -= right.txPackets[j];
                entry.operations -= right.operations[j];
            }
            if (entry.isNegative()) {
                if (observer != null) {
                    observer.foundNonMonotonic(left, i, right, j, cookie);
                }
                entry.rxBytes = Math.max(entry.rxBytes, 0L);
                entry.rxPackets = Math.max(entry.rxPackets, 0L);
                entry.txBytes = Math.max(entry.txBytes, 0L);
                entry.txPackets = Math.max(entry.txPackets, 0L);
                entry.operations = Math.max(entry.operations, 0L);
            }
            result.addValues(entry);
        }
        return result;
    }

    public NetworkStats groupedByIface() {
        NetworkStats stats = new NetworkStats(this.elapsedRealtime, 10);
        Entry entry = new Entry();
        entry.uid = -1;
        entry.set = -1;
        entry.tag = 0;
        entry.metered = -1;
        entry.roaming = -1;
        entry.defaultNetwork = -1;
        entry.operations = 0L;
        for (int i = 0; i < this.size; ++i) {
            if (this.tag[i] != 0) continue;
            entry.iface = this.iface[i];
            entry.rxBytes = this.rxBytes[i];
            entry.rxPackets = this.rxPackets[i];
            entry.txBytes = this.txBytes[i];
            entry.txPackets = this.txPackets[i];
            stats.combineValues(entry);
        }
        return stats;
    }

    public NetworkStats groupedByUid() {
        NetworkStats stats = new NetworkStats(this.elapsedRealtime, 10);
        Entry entry = new Entry();
        entry.iface = IFACE_ALL;
        entry.set = -1;
        entry.tag = 0;
        entry.metered = -1;
        entry.roaming = -1;
        entry.defaultNetwork = -1;
        for (int i = 0; i < this.size; ++i) {
            if (this.tag[i] != 0) continue;
            entry.uid = this.uid[i];
            entry.rxBytes = this.rxBytes[i];
            entry.rxPackets = this.rxPackets[i];
            entry.txBytes = this.txBytes[i];
            entry.txPackets = this.txPackets[i];
            entry.operations = this.operations[i];
            stats.combineValues(entry);
        }
        return stats;
    }

    public NetworkStats withoutUids(int[] uids) {
        NetworkStats stats = new NetworkStats(this.elapsedRealtime, 10);
        Entry entry = new Entry();
        for (int i = 0; i < this.size; ++i) {
            entry = this.getValues(i, entry);
            if (ArrayUtils.contains(uids, entry.uid)) continue;
            stats.addValues(entry);
        }
        return stats;
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("NetworkStats: elapsedRealtime=");
        pw.println(this.elapsedRealtime);
        for (int i = 0; i < this.size; ++i) {
            pw.print(prefix);
            pw.print("  [");
            pw.print(i);
            pw.print("]");
            pw.print(" iface=");
            pw.print(this.iface[i]);
            pw.print(" uid=");
            pw.print(this.uid[i]);
            pw.print(" set=");
            pw.print(NetworkStats.setToString(this.set[i]));
            pw.print(" tag=");
            pw.print(NetworkStats.tagToString(this.tag[i]));
            pw.print(" metered=");
            pw.print(NetworkStats.meteredToString(this.metered[i]));
            pw.print(" roaming=");
            pw.print(NetworkStats.roamingToString(this.roaming[i]));
            pw.print(" defaultNetwork=");
            pw.print(NetworkStats.defaultNetworkToString(this.defaultNetwork[i]));
            pw.print(" rxBytes=");
            pw.print(this.rxBytes[i]);
            pw.print(" rxPackets=");
            pw.print(this.rxPackets[i]);
            pw.print(" txBytes=");
            pw.print(this.txBytes[i]);
            pw.print(" txPackets=");
            pw.print(this.txPackets[i]);
            pw.print(" operations=");
            pw.println(this.operations[i]);
        }
    }

    public static String setToString(int set) {
        switch (set) {
            case -1: {
                return "ALL";
            }
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "FOREGROUND";
            }
            case 1001: {
                return "DBG_VPN_IN";
            }
            case 1002: {
                return "DBG_VPN_OUT";
            }
        }
        return "UNKNOWN";
    }

    public static String setToCheckinString(int set) {
        switch (set) {
            case -1: {
                return "all";
            }
            case 0: {
                return "def";
            }
            case 1: {
                return "fg";
            }
            case 1001: {
                return "vpnin";
            }
            case 1002: {
                return "vpnout";
            }
        }
        return "unk";
    }

    public static boolean setMatches(int querySet, int dataSet) {
        if (querySet == dataSet) {
            return true;
        }
        return querySet == -1 && dataSet < 1000;
    }

    public static String tagToString(int tag) {
        return "0x" + Integer.toHexString(tag);
    }

    public static String meteredToString(int metered) {
        switch (metered) {
            case -1: {
                return "ALL";
            }
            case 0: {
                return "NO";
            }
            case 1: {
                return "YES";
            }
        }
        return "UNKNOWN";
    }

    public static String roamingToString(int roaming) {
        switch (roaming) {
            case -1: {
                return "ALL";
            }
            case 0: {
                return "NO";
            }
            case 1: {
                return "YES";
            }
        }
        return "UNKNOWN";
    }

    public static String defaultNetworkToString(int defaultNetwork) {
        switch (defaultNetwork) {
            case -1: {
                return "ALL";
            }
            case 0: {
                return "NO";
            }
            case 1: {
                return "YES";
            }
        }
        return "UNKNOWN";
    }

    public String toString() {
        CharArrayWriter writer = new CharArrayWriter();
        this.dump("", new PrintWriter(writer));
        return writer.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean migrateTun(int tunUid, String tunIface, String underlyingIface) {
        Entry tunIfaceTotal = new Entry();
        Entry underlyingIfaceTotal = new Entry();
        this.tunAdjustmentInit(tunUid, tunIface, underlyingIface, tunIfaceTotal, underlyingIfaceTotal);
        Entry pool = NetworkStats.tunGetPool(tunIfaceTotal, underlyingIfaceTotal);
        if (pool.isEmpty()) {
            return true;
        }
        Entry moved = this.addTrafficToApplications(tunUid, tunIface, underlyingIface, tunIfaceTotal, pool);
        this.deductTrafficFromVpnApp(tunUid, underlyingIface, moved);
        if (!moved.isEmpty()) {
            Slog.wtf(TAG, "Failed to deduct underlying network traffic from VPN package. Moved=" + moved);
            return false;
        }
        return true;
    }

    private void tunAdjustmentInit(int tunUid, String tunIface, String underlyingIface, Entry tunIfaceTotal, Entry underlyingIfaceTotal) {
        Entry recycle = new Entry();
        for (int i = 0; i < this.size; ++i) {
            this.getValues(i, recycle);
            if (recycle.uid == -1) {
                throw new IllegalStateException("Cannot adjust VPN accounting on an iface aggregated NetworkStats.");
            }
            if (recycle.set == 1001 || recycle.set == 1002) {
                throw new IllegalStateException("Cannot adjust VPN accounting on a NetworkStats containing SET_DBG_VPN_*");
            }
            if (recycle.uid == tunUid && recycle.tag == 0 && Objects.equals(underlyingIface, recycle.iface)) {
                underlyingIfaceTotal.add(recycle);
            }
            if (recycle.uid == tunUid || recycle.tag != 0 || !Objects.equals(tunIface, recycle.iface)) continue;
            tunIfaceTotal.add(recycle);
        }
    }

    private static Entry tunGetPool(Entry tunIfaceTotal, Entry underlyingIfaceTotal) {
        Entry pool = new Entry();
        pool.rxBytes = Math.min(tunIfaceTotal.rxBytes, underlyingIfaceTotal.rxBytes);
        pool.rxPackets = Math.min(tunIfaceTotal.rxPackets, underlyingIfaceTotal.rxPackets);
        pool.txBytes = Math.min(tunIfaceTotal.txBytes, underlyingIfaceTotal.txBytes);
        pool.txPackets = Math.min(tunIfaceTotal.txPackets, underlyingIfaceTotal.txPackets);
        pool.operations = Math.min(tunIfaceTotal.operations, underlyingIfaceTotal.operations);
        return pool;
    }

    private Entry addTrafficToApplications(int tunUid, String tunIface, String underlyingIface, Entry tunIfaceTotal, Entry pool) {
        Entry moved = new Entry();
        Entry tmpEntry = new Entry();
        tmpEntry.iface = underlyingIface;
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equals(this.iface[i], tunIface) || this.uid[i] == tunUid) continue;
            tmpEntry.rxBytes = tunIfaceTotal.rxBytes > 0L ? pool.rxBytes * this.rxBytes[i] / tunIfaceTotal.rxBytes : 0L;
            tmpEntry.rxPackets = tunIfaceTotal.rxPackets > 0L ? pool.rxPackets * this.rxPackets[i] / tunIfaceTotal.rxPackets : 0L;
            tmpEntry.txBytes = tunIfaceTotal.txBytes > 0L ? pool.txBytes * this.txBytes[i] / tunIfaceTotal.txBytes : 0L;
            tmpEntry.txPackets = tunIfaceTotal.txPackets > 0L ? pool.txPackets * this.txPackets[i] / tunIfaceTotal.txPackets : 0L;
            tmpEntry.operations = tunIfaceTotal.operations > 0L ? pool.operations * this.operations[i] / tunIfaceTotal.operations : 0L;
            tmpEntry.uid = this.uid[i];
            tmpEntry.tag = this.tag[i];
            tmpEntry.set = this.set[i];
            tmpEntry.metered = this.metered[i];
            tmpEntry.roaming = this.roaming[i];
            tmpEntry.defaultNetwork = this.defaultNetwork[i];
            this.combineValues(tmpEntry);
            if (this.tag[i] != 0) continue;
            moved.add(tmpEntry);
            tmpEntry.set = 1001;
            this.combineValues(tmpEntry);
        }
        return moved;
    }

    private void deductTrafficFromVpnApp(int tunUid, String underlyingIface, Entry moved) {
        int idxVpnForeground;
        moved.uid = tunUid;
        moved.set = 1002;
        moved.tag = 0;
        moved.iface = underlyingIface;
        moved.metered = -1;
        moved.roaming = -1;
        moved.defaultNetwork = -1;
        this.combineValues(moved);
        int idxVpnBackground = this.findIndex(underlyingIface, tunUid, 0, 0, 0, 0, 0);
        if (idxVpnBackground != -1) {
            NetworkStats.tunSubtract(idxVpnBackground, this, moved);
        }
        if ((idxVpnForeground = this.findIndex(underlyingIface, tunUid, 1, 0, 0, 0, 0)) != -1) {
            NetworkStats.tunSubtract(idxVpnForeground, this, moved);
        }
    }

    private static void tunSubtract(int i, NetworkStats left, Entry right) {
        long rxBytes = Math.min(left.rxBytes[i], right.rxBytes);
        int n = i;
        left.rxBytes[n] = left.rxBytes[n] - rxBytes;
        right.rxBytes -= rxBytes;
        long rxPackets = Math.min(left.rxPackets[i], right.rxPackets);
        int n2 = i;
        left.rxPackets[n2] = left.rxPackets[n2] - rxPackets;
        right.rxPackets -= rxPackets;
        long txBytes = Math.min(left.txBytes[i], right.txBytes);
        int n3 = i;
        left.txBytes[n3] = left.txBytes[n3] - txBytes;
        right.txBytes -= txBytes;
        long txPackets = Math.min(left.txPackets[i], right.txPackets);
        int n4 = i;
        left.txPackets[n4] = left.txPackets[n4] - txPackets;
        right.txPackets -= txPackets;
    }

    public static interface NonMonotonicObserver<C> {
        public void foundNonMonotonic(NetworkStats var1, int var2, NetworkStats var3, int var4, C var5);
    }

    public static class Entry {
        public String iface;
        public int uid;
        public int set;
        public int tag;
        public int metered;
        public int roaming;
        public int defaultNetwork;
        public long rxBytes;
        public long rxPackets;
        public long txBytes;
        public long txPackets;
        public long operations;

        public Entry() {
            this(IFACE_ALL, -1, 0, 0, 0L, 0L, 0L, 0L, 0L);
        }

        public Entry(long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
            this(IFACE_ALL, -1, 0, 0, rxBytes, rxPackets, txBytes, txPackets, operations);
        }

        public Entry(String iface, int uid, int set, int tag, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
            this(iface, uid, set, tag, 0, 0, 0, rxBytes, rxPackets, txBytes, txPackets, operations);
        }

        public Entry(String iface, int uid, int set, int tag, int metered, int roaming, int defaultNetwork, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
            this.iface = iface;
            this.uid = uid;
            this.set = set;
            this.tag = tag;
            this.metered = metered;
            this.roaming = roaming;
            this.defaultNetwork = defaultNetwork;
            this.rxBytes = rxBytes;
            this.rxPackets = rxPackets;
            this.txBytes = txBytes;
            this.txPackets = txPackets;
            this.operations = operations;
        }

        public boolean isNegative() {
            return this.rxBytes < 0L || this.rxPackets < 0L || this.txBytes < 0L || this.txPackets < 0L || this.operations < 0L;
        }

        public boolean isEmpty() {
            return this.rxBytes == 0L && this.rxPackets == 0L && this.txBytes == 0L && this.txPackets == 0L && this.operations == 0L;
        }

        public void add(Entry another) {
            this.rxBytes += another.rxBytes;
            this.rxPackets += another.rxPackets;
            this.txBytes += another.txBytes;
            this.txPackets += another.txPackets;
            this.operations += another.operations;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("iface=").append(this.iface);
            builder.append(" uid=").append(this.uid);
            builder.append(" set=").append(NetworkStats.setToString(this.set));
            builder.append(" tag=").append(NetworkStats.tagToString(this.tag));
            builder.append(" metered=").append(NetworkStats.meteredToString(this.metered));
            builder.append(" roaming=").append(NetworkStats.roamingToString(this.roaming));
            builder.append(" defaultNetwork=").append(NetworkStats.defaultNetworkToString(this.defaultNetwork));
            builder.append(" rxBytes=").append(this.rxBytes);
            builder.append(" rxPackets=").append(this.rxPackets);
            builder.append(" txBytes=").append(this.txBytes);
            builder.append(" txPackets=").append(this.txPackets);
            builder.append(" operations=").append(this.operations);
            return builder.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof Entry) {
                Entry e = (Entry)o;
                return this.uid == e.uid && this.set == e.set && this.tag == e.tag && this.metered == e.metered && this.roaming == e.roaming && this.defaultNetwork == e.defaultNetwork && this.rxBytes == e.rxBytes && this.rxPackets == e.rxPackets && this.txBytes == e.txBytes && this.txPackets == e.txPackets && this.operations == e.operations && this.iface.equals(e.iface);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.uid, this.set, this.tag, this.metered, this.roaming, this.defaultNetwork, this.iface);
        }
    }
}

