/*
 * Decompiled with CFR 0.152.
 */
package android.net.apf;

import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkUtils;
import android.net.apf.ApfCapabilities;
import android.net.apf.ApfGenerator;
import android.net.ip.IpClient;
import android.net.metrics.ApfProgramEvent;
import android.net.metrics.ApfStats;
import android.net.metrics.IpConnectivityLog;
import android.net.metrics.RaEvent;
import android.net.util.InterfaceParams;
import android.os.SystemClock;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.PacketSocketAddress;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.BitUtils;
import com.android.internal.util.HexDump;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import libcore.io.IoBridge;

public class ApfFilter {
    private static final String TAG = "ApfFilter";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final int ETH_HEADER_LEN = 14;
    private static final int ETH_DEST_ADDR_OFFSET = 0;
    private static final int ETH_ETHERTYPE_OFFSET = 12;
    private static final int ETH_TYPE_MIN = 1536;
    private static final int ETH_TYPE_MAX = 65535;
    private static final byte[] ETH_BROADCAST_MAC_ADDRESS = new byte[]{-1, -1, -1, -1, -1, -1};
    private static final int IPV4_FRAGMENT_OFFSET_OFFSET = 20;
    private static final int IPV4_FRAGMENT_OFFSET_MASK = 8191;
    private static final int IPV4_PROTOCOL_OFFSET = 23;
    private static final int IPV4_DEST_ADDR_OFFSET = 30;
    private static final int IPV4_ANY_HOST_ADDRESS = 0;
    private static final int IPV4_BROADCAST_ADDRESS = -1;
    private static final int IPV6_FLOW_LABEL_OFFSET = 15;
    private static final int IPV6_FLOW_LABEL_LEN = 3;
    private static final int IPV6_NEXT_HEADER_OFFSET = 20;
    private static final int IPV6_SRC_ADDR_OFFSET = 22;
    private static final int IPV6_DEST_ADDR_OFFSET = 38;
    private static final int IPV6_HEADER_LEN = 40;
    private static final byte[] IPV6_ALL_NODES_ADDRESS = new byte[]{-1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    private static final int ICMP6_TYPE_OFFSET = 54;
    private static final int ICMP6_ROUTER_SOLICITATION = 133;
    private static final int ICMP6_ROUTER_ADVERTISEMENT = 134;
    private static final int ICMP6_NEIGHBOR_SOLICITATION = 135;
    private static final int ICMP6_NEIGHBOR_ANNOUNCEMENT = 136;
    private static final int UDP_DESTINATION_PORT_OFFSET = 16;
    private static final int UDP_HEADER_LEN = 8;
    private static final int DHCP_CLIENT_PORT = 68;
    private static final int DHCP_CLIENT_MAC_OFFSET = 50;
    private static final int ARP_HEADER_OFFSET = 14;
    private static final int ARP_OPCODE_OFFSET = 20;
    private static final short ARP_OPCODE_REQUEST = 1;
    private static final short ARP_OPCODE_REPLY = 2;
    private static final byte[] ARP_IPV4_HEADER = new byte[]{0, 1, 8, 0, 6, 4};
    private static final int ARP_TARGET_IP_ADDRESS_OFFSET = 38;
    private static final int APF_PROGRAM_EVENT_LIFETIME_THRESHOLD = 2;
    private static final int APF_MAX_ETH_TYPE_BLACK_LIST_LEN = 20;
    private final ApfCapabilities mApfCapabilities;
    private final IpClient.Callback mIpClientCallback;
    private final InterfaceParams mInterfaceParams;
    private final IpConnectivityLog mMetricsLog;
    @VisibleForTesting
    byte[] mHardwareAddress;
    @VisibleForTesting
    ReceiveThread mReceiveThread;
    @GuardedBy(value="this")
    private long mUniqueCounter;
    @GuardedBy(value="this")
    private boolean mMulticastFilter;
    private final boolean mDrop802_3Frames;
    private final int[] mEthTypeBlackList;
    @GuardedBy(value="this")
    private byte[] mIPv4Address;
    @GuardedBy(value="this")
    private int mIPv4PrefixLength;
    private static final int MAX_RAS = 10;
    @GuardedBy(value="this")
    private ArrayList<Ra> mRas = new ArrayList();
    private static final long MAX_PROGRAM_LIFETIME_WORTH_REFRESHING = 30L;
    private static final int FRACTION_OF_LIFETIME_TO_FILTER = 6;
    @GuardedBy(value="this")
    private long mLastTimeInstalledProgram;
    @GuardedBy(value="this")
    private long mLastInstalledProgramMinLifetime;
    @GuardedBy(value="this")
    private ApfProgramEvent mLastInstallEvent;
    @GuardedBy(value="this")
    private byte[] mLastInstalledProgram;
    @GuardedBy(value="this")
    private int mNumProgramUpdates = 0;
    @GuardedBy(value="this")
    private int mNumProgramUpdatesAllowingMulticast = 0;

    @VisibleForTesting
    ApfFilter(ApfConfiguration config, InterfaceParams ifParams, IpClient.Callback ipClientCallback, IpConnectivityLog log) {
        this.mApfCapabilities = config.apfCapabilities;
        this.mIpClientCallback = ipClientCallback;
        this.mInterfaceParams = ifParams;
        this.mMulticastFilter = config.multicastFilter;
        this.mDrop802_3Frames = config.ieee802_3Filter;
        this.mEthTypeBlackList = ApfFilter.filterEthTypeBlackList(config.ethTypeBlackList);
        this.mMetricsLog = log;
        this.maybeStartFilter();
    }

    private void log(String s) {
        Log.d(TAG, "(" + this.mInterfaceParams.name + "): " + s);
    }

    @GuardedBy(value="this")
    private long getUniqueNumberLocked() {
        return this.mUniqueCounter++;
    }

    @GuardedBy(value="this")
    private static int[] filterEthTypeBlackList(int[] ethTypeBlackList) {
        ArrayList<Integer> bl = new ArrayList<Integer>();
        for (int p : ethTypeBlackList) {
            if (p < 1536 || p > 65535 || bl.contains(p)) continue;
            if (bl.size() == 20) {
                Log.w(TAG, "Passed EthType Black List size too large (" + bl.size() + ") using top " + 20 + " protocols");
                break;
            }
            bl.add(p);
        }
        return bl.stream().mapToInt(Integer::intValue).toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void maybeStartFilter() {
        FileDescriptor socket;
        try {
            this.mHardwareAddress = this.mInterfaceParams.macAddr.toByteArray();
            ApfFilter apfFilter = this;
            synchronized (apfFilter) {
                this.installNewProgramLocked();
            }
            socket = Os.socket(OsConstants.AF_PACKET, OsConstants.SOCK_RAW, OsConstants.ETH_P_IPV6);
            PacketSocketAddress addr = new PacketSocketAddress((short)OsConstants.ETH_P_IPV6, this.mInterfaceParams.index);
            Os.bind(socket, addr);
            NetworkUtils.attachRaFilter(socket, this.mApfCapabilities.apfPacketFormat);
        }
        catch (ErrnoException | SocketException e) {
            Log.e(TAG, "Error starting filter", e);
            return;
        }
        this.mReceiveThread = new ReceiveThread(socket);
        this.mReceiveThread.start();
    }

    @VisibleForTesting
    protected long currentTimeSeconds() {
        return SystemClock.elapsedRealtime() / 1000L;
    }

    @GuardedBy(value="this")
    private void generateArpFilterLocked(ApfGenerator gen) throws ApfGenerator.IllegalInstructionException {
        String checkTargetIPv4 = "checkTargetIPv4";
        gen.addLoadImmediate(ApfGenerator.Register.R0, 14);
        gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, ARP_IPV4_HEADER, "__PASS__");
        gen.addLoad16(ApfGenerator.Register.R0, 20);
        gen.addJumpIfR0Equals(1, "checkTargetIPv4");
        gen.addJumpIfR0NotEquals(2, "__PASS__");
        gen.addLoadImmediate(ApfGenerator.Register.R0, 0);
        gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, ETH_BROADCAST_MAC_ADDRESS, "__PASS__");
        gen.defineLabel("checkTargetIPv4");
        if (this.mIPv4Address == null) {
            gen.addLoad32(ApfGenerator.Register.R0, 38);
            gen.addJumpIfR0Equals(0, "__DROP__");
        } else {
            gen.addLoadImmediate(ApfGenerator.Register.R0, 38);
            gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, this.mIPv4Address, "__DROP__");
        }
        gen.addJump("__PASS__");
    }

    @GuardedBy(value="this")
    private void generateIPv4FilterLocked(ApfGenerator gen) throws ApfGenerator.IllegalInstructionException {
        if (this.mMulticastFilter) {
            String skipDhcpv4Filter = "skip_dhcp_v4_filter";
            gen.addLoad8(ApfGenerator.Register.R0, 23);
            gen.addJumpIfR0NotEquals(OsConstants.IPPROTO_UDP, "skip_dhcp_v4_filter");
            gen.addLoad16(ApfGenerator.Register.R0, 20);
            gen.addJumpIfR0AnyBitsSet(8191, "skip_dhcp_v4_filter");
            gen.addLoadFromMemory(ApfGenerator.Register.R1, 13);
            gen.addLoad16Indexed(ApfGenerator.Register.R0, 16);
            gen.addJumpIfR0NotEquals(68, "skip_dhcp_v4_filter");
            gen.addLoadImmediate(ApfGenerator.Register.R0, 50);
            gen.addAddR1();
            gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, this.mHardwareAddress, "skip_dhcp_v4_filter");
            gen.addJump("__PASS__");
            gen.defineLabel("skip_dhcp_v4_filter");
            gen.addLoad8(ApfGenerator.Register.R0, 30);
            gen.addAnd(240);
            gen.addJumpIfR0Equals(224, "__DROP__");
            gen.addLoad32(ApfGenerator.Register.R0, 30);
            gen.addJumpIfR0Equals(-1, "__DROP__");
            if (this.mIPv4Address != null && this.mIPv4PrefixLength < 31) {
                int broadcastAddr = ApfFilter.ipv4BroadcastAddress(this.mIPv4Address, this.mIPv4PrefixLength);
                gen.addJumpIfR0Equals(broadcastAddr, "__DROP__");
            }
            gen.addLoadImmediate(ApfGenerator.Register.R0, 0);
            gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, ETH_BROADCAST_MAC_ADDRESS, "__PASS__");
            gen.addJump("__DROP__");
        }
        gen.addJump("__PASS__");
    }

    @GuardedBy(value="this")
    private void generateIPv6FilterLocked(ApfGenerator gen) throws ApfGenerator.IllegalInstructionException {
        gen.addLoad8(ApfGenerator.Register.R0, 20);
        if (this.mMulticastFilter) {
            String skipIpv6MulticastFilterLabel = "skipIPv6MulticastFilter";
            gen.addJumpIfR0Equals(OsConstants.IPPROTO_ICMPV6, skipIpv6MulticastFilterLabel);
            gen.addLoad8(ApfGenerator.Register.R0, 38);
            gen.addJumpIfR0Equals(255, "__DROP__");
            gen.addJump("__PASS__");
            gen.defineLabel(skipIpv6MulticastFilterLabel);
        } else {
            gen.addJumpIfR0NotEquals(OsConstants.IPPROTO_ICMPV6, "__PASS__");
        }
        String skipUnsolicitedMulticastNALabel = "skipUnsolicitedMulticastNA";
        gen.addLoad8(ApfGenerator.Register.R0, 54);
        gen.addJumpIfR0Equals(133, "__DROP__");
        gen.addJumpIfR0NotEquals(136, skipUnsolicitedMulticastNALabel);
        gen.addLoadImmediate(ApfGenerator.Register.R0, 38);
        gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, IPV6_ALL_NODES_ADDRESS, skipUnsolicitedMulticastNALabel);
        gen.addJump("__DROP__");
        gen.defineLabel(skipUnsolicitedMulticastNALabel);
    }

    @GuardedBy(value="this")
    private ApfGenerator beginProgramLocked() throws ApfGenerator.IllegalInstructionException {
        ApfGenerator gen = new ApfGenerator();
        gen.setApfVersion(this.mApfCapabilities.apfVersionSupported);
        gen.addLoad16(ApfGenerator.Register.R0, 12);
        if (this.mDrop802_3Frames) {
            gen.addJumpIfR0LessThan(1536, "__DROP__");
        }
        for (int p : this.mEthTypeBlackList) {
            gen.addJumpIfR0Equals(p, "__DROP__");
        }
        String skipArpFiltersLabel = "skipArpFilters";
        gen.addJumpIfR0NotEquals(OsConstants.ETH_P_ARP, skipArpFiltersLabel);
        this.generateArpFilterLocked(gen);
        gen.defineLabel(skipArpFiltersLabel);
        String skipIPv4FiltersLabel = "skipIPv4Filters";
        gen.addJumpIfR0NotEquals(OsConstants.ETH_P_IP, skipIPv4FiltersLabel);
        this.generateIPv4FilterLocked(gen);
        gen.defineLabel(skipIPv4FiltersLabel);
        String ipv6FilterLabel = "IPv6Filters";
        gen.addJumpIfR0Equals(OsConstants.ETH_P_IPV6, ipv6FilterLabel);
        gen.addLoadImmediate(ApfGenerator.Register.R0, 0);
        gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, ETH_BROADCAST_MAC_ADDRESS, "__PASS__");
        gen.addJump("__DROP__");
        gen.defineLabel(ipv6FilterLabel);
        this.generateIPv6FilterLocked(gen);
        return gen;
    }

    @GuardedBy(value="this")
    @VisibleForTesting
    void installNewProgramLocked() {
        long now;
        byte[] program;
        this.purgeExpiredRasLocked();
        ArrayList<Ra> rasToFilter = new ArrayList<Ra>();
        long programMinLifetime = Long.MAX_VALUE;
        try {
            ApfGenerator gen = this.beginProgramLocked();
            for (Ra ra : this.mRas) {
                ra.generateFilterLocked(gen);
                if (gen.programLengthOverEstimate() > this.mApfCapabilities.maximumApfProgramSize) break;
                rasToFilter.add(ra);
            }
            gen = this.beginProgramLocked();
            for (Ra ra : rasToFilter) {
                programMinLifetime = Math.min(programMinLifetime, ra.generateFilterLocked(gen));
            }
            program = gen.generate();
        }
        catch (ApfGenerator.IllegalInstructionException | IllegalStateException e) {
            Log.e(TAG, "Failed to generate APF program.", e);
            return;
        }
        this.mLastTimeInstalledProgram = now = this.currentTimeSeconds();
        this.mLastInstalledProgramMinLifetime = programMinLifetime;
        this.mLastInstalledProgram = program;
        ++this.mNumProgramUpdates;
        this.mIpClientCallback.installPacketFilter(program);
        this.logApfProgramEventLocked(now);
        this.mLastInstallEvent = new ApfProgramEvent();
        this.mLastInstallEvent.lifetime = programMinLifetime;
        this.mLastInstallEvent.filteredRas = rasToFilter.size();
        this.mLastInstallEvent.currentRas = this.mRas.size();
        this.mLastInstallEvent.programLength = program.length;
        this.mLastInstallEvent.flags = ApfProgramEvent.flagsFor(this.mIPv4Address != null, this.mMulticastFilter);
    }

    private void logApfProgramEventLocked(long now) {
        if (this.mLastInstallEvent == null) {
            return;
        }
        ApfProgramEvent ev = this.mLastInstallEvent;
        this.mLastInstallEvent = null;
        ev.actualLifetime = now - this.mLastTimeInstalledProgram;
        if (ev.actualLifetime < 2L) {
            return;
        }
        this.mMetricsLog.log(ev);
    }

    private boolean shouldInstallnewProgram() {
        long expiry = this.mLastTimeInstalledProgram + this.mLastInstalledProgramMinLifetime;
        return expiry < this.currentTimeSeconds() + 30L;
    }

    private void hexDump(String msg, byte[] packet, int length) {
        this.log(msg + HexDump.toHexString(packet, 0, length, false));
    }

    @GuardedBy(value="this")
    private void purgeExpiredRasLocked() {
        int i = 0;
        while (i < this.mRas.size()) {
            if (this.mRas.get(i).isExpired()) {
                this.log("Expiring " + this.mRas.get(i));
                this.mRas.remove(i);
                continue;
            }
            ++i;
        }
    }

    @VisibleForTesting
    synchronized ProcessRaResult processRa(byte[] packet, int length) {
        Ra ra;
        for (int i = 0; i < this.mRas.size(); ++i) {
            Ra ra2 = this.mRas.get(i);
            if (!ra2.matches(packet, length)) continue;
            ra2.mLastSeen = this.currentTimeSeconds();
            ra2.mMinLifetime = ra2.minLifetime(packet, length);
            ++ra2.seenCount;
            this.mRas.add(0, this.mRas.remove(i));
            if (this.shouldInstallnewProgram()) {
                this.installNewProgramLocked();
                return ProcessRaResult.UPDATE_EXPIRY;
            }
            return ProcessRaResult.MATCH;
        }
        this.purgeExpiredRasLocked();
        if (this.mRas.size() >= 10) {
            return ProcessRaResult.DROPPED;
        }
        try {
            ra = new Ra(packet, length);
        }
        catch (Exception e) {
            Log.e(TAG, "Error parsing RA", e);
            return ProcessRaResult.PARSE_ERROR;
        }
        if (ra.isExpired()) {
            return ProcessRaResult.ZERO_LIFETIME;
        }
        this.log("Adding " + ra);
        this.mRas.add(ra);
        this.installNewProgramLocked();
        return ProcessRaResult.UPDATE_NEW_RA;
    }

    public static ApfFilter maybeCreate(ApfConfiguration config, InterfaceParams ifParams, IpClient.Callback ipClientCallback) {
        if (config == null || ifParams == null) {
            return null;
        }
        ApfCapabilities apfCapabilities = config.apfCapabilities;
        if (apfCapabilities == null) {
            return null;
        }
        if (apfCapabilities.apfVersionSupported == 0) {
            return null;
        }
        if (apfCapabilities.maximumApfProgramSize < 512) {
            Log.e(TAG, "Unacceptably small APF limit: " + apfCapabilities.maximumApfProgramSize);
            return null;
        }
        if (apfCapabilities.apfPacketFormat != OsConstants.ARPHRD_ETHER) {
            return null;
        }
        if (!new ApfGenerator().setApfVersion(apfCapabilities.apfVersionSupported)) {
            Log.e(TAG, "Unsupported APF version: " + apfCapabilities.apfVersionSupported);
            return null;
        }
        return new ApfFilter(config, ifParams, ipClientCallback, new IpConnectivityLog());
    }

    public synchronized void shutdown() {
        if (this.mReceiveThread != null) {
            this.log("shutting down");
            this.mReceiveThread.halt();
            this.mReceiveThread = null;
        }
        this.mRas.clear();
    }

    public synchronized void setMulticastFilter(boolean isEnabled) {
        if (this.mMulticastFilter == isEnabled) {
            return;
        }
        this.mMulticastFilter = isEnabled;
        if (!isEnabled) {
            ++this.mNumProgramUpdatesAllowingMulticast;
        }
        this.installNewProgramLocked();
    }

    private static LinkAddress findIPv4LinkAddress(LinkProperties lp) {
        LinkAddress ipv4Address = null;
        for (LinkAddress address : lp.getLinkAddresses()) {
            if (!(address.getAddress() instanceof Inet4Address)) continue;
            if (ipv4Address != null && !ipv4Address.isSameAddressAs(address)) {
                return null;
            }
            ipv4Address = address;
        }
        return ipv4Address;
    }

    public synchronized void setLinkProperties(LinkProperties lp) {
        int prefix;
        LinkAddress ipv4Address = ApfFilter.findIPv4LinkAddress(lp);
        byte[] addr = ipv4Address != null ? ipv4Address.getAddress().getAddress() : null;
        int n = prefix = ipv4Address != null ? ipv4Address.getPrefixLength() : 0;
        if (prefix == this.mIPv4PrefixLength && Arrays.equals(addr, this.mIPv4Address)) {
            return;
        }
        this.mIPv4Address = addr;
        this.mIPv4PrefixLength = prefix;
        this.installNewProgramLocked();
    }

    public synchronized void dump(IndentingPrintWriter pw) {
        pw.println("Capabilities: " + this.mApfCapabilities);
        pw.println("Receive thread: " + (this.mReceiveThread != null ? "RUNNING" : "STOPPED"));
        pw.println("Multicast: " + (this.mMulticastFilter ? "DROP" : "ALLOW"));
        try {
            pw.println("IPv4 address: " + InetAddress.getByAddress(this.mIPv4Address).getHostAddress());
        }
        catch (NullPointerException | UnknownHostException exception) {
            // empty catch block
        }
        if (this.mLastTimeInstalledProgram == 0L) {
            pw.println("No program installed.");
            return;
        }
        pw.println("Program updates: " + this.mNumProgramUpdates);
        pw.println(String.format("Last program length %d, installed %ds ago, lifetime %ds", this.mLastInstalledProgram.length, this.currentTimeSeconds() - this.mLastTimeInstalledProgram, this.mLastInstalledProgramMinLifetime));
        pw.println("RA filters:");
        pw.increaseIndent();
        for (Ra ra : this.mRas) {
            pw.println(ra);
            pw.increaseIndent();
            pw.println(String.format("Seen: %d, last %ds ago", ra.seenCount, this.currentTimeSeconds() - ra.mLastSeen));
            pw.println("Last match:");
            pw.increaseIndent();
            pw.println(ra.getLastMatchingPacket());
            pw.decreaseIndent();
            pw.decreaseIndent();
        }
        pw.decreaseIndent();
        pw.println("Last program:");
        pw.increaseIndent();
        pw.println(HexDump.toHexString(this.mLastInstalledProgram, false));
        pw.decreaseIndent();
    }

    @VisibleForTesting
    public static int ipv4BroadcastAddress(byte[] addrBytes, int prefixLength) {
        return BitUtils.bytesToBEInt(addrBytes) | (int)(BitUtils.uint32(-1) >>> prefixLength);
    }

    @VisibleForTesting
    class Ra {
        private static final int ICMP6_RA_HEADER_LEN = 16;
        private static final int ICMP6_RA_CHECKSUM_OFFSET = 56;
        private static final int ICMP6_RA_CHECKSUM_LEN = 2;
        private static final int ICMP6_RA_OPTION_OFFSET = 70;
        private static final int ICMP6_RA_ROUTER_LIFETIME_OFFSET = 60;
        private static final int ICMP6_RA_ROUTER_LIFETIME_LEN = 2;
        private static final int ICMP6_PREFIX_OPTION_TYPE = 3;
        private static final int ICMP6_PREFIX_OPTION_LEN = 32;
        private static final int ICMP6_PREFIX_OPTION_VALID_LIFETIME_OFFSET = 4;
        private static final int ICMP6_PREFIX_OPTION_VALID_LIFETIME_LEN = 4;
        private static final int ICMP6_PREFIX_OPTION_PREFERRED_LIFETIME_OFFSET = 8;
        private static final int ICMP6_PREFIX_OPTION_PREFERRED_LIFETIME_LEN = 4;
        private static final int ICMP6_RDNSS_OPTION_TYPE = 25;
        private static final int ICMP6_DNSSL_OPTION_TYPE = 31;
        private static final int ICMP6_ROUTE_INFO_OPTION_TYPE = 24;
        private static final int ICMP6_4_BYTE_LIFETIME_OFFSET = 4;
        private static final int ICMP6_4_BYTE_LIFETIME_LEN = 4;
        private final ByteBuffer mPacket;
        private final ArrayList<Pair<Integer, Integer>> mNonLifetimes = new ArrayList();
        long mMinLifetime;
        long mLastSeen;
        private final ArrayList<Integer> mPrefixOptionOffsets = new ArrayList();
        private final ArrayList<Integer> mRdnssOptionOffsets = new ArrayList();
        int seenCount = 0;

        String getLastMatchingPacket() {
            return HexDump.toHexString(this.mPacket.array(), 0, this.mPacket.capacity(), false);
        }

        private String IPv6AddresstoString(int pos) {
            try {
                byte[] array2 = this.mPacket.array();
                if (pos < 0 || pos + 16 > array2.length || pos + 16 < pos) {
                    return "???";
                }
                byte[] addressBytes = Arrays.copyOfRange(array2, pos, pos + 16);
                Inet6Address address = (Inet6Address)InetAddress.getByAddress(addressBytes);
                return ((InetAddress)address).getHostAddress();
            }
            catch (UnsupportedOperationException e) {
                return "???";
            }
            catch (ClassCastException | UnknownHostException e) {
                return "???";
            }
        }

        private void prefixOptionToString(StringBuffer sb, int offset) {
            String prefix = this.IPv6AddresstoString(offset + 16);
            int length = BitUtils.getUint8(this.mPacket, offset + 2);
            long valid = BitUtils.getUint32(this.mPacket, offset + 4);
            long preferred = BitUtils.getUint32(this.mPacket, offset + 8);
            sb.append(String.format("%s/%d %ds/%ds ", prefix, length, valid, preferred));
        }

        private void rdnssOptionToString(StringBuffer sb, int offset) {
            int optLen = BitUtils.getUint8(this.mPacket, offset + 1) * 8;
            if (optLen < 24) {
                return;
            }
            long lifetime = BitUtils.getUint32(this.mPacket, offset + 4);
            int numServers = (optLen - 8) / 16;
            sb.append("DNS ").append(lifetime).append("s");
            for (int server = 0; server < numServers; ++server) {
                sb.append(" ").append(this.IPv6AddresstoString(offset + 8 + 16 * server));
            }
        }

        public String toString() {
            try {
                StringBuffer sb = new StringBuffer();
                sb.append(String.format("RA %s -> %s %ds ", this.IPv6AddresstoString(22), this.IPv6AddresstoString(38), BitUtils.getUint16(this.mPacket, 60)));
                for (int i : this.mPrefixOptionOffsets) {
                    this.prefixOptionToString(sb, i);
                }
                for (int i : this.mRdnssOptionOffsets) {
                    this.rdnssOptionToString(sb, i);
                }
                return sb.toString();
            }
            catch (IndexOutOfBoundsException | BufferUnderflowException e) {
                return "<Malformed RA>";
            }
        }

        private int addNonLifetime(int lastNonLifetimeStart, int lifetimeOffset, int lifetimeLength) {
            this.mNonLifetimes.add(new Pair<Integer, Integer>(lastNonLifetimeStart, (lifetimeOffset += this.mPacket.position()) - lastNonLifetimeStart));
            return lifetimeOffset + lifetimeLength;
        }

        private int addNonLifetimeU32(int lastNonLifetimeStart) {
            return this.addNonLifetime(lastNonLifetimeStart, 4, 4);
        }

        Ra(byte[] packet, int length) throws InvalidRaException {
            if (length < 70) {
                throw new InvalidRaException("Not an ICMP6 router advertisement");
            }
            this.mPacket = ByteBuffer.wrap(Arrays.copyOf(packet, length));
            this.mLastSeen = ApfFilter.this.currentTimeSeconds();
            if (BitUtils.getUint16(this.mPacket, 12) != OsConstants.ETH_P_IPV6 || BitUtils.getUint8(this.mPacket, 20) != OsConstants.IPPROTO_ICMPV6 || BitUtils.getUint8(this.mPacket, 54) != 134) {
                throw new InvalidRaException("Not an ICMP6 router advertisement");
            }
            RaEvent.Builder builder = new RaEvent.Builder();
            int lastNonLifetimeStart = this.addNonLifetime(0, 15, 3);
            lastNonLifetimeStart = this.addNonLifetime(lastNonLifetimeStart, 56, 2);
            lastNonLifetimeStart = this.addNonLifetime(lastNonLifetimeStart, 60, 2);
            builder.updateRouterLifetime(BitUtils.getUint16(this.mPacket, 60));
            this.mPacket.position(70);
            while (this.mPacket.hasRemaining()) {
                int position = this.mPacket.position();
                int optionType = BitUtils.getUint8(this.mPacket, position);
                int optionLength = BitUtils.getUint8(this.mPacket, position + 1) * 8;
                switch (optionType) {
                    case 3: {
                        lastNonLifetimeStart = this.addNonLifetime(lastNonLifetimeStart, 4, 4);
                        long lifetime = BitUtils.getUint32(this.mPacket, position + 4);
                        builder.updatePrefixValidLifetime(lifetime);
                        lastNonLifetimeStart = this.addNonLifetime(lastNonLifetimeStart, 8, 4);
                        lifetime = BitUtils.getUint32(this.mPacket, position + 8);
                        builder.updatePrefixPreferredLifetime(lifetime);
                        this.mPrefixOptionOffsets.add(position);
                        break;
                    }
                    case 25: {
                        this.mRdnssOptionOffsets.add(position);
                        lastNonLifetimeStart = this.addNonLifetimeU32(lastNonLifetimeStart);
                        long lifetime = BitUtils.getUint32(this.mPacket, position + 4);
                        builder.updateRdnssLifetime(lifetime);
                        break;
                    }
                    case 24: {
                        lastNonLifetimeStart = this.addNonLifetimeU32(lastNonLifetimeStart);
                        long lifetime = BitUtils.getUint32(this.mPacket, position + 4);
                        builder.updateRouteInfoLifetime(lifetime);
                        break;
                    }
                    case 31: {
                        lastNonLifetimeStart = this.addNonLifetimeU32(lastNonLifetimeStart);
                        long lifetime = BitUtils.getUint32(this.mPacket, position + 4);
                        builder.updateDnsslLifetime(lifetime);
                        break;
                    }
                }
                if (optionLength <= 0) {
                    throw new InvalidRaException(String.format("Invalid option length opt=%d len=%d", optionType, optionLength));
                }
                this.mPacket.position(position + optionLength);
            }
            this.addNonLifetime(lastNonLifetimeStart, 0, 0);
            this.mMinLifetime = this.minLifetime(packet, length);
            ApfFilter.this.mMetricsLog.log(builder.build());
        }

        boolean matches(byte[] packet, int length) {
            if (length != this.mPacket.capacity()) {
                return false;
            }
            byte[] referencePacket = this.mPacket.array();
            for (Pair<Integer, Integer> nonLifetime : this.mNonLifetimes) {
                for (int i = ((Integer)nonLifetime.first).intValue(); i < (Integer)nonLifetime.first + (Integer)nonLifetime.second; ++i) {
                    if (packet[i] == referencePacket[i]) continue;
                    return false;
                }
            }
            return true;
        }

        long minLifetime(byte[] packet, int length) {
            long minLifetime = Long.MAX_VALUE;
            ByteBuffer byteBuffer = ByteBuffer.wrap(packet);
            int i = 0;
            while (i + 1 < this.mNonLifetimes.size()) {
                int offset = (Integer)this.mNonLifetimes.get((int)i).first + (Integer)this.mNonLifetimes.get((int)i).second;
                if (offset != 15 && offset != 56) {
                    long optionLifetime;
                    int lifetimeLength = (Integer)this.mNonLifetimes.get((int)(i + 1)).first - offset;
                    switch (lifetimeLength) {
                        case 2: {
                            optionLifetime = BitUtils.getUint16(byteBuffer, offset);
                            break;
                        }
                        case 4: {
                            optionLifetime = BitUtils.getUint32(byteBuffer, offset);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("bogus lifetime size " + lifetimeLength);
                        }
                    }
                    minLifetime = Math.min(minLifetime, optionLifetime);
                }
                ++i;
            }
            return minLifetime;
        }

        long currentLifetime() {
            return this.mMinLifetime - (ApfFilter.this.currentTimeSeconds() - this.mLastSeen);
        }

        boolean isExpired() {
            return this.currentLifetime() <= 0L;
        }

        @GuardedBy(value="ApfFilter.this")
        long generateFilterLocked(ApfGenerator gen) throws ApfGenerator.IllegalInstructionException {
            String nextFilterLabel = "Ra" + ApfFilter.this.getUniqueNumberLocked();
            gen.addLoadFromMemory(ApfGenerator.Register.R0, 14);
            gen.addJumpIfR0NotEquals(this.mPacket.capacity(), nextFilterLabel);
            int filterLifetime = (int)(this.currentLifetime() / 6L);
            gen.addLoadFromMemory(ApfGenerator.Register.R0, 15);
            gen.addJumpIfR0GreaterThan(filterLifetime, nextFilterLabel);
            for (int i = 0; i < this.mNonLifetimes.size(); ++i) {
                Pair<Integer, Integer> nonLifetime = this.mNonLifetimes.get(i);
                if ((Integer)nonLifetime.second != 0) {
                    gen.addLoadImmediate(ApfGenerator.Register.R0, (Integer)nonLifetime.first);
                    gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, Arrays.copyOfRange(this.mPacket.array(), (int)((Integer)nonLifetime.first), (Integer)nonLifetime.first + (Integer)nonLifetime.second), nextFilterLabel);
                }
                if (i + 1 >= this.mNonLifetimes.size()) continue;
                Pair<Integer, Integer> nextNonLifetime = this.mNonLifetimes.get(i + 1);
                int offset = (Integer)nonLifetime.first + (Integer)nonLifetime.second;
                if (offset == 15 || offset == 56) continue;
                int length = (Integer)nextNonLifetime.first - offset;
                switch (length) {
                    case 4: {
                        gen.addLoad32(ApfGenerator.Register.R0, offset);
                        break;
                    }
                    case 2: {
                        gen.addLoad16(ApfGenerator.Register.R0, offset);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("bogus lifetime size " + length);
                    }
                }
                gen.addJumpIfR0LessThan(filterLifetime, nextFilterLabel);
            }
            gen.addJump("__DROP__");
            gen.defineLabel(nextFilterLabel);
            return filterLifetime;
        }
    }

    public static class InvalidRaException
    extends Exception {
        public InvalidRaException(String m) {
            super(m);
        }
    }

    @VisibleForTesting
    class ReceiveThread
    extends Thread {
        private final byte[] mPacket = new byte[1514];
        private final FileDescriptor mSocket;
        private final long mStart = SystemClock.elapsedRealtime();
        private final ApfStats mStats = new ApfStats();
        private volatile boolean mStopped;

        public ReceiveThread(FileDescriptor socket) {
            this.mSocket = socket;
        }

        public void halt() {
            this.mStopped = true;
            try {
                IoBridge.closeAndSignalBlockedThreads(this.mSocket);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            ApfFilter.this.log("begin monitoring");
            while (!this.mStopped) {
                try {
                    int length = Os.read(this.mSocket, this.mPacket, 0, this.mPacket.length);
                    this.updateStats(ApfFilter.this.processRa(this.mPacket, length));
                }
                catch (ErrnoException | IOException e) {
                    if (this.mStopped) continue;
                    Log.e(ApfFilter.TAG, "Read error", e);
                }
            }
            this.logStats();
        }

        private void updateStats(ProcessRaResult result) {
            ++this.mStats.receivedRas;
            switch (result) {
                case MATCH: {
                    ++this.mStats.matchingRas;
                    return;
                }
                case DROPPED: {
                    ++this.mStats.droppedRas;
                    return;
                }
                case PARSE_ERROR: {
                    ++this.mStats.parseErrors;
                    return;
                }
                case ZERO_LIFETIME: {
                    ++this.mStats.zeroLifetimeRas;
                    return;
                }
                case UPDATE_EXPIRY: {
                    ++this.mStats.matchingRas;
                    ++this.mStats.programUpdates;
                    return;
                }
                case UPDATE_NEW_RA: {
                    ++this.mStats.programUpdates;
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logStats() {
            long nowMs = SystemClock.elapsedRealtime();
            ReceiveThread receiveThread = this;
            synchronized (receiveThread) {
                this.mStats.durationMs = nowMs - this.mStart;
                this.mStats.maxProgramSize = ((ApfFilter)ApfFilter.this).mApfCapabilities.maximumApfProgramSize;
                this.mStats.programUpdatesAll = ApfFilter.this.mNumProgramUpdates;
                this.mStats.programUpdatesAllowingMulticast = ApfFilter.this.mNumProgramUpdatesAllowingMulticast;
                ApfFilter.this.mMetricsLog.log(this.mStats);
                ApfFilter.this.logApfProgramEventLocked(nowMs / 1000L);
            }
        }
    }

    private static enum ProcessRaResult {
        MATCH,
        DROPPED,
        PARSE_ERROR,
        ZERO_LIFETIME,
        UPDATE_NEW_RA,
        UPDATE_EXPIRY;

    }

    public static class ApfConfiguration {
        public ApfCapabilities apfCapabilities;
        public boolean multicastFilter;
        public boolean ieee802_3Filter;
        public int[] ethTypeBlackList;
    }
}

