/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.net.NetworkUtils;
import android.net.util.ConnectivityPacketSummary;
import android.net.util.InterfaceParams;
import android.net.util.PacketReader;
import android.os.Handler;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.PacketSocketAddress;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;
import libcore.util.HexEncoding;

public class ConnectivityPacketTracker {
    private static final String TAG = ConnectivityPacketTracker.class.getSimpleName();
    private static final boolean DBG = false;
    private static final String MARK_START = "--- START ---";
    private static final String MARK_STOP = "--- STOP ---";
    private static final String MARK_NAMED_START = "--- START (%s) ---";
    private static final String MARK_NAMED_STOP = "--- STOP (%s) ---";
    private final String mTag;
    private final LocalLog mLog;
    private final PacketReader mPacketListener;
    private boolean mRunning;
    private String mDisplayName;

    public ConnectivityPacketTracker(Handler h, InterfaceParams ifParams, LocalLog log) {
        if (ifParams == null) {
            throw new IllegalArgumentException("null InterfaceParams");
        }
        this.mTag = TAG + "." + ifParams.name;
        this.mLog = log;
        this.mPacketListener = new PacketListener(h, ifParams);
    }

    public void start(String displayName) {
        this.mRunning = true;
        this.mDisplayName = displayName;
        this.mPacketListener.start();
    }

    public void stop() {
        this.mPacketListener.stop();
        this.mRunning = false;
        this.mDisplayName = null;
    }

    private final class PacketListener
    extends PacketReader {
        private final InterfaceParams mInterface;

        PacketListener(Handler h, InterfaceParams ifParams) {
            super(h, ifParams.defaultMtu);
            this.mInterface = ifParams;
        }

        @Override
        protected FileDescriptor createFd() {
            FileDescriptor s = null;
            try {
                s = Os.socket(OsConstants.AF_PACKET, OsConstants.SOCK_RAW, 0);
                NetworkUtils.attachControlPacketFilter(s, OsConstants.ARPHRD_ETHER);
                Os.bind(s, new PacketSocketAddress((short)OsConstants.ETH_P_ALL, this.mInterface.index));
            }
            catch (ErrnoException | IOException e) {
                this.logError("Failed to create packet tracking socket: ", e);
                PacketListener.closeFd(s);
                return null;
            }
            return s;
        }

        @Override
        protected void handlePacket(byte[] recvbuf, int length) {
            String summary = ConnectivityPacketSummary.summarize(this.mInterface.macAddr, recvbuf, length);
            if (summary == null) {
                return;
            }
            this.addLogEntry(summary + "\n[" + new String(HexEncoding.encode(recvbuf, 0, length)) + "]");
        }

        @Override
        protected void onStart() {
            String msg = TextUtils.isEmpty(ConnectivityPacketTracker.this.mDisplayName) ? ConnectivityPacketTracker.MARK_START : String.format(ConnectivityPacketTracker.MARK_NAMED_START, ConnectivityPacketTracker.this.mDisplayName);
            ConnectivityPacketTracker.this.mLog.log(msg);
        }

        @Override
        protected void onStop() {
            String msg;
            String string2 = msg = TextUtils.isEmpty(ConnectivityPacketTracker.this.mDisplayName) ? ConnectivityPacketTracker.MARK_STOP : String.format(ConnectivityPacketTracker.MARK_NAMED_STOP, ConnectivityPacketTracker.this.mDisplayName);
            if (!ConnectivityPacketTracker.this.mRunning) {
                msg = msg + " (packet listener stopped unexpectedly)";
            }
            ConnectivityPacketTracker.this.mLog.log(msg);
        }

        @Override
        protected void logError(String msg, Exception e) {
            Log.e(ConnectivityPacketTracker.this.mTag, msg, e);
            this.addLogEntry(msg + e);
        }

        private void addLogEntry(String entry) {
            ConnectivityPacketTracker.this.mLog.log(entry);
        }
    }
}

