/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.content.Context;
import android.net.DhcpResults;
import android.net.INetd;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.ProxyInfo;
import android.net.RouteInfo;
import android.net.StaticIpConfiguration;
import android.net.apf.ApfCapabilities;
import android.net.apf.ApfFilter;
import android.net.dhcp.DhcpClient;
import android.net.ip.ConnectivityPacketTracker;
import android.net.ip.InterfaceController;
import android.net.ip.IpReachabilityMonitor;
import android.net.metrics.IpConnectivityLog;
import android.net.metrics.IpManagerEvent;
import android.net.util.InterfaceParams;
import android.net.util.MultinetworkPolicyTracker;
import android.net.util.NetdService;
import android.net.util.SharedLog;
import android.os.INetworkManagementService;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.IState;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.MessageUtils;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.android.internal.util.WakeupMessage;
import com.android.server.net.NetlinkTracker;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class IpClient
extends StateMachine {
    private static final boolean DBG = false;
    private static final Class[] sMessageClasses = new Class[]{IpClient.class, DhcpClient.class};
    private static final SparseArray<String> sWhatToString = MessageUtils.findMessageNames(sMessageClasses);
    public static final String DUMP_ARG = "ipclient";
    public static final String DUMP_ARG_CONFIRM = "confirm";
    private static final int CMD_TERMINATE_AFTER_STOP = 1;
    private static final int CMD_STOP = 2;
    private static final int CMD_START = 3;
    private static final int CMD_CONFIRM = 4;
    private static final int EVENT_PRE_DHCP_ACTION_COMPLETE = 5;
    private static final int EVENT_NETLINK_LINKPROPERTIES_CHANGED = 6;
    private static final int CMD_UPDATE_TCP_BUFFER_SIZES = 7;
    private static final int CMD_UPDATE_HTTP_PROXY = 8;
    private static final int CMD_SET_MULTICAST_FILTER = 9;
    private static final int EVENT_PROVISIONING_TIMEOUT = 10;
    private static final int EVENT_DHCPACTION_TIMEOUT = 11;
    private static final int MAX_LOG_RECORDS = 500;
    private static final int MAX_PACKET_RECORDS = 100;
    private static final boolean NO_CALLBACKS = false;
    private static final boolean SEND_CALLBACKS = true;
    private static final String CLAT_PREFIX = "v4-";
    private final State mStoppedState = new StoppedState();
    private final State mStoppingState = new StoppingState();
    private final State mStartedState = new StartedState();
    private final State mRunningState = new RunningState();
    private final String mTag;
    private final Context mContext;
    private final String mInterfaceName;
    private final String mClatInterfaceName;
    @VisibleForTesting
    protected final Callback mCallback;
    private final INetworkManagementService mNwService;
    private final NetlinkTracker mNetlinkTracker;
    private final WakeupMessage mProvisioningTimeoutAlarm;
    private final WakeupMessage mDhcpActionTimeoutAlarm;
    private final MultinetworkPolicyTracker mMultinetworkPolicyTracker;
    private final SharedLog mLog;
    private final LocalLog mConnectivityPacketLog;
    private final MessageHandlingLogger mMsgStateLogger;
    private final IpConnectivityLog mMetricsLog = new IpConnectivityLog();
    private final InterfaceController mInterfaceCtrl;
    private InterfaceParams mInterfaceParams;
    private LinkProperties mLinkProperties;
    private ProvisioningConfiguration mConfiguration;
    private IpReachabilityMonitor mIpReachabilityMonitor;
    private DhcpClient mDhcpClient;
    private DhcpResults mDhcpResults;
    private String mTcpBufferSizes;
    private ProxyInfo mHttpProxy;
    private ApfFilter mApfFilter;
    private boolean mMulticastFiltering;
    private long mStartTimeMillis;

    public IpClient(Context context, String ifName, Callback callback) {
        this(context, ifName, callback, INetworkManagementService.Stub.asInterface(ServiceManager.getService("network_management")), NetdService.getInstance());
    }

    public IpClient(Context context, String ifName, Callback callback, INetworkManagementService nwService) {
        this(context, ifName, callback, nwService, NetdService.getInstance());
    }

    @VisibleForTesting
    IpClient(Context context, String ifName, Callback callback, INetworkManagementService nwService, INetd netd) {
        super(IpClient.class.getSimpleName() + "." + ifName);
        this.mTag = this.getName();
        this.mContext = context;
        this.mInterfaceName = ifName;
        this.mClatInterfaceName = CLAT_PREFIX + ifName;
        this.mCallback = new LoggingCallbackWrapper(callback);
        this.mNwService = nwService;
        this.mLog = new SharedLog(500, this.mTag);
        this.mConnectivityPacketLog = new LocalLog(100);
        this.mMsgStateLogger = new MessageHandlingLogger();
        this.mInterfaceCtrl = new InterfaceController(this.mInterfaceName, this.mNwService, netd, this.mLog);
        this.mNetlinkTracker = new NetlinkTracker(this.mInterfaceName, new NetlinkTracker.Callback(){

            @Override
            public void update() {
                IpClient.this.sendMessage(6);
            }
        }){

            @Override
            public void interfaceAdded(String iface) {
                super.interfaceAdded(iface);
                if (IpClient.this.mClatInterfaceName.equals(iface)) {
                    IpClient.this.mCallback.setNeighborDiscoveryOffload(false);
                } else if (!IpClient.this.mInterfaceName.equals(iface)) {
                    return;
                }
                String msg = "interfaceAdded(" + iface + ")";
                this.logMsg(msg);
            }

            @Override
            public void interfaceRemoved(String iface) {
                super.interfaceRemoved(iface);
                if (IpClient.this.mClatInterfaceName.equals(iface)) {
                    IpClient.this.mCallback.setNeighborDiscoveryOffload(true);
                } else if (!IpClient.this.mInterfaceName.equals(iface)) {
                    return;
                }
                String msg = "interfaceRemoved(" + iface + ")";
                this.logMsg(msg);
            }

            private void logMsg(String msg) {
                Log.d(IpClient.this.mTag, msg);
                IpClient.this.getHandler().post(() -> IpClient.this.mLog.log("OBSERVED " + msg));
            }
        };
        this.mLinkProperties = new LinkProperties();
        this.mLinkProperties.setInterfaceName(this.mInterfaceName);
        this.mMultinetworkPolicyTracker = new MultinetworkPolicyTracker(this.mContext, this.getHandler(), () -> this.mLog.log("OBSERVED AvoidBadWifi changed"));
        this.mProvisioningTimeoutAlarm = new WakeupMessage(this.mContext, this.getHandler(), this.mTag + ".EVENT_PROVISIONING_TIMEOUT", 10);
        this.mDhcpActionTimeoutAlarm = new WakeupMessage(this.mContext, this.getHandler(), this.mTag + ".EVENT_DHCPACTION_TIMEOUT", 11);
        this.configureAndStartStateMachine();
        this.startStateMachineUpdaters();
    }

    private void configureAndStartStateMachine() {
        this.addState(this.mStoppedState);
        this.addState(this.mStartedState);
        this.addState(this.mRunningState, this.mStartedState);
        this.addState(this.mStoppingState);
        this.setInitialState(this.mStoppedState);
        super.start();
    }

    private void startStateMachineUpdaters() {
        try {
            this.mNwService.registerObserver(this.mNetlinkTracker);
        }
        catch (RemoteException e) {
            this.logError("Couldn't register NetlinkTracker: %s", e);
        }
        this.mMultinetworkPolicyTracker.start();
    }

    private void stopStateMachineUpdaters() {
        try {
            this.mNwService.unregisterObserver(this.mNetlinkTracker);
        }
        catch (RemoteException e) {
            this.logError("Couldn't unregister NetlinkTracker: %s", e);
        }
        this.mMultinetworkPolicyTracker.shutdown();
    }

    @Override
    protected void onQuitting() {
        this.mCallback.onQuit();
    }

    public void shutdown() {
        this.stop();
        this.sendMessage(1);
    }

    public static ProvisioningConfiguration.Builder buildProvisioningConfiguration() {
        return new ProvisioningConfiguration.Builder();
    }

    public void startProvisioning(ProvisioningConfiguration req) {
        if (!req.isValid()) {
            this.doImmediateProvisioningFailure(7);
            return;
        }
        this.mInterfaceParams = InterfaceParams.getByName(this.mInterfaceName);
        if (this.mInterfaceParams == null) {
            this.logError("Failed to find InterfaceParams for " + this.mInterfaceName, new Object[0]);
        }
        this.mCallback.setNeighborDiscoveryOffload(true);
        this.sendMessage(3, new ProvisioningConfiguration(req));
    }

    public void startProvisioning(StaticIpConfiguration staticIpConfig) {
        this.startProvisioning(IpClient.buildProvisioningConfiguration().withStaticConfiguration(staticIpConfig).build());
    }

    public void startProvisioning() {
        this.startProvisioning(new ProvisioningConfiguration());
    }

    public void stop() {
        this.sendMessage(2);
    }

    public void confirmConfiguration() {
        this.sendMessage(4);
    }

    public void completedPreDhcpAction() {
        this.sendMessage(5);
    }

    public void setTcpBufferSizes(String tcpBufferSizes) {
        this.sendMessage(7, tcpBufferSizes);
    }

    public void setHttpProxy(ProxyInfo proxyInfo) {
        this.sendMessage(8, proxyInfo);
    }

    public void setMulticastFilter(boolean enabled) {
        this.sendMessage(9, enabled);
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        if (args != null && args.length > 0 && DUMP_ARG_CONFIRM.equals(args[0])) {
            this.confirmConfiguration();
            return;
        }
        ApfFilter apfFilter = this.mApfFilter;
        ProvisioningConfiguration provisioningConfig = this.mConfiguration;
        ApfCapabilities apfCapabilities = provisioningConfig != null ? provisioningConfig.mApfCapabilities : null;
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        pw.println(this.mTag + " APF dump:");
        pw.increaseIndent();
        if (apfFilter != null) {
            apfFilter.dump(pw);
        } else {
            pw.print("No active ApfFilter; ");
            if (provisioningConfig == null) {
                pw.println("IpClient not yet started.");
            } else if (apfCapabilities == null || apfCapabilities.apfVersionSupported == 0) {
                pw.println("Hardware does not support APF.");
            } else {
                pw.println("ApfFilter not yet started, APF capabilities: " + apfCapabilities);
            }
        }
        pw.decreaseIndent();
        pw.println();
        pw.println(this.mTag + " current ProvisioningConfiguration:");
        pw.increaseIndent();
        pw.println(Objects.toString(provisioningConfig, "N/A"));
        pw.decreaseIndent();
        IpReachabilityMonitor iprm = this.mIpReachabilityMonitor;
        if (iprm != null) {
            pw.println();
            pw.println(this.mTag + " current IpReachabilityMonitor state:");
            pw.increaseIndent();
            iprm.dump(pw);
            pw.decreaseIndent();
        }
        pw.println();
        pw.println(this.mTag + " StateMachine dump:");
        pw.increaseIndent();
        this.mLog.dump(fd, pw, args);
        pw.decreaseIndent();
        pw.println();
        pw.println(this.mTag + " connectivity packet log:");
        pw.println();
        pw.println("Debug with python and scapy via:");
        pw.println("shell$ python");
        pw.println(">>> from scapy import all as scapy");
        pw.println(">>> scapy.Ether(\"<paste_hex_string>\".decode(\"hex\")).show2()");
        pw.println();
        pw.increaseIndent();
        this.mConnectivityPacketLog.readOnlyLocalLog().dump(fd, pw, args);
        pw.decreaseIndent();
    }

    @Override
    protected String getWhatToString(int what) {
        return sWhatToString.get(what, "UNKNOWN: " + Integer.toString(what));
    }

    @Override
    protected String getLogRecString(Message msg) {
        String logLine = String.format("%s/%d %d %d %s [%s]", this.mInterfaceName, this.mInterfaceParams == null ? -1 : this.mInterfaceParams.index, msg.arg1, msg.arg2, Objects.toString(msg.obj), this.mMsgStateLogger);
        String richerLogLine = this.getWhatToString(msg.what) + " " + logLine;
        this.mLog.log(richerLogLine);
        this.mMsgStateLogger.reset();
        return logLine;
    }

    @Override
    protected boolean recordLogRec(Message msg) {
        boolean shouldLog;
        boolean bl = shouldLog = msg.what != 6;
        if (!shouldLog) {
            this.mMsgStateLogger.reset();
        }
        return shouldLog;
    }

    private void logError(String fmt, Object ... args) {
        String msg = "ERROR " + String.format(fmt, args);
        Log.e(this.mTag, msg);
        this.mLog.log(msg);
    }

    private void resetLinkProperties() {
        this.mNetlinkTracker.clearLinkProperties();
        this.mConfiguration = null;
        this.mDhcpResults = null;
        this.mTcpBufferSizes = "";
        this.mHttpProxy = null;
        this.mLinkProperties = new LinkProperties();
        this.mLinkProperties.setInterfaceName(this.mInterfaceName);
    }

    private void recordMetric(int type) {
        if (this.mStartTimeMillis <= 0L) {
            Log.wtf(this.mTag, "Start time undefined!");
        }
        long duration = SystemClock.elapsedRealtime() - this.mStartTimeMillis;
        this.mMetricsLog.log(this.mInterfaceName, (Parcelable)new IpManagerEvent(type, duration));
    }

    @VisibleForTesting
    static boolean isProvisioned(LinkProperties lp, InitialConfiguration config) {
        if (lp.hasIPv4Address() || lp.isProvisioned()) {
            return true;
        }
        if (config == null) {
            return false;
        }
        return config.isProvisionedBy(lp.getLinkAddresses(), lp.getRoutes());
    }

    private LinkProperties.ProvisioningChange compareProvisioning(LinkProperties oldLp, LinkProperties newLp) {
        boolean ignoreIPv6ProvisioningLoss;
        InitialConfiguration config = this.mConfiguration != null ? this.mConfiguration.mInitialConfig : null;
        boolean wasProvisioned = IpClient.isProvisioned(oldLp, config);
        boolean isProvisioned = IpClient.isProvisioned(newLp, config);
        LinkProperties.ProvisioningChange delta = !wasProvisioned && isProvisioned ? LinkProperties.ProvisioningChange.GAINED_PROVISIONING : (wasProvisioned && isProvisioned ? LinkProperties.ProvisioningChange.STILL_PROVISIONED : (!wasProvisioned && !isProvisioned ? LinkProperties.ProvisioningChange.STILL_NOT_PROVISIONED : LinkProperties.ProvisioningChange.LOST_PROVISIONING));
        boolean lostIPv6 = oldLp.isIPv6Provisioned() && !newLp.isIPv6Provisioned();
        boolean lostIPv4Address = oldLp.hasIPv4Address() && !newLp.hasIPv4Address();
        boolean lostIPv6Router = oldLp.hasIPv6DefaultRoute() && !newLp.hasIPv6DefaultRoute();
        boolean bl = ignoreIPv6ProvisioningLoss = !this.mMultinetworkPolicyTracker.getAvoidBadWifi();
        if (lostIPv4Address || lostIPv6 && !ignoreIPv6ProvisioningLoss) {
            delta = LinkProperties.ProvisioningChange.LOST_PROVISIONING;
        }
        if (oldLp.hasGlobalIPv6Address() && lostIPv6Router && !ignoreIPv6ProvisioningLoss) {
            delta = LinkProperties.ProvisioningChange.LOST_PROVISIONING;
        }
        return delta;
    }

    private void dispatchCallback(LinkProperties.ProvisioningChange delta, LinkProperties newLp) {
        switch (delta) {
            case GAINED_PROVISIONING: {
                this.recordMetric(1);
                this.mCallback.onProvisioningSuccess(newLp);
                break;
            }
            case LOST_PROVISIONING: {
                this.recordMetric(2);
                this.mCallback.onProvisioningFailure(newLp);
                break;
            }
            default: {
                this.mCallback.onLinkPropertiesChange(newLp);
            }
        }
    }

    private LinkProperties.ProvisioningChange setLinkProperties(LinkProperties newLp) {
        if (this.mApfFilter != null) {
            this.mApfFilter.setLinkProperties(newLp);
        }
        if (this.mIpReachabilityMonitor != null) {
            this.mIpReachabilityMonitor.updateLinkProperties(newLp);
        }
        LinkProperties.ProvisioningChange delta = this.compareProvisioning(this.mLinkProperties, newLp);
        this.mLinkProperties = new LinkProperties(newLp);
        if (delta == LinkProperties.ProvisioningChange.GAINED_PROVISIONING) {
            this.mProvisioningTimeoutAlarm.cancel();
        }
        return delta;
    }

    private LinkProperties assembleLinkProperties() {
        LinkProperties newLp = new LinkProperties();
        newLp.setInterfaceName(this.mInterfaceName);
        LinkProperties netlinkLinkProperties = this.mNetlinkTracker.getLinkProperties();
        newLp.setLinkAddresses(netlinkLinkProperties.getLinkAddresses());
        for (RouteInfo route : netlinkLinkProperties.getRoutes()) {
            newLp.addRoute(route);
        }
        IpClient.addAllReachableDnsServers(newLp, netlinkLinkProperties.getDnsServers());
        if (this.mDhcpResults != null) {
            for (RouteInfo route : this.mDhcpResults.getRoutes(this.mInterfaceName)) {
                newLp.addRoute(route);
            }
            IpClient.addAllReachableDnsServers(newLp, this.mDhcpResults.dnsServers);
            newLp.setDomains(this.mDhcpResults.domains);
            if (this.mDhcpResults.mtu != 0) {
                newLp.setMtu(this.mDhcpResults.mtu);
            }
        }
        if (!TextUtils.isEmpty(this.mTcpBufferSizes)) {
            newLp.setTcpBufferSizes(this.mTcpBufferSizes);
        }
        if (this.mHttpProxy != null) {
            newLp.setHttpProxy(this.mHttpProxy);
        }
        if (this.mConfiguration != null && this.mConfiguration.mInitialConfig != null) {
            InitialConfiguration config = this.mConfiguration.mInitialConfig;
            if (config.isProvisionedBy(newLp.getLinkAddresses(), null)) {
                for (IpPrefix prefix : config.directlyConnectedRoutes) {
                    newLp.addRoute(new RouteInfo(prefix, null, this.mInterfaceName));
                }
            }
            IpClient.addAllReachableDnsServers(newLp, config.dnsServers);
        }
        LinkProperties oldLp = this.mLinkProperties;
        return newLp;
    }

    private static void addAllReachableDnsServers(LinkProperties lp, Iterable<InetAddress> dnses) {
        for (InetAddress dns : dnses) {
            if (dns.isAnyLocalAddress() || !lp.isReachable(dns)) continue;
            lp.addDnsServer(dns);
        }
    }

    private boolean handleLinkPropertiesUpdate(boolean sendCallbacks) {
        LinkProperties newLp = this.assembleLinkProperties();
        if (Objects.equals(newLp, this.mLinkProperties)) {
            return true;
        }
        LinkProperties.ProvisioningChange delta = this.setLinkProperties(newLp);
        if (sendCallbacks) {
            this.dispatchCallback(delta, newLp);
        }
        return delta != LinkProperties.ProvisioningChange.LOST_PROVISIONING;
    }

    private void handleIPv4Success(DhcpResults dhcpResults) {
        this.mDhcpResults = new DhcpResults(dhcpResults);
        LinkProperties newLp = this.assembleLinkProperties();
        LinkProperties.ProvisioningChange delta = this.setLinkProperties(newLp);
        this.mCallback.onNewDhcpResults(dhcpResults);
        this.dispatchCallback(delta, newLp);
    }

    private void handleIPv4Failure() {
        this.mInterfaceCtrl.clearIPv4Address();
        this.mDhcpResults = null;
        this.mCallback.onNewDhcpResults(null);
        this.handleProvisioningFailure();
    }

    private void handleProvisioningFailure() {
        LinkProperties newLp = this.assembleLinkProperties();
        LinkProperties.ProvisioningChange delta = this.setLinkProperties(newLp);
        if (delta == LinkProperties.ProvisioningChange.STILL_NOT_PROVISIONED) {
            delta = LinkProperties.ProvisioningChange.LOST_PROVISIONING;
        }
        this.dispatchCallback(delta, newLp);
        if (delta == LinkProperties.ProvisioningChange.LOST_PROVISIONING) {
            this.transitionTo(this.mStoppingState);
        }
    }

    private void doImmediateProvisioningFailure(int failureType) {
        this.logError("onProvisioningFailure(): %s", failureType);
        this.recordMetric(failureType);
        this.mCallback.onProvisioningFailure(new LinkProperties(this.mLinkProperties));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean startIPv4() {
        if (this.mConfiguration.mStaticIpConfig != null) {
            if (!this.mInterfaceCtrl.setIPv4Address(this.mConfiguration.mStaticIpConfig.ipAddress)) return false;
            this.handleIPv4Success(new DhcpResults(this.mConfiguration.mStaticIpConfig));
            return true;
        } else {
            this.mDhcpClient = DhcpClient.makeDhcpClient(this.mContext, this, this.mInterfaceParams);
            this.mDhcpClient.registerForPreDhcpNotification();
            this.mDhcpClient.sendMessage(196609);
        }
        return true;
    }

    private boolean startIPv6() {
        return this.mInterfaceCtrl.setIPv6PrivacyExtensions(true) && this.mInterfaceCtrl.setIPv6AddrGenModeIfSupported(this.mConfiguration.mIPv6AddrGenMode) && this.mInterfaceCtrl.enableIPv6();
    }

    private boolean applyInitialConfig(InitialConfiguration config) {
        for (LinkAddress addr : IpClient.findAll(config.ipAddresses, LinkAddress::isIPv6)) {
            if (this.mInterfaceCtrl.addAddress(addr)) continue;
            return false;
        }
        return true;
    }

    private boolean startIpReachabilityMonitor() {
        try {
            this.mIpReachabilityMonitor = new IpReachabilityMonitor(this.mContext, this.mInterfaceParams, this.getHandler(), this.mLog, new IpReachabilityMonitor.Callback(){

                @Override
                public void notifyLost(InetAddress ip, String logMsg) {
                    IpClient.this.mCallback.onReachabilityLost(logMsg);
                }
            }, this.mMultinetworkPolicyTracker);
        }
        catch (IllegalArgumentException iae) {
            this.logError("IpReachabilityMonitor failure: %s", iae);
            this.mIpReachabilityMonitor = null;
        }
        return this.mIpReachabilityMonitor != null;
    }

    private void stopAllIP() {
        this.mInterfaceCtrl.disableIPv6();
        this.mInterfaceCtrl.clearAllAddresses();
    }

    static <T> boolean any(Iterable<T> coll, Predicate<T> fn) {
        for (T t : coll) {
            if (!fn.test(t)) continue;
            return true;
        }
        return false;
    }

    static <T> boolean all(Iterable<T> coll, Predicate<T> fn) {
        return !IpClient.any(coll, IpClient.not(fn));
    }

    static <T> Predicate<T> not(Predicate<T> fn) {
        return t -> !fn.test(t);
    }

    static <T> String join(String delimiter, Collection<T> coll) {
        return coll.stream().map(Object::toString).collect(Collectors.joining(delimiter));
    }

    static <T> T find(Iterable<T> coll, Predicate<T> fn) {
        for (T t : coll) {
            if (!fn.test(t)) continue;
            return t;
        }
        return null;
    }

    static <T> List<T> findAll(Collection<T> coll, Predicate<T> fn) {
        return coll.stream().filter(fn).collect(Collectors.toList());
    }

    private static class MessageHandlingLogger {
        public String processedInState;
        public String receivedInState;

        private MessageHandlingLogger() {
        }

        public void reset() {
            this.processedInState = null;
            this.receivedInState = null;
        }

        public void handled(State processedIn, IState receivedIn) {
            this.processedInState = processedIn.getClass().getSimpleName();
            this.receivedInState = receivedIn.getName();
        }

        public String toString() {
            return String.format("rcvd_in=%s, proc_in=%s", this.receivedInState, this.processedInState);
        }
    }

    class RunningState
    extends State {
        private ConnectivityPacketTracker mPacketTracker;
        private boolean mDhcpActionInFlight;

        RunningState() {
        }

        @Override
        public void enter() {
            ApfFilter.ApfConfiguration apfConfig = new ApfFilter.ApfConfiguration();
            apfConfig.apfCapabilities = ((IpClient)IpClient.this).mConfiguration.mApfCapabilities;
            apfConfig.multicastFilter = IpClient.this.mMulticastFiltering;
            apfConfig.ieee802_3Filter = IpClient.this.mContext.getResources().getBoolean(17956889);
            apfConfig.ethTypeBlackList = IpClient.this.mContext.getResources().getIntArray(17235979);
            IpClient.this.mApfFilter = ApfFilter.maybeCreate(apfConfig, IpClient.this.mInterfaceParams, IpClient.this.mCallback);
            if (IpClient.this.mApfFilter == null) {
                IpClient.this.mCallback.setFallbackMulticastFilter(IpClient.this.mMulticastFiltering);
            }
            this.mPacketTracker = this.createPacketTracker();
            if (this.mPacketTracker != null) {
                this.mPacketTracker.start(((IpClient)IpClient.this).mConfiguration.mDisplayName);
            }
            if (((IpClient)IpClient.this).mConfiguration.mEnableIPv6 && !IpClient.this.startIPv6()) {
                IpClient.this.doImmediateProvisioningFailure(5);
                IpClient.this.transitionTo(IpClient.this.mStoppingState);
                return;
            }
            if (((IpClient)IpClient.this).mConfiguration.mEnableIPv4 && !IpClient.this.startIPv4()) {
                IpClient.this.doImmediateProvisioningFailure(4);
                IpClient.this.transitionTo(IpClient.this.mStoppingState);
                return;
            }
            InitialConfiguration config = ((IpClient)IpClient.this).mConfiguration.mInitialConfig;
            if (config != null && !IpClient.this.applyInitialConfig(config)) {
                IpClient.this.doImmediateProvisioningFailure(7);
                IpClient.this.transitionTo(IpClient.this.mStoppingState);
                return;
            }
            if (((IpClient)IpClient.this).mConfiguration.mUsingIpReachabilityMonitor && !IpClient.this.startIpReachabilityMonitor()) {
                IpClient.this.doImmediateProvisioningFailure(6);
                IpClient.this.transitionTo(IpClient.this.mStoppingState);
                return;
            }
        }

        @Override
        public void exit() {
            this.stopDhcpAction();
            if (IpClient.this.mIpReachabilityMonitor != null) {
                IpClient.this.mIpReachabilityMonitor.stop();
                IpClient.this.mIpReachabilityMonitor = null;
            }
            if (IpClient.this.mDhcpClient != null) {
                IpClient.this.mDhcpClient.sendMessage(196610);
                IpClient.this.mDhcpClient.doQuit();
            }
            if (this.mPacketTracker != null) {
                this.mPacketTracker.stop();
                this.mPacketTracker = null;
            }
            if (IpClient.this.mApfFilter != null) {
                IpClient.this.mApfFilter.shutdown();
                IpClient.this.mApfFilter = null;
            }
            IpClient.this.resetLinkProperties();
        }

        private ConnectivityPacketTracker createPacketTracker() {
            try {
                return new ConnectivityPacketTracker(IpClient.this.getHandler(), IpClient.this.mInterfaceParams, IpClient.this.mConnectivityPacketLog);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        private void ensureDhcpAction() {
            if (!this.mDhcpActionInFlight) {
                IpClient.this.mCallback.onPreDhcpAction();
                this.mDhcpActionInFlight = true;
                long alarmTime = SystemClock.elapsedRealtime() + (long)((IpClient)IpClient.this).mConfiguration.mRequestedPreDhcpActionMs;
                IpClient.this.mDhcpActionTimeoutAlarm.schedule(alarmTime);
            }
        }

        private void stopDhcpAction() {
            IpClient.this.mDhcpActionTimeoutAlarm.cancel();
            if (this.mDhcpActionInFlight) {
                IpClient.this.mCallback.onPostDhcpAction();
                this.mDhcpActionInFlight = false;
            }
        }

        @Override
        public boolean processMessage(Message msg) {
            block0 : switch (msg.what) {
                case 2: {
                    IpClient.this.transitionTo(IpClient.this.mStoppingState);
                    break;
                }
                case 3: {
                    IpClient.this.logError("ALERT: START received in StartedState. Please fix caller.", new Object[0]);
                    break;
                }
                case 4: {
                    if (IpClient.this.mIpReachabilityMonitor == null) break;
                    IpClient.this.mIpReachabilityMonitor.probeAll();
                    break;
                }
                case 5: {
                    if (IpClient.this.mDhcpClient == null) break;
                    IpClient.this.mDhcpClient.sendMessage(196614);
                    break;
                }
                case 6: {
                    if (IpClient.this.handleLinkPropertiesUpdate(true)) break;
                    IpClient.this.transitionTo(IpClient.this.mStoppingState);
                    break;
                }
                case 7: {
                    IpClient.this.mTcpBufferSizes = (String)msg.obj;
                    IpClient.this.handleLinkPropertiesUpdate(true);
                    break;
                }
                case 8: {
                    IpClient.this.mHttpProxy = (ProxyInfo)msg.obj;
                    IpClient.this.handleLinkPropertiesUpdate(true);
                    break;
                }
                case 9: {
                    IpClient.this.mMulticastFiltering = (Boolean)msg.obj;
                    if (IpClient.this.mApfFilter != null) {
                        IpClient.this.mApfFilter.setMulticastFilter(IpClient.this.mMulticastFiltering);
                        break;
                    }
                    IpClient.this.mCallback.setFallbackMulticastFilter(IpClient.this.mMulticastFiltering);
                    break;
                }
                case 11: {
                    this.stopDhcpAction();
                    break;
                }
                case 196611: {
                    if (((IpClient)IpClient.this).mConfiguration.mRequestedPreDhcpActionMs > 0) {
                        this.ensureDhcpAction();
                        break;
                    }
                    IpClient.this.sendMessage(5);
                    break;
                }
                case 196615: {
                    IpClient.this.mInterfaceCtrl.clearIPv4Address();
                    break;
                }
                case 196616: {
                    LinkAddress ipAddress = (LinkAddress)msg.obj;
                    if (IpClient.this.mInterfaceCtrl.setIPv4Address(ipAddress)) {
                        IpClient.this.mDhcpClient.sendMessage(196617);
                        break;
                    }
                    IpClient.this.logError("Failed to set IPv4 address.", new Object[0]);
                    IpClient.this.dispatchCallback(LinkProperties.ProvisioningChange.LOST_PROVISIONING, new LinkProperties(IpClient.this.mLinkProperties));
                    IpClient.this.transitionTo(IpClient.this.mStoppingState);
                    break;
                }
                case 196612: {
                    this.stopDhcpAction();
                    switch (msg.arg1) {
                        case 1: {
                            IpClient.this.handleIPv4Success((DhcpResults)msg.obj);
                            break block0;
                        }
                        case 2: {
                            IpClient.this.handleIPv4Failure();
                            break block0;
                        }
                    }
                    IpClient.this.logError("Unknown CMD_POST_DHCP_ACTION status: %s", new Object[]{msg.arg1});
                    break;
                }
                case 196613: {
                    IpClient.this.logError("Unexpected CMD_ON_QUIT.", new Object[0]);
                    IpClient.this.mDhcpClient = null;
                    break;
                }
                default: {
                    return false;
                }
            }
            IpClient.this.mMsgStateLogger.handled(this, IpClient.this.getCurrentState());
            return true;
        }
    }

    class StartedState
    extends State {
        StartedState() {
        }

        @Override
        public void enter() {
            IpClient.this.mStartTimeMillis = SystemClock.elapsedRealtime();
            if (((IpClient)IpClient.this).mConfiguration.mProvisioningTimeoutMs > 0) {
                long alarmTime = SystemClock.elapsedRealtime() + (long)((IpClient)IpClient.this).mConfiguration.mProvisioningTimeoutMs;
                IpClient.this.mProvisioningTimeoutAlarm.schedule(alarmTime);
            }
            if (this.readyToProceed()) {
                IpClient.this.transitionTo(IpClient.this.mRunningState);
            } else {
                IpClient.this.stopAllIP();
            }
        }

        @Override
        public void exit() {
            IpClient.this.mProvisioningTimeoutAlarm.cancel();
        }

        @Override
        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    IpClient.this.transitionTo(IpClient.this.mStoppingState);
                    break;
                }
                case 6: {
                    IpClient.this.handleLinkPropertiesUpdate(false);
                    if (!this.readyToProceed()) break;
                    IpClient.this.transitionTo(IpClient.this.mRunningState);
                    break;
                }
                case 10: {
                    IpClient.this.handleProvisioningFailure();
                    break;
                }
                default: {
                    IpClient.this.deferMessage(msg);
                }
            }
            IpClient.this.mMsgStateLogger.handled(this, IpClient.this.getCurrentState());
            return true;
        }

        boolean readyToProceed() {
            return !IpClient.this.mLinkProperties.hasIPv4Address() && !IpClient.this.mLinkProperties.hasGlobalIPv6Address();
        }
    }

    class StoppingState
    extends State {
        StoppingState() {
        }

        @Override
        public void enter() {
            if (IpClient.this.mDhcpClient == null) {
                IpClient.this.transitionTo(IpClient.this.mStoppedState);
            }
        }

        @Override
        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    break;
                }
                case 196615: {
                    IpClient.this.mInterfaceCtrl.clearIPv4Address();
                    break;
                }
                case 196613: {
                    IpClient.this.mDhcpClient = null;
                    IpClient.this.transitionTo(IpClient.this.mStoppedState);
                    break;
                }
                default: {
                    IpClient.this.deferMessage(msg);
                }
            }
            IpClient.this.mMsgStateLogger.handled(this, IpClient.this.getCurrentState());
            return true;
        }
    }

    class StoppedState
    extends State {
        StoppedState() {
        }

        @Override
        public void enter() {
            IpClient.this.stopAllIP();
            IpClient.this.resetLinkProperties();
            if (IpClient.this.mStartTimeMillis > 0L) {
                IpClient.this.recordMetric(3);
                IpClient.this.mStartTimeMillis = 0L;
            }
        }

        @Override
        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    IpClient.this.stopStateMachineUpdaters();
                    IpClient.this.quit();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    IpClient.this.mConfiguration = (ProvisioningConfiguration)msg.obj;
                    IpClient.this.transitionTo(IpClient.this.mStartedState);
                    break;
                }
                case 6: {
                    IpClient.this.handleLinkPropertiesUpdate(false);
                    break;
                }
                case 7: {
                    IpClient.this.mTcpBufferSizes = (String)msg.obj;
                    IpClient.this.handleLinkPropertiesUpdate(false);
                    break;
                }
                case 8: {
                    IpClient.this.mHttpProxy = (ProxyInfo)msg.obj;
                    IpClient.this.handleLinkPropertiesUpdate(false);
                    break;
                }
                case 9: {
                    IpClient.this.mMulticastFiltering = (Boolean)msg.obj;
                    break;
                }
                case 196613: {
                    IpClient.this.logError("Unexpected CMD_ON_QUIT (already stopped).", new Object[0]);
                    break;
                }
                default: {
                    return false;
                }
            }
            IpClient.this.mMsgStateLogger.handled(this, IpClient.this.getCurrentState());
            return true;
        }
    }

    public static class InitialConfiguration {
        public final Set<LinkAddress> ipAddresses = new HashSet<LinkAddress>();
        public final Set<IpPrefix> directlyConnectedRoutes = new HashSet<IpPrefix>();
        public final Set<InetAddress> dnsServers = new HashSet<InetAddress>();
        public Inet4Address gateway;

        public static InitialConfiguration copy(InitialConfiguration config) {
            if (config == null) {
                return null;
            }
            InitialConfiguration configCopy = new InitialConfiguration();
            configCopy.ipAddresses.addAll(config.ipAddresses);
            configCopy.directlyConnectedRoutes.addAll(config.directlyConnectedRoutes);
            configCopy.dnsServers.addAll(config.dnsServers);
            return configCopy;
        }

        public String toString() {
            return String.format("InitialConfiguration(IPs: {%s}, prefixes: {%s}, DNS: {%s}, v4 gateway: %s)", IpClient.join(", ", this.ipAddresses), IpClient.join(", ", this.directlyConnectedRoutes), IpClient.join(", ", this.dnsServers), this.gateway);
        }

        public boolean isValid() {
            if (this.ipAddresses.isEmpty()) {
                return false;
            }
            for (LinkAddress linkAddress : this.ipAddresses) {
                if (IpClient.any(this.directlyConnectedRoutes, p -> p.contains(linkAddress.getAddress()))) continue;
                return false;
            }
            for (InetAddress inetAddress : this.dnsServers) {
                if (IpClient.any(this.directlyConnectedRoutes, p -> p.contains(inetAddress))) continue;
                return false;
            }
            if (IpClient.any(this.ipAddresses, IpClient.not(InitialConfiguration::isPrefixLengthCompliant))) {
                return false;
            }
            if (IpClient.any(this.directlyConnectedRoutes, InitialConfiguration::isIPv6DefaultRoute) && IpClient.all(this.ipAddresses, IpClient.not(InitialConfiguration::isIPv6GUA))) {
                return false;
            }
            if (IpClient.any(this.directlyConnectedRoutes, IpClient.not(InitialConfiguration::isPrefixLengthCompliant))) {
                return false;
            }
            return this.ipAddresses.stream().filter(Inet4Address.class::isInstance).count() <= 1L;
        }

        public boolean isProvisionedBy(List<LinkAddress> addresses, List<RouteInfo> routes) {
            if (this.ipAddresses.isEmpty()) {
                return false;
            }
            for (LinkAddress addr : this.ipAddresses) {
                if (IpClient.any(addresses, addrSeen -> addr.isSameAddressAs((LinkAddress)addrSeen))) continue;
                return false;
            }
            if (routes != null) {
                for (IpPrefix prefix : this.directlyConnectedRoutes) {
                    if (IpClient.any(routes, routeSeen -> InitialConfiguration.isDirectlyConnectedRoute(routeSeen, prefix))) continue;
                    return false;
                }
            }
            return true;
        }

        private static boolean isDirectlyConnectedRoute(RouteInfo route, IpPrefix prefix) {
            return !route.hasGateway() && prefix.equals(route.getDestination());
        }

        private static boolean isPrefixLengthCompliant(LinkAddress addr) {
            return addr.isIPv4() || InitialConfiguration.isCompliantIPv6PrefixLength(addr.getPrefixLength());
        }

        private static boolean isPrefixLengthCompliant(IpPrefix prefix) {
            return prefix.isIPv4() || InitialConfiguration.isCompliantIPv6PrefixLength(prefix.getPrefixLength());
        }

        private static boolean isCompliantIPv6PrefixLength(int prefixLength) {
            return 48 <= prefixLength && prefixLength <= 64;
        }

        private static boolean isIPv6DefaultRoute(IpPrefix prefix) {
            return prefix.getAddress().equals(Inet6Address.ANY);
        }

        private static boolean isIPv6GUA(LinkAddress addr) {
            return addr.isIPv6() && addr.isGlobalPreferred();
        }
    }

    public static class ProvisioningConfiguration {
        private static final int DEFAULT_TIMEOUT_MS = 36000;
        boolean mEnableIPv4 = true;
        boolean mEnableIPv6 = true;
        boolean mUsingIpReachabilityMonitor = true;
        int mRequestedPreDhcpActionMs;
        InitialConfiguration mInitialConfig;
        StaticIpConfiguration mStaticIpConfig;
        ApfCapabilities mApfCapabilities;
        int mProvisioningTimeoutMs = 36000;
        int mIPv6AddrGenMode = 2;
        Network mNetwork = null;
        String mDisplayName = null;

        public ProvisioningConfiguration() {
        }

        public ProvisioningConfiguration(ProvisioningConfiguration other) {
            this.mEnableIPv4 = other.mEnableIPv4;
            this.mEnableIPv6 = other.mEnableIPv6;
            this.mUsingIpReachabilityMonitor = other.mUsingIpReachabilityMonitor;
            this.mRequestedPreDhcpActionMs = other.mRequestedPreDhcpActionMs;
            this.mInitialConfig = InitialConfiguration.copy(other.mInitialConfig);
            this.mStaticIpConfig = other.mStaticIpConfig;
            this.mApfCapabilities = other.mApfCapabilities;
            this.mProvisioningTimeoutMs = other.mProvisioningTimeoutMs;
            this.mIPv6AddrGenMode = other.mIPv6AddrGenMode;
            this.mNetwork = other.mNetwork;
            this.mDisplayName = other.mDisplayName;
        }

        public String toString() {
            return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("mEnableIPv4: " + this.mEnableIPv4).add("mEnableIPv6: " + this.mEnableIPv6).add("mUsingIpReachabilityMonitor: " + this.mUsingIpReachabilityMonitor).add("mRequestedPreDhcpActionMs: " + this.mRequestedPreDhcpActionMs).add("mInitialConfig: " + this.mInitialConfig).add("mStaticIpConfig: " + this.mStaticIpConfig).add("mApfCapabilities: " + this.mApfCapabilities).add("mProvisioningTimeoutMs: " + this.mProvisioningTimeoutMs).add("mIPv6AddrGenMode: " + this.mIPv6AddrGenMode).add("mNetwork: " + this.mNetwork).add("mDisplayName: " + this.mDisplayName).toString();
        }

        public boolean isValid() {
            return this.mInitialConfig == null || this.mInitialConfig.isValid();
        }

        public static class Builder {
            private ProvisioningConfiguration mConfig = new ProvisioningConfiguration();

            public Builder withoutIPv4() {
                this.mConfig.mEnableIPv4 = false;
                return this;
            }

            public Builder withoutIPv6() {
                this.mConfig.mEnableIPv6 = false;
                return this;
            }

            public Builder withoutIpReachabilityMonitor() {
                this.mConfig.mUsingIpReachabilityMonitor = false;
                return this;
            }

            public Builder withPreDhcpAction() {
                this.mConfig.mRequestedPreDhcpActionMs = 36000;
                return this;
            }

            public Builder withPreDhcpAction(int dhcpActionTimeoutMs) {
                this.mConfig.mRequestedPreDhcpActionMs = dhcpActionTimeoutMs;
                return this;
            }

            public Builder withInitialConfiguration(InitialConfiguration initialConfig) {
                this.mConfig.mInitialConfig = initialConfig;
                return this;
            }

            public Builder withStaticConfiguration(StaticIpConfiguration staticConfig) {
                this.mConfig.mStaticIpConfig = staticConfig;
                return this;
            }

            public Builder withApfCapabilities(ApfCapabilities apfCapabilities) {
                this.mConfig.mApfCapabilities = apfCapabilities;
                return this;
            }

            public Builder withProvisioningTimeoutMs(int timeoutMs) {
                this.mConfig.mProvisioningTimeoutMs = timeoutMs;
                return this;
            }

            public Builder withRandomMacAddress() {
                this.mConfig.mIPv6AddrGenMode = 0;
                return this;
            }

            public Builder withStableMacAddress() {
                this.mConfig.mIPv6AddrGenMode = 2;
                return this;
            }

            public Builder withNetwork(Network network) {
                this.mConfig.mNetwork = network;
                return this;
            }

            public Builder withDisplayName(String displayName) {
                this.mConfig.mDisplayName = displayName;
                return this;
            }

            public ProvisioningConfiguration build() {
                return new ProvisioningConfiguration(this.mConfig);
            }
        }
    }

    private class LoggingCallbackWrapper
    extends Callback {
        private static final String PREFIX = "INVOKE ";
        private Callback mCallback;

        public LoggingCallbackWrapper(Callback callback) {
            this.mCallback = callback;
        }

        private void log(String msg) {
            IpClient.this.mLog.log(PREFIX + msg);
        }

        @Override
        public void onPreDhcpAction() {
            this.mCallback.onPreDhcpAction();
            this.log("onPreDhcpAction()");
        }

        @Override
        public void onPostDhcpAction() {
            this.mCallback.onPostDhcpAction();
            this.log("onPostDhcpAction()");
        }

        @Override
        public void onNewDhcpResults(DhcpResults dhcpResults) {
            this.mCallback.onNewDhcpResults(dhcpResults);
            this.log("onNewDhcpResults({" + dhcpResults + "})");
        }

        @Override
        public void onProvisioningSuccess(LinkProperties newLp) {
            this.mCallback.onProvisioningSuccess(newLp);
            this.log("onProvisioningSuccess({" + newLp + "})");
        }

        @Override
        public void onProvisioningFailure(LinkProperties newLp) {
            this.mCallback.onProvisioningFailure(newLp);
            this.log("onProvisioningFailure({" + newLp + "})");
        }

        @Override
        public void onLinkPropertiesChange(LinkProperties newLp) {
            this.mCallback.onLinkPropertiesChange(newLp);
            this.log("onLinkPropertiesChange({" + newLp + "})");
        }

        @Override
        public void onReachabilityLost(String logMsg) {
            this.mCallback.onReachabilityLost(logMsg);
            this.log("onReachabilityLost(" + logMsg + ")");
        }

        @Override
        public void onQuit() {
            this.mCallback.onQuit();
            this.log("onQuit()");
        }

        @Override
        public void installPacketFilter(byte[] filter) {
            this.mCallback.installPacketFilter(filter);
            this.log("installPacketFilter(byte[" + filter.length + "])");
        }

        @Override
        public void setFallbackMulticastFilter(boolean enabled) {
            this.mCallback.setFallbackMulticastFilter(enabled);
            this.log("setFallbackMulticastFilter(" + enabled + ")");
        }

        @Override
        public void setNeighborDiscoveryOffload(boolean enable) {
            this.mCallback.setNeighborDiscoveryOffload(enable);
            this.log("setNeighborDiscoveryOffload(" + enable + ")");
        }
    }

    public static class Callback {
        public void onPreDhcpAction() {
        }

        public void onPostDhcpAction() {
        }

        public void onNewDhcpResults(DhcpResults dhcpResults) {
        }

        public void onProvisioningSuccess(LinkProperties newLp) {
        }

        public void onProvisioningFailure(LinkProperties newLp) {
        }

        public void onLinkPropertiesChange(LinkProperties newLp) {
        }

        public void onReachabilityLost(String logMsg) {
        }

        public void onQuit() {
        }

        public void installPacketFilter(byte[] filter) {
        }

        public void setFallbackMulticastFilter(boolean enabled) {
        }

        public void setNeighborDiscoveryOffload(boolean enable) {
        }
    }
}

