/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.content.Context;
import android.net.INetd;
import android.net.LinkProperties;
import android.net.Network;
import android.net.StaticIpConfiguration;
import android.net.apf.ApfCapabilities;
import android.net.ip.IpClient;
import android.net.util.NetdService;
import android.os.INetworkManagementService;
import android.os.ServiceManager;
import com.android.internal.annotations.VisibleForTesting;

public class IpManager
extends IpClient {
    public static ProvisioningConfiguration.Builder buildProvisioningConfiguration() {
        return new ProvisioningConfiguration.Builder();
    }

    public IpManager(Context context, String ifName, Callback callback) {
        this(context, ifName, callback, INetworkManagementService.Stub.asInterface(ServiceManager.getService("network_management")), NetdService.getInstance());
    }

    public IpManager(Context context, String ifName, Callback callback, INetworkManagementService nwService) {
        this(context, ifName, callback, nwService, NetdService.getInstance());
    }

    @VisibleForTesting
    public IpManager(Context context, String ifName, Callback callback, INetworkManagementService nwService, INetd netd) {
        super(context, ifName, callback, nwService, netd);
    }

    public void startProvisioning(ProvisioningConfiguration req) {
        super.startProvisioning(req);
    }

    public static class WaitForProvisioningCallback
    extends Callback {
        private LinkProperties mCallbackLinkProperties;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LinkProperties waitForProvisioning() {
            WaitForProvisioningCallback waitForProvisioningCallback = this;
            synchronized (waitForProvisioningCallback) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.mCallbackLinkProperties;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onProvisioningSuccess(LinkProperties newLp) {
            WaitForProvisioningCallback waitForProvisioningCallback = this;
            synchronized (waitForProvisioningCallback) {
                this.mCallbackLinkProperties = newLp;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onProvisioningFailure(LinkProperties newLp) {
            WaitForProvisioningCallback waitForProvisioningCallback = this;
            synchronized (waitForProvisioningCallback) {
                this.mCallbackLinkProperties = null;
                this.notify();
            }
        }
    }

    public static class Callback
    extends IpClient.Callback {
    }

    public static class InitialConfiguration
    extends IpClient.InitialConfiguration {
    }

    public static class ProvisioningConfiguration
    extends IpClient.ProvisioningConfiguration {
        public ProvisioningConfiguration(IpClient.ProvisioningConfiguration ipcConfig) {
            super(ipcConfig);
        }

        public static class Builder
        extends IpClient.ProvisioningConfiguration.Builder {
            @Override
            public Builder withoutIPv4() {
                super.withoutIPv4();
                return this;
            }

            @Override
            public Builder withoutIPv6() {
                super.withoutIPv6();
                return this;
            }

            @Override
            public Builder withoutIpReachabilityMonitor() {
                super.withoutIpReachabilityMonitor();
                return this;
            }

            @Override
            public Builder withPreDhcpAction() {
                super.withPreDhcpAction();
                return this;
            }

            @Override
            public Builder withPreDhcpAction(int dhcpActionTimeoutMs) {
                super.withPreDhcpAction(dhcpActionTimeoutMs);
                return this;
            }

            public Builder withInitialConfiguration(InitialConfiguration initialConfig) {
                super.withInitialConfiguration(initialConfig);
                return this;
            }

            @Override
            public Builder withStaticConfiguration(StaticIpConfiguration staticConfig) {
                super.withStaticConfiguration(staticConfig);
                return this;
            }

            @Override
            public Builder withApfCapabilities(ApfCapabilities apfCapabilities) {
                super.withApfCapabilities(apfCapabilities);
                return this;
            }

            @Override
            public Builder withProvisioningTimeoutMs(int timeoutMs) {
                super.withProvisioningTimeoutMs(timeoutMs);
                return this;
            }

            @Override
            public Builder withNetwork(Network network) {
                super.withNetwork(network);
                return this;
            }

            @Override
            public Builder withDisplayName(String displayName) {
                super.withDisplayName(displayName);
                return this;
            }

            @Override
            public ProvisioningConfiguration build() {
                return new ProvisioningConfiguration(super.build());
            }
        }
    }
}

