/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.net.MacAddress;
import android.net.netlink.NetlinkConstants;
import android.net.netlink.NetlinkErrorMessage;
import android.net.netlink.NetlinkMessage;
import android.net.netlink.NetlinkSocket;
import android.net.netlink.RtNetlinkNeighborMessage;
import android.net.netlink.StructNdMsg;
import android.net.util.PacketReader;
import android.net.util.SharedLog;
import android.os.Handler;
import android.os.SystemClock;
import android.system.ErrnoException;
import android.system.NetlinkSocketAddress;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import com.android.internal.util.BitUtils;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.StringJoiner;
import libcore.io.IoUtils;

public class IpNeighborMonitor
extends PacketReader {
    private static final String TAG = IpNeighborMonitor.class.getSimpleName();
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private final SharedLog mLog;
    private final NeighborEventConsumer mConsumer;

    public static int startKernelNeighborProbe(int ifIndex, InetAddress ip) {
        String msgSnippet = "probing ip=" + ip.getHostAddress() + "%" + ifIndex;
        byte[] msg = RtNetlinkNeighborMessage.newNewNeighborMessage(1, ip, (short)16, ifIndex, null);
        try {
            NetlinkSocket.sendOneShotKernelMessage(OsConstants.NETLINK_ROUTE, msg);
        }
        catch (ErrnoException e) {
            Log.e(TAG, "Error " + msgSnippet + ": " + e);
            return -e.errno;
        }
        return 0;
    }

    public IpNeighborMonitor(Handler h, SharedLog log, NeighborEventConsumer cb) {
        super(h, 8192);
        this.mLog = log.forSubComponent(TAG);
        this.mConsumer = cb != null ? cb : event -> {};
    }

    @Override
    protected FileDescriptor createFd() {
        FileDescriptor fd = null;
        try {
            fd = NetlinkSocket.forProto(OsConstants.NETLINK_ROUTE);
            Os.bind(fd, new NetlinkSocketAddress(0, OsConstants.RTMGRP_NEIGH));
            Os.connect(fd, new NetlinkSocketAddress(0, 0));
        }
        catch (ErrnoException | SocketException e) {
            this.logError("Failed to create rtnetlink socket", e);
            IoUtils.closeQuietly(fd);
            return null;
        }
        return fd;
    }

    @Override
    protected void handlePacket(byte[] recvbuf, int length) {
        long whenMs = SystemClock.elapsedRealtime();
        ByteBuffer byteBuffer = ByteBuffer.wrap(recvbuf, 0, length);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.parseNetlinkMessageBuffer(byteBuffer, whenMs);
    }

    private void parseNetlinkMessageBuffer(ByteBuffer byteBuffer, long whenMs) {
        while (byteBuffer.remaining() > 0) {
            int position = byteBuffer.position();
            NetlinkMessage nlMsg = NetlinkMessage.parse(byteBuffer);
            if (nlMsg == null || nlMsg.getHeader() == null) {
                byteBuffer.position(position);
                this.mLog.e("unparsable netlink msg: " + NetlinkConstants.hexify(byteBuffer));
                break;
            }
            int srcPortId = nlMsg.getHeader().nlmsg_pid;
            if (srcPortId != 0) {
                this.mLog.e("non-kernel source portId: " + BitUtils.uint32(srcPortId));
                break;
            }
            if (nlMsg instanceof NetlinkErrorMessage) {
                this.mLog.e("netlink error: " + nlMsg);
                continue;
            }
            if (!(nlMsg instanceof RtNetlinkNeighborMessage)) {
                this.mLog.i("non-rtnetlink neighbor msg: " + nlMsg);
                continue;
            }
            this.evaluateRtNetlinkNeighborMessage((RtNetlinkNeighborMessage)nlMsg, whenMs);
        }
    }

    private void evaluateRtNetlinkNeighborMessage(RtNetlinkNeighborMessage neighMsg, long whenMs) {
        short msgType = neighMsg.getHeader().nlmsg_type;
        StructNdMsg ndMsg = neighMsg.getNdHeader();
        if (ndMsg == null) {
            this.mLog.e("RtNetlinkNeighborMessage without ND message header!");
            return;
        }
        int ifindex = ndMsg.ndm_ifindex;
        InetAddress destination = neighMsg.getDestination();
        short nudState = msgType == 29 ? (short)0 : ndMsg.ndm_state;
        NeighborEvent event = new NeighborEvent(whenMs, msgType, ifindex, destination, nudState, IpNeighborMonitor.getMacAddress(neighMsg.getLinkLayerAddress()));
        this.mConsumer.accept(event);
    }

    private static MacAddress getMacAddress(byte[] linkLayerAddress) {
        if (linkLayerAddress != null) {
            try {
                return MacAddress.fromBytes(linkLayerAddress);
            }
            catch (IllegalArgumentException e) {
                Log.e(TAG, "Failed to parse link-layer address: " + NetlinkConstants.hexify(linkLayerAddress));
            }
        }
        return null;
    }

    public static interface NeighborEventConsumer {
        public void accept(NeighborEvent var1);
    }

    public static class NeighborEvent {
        final long elapsedMs;
        final short msgType;
        final int ifindex;
        final InetAddress ip;
        final short nudState;
        final MacAddress macAddr;

        public NeighborEvent(long elapsedMs, short msgType, int ifindex, InetAddress ip, short nudState, MacAddress macAddr) {
            this.elapsedMs = elapsedMs;
            this.msgType = msgType;
            this.ifindex = ifindex;
            this.ip = ip;
            this.nudState = nudState;
            this.macAddr = macAddr;
        }

        boolean isConnected() {
            return this.msgType != 29 && StructNdMsg.isNudStateConnected(this.nudState);
        }

        boolean isValid() {
            return this.msgType != 29 && StructNdMsg.isNudStateValid(this.nudState);
        }

        public String toString() {
            StringJoiner j = new StringJoiner(",", "NeighborEvent{", "}");
            return j.add("@" + this.elapsedMs).add(NetlinkConstants.stringForNlMsgType(this.msgType)).add("if=" + this.ifindex).add(this.ip.getHostAddress()).add(StructNdMsg.stringForNudState(this.nudState)).add("[" + this.macAddr + "]").toString();
        }
    }
}

