/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.content.Context;
import android.net.LinkProperties;
import android.net.RouteInfo;
import android.net.ip.IpNeighborMonitor;
import android.net.metrics.IpConnectivityLog;
import android.net.metrics.IpReachabilityEvent;
import android.net.util.InterfaceParams;
import android.net.util.MultinetworkPolicyTracker;
import android.net.util.SharedLog;
import android.os.Handler;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.SystemClock;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.DumpUtils;
import java.io.PrintWriter;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IpReachabilityMonitor {
    private static final String TAG = "IpReachabilityMonitor";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private final InterfaceParams mInterfaceParams;
    private final IpNeighborMonitor mIpNeighborMonitor;
    private final SharedLog mLog;
    private final Callback mCallback;
    private final Dependencies mDependencies;
    private final MultinetworkPolicyTracker mMultinetworkPolicyTracker;
    private final IpConnectivityLog mMetricsLog = new IpConnectivityLog();
    private LinkProperties mLinkProperties = new LinkProperties();
    private Map<InetAddress, IpNeighborMonitor.NeighborEvent> mNeighborWatchList = new HashMap<InetAddress, IpNeighborMonitor.NeighborEvent>();
    private volatile long mLastProbeTimeMs;

    public IpReachabilityMonitor(Context context, InterfaceParams ifParams, Handler h, SharedLog log, Callback callback, MultinetworkPolicyTracker tracker) {
        this(ifParams, h, log, callback, tracker, Dependencies.makeDefault(context, ifParams.name));
    }

    @VisibleForTesting
    IpReachabilityMonitor(InterfaceParams ifParams, Handler h, SharedLog log, Callback callback, MultinetworkPolicyTracker tracker, Dependencies dependencies) {
        if (ifParams == null) {
            throw new IllegalArgumentException("null InterfaceParams");
        }
        this.mInterfaceParams = ifParams;
        this.mLog = log.forSubComponent(TAG);
        this.mCallback = callback;
        this.mMultinetworkPolicyTracker = tracker;
        this.mDependencies = dependencies;
        this.mIpNeighborMonitor = new IpNeighborMonitor(h, this.mLog, event -> {
            if (this.mInterfaceParams.index != event.ifindex) {
                return;
            }
            if (!this.mNeighborWatchList.containsKey(event.ip)) {
                return;
            }
            IpNeighborMonitor.NeighborEvent prev = this.mNeighborWatchList.put(event.ip, event);
            if (event.nudState == 32) {
                this.mLog.w("ALERT neighbor went from: " + prev + " to: " + event);
                this.handleNeighborLost(event);
            }
        });
        this.mIpNeighborMonitor.start();
    }

    public void stop() {
        this.mIpNeighborMonitor.stop();
        this.clearLinkProperties();
    }

    public void dump(PrintWriter pw) {
        DumpUtils.dumpAsync(this.mIpNeighborMonitor.getHandler(), new DumpUtils.Dump(){

            @Override
            public void dump(PrintWriter pw, String prefix) {
                pw.println(IpReachabilityMonitor.this.describeWatchList("\n"));
            }
        }, pw, "", 1000L);
    }

    private String describeWatchList() {
        return this.describeWatchList(" ");
    }

    private String describeWatchList(String sep) {
        StringBuilder sb = new StringBuilder();
        sb.append("iface{" + this.mInterfaceParams + "}," + sep);
        sb.append("ntable=[" + sep);
        String delimiter = "";
        for (Map.Entry<InetAddress, IpNeighborMonitor.NeighborEvent> entry : this.mNeighborWatchList.entrySet()) {
            sb.append(delimiter).append(entry.getKey().getHostAddress() + "/" + entry.getValue());
            delimiter = "," + sep;
        }
        sb.append("]");
        return sb.toString();
    }

    private static boolean isOnLink(List<RouteInfo> routes, InetAddress ip) {
        for (RouteInfo route : routes) {
            if (route.hasGateway() || !route.matches(ip)) continue;
            return true;
        }
        return false;
    }

    public void updateLinkProperties(LinkProperties lp) {
        if (!this.mInterfaceParams.name.equals(lp.getInterfaceName())) {
            Log.wtf(TAG, "requested LinkProperties interface '" + lp.getInterfaceName() + "' does not match: " + this.mInterfaceParams.name);
            return;
        }
        this.mLinkProperties = new LinkProperties(lp);
        HashMap<InetAddress, IpNeighborMonitor.NeighborEvent> newNeighborWatchList = new HashMap<InetAddress, IpNeighborMonitor.NeighborEvent>();
        List<RouteInfo> routes = this.mLinkProperties.getRoutes();
        for (RouteInfo route : routes) {
            InetAddress gw;
            if (!route.hasGateway() || !IpReachabilityMonitor.isOnLink(routes, gw = route.getGateway())) continue;
            newNeighborWatchList.put(gw, this.mNeighborWatchList.getOrDefault(gw, null));
        }
        for (InetAddress dns : lp.getDnsServers()) {
            if (!IpReachabilityMonitor.isOnLink(routes, dns)) continue;
            newNeighborWatchList.put(dns, this.mNeighborWatchList.getOrDefault(dns, null));
        }
        this.mNeighborWatchList = newNeighborWatchList;
    }

    public void clearLinkProperties() {
        this.mLinkProperties.clear();
        this.mNeighborWatchList.clear();
    }

    private void handleNeighborLost(IpNeighborMonitor.NeighborEvent event) {
        LinkProperties whatIfLp = new LinkProperties(this.mLinkProperties);
        InetAddress ip = null;
        for (Map.Entry<InetAddress, IpNeighborMonitor.NeighborEvent> entry : this.mNeighborWatchList.entrySet()) {
            if (entry.getValue().nudState != 32) continue;
            ip = entry.getKey();
            for (RouteInfo route : this.mLinkProperties.getRoutes()) {
                if (!ip.equals(route.getGateway())) continue;
                whatIfLp.removeRoute(route);
            }
            if (!this.avoidingBadLinks() && ip instanceof Inet6Address) continue;
            whatIfLp.removeDnsServer(ip);
        }
        LinkProperties.ProvisioningChange delta = LinkProperties.compareProvisioning(this.mLinkProperties, whatIfLp);
        if (delta == LinkProperties.ProvisioningChange.LOST_PROVISIONING) {
            String logMsg = "FAILURE: LOST_PROVISIONING, " + event;
            Log.w(TAG, logMsg);
            if (this.mCallback != null) {
                this.mCallback.notifyLost(ip, logMsg);
            }
        }
        this.logNudFailed(delta);
    }

    private boolean avoidingBadLinks() {
        return this.mMultinetworkPolicyTracker == null || this.mMultinetworkPolicyTracker.getAvoidBadWifi();
    }

    public void probeAll() {
        ArrayList<InetAddress> ipProbeList = new ArrayList<InetAddress>(this.mNeighborWatchList.keySet());
        if (!ipProbeList.isEmpty()) {
            this.mDependencies.acquireWakeLock(IpReachabilityMonitor.getProbeWakeLockDuration());
        }
        for (InetAddress ip : ipProbeList) {
            int rval = IpNeighborMonitor.startKernelNeighborProbe(this.mInterfaceParams.index, ip);
            this.mLog.log(String.format("put neighbor %s into NUD_PROBE state (rval=%d)", ip.getHostAddress(), rval));
            this.logEvent(256, rval);
        }
        this.mLastProbeTimeMs = SystemClock.elapsedRealtime();
    }

    private static long getProbeWakeLockDuration() {
        long numUnicastProbes = 3L;
        long retransTimeMs = 1000L;
        long gracePeriodMs = 500L;
        return 3500L;
    }

    private void logEvent(int probeType, int errorCode) {
        int eventType = probeType | errorCode & 0xFF;
        this.mMetricsLog.log(this.mInterfaceParams.name, (Parcelable)new IpReachabilityEvent(eventType));
    }

    private void logNudFailed(LinkProperties.ProvisioningChange delta) {
        long duration = SystemClock.elapsedRealtime() - this.mLastProbeTimeMs;
        boolean isFromProbe = duration < IpReachabilityMonitor.getProbeWakeLockDuration();
        boolean isProvisioningLost = delta == LinkProperties.ProvisioningChange.LOST_PROVISIONING;
        int eventType = IpReachabilityEvent.nudFailureEventType(isFromProbe, isProvisioningLost);
        this.mMetricsLog.log(this.mInterfaceParams.name, (Parcelable)new IpReachabilityEvent(eventType));
    }

    static interface Dependencies {
        public void acquireWakeLock(long var1);

        public static Dependencies makeDefault(Context context, String iface) {
            String lockName = "IpReachabilityMonitor." + iface;
            PowerManager pm = (PowerManager)context.getSystemService("power");
            final PowerManager.WakeLock lock = pm.newWakeLock(1, lockName);
            return new Dependencies(){

                @Override
                public void acquireWakeLock(long durationMs) {
                    lock.acquire(durationMs);
                }
            };
        }
    }

    public static interface Callback {
        public void notifyLost(InetAddress var1, String var2);
    }
}

