/*
 * Decompiled with CFR 0.152.
 */
package android.net.metrics;

import android.net.NetworkCapabilities;
import com.android.internal.util.BitUtils;
import java.util.StringJoiner;

public class DefaultNetworkEvent {
    public final long creationTimeMs;
    public int netId = 0;
    public int transports;
    public int previousTransports;
    public boolean ipv4;
    public boolean ipv6;
    public int initialScore;
    public int finalScore;
    public long durationMs;
    public long validatedMs;

    public DefaultNetworkEvent(long timeMs) {
        this.creationTimeMs = timeMs;
    }

    public void updateDuration(long timeMs) {
        this.durationMs = timeMs - this.creationTimeMs;
    }

    public String toString() {
        StringJoiner j = new StringJoiner(", ", "DefaultNetworkEvent(", ")");
        j.add("netId=" + this.netId);
        for (int t : BitUtils.unpackBits(this.transports)) {
            j.add(NetworkCapabilities.transportNameOf(t));
        }
        j.add("ip=" + this.ipSupport());
        if (this.initialScore > 0) {
            j.add("initial_score=" + this.initialScore);
        }
        if (this.finalScore > 0) {
            j.add("final_score=" + this.finalScore);
        }
        j.add(String.format("duration=%.0fs", (double)this.durationMs / 1000.0));
        j.add(String.format("validation=%04.1f%%", (double)this.validatedMs * 100.0 / (double)this.durationMs));
        return j.toString();
    }

    private String ipSupport() {
        if (this.ipv4 && this.ipv6) {
            return "IPv4v6";
        }
        if (this.ipv6) {
            return "IPv6";
        }
        if (this.ipv4) {
            return "IPv4";
        }
        return "NONE";
    }
}

