/*
 * Decompiled with CFR 0.152.
 */
package android.net.metrics;

import android.net.NetworkCapabilities;
import android.net.metrics.ConnectStats;
import android.net.metrics.DnsEvent;
import com.android.internal.util.BitUtils;
import com.android.internal.util.TokenBucket;
import java.util.StringJoiner;

public class NetworkMetrics {
    private static final int INITIAL_DNS_BATCH_SIZE = 100;
    private static final int CONNECT_LATENCY_MAXIMUM_RECORDS = 20000;
    public final int netId;
    public final long transports;
    public final ConnectStats connectMetrics;
    public final DnsEvent dnsMetrics;
    public final Summary summary;
    public Summary pendingSummary;

    public NetworkMetrics(int netId, long transports, TokenBucket tb) {
        this.netId = netId;
        this.transports = transports;
        this.connectMetrics = new ConnectStats(netId, transports, tb, 20000);
        this.dnsMetrics = new DnsEvent(netId, transports, 100);
        this.summary = new Summary(netId, transports);
    }

    public Summary getPendingStats() {
        Summary s = this.pendingSummary;
        this.pendingSummary = null;
        if (s != null) {
            this.summary.merge(s);
        }
        return s;
    }

    public void addDnsResult(int eventType, int returnCode, int latencyMs) {
        if (this.pendingSummary == null) {
            this.pendingSummary = new Summary(this.netId, this.transports);
        }
        boolean isSuccess = this.dnsMetrics.addResult((byte)eventType, (byte)returnCode, latencyMs);
        this.pendingSummary.dnsLatencies.count(latencyMs);
        this.pendingSummary.dnsErrorRate.count(isSuccess ? 0.0 : 1.0);
    }

    public void addConnectResult(int error, int latencyMs, String ipAddr) {
        if (this.pendingSummary == null) {
            this.pendingSummary = new Summary(this.netId, this.transports);
        }
        boolean isSuccess = this.connectMetrics.addEvent(error, latencyMs, ipAddr);
        this.pendingSummary.connectErrorRate.count(isSuccess ? 0.0 : 1.0);
        if (ConnectStats.isNonBlocking(error)) {
            this.pendingSummary.connectLatencies.count(latencyMs);
        }
    }

    public void addTcpStatsResult(int sent, int lost, int rttUs, int sentAckDiffMs) {
        this.pendingSummary.tcpLossRate.count(lost, sent);
        this.pendingSummary.roundTripTimeUs.count(rttUs);
        this.pendingSummary.sentAckTimeDiffenceMs.count(sentAckDiffMs);
    }

    static class Metrics {
        public double sum;
        public double max = Double.MIN_VALUE;
        public int count;

        Metrics() {
        }

        void merge(Metrics that) {
            this.count += that.count;
            this.sum += that.sum;
            this.max = Math.max(this.max, that.max);
        }

        void count(double value) {
            this.count(value, 1);
        }

        void count(double value, int subcount) {
            this.count += subcount;
            this.sum += value;
            this.max = Math.max(this.max, value);
        }

        double average() {
            double a = this.sum / (double)this.count;
            if (Double.isNaN(a)) {
                a = 0.0;
            }
            return a;
        }
    }

    public static class Summary {
        public final int netId;
        public final long transports;
        public final Metrics dnsLatencies = new Metrics();
        public final Metrics dnsErrorRate = new Metrics();
        public final Metrics connectLatencies = new Metrics();
        public final Metrics connectErrorRate = new Metrics();
        public final Metrics tcpLossRate = new Metrics();
        public final Metrics roundTripTimeUs = new Metrics();
        public final Metrics sentAckTimeDiffenceMs = new Metrics();

        public Summary(int netId, long transports) {
            this.netId = netId;
            this.transports = transports;
        }

        void merge(Summary that) {
            this.dnsLatencies.merge(that.dnsLatencies);
            this.dnsErrorRate.merge(that.dnsErrorRate);
            this.connectLatencies.merge(that.connectLatencies);
            this.connectErrorRate.merge(that.connectErrorRate);
            this.tcpLossRate.merge(that.tcpLossRate);
        }

        public String toString() {
            StringJoiner j = new StringJoiner(", ", "{", "}");
            j.add("netId=" + this.netId);
            for (int t : BitUtils.unpackBits(this.transports)) {
                j.add(NetworkCapabilities.transportNameOf(t));
            }
            j.add(String.format("dns avg=%dms max=%dms err=%.1f%% tot=%d", (int)this.dnsLatencies.average(), (int)this.dnsLatencies.max, 100.0 * this.dnsErrorRate.average(), this.dnsErrorRate.count));
            j.add(String.format("connect avg=%dms max=%dms err=%.1f%% tot=%d", (int)this.connectLatencies.average(), (int)this.connectLatencies.max, 100.0 * this.connectErrorRate.average(), this.connectErrorRate.count));
            j.add(String.format("tcp avg_loss=%.1f%% total_sent=%d total_lost=%d", 100.0 * this.tcpLossRate.average(), this.tcpLossRate.count, (int)this.tcpLossRate.sum));
            j.add(String.format("tcp rtt=%dms", (int)(this.roundTripTimeUs.average() / 1000.0)));
            j.add(String.format("tcp sent-ack_diff=%dms", (int)this.sentAckTimeDiffenceMs.average()));
            return j.toString();
        }
    }
}

