/*
 * Decompiled with CFR 0.152.
 */
package android.net.netlink;

import android.net.netlink.NetlinkConstants;
import android.net.netlink.NetlinkErrorMessage;
import android.net.netlink.RtNetlinkNeighborMessage;
import android.net.netlink.StructNlMsgHdr;
import java.nio.ByteBuffer;

public class NetlinkMessage {
    private static final String TAG = "NetlinkMessage";
    protected StructNlMsgHdr mHeader;

    public static NetlinkMessage parse(ByteBuffer byteBuffer) {
        int startPosition = byteBuffer != null ? byteBuffer.position() : -1;
        StructNlMsgHdr nlmsghdr = StructNlMsgHdr.parse(byteBuffer);
        if (nlmsghdr == null) {
            return null;
        }
        int payloadLength = NetlinkConstants.alignedLengthOf(nlmsghdr.nlmsg_len);
        if ((payloadLength -= 16) < 0 || payloadLength > byteBuffer.remaining()) {
            byteBuffer.position(byteBuffer.limit());
            return null;
        }
        switch (nlmsghdr.nlmsg_type) {
            case 2: {
                return NetlinkErrorMessage.parse(nlmsghdr, byteBuffer);
            }
            case 3: {
                byteBuffer.position(byteBuffer.position() + payloadLength);
                return new NetlinkMessage(nlmsghdr);
            }
            case 28: 
            case 29: 
            case 30: {
                return RtNetlinkNeighborMessage.parse(nlmsghdr, byteBuffer);
            }
        }
        if (nlmsghdr.nlmsg_type <= 15) {
            byteBuffer.position(byteBuffer.position() + payloadLength);
            return new NetlinkMessage(nlmsghdr);
        }
        return null;
    }

    public NetlinkMessage(StructNlMsgHdr nlmsghdr) {
        this.mHeader = nlmsghdr;
    }

    public StructNlMsgHdr getHeader() {
        return this.mHeader;
    }

    public String toString() {
        return "NetlinkMessage{" + (this.mHeader == null ? "" : this.mHeader.toString()) + "}";
    }
}

