/*
 * Decompiled with CFR 0.152.
 */
package android.net.netlink;

import android.net.netlink.NetlinkConstants;
import android.net.netlink.NetlinkErrorMessage;
import android.net.netlink.NetlinkMessage;
import android.system.ErrnoException;
import android.system.NetlinkSocketAddress;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructTimeval;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import libcore.io.IoUtils;

public class NetlinkSocket {
    private static final String TAG = "NetlinkSocket";
    public static final int DEFAULT_RECV_BUFSIZE = 8192;
    public static final int SOCKET_RECV_BUFSIZE = 65536;

    public static void sendOneShotKernelMessage(int nlProto, byte[] msg) throws ErrnoException {
        FileDescriptor fd;
        block7: {
            String errPrefix = "Error in NetlinkSocket.sendOneShotKernelMessage";
            long IO_TIMEOUT = 300L;
            try {
                String errmsg;
                fd = NetlinkSocket.forProto(nlProto);
                NetlinkSocket.connectToKernel(fd);
                NetlinkSocket.sendMessage(fd, msg, 0, msg.length, 300L);
                ByteBuffer bytes = NetlinkSocket.recvMessage(fd, 8192, 300L);
                NetlinkMessage response = NetlinkMessage.parse(bytes);
                if (response != null && response instanceof NetlinkErrorMessage && ((NetlinkErrorMessage)response).getNlMsgError() != null) {
                    int errno = ((NetlinkErrorMessage)response).getNlMsgError().error;
                    if (errno != 0) {
                        Log.e(TAG, "Error in NetlinkSocket.sendOneShotKernelMessage, errmsg=" + response.toString());
                        throw new ErrnoException(response.toString(), Math.abs(errno));
                    }
                    break block7;
                }
                if (response == null) {
                    bytes.position(0);
                    errmsg = "raw bytes: " + NetlinkConstants.hexify(bytes);
                } else {
                    errmsg = response.toString();
                }
                Log.e(TAG, "Error in NetlinkSocket.sendOneShotKernelMessage, errmsg=" + errmsg);
                throw new ErrnoException(errmsg, OsConstants.EPROTO);
            }
            catch (InterruptedIOException e) {
                Log.e(TAG, "Error in NetlinkSocket.sendOneShotKernelMessage", e);
                throw new ErrnoException("Error in NetlinkSocket.sendOneShotKernelMessage", OsConstants.ETIMEDOUT, e);
            }
            catch (SocketException e) {
                Log.e(TAG, "Error in NetlinkSocket.sendOneShotKernelMessage", e);
                throw new ErrnoException("Error in NetlinkSocket.sendOneShotKernelMessage", OsConstants.EIO, e);
            }
        }
        IoUtils.closeQuietly(fd);
    }

    public static FileDescriptor forProto(int nlProto) throws ErrnoException {
        FileDescriptor fd = Os.socket(OsConstants.AF_NETLINK, OsConstants.SOCK_DGRAM, nlProto);
        Os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_RCVBUF, 65536);
        return fd;
    }

    public static void connectToKernel(FileDescriptor fd) throws ErrnoException, SocketException {
        Os.connect(fd, new NetlinkSocketAddress(0, 0));
    }

    private static void checkTimeout(long timeoutMs) {
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException("Negative timeouts not permitted");
        }
    }

    public static ByteBuffer recvMessage(FileDescriptor fd, int bufsize, long timeoutMs) throws ErrnoException, IllegalArgumentException, InterruptedIOException {
        NetlinkSocket.checkTimeout(timeoutMs);
        Os.setsockoptTimeval(fd, OsConstants.SOL_SOCKET, OsConstants.SO_RCVTIMEO, StructTimeval.fromMillis(timeoutMs));
        ByteBuffer byteBuffer = ByteBuffer.allocate(bufsize);
        int length = Os.read(fd, byteBuffer);
        if (length == bufsize) {
            Log.w(TAG, "maximum read");
        }
        byteBuffer.position(0);
        byteBuffer.limit(length);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }

    public static int sendMessage(FileDescriptor fd, byte[] bytes, int offset, int count, long timeoutMs) throws ErrnoException, IllegalArgumentException, InterruptedIOException {
        NetlinkSocket.checkTimeout(timeoutMs);
        Os.setsockoptTimeval(fd, OsConstants.SOL_SOCKET, OsConstants.SO_SNDTIMEO, StructTimeval.fromMillis(timeoutMs));
        return Os.write(fd, bytes, offset, count);
    }
}

